/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleDictionaryQueries;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleIndexBuilder;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleRelationBuilder;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OracleTableBuilder
extends OracleRelationBuilder {
    static final /* synthetic */ boolean $assertionsDisabled;

    protected OracleTableBuilder(BaseOracleDatabase db) {
        this(db, "TABLE");
    }

    protected OracleTableBuilder(BaseOracleDatabase db, String type) {
        super(db, type);
    }

    public SchemaObject createObject(String name, Schema schema, DBObjectID id) {
        Table table = new Table(name, schema);
        table.setID(id);
        return table;
    }

    @Override
    protected void fillInObject(SchemaObject object) throws DBException {
        super.fillInObject(object);
        Table table = (Table)object;
        if (this.needsBuilding((AbstractSchemaObject)table, "INDEX")) {
            this.fillInIndexes(table);
        }
        if (this.needsBuilding((AbstractSchemaObject)table, "BASE")) {
            this.buildBaseProperties(table);
        }
        this.buildNonBaseProperties(table);
    }

    private void fillInIndexes(Table table) throws DBException {
        OracleIndexBuilder ib = (OracleIndexBuilder)this.getDatabase().getBuilderForType("INDEX");
        ib.fillInIndexes((SchemaObject)table);
    }

    private void buildBaseProperties(Table table) throws DBException {
        String query;
        Holder tryObjectQuery = new Holder((Object)true);
        QueryWrapper wrap = this.newQueryWrapper(this.getTableQuery(), table.getSchema(), table);
        1 r = new 1(this, tryObjectQuery, table, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        if (((Boolean)tryObjectQuery.get()).booleanValue() && (query = this.getObjectTableQuery()) != null) {
            QueryWrapper wrap2 = this.newQueryWrapper(query, table.getSchema(), table);
            2 r2 = new 2(this, table, wrap2);
            wrap2.executeQuery((QueryWrapper.QueryRunnable)r2);
        }
    }

    private void getBasePropertiesFromRS(Table table, ResultSet rs) throws SQLException, DBException {
        boolean isNestedTable = "YES".equals(rs.getString(19));
        boolean isPartitionedTable = "YES".equals(rs.getString(18));
        OracleExternalTableProperties externalTableProperties = null;
        boolean compression = "ENABLED".equals(rs.getString(20));
        String degree = rs.getString(21);
        if (degree != null) {
            degree = degree.trim();
        }
        if (degree != null && degree.equals("DEFAULT")) {
            degree = "0";
        } else if ("1".equals(degree)) {
            degree = null;
        }
        Table.TableType type = Table.TableType.NORMAL;
        if ("IOT".equals(rs.getString(17))) {
            type = Table.TableType.INDEX_ORGANIZED;
            compression = false;
        } else if ("Y".equals(rs.getString(15))) {
            String s = rs.getString(16);
            if ("SYS$SESSION".equals(s)) {
                type = Table.TableType.SESSION_TEMP;
            } else if ("SYS$TRANSACTION".equals(s)) {
                type = Table.TableType.TRANSACTION_TEMP;
            }
            compression = false;
        } else {
            OracleExternalTableProperties oracleExternalTableProperties = externalTableProperties = type == Table.TableType.NORMAL && !isNestedTable ? this.getExternalTableProperties(table) : null;
            if (externalTableProperties != null) {
                type = Table.TableType.EXTERNAL;
                compression = false;
            }
        }
        table.setProperty("TableType", (Object)type);
        if (compression) {
            table.setProperty("compression", (Object)Boolean.TRUE);
        }
        if (degree != null) {
            table.setProperty("parallel", (Object)Integer.valueOf(degree));
        }
        if (type == Table.TableType.INDEX_ORGANIZED) {
            if (isPartitionedTable) {
                table.setProperty("OracleStorageProperties", (Object)this.getSegmentAttributeProperties("select /*OracleDictionaryQueries.ALL_PARTITIONED_IOT_DEFAULT_STORAGE_PROPERTIES_QUERY*/\n       def_tablespace_name TABLESPACE_NAME,\n       def_pct_free PCT_FREE, null PCT_USED,\n       def_ini_trans INI_TRANS, def_max_trans MAX_TRANS,\n       decode(def_initial_extent, 'DEFAULT', null, def_initial_extent) INITIAL_EXTENT,\n       decode(def_next_extent, 'DEFAULT', null, def_next_extent) NEXT_EXTENT,\n       decode(def_min_extents, 'DEFAULT', null, def_min_extents) MIN_EXTENTS,\n       decode(def_max_extents, 'DEFAULT', null, def_max_extents) MAX_EXTENTS,\n       decode(def_pct_increase, 'DEFAULT', null, def_pct_increase) PCT_INCREASE,\n       decode(def_freelists, 0, null, def_freelists) FREELISTS,\n       decode(def_freelist_groups, 0, null, def_freelist_groups) FREELIST_GROUPS,\n       decode(def_logging, 'NONE', null, def_logging) LOGGING,\n       def_buffer_pool BUFFER_POOL\nfrom   all_part_indexes\nwhere  owner = ?\nand    index_name = ?\n", table, this.getQueryObject(table).getName()));
            } else {
                table.setProperty("OracleStorageProperties", (Object)this.getSegmentAttributeProperties(OracleDictionaryQueries.TABLE_IOT_STORAGE_PROPERTIES_QUERY, table, table.getName()));
            }
        } else if (type == Table.TableType.EXTERNAL) {
            table.setProperty("OracleExternalTableProperties", (Object)externalTableProperties);
        } else if (isPartitionedTable) {
            table.setProperty("OracleStorageProperties", (Object)this.getSegmentAttributeProperties("select /*OracleDictionaryQueries.ALL_PARTITIONED_TABLE_DEFAULT_STORAGE_PROPERTIES_QUERY*/\n       def_tablespace_name TABLESPACE_NAME,\n       def_pct_free PCT_FREE, def_pct_used PCT_USED,\n       def_ini_trans INI_TRANS, def_max_trans MAX_TRANS,\n       decode(def_initial_extent, 'DEFAULT', null, def_initial_extent) INITIAL_EXTENT,\n       decode(def_next_extent, 'DEFAULT', null, def_next_extent) NEXT_EXTENT,\n       decode(def_min_extents, 'DEFAULT', null, def_min_extents) MIN_EXTENTS,\n       decode(def_max_extents, 'DEFAULT', null, def_max_extents) MAX_EXTENTS,\n       decode(def_pct_increase, 'DEFAULT', null, def_pct_increase) PCT_INCREASE,\n       decode(def_freelists, 0, null, def_freelists) FREELISTS,\n       decode(def_freelist_groups, 0, null, def_freelist_groups) FREELIST_GROUPS,\n       decode(def_logging, 'NONE', null, def_logging) LOGGING,\n       def_buffer_pool BUFFER_POOL\nfrom   all_part_tables\nwhere  owner = ?\nand    table_name = ?\n", table, table.getName()));
        } else {
            table.setProperty("OracleStorageProperties", (Object)OracleTableBuilder.getSegmentAttributeProperties(rs));
        }
        table.setProperty("NESTED TABLE", (Object)(isNestedTable ? Boolean.TRUE : null));
        table.setProperty("PARTITIONED TABLE", (Object)(isPartitionedTable ? Boolean.TRUE : null));
    }

    private static OracleStorageProperties getStorageProperties(ResultSet rs) throws SQLException {
        OracleStorageProperties properties = new OracleStorageProperties();
        int i = rs.getInt("INITIAL_EXTENT");
        Integer I = rs.wasNull() ? null : new Integer(i);
        properties.setInitialExtent(I);
        i = rs.getInt("NEXT_EXTENT");
        I = rs.wasNull() ? null : new Integer(i);
        properties.setNextExtent(I);
        i = rs.getInt("MIN_EXTENTS");
        I = rs.wasNull() ? null : new Integer(i);
        properties.setMinExtent(I);
        i = rs.getInt("MAX_EXTENTS");
        I = rs.wasNull() ? null : new Integer(i);
        properties.setMaxExtent(I);
        i = rs.getInt("PCT_INCREASE");
        I = rs.wasNull() ? null : new Integer(i);
        properties.setPercentIncrease(I);
        i = rs.getInt("FREELISTS");
        I = rs.wasNull() ? null : new Integer(i);
        properties.setFreelists(I);
        i = rs.getInt("FREELIST_GROUPS");
        I = rs.wasNull() ? null : new Integer(i);
        properties.setFreelistGroups(I);
        String s = rs.getString("BUFFER_POOL");
        properties.setBufferMode(ModelUtil.hasLength((String)s) ? OracleStorageProperties.BufferModes.valueOf((String)s) : null);
        return properties;
    }

    private OracleStorageProperties getSegmentAttributeProperties(String query, Table table, String objectName) throws DBException {
        Holder osp = new Holder();
        QueryWrapper wrap = this.newQueryWrapper(query, table.getSchema(), objectName);
        3 r = new 3(this, osp, wrap, table);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        return (OracleStorageProperties)osp.get();
    }

    public static OracleStorageProperties getSegmentAttributeProperties(ResultSet rs) throws SQLException {
        OracleStorageProperties properties = OracleTableBuilder.getStorageProperties(rs);
        int i = rs.getInt("PCT_FREE");
        Integer I = rs.wasNull() ? null : new Integer(i);
        properties.setPercentFree(I);
        i = rs.getInt("PCT_USED");
        I = rs.wasNull() ? null : new Integer(i);
        properties.setPercentUsed(I);
        i = rs.getInt("INI_TRANS");
        I = rs.wasNull() || i == 0 ? null : new Integer(i);
        properties.setInitrans(I);
        i = rs.getInt("MAX_TRANS");
        I = rs.wasNull() || i == 0 ? null : new Integer(i);
        properties.setMaxtrans(I);
        properties.setTablespace(rs.getString("TABLESPACE_NAME"));
        String s = rs.getString("LOGGING");
        if (!rs.wasNull() && s != null) {
            properties.setLogging("YES".equalsIgnoreCase(s) ? Boolean.TRUE : Boolean.FALSE);
        }
        return properties;
    }

    private void buildNonBaseProperties(Table table) throws DBException {
        boolean isIOT = table.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED;
        boolean isExternal = table.getProperty("TableType") == Table.TableType.EXTERNAL;
        boolean isPartitionedTable = Boolean.TRUE.equals(table.getProperty("PARTITIONED TABLE"));
        if (isIOT) {
            table.setProperty("OracleIndexOrganizedTableProperties", (Object)this.getIotProperties(table));
        }
        if (isPartitionedTable && !isExternal) {
            table.setProperty("OracleTablePartitions", (Object)this.getOracleTablePartitions(table));
        }
        boolean getLobParameters = false;
        if (this.getDatabase().getOracleDatabaseType() != 9) {
            Column[] columnArray = table.getColumns();
            int n = 0;
            while (n < columnArray.length) {
                Column col = columnArray[n];
                if (LOBDescriptor.isLOBColumn((Column)col) || LOBDescriptor.isVARRAYColumn((Column)col)) {
                    getLobParameters = true;
                    break;
                }
                ++n;
            }
        }
        if (getLobParameters) {
            QueryWrapper wrap = this.newQueryWrapper(OracleTableBuilder.getLobParametersQuery(this.getDatabase().getOracleDatabaseType()), table.getSchema(), table, table.getSchema(), table);
            4 r = new 4(this, table, wrap);
            wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        }
    }

    protected OracleTablePartitions getOracleTablePartitions(Table table) throws DBException {
        Holder holder = new Holder();
        QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_TABLE_PARTITIONS_TYPE_QUERY*/\n       apt.partitioning_type, apt.subpartitioning_type, apkc.column_name\nfrom   all_part_tables apt, all_part_key_columns apkc\nwhere  apt.owner = ?\nand    apt.table_name = ?\nand    apkc.owner = apt.owner\nand    apkc.name  = apt.table_name\nand    apkc.object_type = 'TABLE'\norder by apkc.column_position", table.getSchema(), table);
        5 r = new 5(this, holder, table, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        OracleTablePartitions partitions = (OracleTablePartitions)holder.get();
        OracleTablePartitions subpartitionModel = partitions.getSubpartitionModel();
        if (partitions != null) {
            Map<String, List<LOBDescriptor>> lobPartitions = this.getPartitionLOBs(table, "select /*OracleDictionaryQueries.ALL_TABLE_LOB_PARTITIONS_QUERY*/\n       COLUMN_NAME, PARTITION_NAME NAME, LOB_PARTITION_NAME LOB_SEGMENT_NAME, CHUNK,\n       PCTVERSION, CACHE, IN_ROW, TABLESPACE_NAME, LOGGING, BUFFER_POOL,\n       decode(INITIAL_EXTENT, 'DEFAULT', null, INITIAL_EXTENT) INITIAL_EXTENT,\n       decode(NEXT_EXTENT, 'DEFAULT', null, NEXT_EXTENT) NEXT_EXTENT,\n       decode(MIN_EXTENTS, 'DEFAULT', null, MIN_EXTENTS) MIN_EXTENTS,\n       decode(MAX_EXTENTS, 'DEFAULT', null, MAX_EXTENTS) MAX_EXTENTS,\n       decode(PCT_INCREASE, 'DEFAULT', null, PCT_INCREASE) PCT_INCREASE,\n       decode(FREELISTS, 'DEFAULT', null, FREELISTS) FREELISTS,\n       decode(FREELIST_GROUPS, 'DEFAULT', null, FREELIST_GROUPS) FREELIST_GROUPS\nfrom   ALL_LOB_PARTITIONS\nwhere  TABLE_OWNER = ?\nand    TABLE_NAME  = ?\norder by PARTITION_POSITION, COLUMN_NAME");
            Map<String, OracleTablePartitions> partitionLevelSubpartitions = subpartitionModel != null ? this.getPartitionLevelSubpartitions(table, subpartitionModel.getPartitionType()) : null;
            QueryWrapper wrap2 = this.newQueryWrapper(Table.TableType.INDEX_ORGANIZED == table.getProperty("TableType") ? "select /*OracleDictionaryQueries.ALL_INDEX_PARTITIONS_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, null PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENT min_extents, MAX_EXTENT max_extents,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       COMPRESSION, PARTITION_NAME, HIGH_VALUE, PARAMETERS\nfrom   all_ind_partitions aip\nwhere  aip.index_owner = ?\nand    aip.index_name  = ?\norder by aip.partition_position" : "select /*OracleDictionaryQueries.ALL_TABLE_PARTITIONS_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, min_extent MIN_EXTENTS, max_extent MAX_EXTENTS,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       COMPRESSION, PARTITION_NAME, HIGH_VALUE\nfrom   all_tab_partitions atp\nwhere  atp.table_owner = ?\nand    atp.table_name  = ?\norder by atp.partition_position", table.getSchema(), this.getQueryObject(table));
            6 r2 = new 6(this, partitions, lobPartitions, partitionLevelSubpartitions, wrap2, table);
            wrap2.executeQuery((QueryWrapper.QueryRunnable)r2);
            if (subpartitionModel != null) {
                this.getSubpartitionColumns(table, subpartitionModel);
                this.getSubpartitionTemplates(table, subpartitionModel);
            }
        }
        return partitions;
    }

    private DBObject getQueryObject(Table table) {
        if (Table.TableType.INDEX_ORGANIZED == table.getProperty("TableType")) {
            Constraint[] constraintArray = table.getConstraints();
            int n = 0;
            while (n < constraintArray.length) {
                Constraint constraint = constraintArray[n];
                if (constraint instanceof PKConstraint) {
                    return constraint;
                }
                ++n;
            }
        }
        return table;
    }

    private Map<String, List<LOBDescriptor>> getPartitionLOBs(Table table, String query) throws DBException {
        HashMap<String, List<LOBDescriptor>> lobPartitions = new HashMap<String, List<LOBDescriptor>>();
        QueryWrapper wrap = this.newQueryWrapper(query, table.getSchema(), table);
        7 r = new 7(this, lobPartitions, table, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        return lobPartitions;
    }

    static {
        $assertionsDisabled = OracleTableBuilder.class.desiredAssertionStatus() ^ true;
    }

    private void initialisePartition(TablePartition partition, ResultSet rs, Map<String, List<LOBDescriptor>> lobPartitions, Map<String, OracleTablePartitions> partitionLevelSubpartitions) throws SQLException {
        if (partition != null && partition.getPartitionType() != null) {
            if (partition.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
                this.initialiseHashPartition(partition, rs.getString("TABLESPACE_NAME"), lobPartitions);
            } else {
                OracleTablePartitions plSubpartitions;
                List<LOBDescriptor> lobDescriptors;
                partition.setValues(rs.getString("HIGH_VALUE"));
                String compression = rs.getString("COMPRESSION");
                if ("ENABLED".equals(compression)) {
                    partition.setCompression("COMPRESS");
                } else if ("DISABLED".equals(compression) || "NONE".equals(compression)) {
                    partition.setCompression("NOCOMPRESS");
                }
                partition.setSegmentAttributes(OracleTableBuilder.getSegmentAttributeProperties(rs));
                if (lobPartitions != null && lobPartitions.containsKey(partition.getName()) && (lobDescriptors = lobPartitions.get(partition.getName())) != null) {
                    for (LOBDescriptor lob : lobDescriptors) {
                        lob.setID((DBObjectID)new NameBasedID((DBObject)lob, partition.getID()));
                        partition.addLOBDescriptor(lob);
                    }
                }
                if (partition.getPartitionType() == OracleTablePartitions.PartitionType.RANGE && partitionLevelSubpartitions != null && partitionLevelSubpartitions.containsKey(partition.getName()) && (plSubpartitions = partitionLevelSubpartitions.get(partition.getName())) != null) {
                    NameBasedID plsID = new NameBasedID((DBObject)plSubpartitions, partition.getID());
                    plSubpartitions.setID((DBObjectID)plsID);
                    TablePartition[] tablePartitionArray = plSubpartitions.getPartitions();
                    int n = 0;
                    while (n < tablePartitionArray.length) {
                        TablePartition subpartition = tablePartitionArray[n];
                        NameBasedID subpartid = new NameBasedID((DBObject)subpartition, (DBObjectID)plsID);
                        subpartition.setID((DBObjectID)subpartid);
                        LOBDescriptor[] lobDescriptors2 = subpartition.getLOBDescriptors();
                        if (lobDescriptors2 != null) {
                            LOBDescriptor[] lOBDescriptorArray = lobDescriptors2;
                            int n2 = 0;
                            while (n2 < lOBDescriptorArray.length) {
                                LOBDescriptor lob = lOBDescriptorArray[n2];
                                NameBasedID id = new NameBasedID((DBObject)lob, (DBObjectID)subpartid);
                                lob.setID((DBObjectID)id);
                                ++n2;
                            }
                        }
                        ++n;
                    }
                    partition.setPartitionLevelSubpartitions(plSubpartitions);
                }
            }
        } else if (!($assertionsDisabled || partition != null && partition.getPartitionType() != null)) {
            throw new AssertionError();
        }
    }

    private void initialiseHashPartition(TablePartition partition, String tsName, Map<String, List<LOBDescriptor>> lobPartitions) {
        this.addTablespace(partition, tsName);
        if (lobPartitions != null && lobPartitions.containsKey(partition.getName())) {
            List<LOBDescriptor> lobDescriptors = lobPartitions.get(partition.getName());
            int i = 0;
            while (i < lobDescriptors.size()) {
                LOBDescriptor partitionStorageLOB = new LOBDescriptor();
                partition.addLOBDescriptor(partitionStorageLOB);
                LOBDescriptor lob = lobDescriptors.get(i);
                NameBasedID id = new NameBasedID((DBObject)lob, partition.getID());
                partitionStorageLOB.setID((DBObjectID)id);
                partitionStorageLOB.setColumns(lob.getColumns());
                partitionStorageLOB.setLOBSegName(lob.getLOBSegName());
                if (lob.getStorage() != null && ModelUtil.hasLength((String)lob.getStorage().getTablespace())) {
                    this.addTablespace(partitionStorageLOB, lob.getStorage().getTablespace());
                }
                ++i;
            }
        }
    }

    private void getSubpartitionColumns(Table table, OracleTablePartitions subpartitions) throws DBException {
        QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_TABLE_SUBPARTITION_COLUMNS_QUERY*/\n       COLUMN_NAME\nfrom   ALL_SUBPART_KEY_COLUMNS\nwhere  OWNER = ?\nand    NAME  = ?\norder by COLUMN_POSITION", table.getSchema(), table);
        8 r = new 8(this, table, subpartitions, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
    }

    private void getSubpartitionTemplates(Table table, OracleTablePartitions subpartitions) throws DBException {
        QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_TABLE_SUBPARTITION_TEMPLATES_QUERY*/\n       SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_BOUND\nfrom   ALL_SUBPARTITION_TEMPLATES\nwhere  USER_NAME  = ?\nand    TABLE_NAME = ?\norder by SUBPARTITION_POSITION", table.getSchema(), table);
        9 r = new 9(this, subpartitions, wrap, table);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        this.getSubpartitionLOBTemplates(table, subpartitions.getPartitions());
    }

    private void getSubpartitionLOBTemplates(Table table, TablePartition[] subpartitionTemplates) throws DBException {
        if (subpartitionTemplates.length > 0) {
            QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_TABLE_LOB_TEMPLATES_QUERY*/\n       distinct SUBPARTITION_NAME, LOB_SEGMENT_NAME, TABLESPACE_NAME, LOB_COL_NAME\nfrom   ALL_LOB_TEMPLATES\nwhere  USER_NAME  = ?\nand    TABLE_NAME = ?\norder by SUBPARTITION_NAME", table.getSchema(), table);
            10 r = new 10(this, subpartitionTemplates, table, wrap);
            wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        }
    }

    private TablePartition findSubpartitionTemplate(String name, TablePartition[] subpartitions) {
        int i = 0;
        while (i < subpartitions.length) {
            if (subpartitions[i].getName().equals(name)) {
                return subpartitions[i];
            }
            ++i;
        }
        return null;
    }

    private Map<String, OracleTablePartitions> getPartitionLevelSubpartitions(Table table, OracleTablePartitions.PartitionType partitionType) throws DBException {
        HashMap<String, OracleTablePartitions> subpartitionMap = new HashMap<String, OracleTablePartitions>();
        Map<String, List<LOBDescriptor>> lobSubpartitionMap = this.getPartitionLOBs(table, "select /*OracleDictionaryQueries.ALL_TABLE_PARTITION_LEVEL_SUBPARTITION_LOBS_QUERY*/\n       LS.COLUMN_NAME\n,      LS.SUBPARTITION_NAME NAME\n,      LS.LOB_SUBPARTITION_NAME LOB_SEGMENT_NAME\n,      LS.CHUNK\n,      LS.PCTVERSION\n,      LS.CACHE\n,      LS.IN_ROW\n,      LS.TABLESPACE_NAME\n,      LS.LOGGING\n,      LS.BUFFER_POOL\n,      LS.INITIAL_EXTENT\n,      LS.NEXT_EXTENT\n,      LS.MIN_EXTENTS\n,      LS.MAX_EXTENTS\n,      LS.PCT_INCREASE\n,      LS.FREELISTS\n,      LS.FREELIST_GROUPS\nfrom   ALL_LOB_SUBPARTITIONS LS\n,      ALL_LOBS L\nwhere  LS.TABLE_OWNER = :1\nand    LS.TABLE_NAME  = :2\nand    LS.TABLE_OWNER = L.OWNER\nand    LS.TABLE_NAME = L.TABLE_NAME\nand    LS.COLUMN_NAME = L.COLUMN_NAME\norder by LS.SUBPARTITION_NAME");
        QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_TABLE_PARTITION_LEVEL_SUBPARTITIONS_QUERY*/\n       PARTITION_NAME, SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_VALUE\nfrom   ALL_TAB_SUBPARTITIONS\nwhere  TABLE_OWNER = ?\nand    TABLE_NAME  = ?\norder by PARTITION_NAME, SUBPARTITION_POSITION", table.getSchema(), table);
        11 r = new 11(this, subpartitionMap, partitionType, lobSubpartitionMap, wrap, table);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        return subpartitionMap;
    }

    private Map<String, List<LOBDescriptor>> getPartitionLevelSubpartitionLOBs(Table table) throws DBException {
        HashMap<String, List<LOBDescriptor>> lobDescriptorsMap = new HashMap<String, List<LOBDescriptor>>();
        QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_TABLE_PARTITION_LEVEL_SUBPARTITION_LOBS_QUERY*/\n       LS.COLUMN_NAME\n,      LS.SUBPARTITION_NAME NAME\n,      LS.LOB_SUBPARTITION_NAME LOB_SEGMENT_NAME\n,      LS.CHUNK\n,      LS.PCTVERSION\n,      LS.CACHE\n,      LS.IN_ROW\n,      LS.TABLESPACE_NAME\n,      LS.LOGGING\n,      LS.BUFFER_POOL\n,      LS.INITIAL_EXTENT\n,      LS.NEXT_EXTENT\n,      LS.MIN_EXTENTS\n,      LS.MAX_EXTENTS\n,      LS.PCT_INCREASE\n,      LS.FREELISTS\n,      LS.FREELIST_GROUPS\nfrom   ALL_LOB_SUBPARTITIONS LS\n,      ALL_LOBS L\nwhere  LS.TABLE_OWNER = :1\nand    LS.TABLE_NAME  = :2\nand    LS.TABLE_OWNER = L.OWNER\nand    LS.TABLE_NAME = L.TABLE_NAME\nand    LS.COLUMN_NAME = L.COLUMN_NAME\norder by LS.SUBPARTITION_NAME", table.getSchema(), table);
        12 r = new 12(this, lobDescriptorsMap, table, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        return lobDescriptorsMap;
    }

    private void addTablespace(TablePartition partition, String tablespaceName) {
        OracleStorageProperties segmentAttributes = this.getSegmentAttributes(partition);
        segmentAttributes.setTablespace(tablespaceName);
    }

    private void addTablespace(LOBDescriptor descriptor, String tablespaceName) {
        OracleStorageProperties storage = descriptor.getStorage();
        if (storage == null) {
            storage = new OracleStorageProperties();
            descriptor.setStorage(storage);
        }
        storage.setTablespace(tablespaceName);
    }

    private OracleStorageProperties getSegmentAttributes(TablePartition partition) {
        OracleStorageProperties segmentAttributes = partition.getSegmentAttributes();
        if (segmentAttributes == null) {
            segmentAttributes = new OracleStorageProperties();
            partition.setSegmentAttributes(segmentAttributes);
        }
        return segmentAttributes;
    }

    private OracleIndexOrganizedTableProperties getIotProperties(Table table) throws DBException {
        OracleIndexOrganizedTableProperties properties = new OracleIndexOrganizedTableProperties();
        properties.setID((DBObjectID)new NameBasedID((DBObject)properties, table.getID()));
        this.populateIotPropsFromAllIndexes(table, properties);
        this.populateIotPropsFromAllTables(table, properties);
        return properties;
    }

    private void populateIotPropsFromAllIndexes(Table table, OracleIndexOrganizedTableProperties properties) throws DBException {
        QueryWrapper wrap = this.newQueryWrapper(OracleDictionaryQueries.TABLE_IOT_INDEX_QUERY, table.getSchema(), this.getQueryObject(table));
        13 r = new 13(this, properties, table, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
    }

    private void populateIotPropsFromAllTables(Table table, OracleIndexOrganizedTableProperties properties) throws DBException {
        QueryWrapper wrap = this.newQueryWrapper(OracleDictionaryQueries.TABLE_IOT_MAPPING_AND_OVERFLOW_QUERY, table.getSchema(), table);
        14 r = new 14(this, properties, table, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
    }

    private OracleExternalTableProperties getExternalTableProperties(Table table) throws DBException {
        Holder holder = new Holder();
        BaseOracleDatabase db = this.getDatabase();
        int dbType = db.getOracleDatabaseType();
        String query = OracleTableBuilder.getExternalTableQuery(dbType);
        if (query != null) {
            QueryWrapper wrap = this.newQueryWrapper(query, table.getSchema(), table);
            15 r = new 15(this, holder, wrap, table);
            wrap.executeQuery((QueryWrapper.QueryRunnable)r);
            OracleExternalTableProperties properties = (OracleExternalTableProperties)holder.get();
            if (properties != null) {
                this.populateLocAndDir(table, properties);
            }
        }
        return (OracleExternalTableProperties)holder.get();
    }

    private void populateLocAndDir(Table table, OracleExternalTableProperties properties) throws DBException {
        QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_TABLE_EXT_LOCATIONS_QUERY*/\n       LOCATION, DIRECTORY_OWNER, DIRECTORY_NAME \nfrom   SYS.ALL_EXTERNAL_LOCATIONS \nwhere  OWNER = ?\nand    TABLE_NAME = ?\n", table.getSchema(), table);
        16 r = new 16(this, properties, wrap, table);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
    }

    private DBObjectID getDirectory(String owner, String name) {
        if (ModelUtil.hasLength((String)name)) {
            return new ReferenceID("DIRECTORY", owner, name);
        }
        return null;
    }

    private static String getExternalTableQuery(int databaseType) {
        switch (databaseType) {
            case 0: 
            case 1: 
            case 2: 
            case 9: {
                return null;
            }
            case 3: 
            case 4: {
                return "select /*OracleDictionaryQueries.ALL_TABLE_EXTERNAL_TAB_ORACLE9i_QUERY*/\n       TYPE_NAME, REJECT_LIMIT, ACCESS_TYPE, ACCESS_PARAMETERS, null, \n       DEFAULT_DIRECTORY_OWNER, DEFAULT_DIRECTORY_NAME \nfrom   SYS.ALL_EXTERNAL_TABLES \nwhere  OWNER = ? \nand    TABLE_NAME = ? \n";
            }
        }
        return "select /*OracleDictionaryQueries.ALL_TABLE_EXTERNAL_TAB_QUERY*/\n       TYPE_NAME, REJECT_LIMIT, ACCESS_TYPE, ACCESS_PARAMETERS, PROPERTY, \n       DEFAULT_DIRECTORY_OWNER, DEFAULT_DIRECTORY_NAME \nfrom   SYS.ALL_EXTERNAL_TABLES \nwhere  OWNER = ? \nand    TABLE_NAME = ? \n";
    }

    protected String getTableQuery() {
        String query = null;
        switch (this.getDatabase().getOracleDatabaseType()) {
            case 9: {
                query = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_OLITE_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       null FREELISTS, null FREELIST_GROUPS, null LOGGING,\n       null BUFFER_POOL, 'N' TEMPORARY, null DURATION,\n       null IOT_TYPE, null PARTITIONED, 'NO' NESTED\n, null COMPRESSION, null DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
                break;
            }
            case 0: {
                query = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE7_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, null LOGGING, null BUFFER_POOL,\n       'N' TEMPORARY, null DURATION,\n       null IOT_TYPE, null PARTITIONED, 'NO' NESTED, null COMPRESSION, 1 DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
                break;
            }
            case 1: 
            case 2: {
                query = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE8_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       'N' TEMPORARY, null DURATION,\n       IOT_TYPE, PARTITIONED, NESTED, null COMPRESSION, DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
                break;
            }
            case 3: 
            case 4: {
                query = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE9_QUERY(ALL_TABLES)*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, TEMPORARY, DURATION,\n       IOT_TYPE, PARTITIONED, NESTED, null COMPRESSION, DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
                break;
            }
            default: {
                query = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_QUERY(ALL_TABLES)*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, TEMPORARY, DURATION,\n       IOT_TYPE, PARTITIONED, NESTED, COMPRESSION, DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
                break;
            }
        }
        return query;
    }

    private String getObjectTableQuery() {
        String query = null;
        switch (this.getDatabase().getOracleDatabaseType()) {
            case 0: 
            case 1: 
            case 9: {
                query = null;
                break;
            }
            default: {
                Pattern p1 = Pattern.compile("ALL_TABLES", 2);
                query = p1.matcher("SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_QUERY(ALL_TABLES)*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, TEMPORARY, DURATION,\n       IOT_TYPE, PARTITIONED, NESTED, COMPRESSION, DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?").replaceAll("ALL_OBJECT_TABLES");
                break;
            }
        }
        return query;
    }

    private static String getLobParametersQuery(int databaseType) {
        return databaseType > 2 ? "SELECT /*OracleDictionaryQueries.ALL_TABLE_LOB_PARMATERS_QUERY*/ \n       AL.COLUMN_NAME\n,      AL.SEGMENT_NAME\n,      AL.PCTVERSION\n,      AL.IN_ROW\n,      AL.CHUNK\n,      AL.FREEPOOLS\n,      AL.RETENTION\n,      PS.TABLESPACE_NAME\n,      AL.CACHE\n,      AL.LOGGING\n,      PS.INITIAL_EXTENT\n,      PS.NEXT_EXTENT\n,      PS.MIN_EXTENTS\n,      PS.MAX_EXTENTS\n,      PS.PCT_INCREASE\n,      PS.FREELISTS\n,      PS.FREELIST_GROUPS\n,      PS.BUFFER_POOL\nFROM   ALL_LOBS AL\n,      ALL_TABLES T\n,     (SELECT US.SEGMENT_NAME\n       ,      US.TABLESPACE_NAME\n       ,      US.INITIAL_EXTENT\n       ,      US.NEXT_EXTENT\n       ,      US.MIN_EXTENTS\n       ,      US.MAX_EXTENTS\n       ,      US.PCT_INCREASE\n       ,      US.FREELISTS\n       ,      US.FREELIST_GROUPS\n       ,      US.BUFFER_POOL\n       ,      US.PARTITION_NAME\n       FROM   USER_SEGMENTS US\n       ,      USER_LOBS UL\n       WHERE  US.SEGMENT_NAME = UL.SEGMENT_NAME\n       AND    US.PARTITION_NAME IS NULL\n       AND    US.SEGMENT_TYPE = 'LOBSEGMENT'\n       AND    USER = ?\n       AND    UL.TABLE_NAME = ?\n      ) PS\nWHERE AL.OWNER = ?\nAND   AL.TABLE_NAME = ?\nAND   AL.OWNER = T.OWNER\nAND   AL.TABLE_NAME = T.TABLE_NAME\nAND   T.PARTITIONED = 'NO'\nAND   AL.SEGMENT_NAME = PS.SEGMENT_NAME (+)" : "SELECT /*OracleDictionaryQueries.ALL_TABLE_LOB_PARMATERS_QUERY*/ \n       AL.COLUMN_NAME\n,      AL.SEGMENT_NAME\n,      AL.PCTVERSION\n,      AL.IN_ROW\n,      AL.CHUNK\n,      AL.FREEPOOLS\n,      AL.RETENTION\n,      PS.TABLESPACE_NAME\n,      AL.CACHE\n,      AL.LOGGING\n,      PS.INITIAL_EXTENT\n,      PS.NEXT_EXTENT\n,      PS.MIN_EXTENTS\n,      PS.MAX_EXTENTS\n,      PS.PCT_INCREASE\n,      PS.FREELISTS\n,      PS.FREELIST_GROUPS\n,      PS.BUFFER_POOL\nFROM   ALL_LOBS AL\n,      ALL_TABLES T\n,     (SELECT US.SEGMENT_NAME\n       ,      US.TABLESPACE_NAME\n       ,      US.INITIAL_EXTENT\n       ,      US.NEXT_EXTENT\n       ,      US.MIN_EXTENTS\n       ,      US.MAX_EXTENTS\n       ,      US.PCT_INCREASE\n       ,      US.FREELISTS\n       ,      US.FREELIST_GROUPS\n       ,      US.BUFFER_POOL\n       ,      US.PARTITION_NAME\n       FROM   USER_SEGMENTS US\n       ,      USER_LOBS UL\n       WHERE  US.SEGMENT_NAME = UL.SEGMENT_NAME\n       AND    US.PARTITION_NAME IS NULL\n       AND    US.SEGMENT_TYPE = 'LOBSEGMENT'\n       AND    USER = ?\n       AND    UL.TABLE_NAME = ?\n      ) PS\nWHERE AL.OWNER = ?\nAND   AL.TABLE_NAME = ?\nAND   AL.OWNER = T.OWNER\nAND   AL.TABLE_NAME = T.TABLE_NAME\nAND   T.PARTITIONED = 'NO'\nAND   AL.SEGMENT_NAME = PS.SEGMENT_NAME (+)".replaceFirst("AL.FREEPOOLS", "null FREEPOOLS").replaceFirst("AL.RETENTION", "null RETENTION");
    }

    @Override
    protected void fillInObjectComponent(SchemaObject object, String key) throws DBException {
        Table table = (Table)object;
        if (key.equals("INDEX")) {
            this.ensureComponent((AbstractSchemaObject)table, "COLUMN");
            this.ensureComponent((AbstractSchemaObject)table, "CONSTRAINT");
            this.fillInIndexes(table);
        } else if (key.equals("BASE")) {
            this.buildBaseProperties(table);
        } else if (key.equals("TableType") || key.equals("OracleStorageProperties") || key.equals("OracleExternalTableProperties") || key.equals("NESTED TABLE") || key.equals("compression") || key.equals("parallel") || key.equals("PARTITIONED TABLE")) {
            this.ensureComponent((AbstractSchemaObject)table, "BASE");
        } else {
            super.fillInObjectComponent(object, key);
        }
    }

    protected boolean canBuildComponents() {
        return true;
    }

    static DBObjectID mav$getDirectory(OracleTableBuilder oracleTableBuilder, String string, String string2) {
        return oracleTableBuilder.getDirectory(string, string2);
    }

    static OracleStorageProperties mav$getSegmentAttributeProperties(OracleTableBuilder oracleTableBuilder, String string, Table table, String string2) {
        return oracleTableBuilder.getSegmentAttributeProperties(string, table, string2);
    }

    static void mav$addTablespace(OracleTableBuilder oracleTableBuilder, LOBDescriptor lOBDescriptor, String string) {
        oracleTableBuilder.addTablespace(lOBDescriptor, string);
    }

    static void mav$addTablespace(OracleTableBuilder oracleTableBuilder, TablePartition tablePartition, String string) {
        oracleTableBuilder.addTablespace(tablePartition, string);
    }

    static TablePartition mav$findSubpartitionTemplate(OracleTableBuilder oracleTableBuilder, String string, TablePartition[] tablePartitionArray) {
        return oracleTableBuilder.findSubpartitionTemplate(string, tablePartitionArray);
    }

    static OracleStorageProperties maS$getStorageProperties(ResultSet resultSet) {
        return OracleTableBuilder.getStorageProperties(resultSet);
    }

    static void mav$initialisePartition(OracleTableBuilder oracleTableBuilder, TablePartition tablePartition, ResultSet resultSet, Map map, Map map2) {
        oracleTableBuilder.initialisePartition(tablePartition, resultSet, map, map2);
    }

    static void mav$getBasePropertiesFromRS(OracleTableBuilder oracleTableBuilder, Table table, ResultSet resultSet) {
        oracleTableBuilder.getBasePropertiesFromRS(table, resultSet);
    }

    final class 1
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Holder v$tryObjectQuery;
        private final /* synthetic */ Table v$table;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleTableBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    this.v$tryObjectQuery.set((Object)false);
                    OracleTableBuilder.mav$getBasePropertiesFromRS(this.this$0, this.v$table, rs);
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$table, ex);
            }
        }

        public 1(OracleTableBuilder oracleTableBuilder, Holder holder, Table table, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$table = table;
            this.v$tryObjectQuery = holder;
            this.this$0 = oracleTableBuilder;
        }
    }

    final class 2
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Table v$table;
        private final /* synthetic */ QueryWrapper v$wrap2;
        final /* synthetic */ OracleTableBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    this.v$table.setProperty("OBJECT TABLE", (Object)Boolean.TRUE);
                    OracleTableBuilder.mav$getBasePropertiesFromRS(this.this$0, this.v$table, rs);
                }
            }
            catch (SQLException ex) {
                this.v$wrap2.throwDBException((DBObject)this.v$table, ex);
            }
        }

        public 2(OracleTableBuilder oracleTableBuilder, Table table, QueryWrapper queryWrapper) {
            this.v$wrap2 = queryWrapper;
            this.v$table = table;
            this.this$0 = oracleTableBuilder;
        }
    }

    final class 3
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Holder v$osp;
        private final /* synthetic */ QueryWrapper v$wrap;
        private final /* synthetic */ Table v$table;
        final /* synthetic */ OracleTableBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    this.v$osp.set((Object)OracleTableBuilder.getSegmentAttributeProperties(rs));
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$table, ex);
            }
        }

        public 3(OracleTableBuilder oracleTableBuilder, Holder holder, QueryWrapper queryWrapper, Table table) {
            this.v$table = table;
            this.v$wrap = queryWrapper;
            this.v$osp = holder;
            this.this$0 = oracleTableBuilder;
        }
    }

    final class 4
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Table v$table;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleTableBuilder this$0;

        public void processResultSet(ResultSet rs2) throws DBException {
            try {
                while (rs2.next()) {
                    LOBDescriptor lobDescriptor = new LOBDescriptor();
                    int chunk = rs2.getInt("CHUNK");
                    lobDescriptor.setChunk(rs2.wasNull() ? null : Integer.valueOf(chunk));
                    lobDescriptor.setLOBSegName(rs2.getString("SEGMENT_NAME"));
                    int pctVersion = rs2.getInt("PCTVERSION");
                    lobDescriptor.setPctVersion(rs2.wasNull() ? null : Integer.valueOf(pctVersion));
                    lobDescriptor.setStorageEnabledInRow("YES".equalsIgnoreCase(rs2.getString("IN_ROW")));
                    int freepools = rs2.getInt("FREEPOOLS");
                    lobDescriptor.setFreepools(rs2.wasNull() ? null : Integer.valueOf(freepools));
                    if (lobDescriptor.getPctVersion() == null) {
                        rs2.getInt("RETENTION");
                        lobDescriptor.setRetention(rs2.wasNull() ^ true);
                    }
                    String cache = rs2.getString("CACHE");
                    if (!rs2.wasNull() && cache != null) {
                        lobDescriptor.setCache(cache.equals("YES") ? "CACHE" : (cache.equals("NO") ? "NOCACHE" : (cache.equals("CACHEREADS") ? "CACHE READS" : null)));
                    }
                    OracleStorageProperties storage = OracleTableBuilder.maS$getStorageProperties(rs2);
                    lobDescriptor.setStorage(storage);
                    storage.setTablespace(rs2.getString("TABLESPACE_NAME"));
                    String logging = rs2.getString("LOGGING");
                    if (!rs2.wasNull() && logging != null) {
                        storage.setLogging("YES".equalsIgnoreCase(logging) ? Boolean.TRUE : Boolean.FALSE);
                    }
                    OracleColumnProperties ocp = new OracleColumnProperties();
                    Column col = this.v$table.getColumn(rs2.getString("COLUMN_NAME"));
                    if (col == null) continue;
                    if (LOBDescriptor.isLOBColumn((Column)col)) {
                        ocp.setLOBProperties(lobDescriptor);
                    } else if (LOBDescriptor.isVARRAYColumn((Column)col)) {
                        ocp.setVAProperties(lobDescriptor);
                    }
                    col.setProperty("OracleColumnProperties", (Object)ocp);
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$table, ex);
            }
        }

        public 4(OracleTableBuilder oracleTableBuilder, Table table, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$table = table;
            this.this$0 = oracleTableBuilder;
        }
    }

    final class 5
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Holder v$holder;
        private final /* synthetic */ Table v$table;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleTableBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    Column col;
                    OracleTablePartitions partitions = (OracleTablePartitions)this.v$holder.get();
                    if (partitions == null) {
                        String partitionType = rs.getString(1);
                        String subpartitionType = rs.getString(2);
                        if ("HASH".equals(partitionType) || "LIST".equals(partitionType) || "RANGE".equals(partitionType)) {
                            partitions = new OracleTablePartitions(OracleTablePartitions.PartitionType.valueOf((String)partitionType), OracleTablePartitions.ObjectType.PARTITION);
                            this.v$holder.set((Object)partitions);
                            NameBasedID parid = new NameBasedID((DBObject)partitions, this.v$table.getID());
                            partitions.setID((DBObjectID)parid);
                            if ("HASH".equals(subpartitionType) || "LIST".equals(subpartitionType)) {
                                OracleTablePartitions subpartitionModel = new OracleTablePartitions(OracleTablePartitions.PartitionType.valueOf((String)subpartitionType), OracleTablePartitions.ObjectType.SUBPARTITION);
                                subpartitionModel.setID((DBObjectID)new NameBasedID((DBObject)subpartitionModel, (DBObjectID)parid));
                                partitions.setSubpartitionModel(subpartitionModel);
                            }
                        }
                    }
                    if (partitions == null || (col = this.v$table.getColumn(rs.getString(3))) == null) continue;
                    partitions.addPartitionColumn(col.getID());
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException((DBObject)this.v$table, sqe);
            }
        }

        public 5(OracleTableBuilder oracleTableBuilder, Holder holder, Table table, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$table = table;
            this.v$holder = holder;
            this.this$0 = oracleTableBuilder;
        }
    }

    final class 6
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ OracleTablePartitions v$partitions;
        private final /* synthetic */ Map v$lobPartitions;
        private final /* synthetic */ Map v$partitionLevelSubpartitions;
        private final /* synthetic */ QueryWrapper v$wrap2;
        private final /* synthetic */ Table v$table;
        final /* synthetic */ OracleTableBuilder this$0;

        public void processResultSet(ResultSet rs2) throws DBException {
            try {
                while (rs2.next()) {
                    TablePartition partition = this.v$partitions.createPartition(rs2.getString("PARTITION_NAME"));
                    partition.setID((DBObjectID)new NameBasedID((DBObject)partition, this.v$partitions.getID()));
                    OracleTableBuilder.mav$initialisePartition(this.this$0, partition, rs2, this.v$lobPartitions, this.v$partitionLevelSubpartitions);
                }
            }
            catch (SQLException sqe) {
                this.v$wrap2.throwDBException((DBObject)this.v$table, sqe);
            }
        }

        public 6(OracleTableBuilder oracleTableBuilder, OracleTablePartitions oracleTablePartitions, Map map, Map map2, QueryWrapper queryWrapper, Table table) {
            this.v$table = table;
            this.v$wrap2 = queryWrapper;
            this.v$partitionLevelSubpartitions = map2;
            this.v$lobPartitions = map;
            this.v$partitions = oracleTablePartitions;
            this.this$0 = oracleTableBuilder;
        }
    }

    final class 7
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Map v$lobPartitions;
        private final /* synthetic */ Table v$table;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleTableBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    List<LOBDescriptor> lobItems;
                    String partitionName = rs.getString("NAME");
                    if (!this.v$lobPartitions.containsKey(partitionName)) {
                        lobItems = new ArrayList();
                        this.v$lobPartitions.put(partitionName, lobItems);
                    } else {
                        lobItems = (List)this.v$lobPartitions.get(partitionName);
                    }
                    LOBDescriptor lobDescriptor = new LOBDescriptor();
                    lobItems.add(lobDescriptor);
                    lobDescriptor.addColumn(this.v$table.getColumn(rs.getString("COLUMN_NAME")).getID());
                    int chunk = rs.getInt("CHUNK");
                    lobDescriptor.setChunk(rs.wasNull() ? null : Integer.valueOf(chunk));
                    lobDescriptor.setLOBSegName(rs.getString("LOB_SEGMENT_NAME"));
                    int pctVersion = rs.getInt("PCTVERSION");
                    lobDescriptor.setPctVersion(rs.wasNull() ? null : Integer.valueOf(pctVersion));
                    lobDescriptor.setStorageEnabledInRow("YES".equalsIgnoreCase(rs.getString("IN_ROW")));
                    String cache = rs.getString("CACHE");
                    if (!rs.wasNull() && cache != null) {
                        lobDescriptor.setCache(cache.equals("YES") ? "CACHE" : (cache.equals("NO") ? "NOCACHE" : (cache.equals("CACHEREADS") ? "CACHE READS" : null)));
                    }
                    OracleStorageProperties storage = OracleTableBuilder.maS$getStorageProperties(rs);
                    lobDescriptor.setStorage(storage);
                    storage.setTablespace(rs.getString("TABLESPACE_NAME"));
                    String logging = rs.getString("LOGGING");
                    if (rs.wasNull() || logging == null) continue;
                    storage.setLogging("YES".equalsIgnoreCase(logging) ? Boolean.TRUE : Boolean.FALSE);
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException((DBObject)this.v$table, sqe);
            }
        }

        public 7(OracleTableBuilder oracleTableBuilder, Map map, Table table, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$table = table;
            this.v$lobPartitions = map;
            this.this$0 = oracleTableBuilder;
        }
    }

    final class 8
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Table v$table;
        private final /* synthetic */ OracleTablePartitions v$subpartitions;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleTableBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    Column col = this.v$table.getColumn(rs.getString(1));
                    if (col == null) continue;
                    this.v$subpartitions.addPartitionColumn(col.getID());
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException((DBObject)this.v$table, sqe);
            }
        }

        public 8(OracleTableBuilder oracleTableBuilder, Table table, OracleTablePartitions oracleTablePartitions, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$subpartitions = oracleTablePartitions;
            this.v$table = table;
            this.this$0 = oracleTableBuilder;
        }
    }

    final class 9
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ OracleTablePartitions v$subpartitions;
        private final /* synthetic */ QueryWrapper v$wrap;
        private final /* synthetic */ Table v$table;
        final /* synthetic */ OracleTableBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    String tablespaceName;
                    this.v$subpartitions.setObjectType(OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE);
                    String name = rs.getString("SUBPARTITION_NAME");
                    TablePartition template = this.v$subpartitions.createPartition(name);
                    template.setID((DBObjectID)new NameBasedID((DBObject)template, this.v$subpartitions.getID()));
                    String values = rs.getString("HIGH_BOUND");
                    if (values != null && !rs.wasNull()) {
                        template.setValues(values);
                    }
                    if ((tablespaceName = rs.getString("TABLESPACE_NAME")) == null || rs.wasNull()) continue;
                    OracleTableBuilder.mav$addTablespace(this.this$0, template, tablespaceName);
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException((DBObject)this.v$table, sqe);
            }
        }

        public 9(OracleTableBuilder oracleTableBuilder, OracleTablePartitions oracleTablePartitions, QueryWrapper queryWrapper, Table table) {
            this.v$table = table;
            this.v$wrap = queryWrapper;
            this.v$subpartitions = oracleTablePartitions;
            this.this$0 = oracleTableBuilder;
        }
    }

    final class 10
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ TablePartition[] v$subpartitionTemplates;
        static final /* synthetic */ boolean $assertionsDisabled;
        private final /* synthetic */ Table v$table;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleTableBuilder this$0;

        static {
            $assertionsDisabled = 10.class.desiredAssertionStatus() ^ true;
        }

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    TablePartition template = OracleTableBuilder.mav$findSubpartitionTemplate(this.this$0, rs.getString("SUBPARTITION_NAME"), this.v$subpartitionTemplates);
                    if (!$assertionsDisabled && template == null) {
                        throw new AssertionError();
                    }
                    if (template == null) continue;
                    LOBDescriptor lobDescriptor = new LOBDescriptor();
                    template.addLOBDescriptor(lobDescriptor);
                    lobDescriptor.setID((DBObjectID)new NameBasedID((DBObject)lobDescriptor, template.getID()));
                    lobDescriptor.addColumn(this.v$table.getColumn(rs.getString("LOB_COL_NAME")).getID());
                    lobDescriptor.setLOBSegName(rs.getString("LOB_SEGMENT_NAME"));
                    String tablespaceName = rs.getString("TABLESPACE_NAME");
                    if (tablespaceName == null || rs.wasNull()) continue;
                    OracleTableBuilder.mav$addTablespace(this.this$0, lobDescriptor, tablespaceName);
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException((DBObject)this.v$table, sqe);
            }
        }

        public 10(OracleTableBuilder oracleTableBuilder, TablePartition[] tablePartitionArray, Table table, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$table = table;
            this.v$subpartitionTemplates = tablePartitionArray;
            this.this$0 = oracleTableBuilder;
        }
    }

    final class 11
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Map v$subpartitionMap;
        private final /* synthetic */ OracleTablePartitions.PartitionType v$partitionType;
        private final /* synthetic */ Map v$lobSubpartitionMap;
        private final /* synthetic */ QueryWrapper v$wrap;
        private final /* synthetic */ Table v$table;
        final /* synthetic */ OracleTableBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                OracleTablePartitions subpartitions = null;
                while (rs.next()) {
                    List lobDescriptors;
                    String partitionName = rs.getString("PARTITION_NAME");
                    if (!this.v$subpartitionMap.containsKey(partitionName)) {
                        subpartitions = new OracleTablePartitions(this.v$partitionType, OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION);
                        this.v$subpartitionMap.put(partitionName, subpartitions);
                    }
                    String subpartitionName = rs.getString("SUBPARTITION_NAME");
                    TablePartition subpartition = subpartitions.createPartition(subpartitionName);
                    subpartition.setValues(rs.getString("HIGH_VALUE"));
                    String tablespaceName = rs.getString("TABLESPACE_NAME");
                    if (tablespaceName != null && !rs.wasNull()) {
                        OracleTableBuilder.mav$addTablespace(this.this$0, subpartition, tablespaceName);
                    }
                    if (this.v$lobSubpartitionMap == null || !this.v$lobSubpartitionMap.containsKey(subpartitionName) || (lobDescriptors = (List)this.v$lobSubpartitionMap.get(subpartitionName)) == null) continue;
                    subpartition.setLOBDescriptors(lobDescriptors.toArray(new LOBDescriptor[lobDescriptors.size()]));
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException((DBObject)this.v$table, sqe);
            }
        }

        public 11(OracleTableBuilder oracleTableBuilder, Map map, OracleTablePartitions.PartitionType partitionType, Map map2, QueryWrapper queryWrapper, Table table) {
            this.v$table = table;
            this.v$wrap = queryWrapper;
            this.v$lobSubpartitionMap = map2;
            this.v$partitionType = partitionType;
            this.v$subpartitionMap = map;
            this.this$0 = oracleTableBuilder;
        }
    }

    final class 12
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Map v$lobDescriptorsMap;
        private final /* synthetic */ Table v$table;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleTableBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                ArrayList<LOBDescriptor> lobDescriptors = null;
                while (rs.next()) {
                    String subpartitionName = rs.getString("SUBPARTITION_NAME");
                    if (!this.v$lobDescriptorsMap.containsKey(subpartitionName)) {
                        lobDescriptors = new ArrayList<LOBDescriptor>();
                        this.v$lobDescriptorsMap.put(subpartitionName, lobDescriptors);
                    }
                    LOBDescriptor lob = new LOBDescriptor();
                    lobDescriptors.add(lob);
                    lob.addColumn(this.v$table.getColumn(rs.getString("COLUMN_NAME")).getID());
                    lob.setLOBSegName(rs.getString("LOB_SUBPARTITION_NAME"));
                    OracleTableBuilder.mav$addTablespace(this.this$0, lob, rs.getString("TABLESPACE_NAME"));
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException((DBObject)this.v$table, sqe);
            }
        }

        public 12(OracleTableBuilder oracleTableBuilder, Map map, Table table, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$table = table;
            this.v$lobDescriptorsMap = map;
            this.this$0 = oracleTableBuilder;
        }
    }

    final class 13
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ OracleIndexOrganizedTableProperties v$properties;
        private final /* synthetic */ Table v$table;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleTableBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    int pctThreshold = rs.getInt(1);
                    this.v$properties.setPctThreshold(rs.wasNull() ? null : new Integer(pctThreshold));
                    int compression = rs.getInt(2);
                    this.v$properties.setKeyCompression(rs.wasNull() ? null : new Integer(compression));
                    int includeColumnId = rs.getInt(3);
                    Column includeColumn = null;
                    if (!rs.wasNull()) {
                        Column[] columns = this.v$table.getColumns();
                        Column column = includeColumn = includeColumnId > 0 && includeColumnId <= columns.length ? columns[includeColumnId - 1] : null;
                    }
                    if (includeColumn != null) {
                        this.v$properties.setIncludeColumn(includeColumn.getID());
                    }
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException(sqe);
            }
        }

        public 13(OracleTableBuilder oracleTableBuilder, OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties, Table table, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$table = table;
            this.v$properties = oracleIndexOrganizedTableProperties;
            this.this$0 = oracleTableBuilder;
        }
    }

    final class 14
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ OracleIndexOrganizedTableProperties v$properties;
        private final /* synthetic */ Table v$table;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleTableBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    if (rs.getString("IOT_TYPE").equals("IOT_OVERFLOW")) {
                        this.v$properties.setOverflowable(true);
                        if (Boolean.TRUE.equals(this.v$table.getProperty("PARTITIONED TABLE"))) {
                            String overflowTableName = rs.getString("TABLE_NAME");
                            this.v$properties.setOverflowProperties(OracleTableBuilder.mav$getSegmentAttributeProperties(this.this$0, "select /*OracleDictionaryQueries.ALL_PARTITIONED_TABLE_DEFAULT_STORAGE_PROPERTIES_QUERY*/\n       def_tablespace_name TABLESPACE_NAME,\n       def_pct_free PCT_FREE, def_pct_used PCT_USED,\n       def_ini_trans INI_TRANS, def_max_trans MAX_TRANS,\n       decode(def_initial_extent, 'DEFAULT', null, def_initial_extent) INITIAL_EXTENT,\n       decode(def_next_extent, 'DEFAULT', null, def_next_extent) NEXT_EXTENT,\n       decode(def_min_extents, 'DEFAULT', null, def_min_extents) MIN_EXTENTS,\n       decode(def_max_extents, 'DEFAULT', null, def_max_extents) MAX_EXTENTS,\n       decode(def_pct_increase, 'DEFAULT', null, def_pct_increase) PCT_INCREASE,\n       decode(def_freelists, 0, null, def_freelists) FREELISTS,\n       decode(def_freelist_groups, 0, null, def_freelist_groups) FREELIST_GROUPS,\n       decode(def_logging, 'NONE', null, def_logging) LOGGING,\n       def_buffer_pool BUFFER_POOL\nfrom   all_part_tables\nwhere  owner = ?\nand    table_name = ?\n", this.v$table, overflowTableName));
                            continue;
                        }
                        this.v$properties.setOverflowProperties(OracleTableBuilder.getSegmentAttributeProperties(rs));
                        continue;
                    }
                    this.v$properties.setMapped(true);
                }
            }
            catch (SQLException x) {
                this.v$wrap.throwDBException((DBObject)this.v$table, x);
            }
        }

        public 14(OracleTableBuilder oracleTableBuilder, OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties, Table table, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$table = table;
            this.v$properties = oracleIndexOrganizedTableProperties;
            this.this$0 = oracleTableBuilder;
        }
    }

    final class 15
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Holder v$holder;
        private final /* synthetic */ QueryWrapper v$wrap;
        private final /* synthetic */ Table v$table;
        final /* synthetic */ OracleTableBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    String pc;
                    OracleExternalTableProperties properties = new OracleExternalTableProperties();
                    properties.setAccessDriverType(rs.getString(1));
                    properties.setRejectLimit(rs.getString(2));
                    if (rs.getString(4) != null) {
                        properties.setAccessParameters((Object)rs.getString(4).trim());
                    }
                    if ((pc = rs.getString(5)) != null && !pc.equals("null")) {
                        properties.setProjectColumn(OracleExternalTableProperties.ProjectColumn.valueOf((String)pc));
                    }
                    properties.setDefaultDirectory(OracleTableBuilder.mav$getDirectory(this.this$0, rs.getString(6), rs.getString(7)));
                    this.v$holder.set((Object)properties);
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException((DBObject)this.v$table, sqe);
            }
        }

        public 15(OracleTableBuilder oracleTableBuilder, Holder holder, QueryWrapper queryWrapper, Table table) {
            this.v$table = table;
            this.v$wrap = queryWrapper;
            this.v$holder = holder;
            this.this$0 = oracleTableBuilder;
        }
    }

    final class 16
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ OracleExternalTableProperties v$properties;
        private final /* synthetic */ QueryWrapper v$wrap;
        private final /* synthetic */ Table v$table;
        final /* synthetic */ OracleTableBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    this.v$properties.addLocationSpecifier(OracleTableBuilder.mav$getDirectory(this.this$0, rs.getString(2), rs.getString(3)), rs.getString(1));
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException((DBObject)this.v$table, sqe);
            }
        }

        public 16(OracleTableBuilder oracleTableBuilder, OracleExternalTableProperties oracleExternalTableProperties, QueryWrapper queryWrapper, Table table) {
            this.v$table = table;
            this.v$wrap = queryWrapper;
            this.v$properties = oracleExternalTableProperties;
            this.this$0 = oracleTableBuilder;
        }
    }
}

