/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.ide.util.Assert;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleDictionaryQueries;
import oracle.javatools.db.ora.ddlgen.OracleTriggerDDLGenerator;

class OracleTriggerBuilder
extends OracleDBObjectBuilder {
    OracleTriggerBuilder(BaseOracleDatabase db) {
        super(db, "TRIGGER");
    }

    public SchemaObject createObject(String name, Schema schema, DBObjectID id) {
        Trigger trigger = new Trigger(schema, name);
        trigger.setID(id);
        return trigger;
    }

    protected void fillInObject(SchemaObject obj) throws DBException {
        Trigger trigger = (Trigger)obj;
        QueryWrapper wrap = this.newQueryWrapper(this.getQueryString(), trigger.getSchema(), trigger);
        1 r = new 1(this, trigger, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        trigger.setSource(this.getSource(trigger));
    }

    protected String getQueryString() {
        if (this.getDatabase().getOracleDatabaseType() < 2) {
            return OracleDictionaryQueries.TRIGGER_PROPS_ORACLE8_QUERY;
        }
        return "SELECT /*OracleDictionaryQueries.ALL_TRIGGER_PROPS_QUERY*/\n       A.BASE_OBJECT_TYPE, A.TRIGGER_TYPE, A.TRIGGERING_EVENT, A.TABLE_OWNER, A.TABLE_NAME, A.REFERENCING_NAMES, A.WHEN_CLAUSE, A.TRIGGER_BODY, A.STATUS, B.COLUMN_NAME, B.COLUMN_LIST FROM SYS.ALL_TRIGGERS A, SYS.ALL_TRIGGER_COLS B WHERE A.OWNER = B.TRIGGER_OWNER(+) AND A.TRIGGER_NAME = B.TRIGGER_NAME(+) AND A.OWNER = ? AND A.TRIGGER_NAME = ?";
    }

    private static void parseBaseType(String s, Trigger trigger) {
        Trigger.BaseType baseType = null;
        if (s != null) {
            s = s.trim();
            baseType = Trigger.BaseType.valueOf((String)s);
        }
        trigger.setBaseType(baseType);
    }

    private static void parseTriggerType(String s, Trigger trigger) {
        switch (3.$sm$oracle$javatools$db$Trigger$BaseType[trigger.getBaseType().ordinal()]) {
            case 3: {
                if (!"INSTEAD OF".equals(s)) break;
                trigger.setTiming(Trigger.Timing.INSTEAD_OF);
                break;
            }
            case 4: {
                if ("BEFORE STATEMENT".equals(s)) {
                    trigger.setTiming(Trigger.Timing.BEFORE);
                    trigger.setStatementLevel(true);
                    break;
                }
                if ("BEFORE EACH ROW".equals(s)) {
                    trigger.setTiming(Trigger.Timing.BEFORE);
                    trigger.setStatementLevel(false);
                    break;
                }
                if ("AFTER STATEMENT".equals(s)) {
                    trigger.setTiming(Trigger.Timing.AFTER);
                    trigger.setStatementLevel(true);
                    break;
                }
                if (!"AFTER EACH ROW".equals(s)) break;
                trigger.setTiming(Trigger.Timing.AFTER);
                trigger.setStatementLevel(false);
                break;
            }
            case 1: 
            case 2: {
                if ("BEFORE EVENT".equals(s)) {
                    trigger.setTiming(Trigger.Timing.BEFORE);
                    break;
                }
                if (!"AFTER EVENT".equals(s)) break;
                trigger.setTiming(Trigger.Timing.AFTER);
                break;
            }
        }
    }

    private static void parseTriggeringEvent(String s, Trigger t) {
        ArrayList<String> events = new ArrayList<String>();
        if (s != null) {
            StringTokenizer tkn = new StringTokenizer(s, " ");
            while (tkn.hasMoreTokens()) {
                String evt = tkn.nextToken();
                if ("OR".equalsIgnoreCase(evt)) continue;
                events.add(evt);
            }
        }
        t.setEvents(events.toArray(new String[events.size()]));
    }

    private static void parseOwnerAndName(Schema owner, String name, Trigger t, DBObjectProvider pro) {
        SchemaObject obj = null;
        String baseType = "TABLE";
        switch (3.$sm$oracle$javatools$db$Trigger$BaseType[t.getBaseType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                t.setTableOwner(owner);
                break;
            }
            case 3: {
                baseType = "VIEW";
            }
            case 4: {
                t.setTableOwner(owner);
                try {
                    obj = pro.getObject(baseType, owner, name);
                }
                catch (DBException e) {
                    Assert.printStackTrace();
                    return;
                }
                if (obj == null) break;
                t.setTableID(obj.getID());
                break;
            }
        }
    }

    private static void parseReferencingNames(String s, Trigger t) {
        if (s != null) {
            String[] names = new String[2];
            boolean foundAs = false;
            int idx = -1;
            StringTokenizer tkn = new StringTokenizer(s, " ");
            while (tkn.hasMoreTokens()) {
                String value = tkn.nextToken();
                if (foundAs) {
                    if (idx != -1) {
                        names[idx] = value;
                    }
                    idx = -1;
                    foundAs = false;
                    continue;
                }
                if ("AS".equals(value)) {
                    foundAs = true;
                    continue;
                }
                idx = "OLD".equals(value) ? 0 : ("NEW".equals(value) ? 1 : -1);
            }
            if (!"OLD".equals(names[0]) || !"NEW".equals(names[1])) {
                t.setReferenceNames(names);
            }
        }
    }

    private final String getSource(Trigger trg) throws DBException {
        String result = null;
        StringBuffer buf = new StringBuffer();
        QueryWrapper wrap = this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_TRIGGER_SOURCE_QUERY*/\n       TEXT FROM SYS.ALL_SOURCE WHERE TYPE = 'TRIGGER' AND OWNER = ? AND NAME = ? ORDER BY LINE", trg.getSchema(), trg);
        2 r = new 2(this, buf, wrap, trg);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        if (buf.length() > 0) {
            result = buf.toString();
        }
        if (result == null) {
            OracleTriggerDDLGenerator ddlgen = new OracleTriggerDDLGenerator((DBObjectProvider)this.getProvider());
            result = ddlgen.buildFromAttributes(trg).toString();
        }
        return result;
    }

    static void maS$parseBaseType(String string, Trigger trigger) {
        OracleTriggerBuilder.parseBaseType(string, trigger);
    }

    static void maS$parseTriggerType(String string, Trigger trigger) {
        OracleTriggerBuilder.parseTriggerType(string, trigger);
    }

    static void maS$parseTriggeringEvent(String string, Trigger trigger) {
        OracleTriggerBuilder.parseTriggeringEvent(string, trigger);
    }

    static void maS$parseOwnerAndName(Schema schema, String string, Trigger trigger, DBObjectProvider dBObjectProvider) {
        OracleTriggerBuilder.parseOwnerAndName(schema, string, trigger, dBObjectProvider);
    }

    static void maS$parseReferencingNames(String string, Trigger trigger) {
        OracleTriggerBuilder.parseReferencingNames(string, trigger);
    }

    final class 1
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Trigger v$trigger;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleTriggerBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    this.v$trigger.setCode(rs.getString(8));
                    String s = rs.getString(1);
                    OracleTriggerBuilder.maS$parseBaseType(s, this.v$trigger);
                    Trigger.BaseType baseType = this.v$trigger.getBaseType();
                    s = rs.getString(2);
                    OracleTriggerBuilder.maS$parseTriggerType(s, this.v$trigger);
                    OracleTriggerBuilder.maS$parseTriggeringEvent(rs.getString(3), this.v$trigger);
                    s = rs.getString(4);
                    Schema tSchema = s != null ? this.this$0.getDatabase().getSchema(s) : null;
                    OracleTriggerBuilder.maS$parseOwnerAndName(tSchema, rs.getString(5), this.v$trigger, (DBObjectProvider)this.this$0.getDatabase());
                    if (baseType == Trigger.BaseType.VIEW || baseType == Trigger.BaseType.TABLE && !this.v$trigger.isStatementLevel()) {
                        OracleTriggerBuilder.maS$parseReferencingNames(rs.getString(6), this.v$trigger);
                    }
                    this.v$trigger.setWhenClause(rs.getString(7));
                    this.v$trigger.setEnabled("DISABLED".equals(rs.getString(9)) ^ true);
                    ArrayList<NameBasedID> columnIDs = new ArrayList<NameBasedID>();
                    s = rs.getString(10);
                    while (s != null) {
                        String listed = rs.getString(11);
                        if ("Y".equals(listed) || "YES".equals(listed)) {
                            NameBasedID refID = new NameBasedID("COLUMN", s, this.v$trigger.getTableID());
                            columnIDs.add(refID);
                        }
                        String string = s = rs.next() ? rs.getString(10) : null;
                    }
                    this.v$trigger.setColumnIDs(columnIDs.toArray(new DBObjectID[columnIDs.size()]));
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$trigger, ex);
            }
        }

        public 1(OracleTriggerBuilder oracleTriggerBuilder, Trigger trigger, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$trigger = trigger;
            this.this$0 = oracleTriggerBuilder;
        }
    }

    final class 2
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ StringBuffer v$buf;
        private final /* synthetic */ QueryWrapper v$wrap;
        private final /* synthetic */ Trigger v$trg;
        final /* synthetic */ OracleTriggerBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    String line = rs.getString(1);
                    if (line != null) {
                        this.v$buf.append(line);
                        if (line.endsWith("\n")) continue;
                        this.v$buf.append('\n');
                        continue;
                    }
                    this.v$buf.append('\n');
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$trg, ex);
            }
        }

        public 2(OracleTriggerBuilder oracleTriggerBuilder, StringBuffer stringBuffer, QueryWrapper queryWrapper, Trigger trigger) {
            this.v$trg = trigger;
            this.v$wrap = queryWrapper;
            this.v$buf = stringBuffer;
            this.this$0 = oracleTriggerBuilder;
        }
    }

    static class 3 {
        static final /* synthetic */ int[] $sm$oracle$javatools$db$Trigger$BaseType;

        static {
            int[] nArray = new int[Trigger.BaseType.values().length];
            $sm$oracle$javatools$db$Trigger$BaseType = nArray;
            try {
                nArray[Trigger.BaseType.DATABASE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                3.$sm$oracle$javatools$db$Trigger$BaseType[Trigger.BaseType.SCHEMA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                3.$sm$oracle$javatools$db$Trigger$BaseType[Trigger.BaseType.VIEW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                3.$sm$oracle$javatools$db$Trigger$BaseType[Trigger.BaseType.TABLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

