/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.View;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleRelationBuilder;
import oracle.javatools.db.ora.OracleSQLQueryBuilder;
import oracle.javatools.db.sql.AbstractSQLQuery;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryException;

class OracleViewBuilder
extends OracleRelationBuilder {
    protected OracleViewBuilder(BaseOracleDatabase db) {
        super(db, "VIEW");
    }

    public SchemaObject createObject(String name, Schema schema, DBObjectID id) {
        View view = new View(name, schema);
        view.setID(id);
        return view;
    }

    protected void fillInObject(SchemaObject obj) throws DBException {
        super.fillInObject(obj);
        View view = (View)obj;
        if (this.needsBuilding((AbstractSchemaObject)view, "SQLQuery")) {
            this.fillInQueryText(view);
        }
    }

    private void fillInQueryText(View view) throws DBException {
        QueryWrapper wrap = this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_VIEW_TEXT_QUERY*/\n       TEXT_LENGTH, TEXT FROM SYS.ALL_VIEWS WHERE OWNER = ? AND VIEW_NAME = ?", view.getSchema(), view);
        1 r = new 1(this, view, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
    }

    public static final SQLQuery buildQuery(BaseOracleDatabase db, Schema schema, String txt) throws DBException {
        AbstractSQLQuery query = null;
        OracleSQLQueryBuilder builder = new OracleSQLQueryBuilder((DBObjectProvider)db, schema);
        try {
            builder.buildQuery(txt);
            builder.fixTemporaryIDs();
            query = builder.getSQLQuery();
        }
        catch (SQLParseException e) {
            DBLog.logStackTrace((Throwable)e);
            query = new NonDeclarativeSQLQuery(txt);
        }
        catch (SQLQueryException sqe) {
            query = builder.getSQLQuery();
        }
        return query;
    }

    protected boolean canBuildComponents() {
        return true;
    }

    protected void fillInObjectComponent(SchemaObject object, String key) throws DBException {
        if (key.equals("SQLQuery")) {
            this.fillInQueryText((View)object);
        } else {
            super.fillInObjectComponent(object, key);
        }
    }

    final class 1
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ View v$view;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleViewBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    int len = rs.getInt(1);
                    String txt = rs.getString(2);
                    if (txt != null) {
                        if (txt.toUpperCase().trim().endsWith("WITH CHECK OPTION")) {
                            this.v$view.setQueryRestriction("WITH CHECK OPTION");
                            txt = txt.substring(0, txt.toUpperCase().lastIndexOf("WITH") - 1);
                        } else if (txt.toUpperCase().trim().endsWith("WITH READ ONLY")) {
                            this.v$view.setQueryRestriction("WITH READ ONLY");
                            txt = txt.substring(0, txt.toUpperCase().lastIndexOf("WITH") - 1);
                        }
                        NonDeclarativeSQLQuery query = new NonDeclarativeSQLQuery(txt);
                        this.v$view.setSQLQuery((SQLQuery)query);
                    }
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$view, ex);
            }
        }

        public 1(OracleViewBuilder oracleViewBuilder, View view, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$view = view;
            this.this$0 = oracleViewBuilder;
        }
    }
}

