/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.RecycledObject;

class RecycledObjectBuilder
extends OracleDBObjectBuilder {
    public static final String YES = "YES";
    private Boolean m_sysDBA;

    public RecycledObjectBuilder(BaseOracleDatabase db) {
        super(db, "RECYCLEBIN");
    }

    public SchemaObject createObject(String name, Schema schema, DBObjectID id) {
        return new RecycledObject(name, schema, id);
    }

    protected void fillInObject(SchemaObject object) throws DBException {
        RecycledObject recycled = (RecycledObject)object;
        QueryWrapper wrap = this.getQueryWrapper(recycled);
        1 r = new 1(this, recycled, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
    }

    private QueryWrapper getQueryWrapper(RecycledObject recycled) {
        if (this.isSysdba()) {
            return this.newQueryWrapper("SELECT /*OracleDictionaryQueries.DBA_RECYCLED_OBJECT_QUERY*/\n       ORIGINAL_NAME, OPERATION, TYPE, TS_NAME, CREATETIME, DROPTIME,  DROPSCN, PARTITION_NAME, CAN_UNDROP, CAN_PURGE, SPACE, RELATED, BASE_OBJECT, PURGE_OBJECT FROM DBA_RECYCLEBIN WHERE OBJECT_NAME = ? AND OWNER = ? AND NOT(CAN_PURGE = 'NO' AND CAN_UNDROP = 'NO')", recycled, recycled.getSchema());
        }
        return this.newQueryWrapper("SELECT /*OracleDictionaryQueries.RECYCLED_OBJECT_QUERY*/\n       ORIGINAL_NAME, OPERATION, TYPE, TS_NAME, CREATETIME, DROPTIME,  DROPSCN, PARTITION_NAME, CAN_UNDROP, CAN_PURGE, SPACE, RELATED, BASE_OBJECT, PURGE_OBJECT FROM RECYCLEBIN WHERE OBJECT_NAME = ? AND NOT(CAN_PURGE = 'NO' AND CAN_UNDROP = 'NO')", recycled);
    }

    private boolean isSysdba() {
        if (this.m_sysDBA == null) {
            this.m_sysDBA = ((OracleDatabaseImpl)this.getDatabase()).hasPrivilege("SYSDBA");
        }
        return this.m_sysDBA;
    }

    final class 1
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ RecycledObject v$recycled;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ RecycledObjectBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    String origName = rs.getString(1);
                    this.v$recycled.setOriginalName(origName);
                    String operation = rs.getString(2);
                    this.v$recycled.setOperation(RecycledObject.Operation.valueOf((String)operation));
                    String type = rs.getString(3);
                    this.v$recycled.setOriginalType(type);
                    String tsName = rs.getString(4);
                    this.v$recycled.setTablespaceName(tsName);
                    String createTime = rs.getString(5);
                    this.v$recycled.setCreateTime(createTime);
                    String dropTime = rs.getString(6);
                    this.v$recycled.setDropTime(dropTime);
                    Long dropSCN = rs.getLong(7);
                    this.v$recycled.setDropSCN(dropSCN);
                    String partName = rs.getString(8);
                    this.v$recycled.setPartitionName(partName);
                    String canUndrop = rs.getString(9);
                    this.v$recycled.setCanUndrop(RecycledObjectBuilder.YES.equals(canUndrop));
                    String canPurge = rs.getString(10);
                    this.v$recycled.setCanPurge(RecycledObjectBuilder.YES.equals(canPurge));
                    int space = rs.getInt(11);
                    this.v$recycled.setSpace(space);
                    int related = rs.getInt(12);
                    this.v$recycled.setRelatedObjectID((DBObjectID)new IdentifierBasedID(type, (Object)related, (AbstractDBObjectProvider)this.this$0.getDatabase()));
                    int base = rs.getInt(13);
                    this.v$recycled.setBaseObjectID((DBObjectID)new IdentifierBasedID(type, (Object)base, (AbstractDBObjectProvider)this.this$0.getDatabase()));
                    int purge = rs.getInt(14);
                    this.v$recycled.setPurgeObjectID((DBObjectID)new IdentifierBasedID(type, (Object)purge, (AbstractDBObjectProvider)this.this$0.getDatabase()));
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$recycled, ex);
            }
        }

        public 1(RecycledObjectBuilder recycledObjectBuilder, RecycledObject recycledObject, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$recycled = recycledObject;
            this.this$0 = recycledObjectBuilder;
        }
    }
}

