/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.XMLSchema;

class XMLSchemaBuilder
extends OracleDBObjectBuilder {
    XMLSchemaBuilder(BaseOracleDatabase db) {
        super(db, "XML SCHEMA");
    }

    public SchemaObject createObject(String name, Schema schema, DBObjectID id) {
        XMLSchema xmlSchema = new XMLSchema();
        xmlSchema.setName(name);
        xmlSchema.setSchema(schema);
        xmlSchema.setID(id);
        return xmlSchema;
    }

    protected void fillInObject(SchemaObject obj) throws DBException {
        XMLSchema xmlSchema = (XMLSchema)obj;
        QueryWrapper wrap = this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_XML_SCHEMA_OBJECT_QUERY*/\n       sys.xmltype.getClobVal(SCHEMA), INT_OBJNAME, LOCAL FROM ALL_XML_SCHEMAS WHERE OWNER = ? AND SCHEMA_URL = ? ", xmlSchema.getSchema(), xmlSchema);
        1 r = new 1(this, xmlSchema, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
    }

    final class 1
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ XMLSchema v$xmlSchema;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ XMLSchemaBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    this.v$xmlSchema.setSchemaText(rs.getString(1));
                    this.v$xmlSchema.setInternalName(rs.getString(2));
                    this.v$xmlSchema.setLocal("YES".equals(rs.getString(3)));
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException((DBObject)this.v$xmlSchema, sqe);
            }
        }

        public 1(XMLSchemaBuilder xMLSchemaBuilder, XMLSchema xMLSchema, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$xmlSchema = xMLSchema;
            this.this$0 = xMLSchemaBuilder;
        }
    }
}

