/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ddl.BundleDDLGenerator;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.ddl.Oracle10gDDLBundle;
import oracle.javatools.db.ora.ddl.OracleDDLBundle;
import oracle.javatools.db.ora.ddl.OracleDDLType;
import oracle.javatools.db.ora.ddl.OracleStatementType;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDDLGenerator
extends BundleDDLGenerator<OracleDDLType> {
    public OracleDDLGenerator(Class<? extends OracleDatabase> oraClz, DBObjectProvider pro) {
        super(pro, OracleDDLGenerator.getBundles(oraClz));
        this.registerTokens();
    }

    protected OracleDDLType getDDLType(String key) {
        return OracleDDLType.getDDLType((String)key);
    }

    protected void registerTokens() {
        this.registerSimpleDropDDL("FUNCTION");
        this.registerSimpleDropDDL("INDEX");
        this.registerSimpleDropDDL("SEQUENCE");
        this.registerSimpleDropDDL("MATERIALIZED VIEW");
        this.registerSimpleDropDDL("PACKAGE");
        this.registerSimpleDropDDL("PROCEDURE");
        this.registerSimpleDropDDL("TRIGGER");
    }

    protected final void registerSimpleDropDDL(String type) {
        this.registerBundleDropDDL(type, "SIMPLE_DROP", (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.DROP));
    }

    private static ResourceBundle[] getBundles(Class<? extends OracleDatabase> clz) {
        ArrayList<ResourceBundle> retval = new ArrayList<ResourceBundle>();
        retval.add(OracleDDLBundle.getBundle());
        if (Oracle10g.class.isAssignableFrom(clz)) {
            retval.add(Oracle10gDDLBundle.getBundle());
        }
        return retval.toArray(new ResourceBundle[retval.size()]);
    }

    protected DDL<OracleDDLType> finish(DDLOptions options, DDL<OracleDDLType> ddl) {
        DDL retval = super.finish(options, ddl);
        String spoolFile = options.getSpoolFile();
        if (ModelUtil.hasLength((String)spoolFile) && ddl.get((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SPOOLON)).isEmpty()) {
            ddl.append((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SPOOLON), MessageFormat.format("SPOOL {0}\n", spoolFile));
            ddl.append((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SPOOLOFF), "SPOOL OFF");
        }
        return retval;
    }
}

