/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import java.text.SimpleDateFormat;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.ddlgen.OracleMatViewDDLGenerator;
import oracle.javatools.db.ora.ddlgen.OracleRelationDDLGenerator;
import oracle.javatools.util.ModelUtil;

public class MaterializedViewDDLHelper
extends OracleMatViewDDLGenerator {
    private MaterializedView _mview;

    public MaterializedViewDDLHelper(MaterializedView mview, DBObjectProvider prov) {
        super(prov);
        if (mview == null) {
            throw new IllegalStateException("Null materialized view passed into MaterializedViewDDLHelper class");
        }
        this._mview = mview;
    }

    public final String getUsingIndexDDL(boolean alter) {
        StringBuffer buffer = new StringBuffer();
        if (this._mview.isUseNoIndex() && !alter) {
            buffer.append("USING").append(" ").append("NO").append(" ").append("INDEX").append("\n");
        } else if (!this._mview.isUseNoIndex()) {
            buffer.append("USING").append(" ").append("INDEX").append("\n");
            OracleStorageProperties osp = (OracleStorageProperties)this._mview.getProperty("MatViewIndexStorageProperties");
            if (osp != null) {
                Boolean logging = osp.getLogging();
                osp.setLogging(null);
                buffer.append(OracleRelationDDLGenerator.getSegmentAttributeClause(osp, "    "));
                osp.setLogging(logging);
            }
        }
        return buffer.toString();
    }

    public final String getRefreshDDL() {
        StringBuffer buffer = new StringBuffer();
        if (this._mview.getRefreshMode() == MaterializedView.RefreshMode.NEVER) {
            buffer.append("NEVER REFRESH").append("\n");
        } else {
            buffer.append("REFRESH").append(" ");
            buffer.append(this.getDemandCommitDDL());
            buffer.append(this.getStartWithDDL());
            buffer.append(this.getIntervalDDL());
            buffer.append(this.getRefreshMethodDDL());
            buffer.append(this.getPKRowIdDDL());
            buffer.append(this.getUsingDDL());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public final String getCacheDDL() {
        StringBuffer buffer = new StringBuffer();
        if (this._mview.isCache()) {
            buffer.append("CACHE").append(" ");
        } else {
            buffer.append("NOCACHE").append(" ");
        }
        return buffer.toString();
    }

    public final String getParallelDDL() {
        StringBuffer buffer = new StringBuffer();
        int parallel = this._mview.getParallel();
        if (parallel < 2 && parallel != 0) {
            buffer.append("NOPARALLEL").append(" ");
        } else {
            buffer.append("PARALLEL").append(" ");
            if (parallel != 0) {
                buffer.append(parallel).append(" ");
            }
        }
        return buffer.toString();
    }

    public final String getCompressionDDL(boolean alter) {
        StringBuffer buffer = new StringBuffer();
        if (this._mview.isCompression()) {
            buffer.append("COMPRESS").append(" ");
        } else if (alter) {
            buffer.append("NOCOMPRESS").append(" ");
        }
        return buffer.toString();
    }

    public final String getTablespaceDDL() {
        String tablespace;
        StringBuffer buffer = new StringBuffer();
        OracleStorageProperties osp = (OracleStorageProperties)this._mview.getProperty("MatViewIndexStorageProperties");
        String string = tablespace = osp == null ? null : osp.getTablespace();
        if (ModelUtil.hasLength((String)tablespace)) {
            buffer.append("TABLESPACE").append(" ");
            buffer.append(tablespace).append(" ");
        }
        return buffer.toString();
    }

    public final String getIndexPercentFreeDDL() {
        Integer pf;
        StringBuffer buffer = new StringBuffer();
        OracleStorageProperties osp = (OracleStorageProperties)this._mview.getProperty("MatViewIndexStorageProperties");
        Integer n = pf = osp == null ? null : osp.getPercentFree();
        if (pf != null && pf >= 0) {
            buffer.append("PCTFREE").append(" ");
            buffer.append(pf).append(" ");
        }
        return buffer.toString();
    }

    public final String getIndexInitTransDDL() {
        Integer it;
        StringBuffer buffer = new StringBuffer();
        OracleStorageProperties osp = (OracleStorageProperties)this._mview.getProperty("MatViewIndexStorageProperties");
        Integer n = it = osp == null ? null : osp.getInitrans();
        if (it != null && it >= 1) {
            buffer.append("INITRANS").append(" ");
            buffer.append(it).append(" ");
        }
        return buffer.toString();
    }

    public final String getIndexExtentDDL() {
        Integer me;
        StringBuffer buffer = new StringBuffer();
        OracleStorageProperties osp = (OracleStorageProperties)this._mview.getProperty("MatViewIndexStorageProperties");
        Integer ie = osp == null ? null : osp.getInitialExtent();
        Integer n = me = osp == null ? null : osp.getMaxExtent();
        if (ie != null && ie >= 1 || me != null && me >= 1) {
            buffer.append("STORAGE").append("(");
            if (ie != null && ie >= 1) {
                buffer.append("MINEXTENTS").append(" ");
                buffer.append(ie).append(" ");
            }
            if (me != null && me >= 1) {
                buffer.append("MAXEXTENTS").append(" ");
                buffer.append(me).append(" ");
            }
            buffer.append(")").append(" ");
        }
        return buffer.toString();
    }

    public final String getDemandCommitDDL() {
        StringBuffer buffer = new StringBuffer();
        if (this._mview.getRefreshMode() == MaterializedView.RefreshMode.COMMIT) {
            buffer.append("ON").append(" ").append("COMMIT").append(" ");
        } else if (this._mview.getRefreshMode() == MaterializedView.RefreshMode.DEMAND) {
            buffer.append("ON").append(" ").append("DEMAND").append(" ");
        }
        return buffer.toString();
    }

    public final String getStartWithDDL() {
        StringBuffer buffer = new StringBuffer();
        if (this._mview.getRefreshMode() == MaterializedView.RefreshMode.SPECIFY && this._mview.getLastRefreshDate() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
            String startDate = sdf.format(this._mview.getLastRefreshDate());
            buffer.append("START").append(" ").append("WITH").append(" ").append("GREATEST").append("(").append("SYSDATE").append(",").append("TO_DATE").append("(").append("'").append(startDate).append("'").append(",").append("'").append("YYYY.MM.DD.HH24.MI.SS").append("'").append(")").append(")").append(" ");
        }
        return buffer.toString();
    }

    public final String getIntervalDDL() {
        StringBuffer buffer = new StringBuffer();
        if (this._mview.getRefreshMode() == MaterializedView.RefreshMode.SPECIFY && ModelUtil.hasLength((String)this._mview.getInterval())) {
            buffer.append("NEXT").append(" ").append(this._mview.getInterval()).append(" ");
        }
        return buffer.toString();
    }

    public final String getRefreshMethodDDL() {
        StringBuffer buffer = new StringBuffer();
        if (this._mview.getRefreshMethod() == MaterializedView.RefreshMethod.FAST) {
            buffer.append("FAST").append(" ");
        } else if (this._mview.getRefreshMethod() == MaterializedView.RefreshMethod.COMPLETE) {
            buffer.append("COMPLETE").append(" ");
        } else if (this._mview.getRefreshMethod() == MaterializedView.RefreshMethod.FORCE) {
            buffer.append("FORCE").append(" ");
        }
        return buffer.toString();
    }

    public final String getPKRowIdDDL() {
        StringBuffer buffer = new StringBuffer();
        if (this._mview.getKeyType() == MaterializedView.RefreshWith.PRIMARY_KEY) {
            buffer.append("\n").append("WITH").append(" ");
            buffer.append("PRIMARY").append(" ").append("KEY").append(" ");
        } else if (this._mview.getKeyType() == MaterializedView.RefreshWith.ROWID) {
            buffer.append("\n").append("WITH").append(" ");
            buffer.append("ROWID").append(" ");
        }
        return buffer.toString();
    }

    public final String getUsingDDL() {
        StringBuffer buffer = new StringBuffer();
        boolean using = false;
        if (this._mview.getRollbackSegmentType() != MaterializedView.RollbackSegmentType.NONE) {
            String rsName = this._mview.getRollbackSegmentName();
            String ml = this._mview.getRollbackSegmentType() == MaterializedView.RollbackSegmentType.LOCAL ? "LOCAL" : "MASTER";
            buffer.append("USING").append(" ");
            using = true;
            if (!ModelUtil.hasLength((String)rsName) || "DEFAULT".equals(rsName)) {
                buffer.append("DEFAULT").append(" ");
                buffer.append(ml).append(" ");
                buffer.append("ROLLBACK SEGMENT").append(" ");
            } else {
                buffer.append(ml).append(" ");
                buffer.append("ROLLBACK SEGMENT").append(" ");
                buffer.append(rsName).append(" ");
            }
        }
        if ((!(this.m_prov instanceof Database) || this.m_prov instanceof Oracle10g) && this._mview.getUsingConstraints() != null && this._mview.getUsingConstraints() == MaterializedView.UsingConstraints.TRUSTED) {
            if (!using) {
                buffer.append("USING").append(" ");
            }
            buffer.append("TRUSTED").append(" ");
            buffer.append("constraints".toUpperCase()).append(" ");
        }
        return buffer.toString();
    }
}

