/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import java.util.List;
import java.util.Map;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.ddlgen.OracleAlterDDLIndex;
import oracle.javatools.util.ModelUtil;

public class Oracle10gAlterDDLIndex
extends OracleAlterDDLIndex {
    public Oracle10gAlterDDLIndex(DBObjectProvider prov, ResultSet rs) {
        super(prov, rs);
    }

    public int getUpdateAction(ResultSet rs) {
        int result = super.getUpdateAction(rs);
        if (result == 2 && this.isAddHashPartition(rs)) {
            result = 1;
        }
        return result;
    }

    public Ddl getAlterStatement(SchemaObject schemaObject, ResultSet soDiff) {
        Ddl ddl = new Ddl();
        ddl = super.getAlterStatement(schemaObject, soDiff);
        if (this.isAddHashPartition(soDiff)) {
            ddl.append(this.getAlterIndex((Index)schemaObject, soDiff));
        }
        return ddl;
    }

    private Ddl getAlterIndex(Index index, ResultSet indexDiff) {
        ResultSet oipMap;
        Map oipAttrs;
        Ddl ddl = new Ddl();
        StringBuffer fsb = new StringBuffer(this.alterIndex(index));
        Map indexAttributes = indexDiff.getModifiedObjectMap();
        if (indexAttributes.containsKey("OracleIndexPartitions") && (oipAttrs = (oipMap = (ResultSet)indexAttributes.get("OracleIndexPartitions")).getModifiedObjectMap()).containsKey("partitions")) {
            ResultSet oipList = (ResultSet)oipAttrs.get("partitions");
            List newList = oipList.getBonlyList();
            for (ResultSet parRS : newList) {
                Map segAttrMap;
                ResultSet tableSpaceRS;
                String tableSpaceName = null;
                if (parRS == null) continue;
                Map parAttrMap = parRS.getAllObjectsMap();
                ResultSet segAttr = (ResultSet)parAttrMap.get("segmentAttributes");
                if (segAttr != null && (tableSpaceRS = (ResultSet)(segAttrMap = segAttr.getAllObjectsMap()).get("tablespace")) != null) {
                    tableSpaceName = DisplayProps.getBVal(tableSpaceRS);
                }
                fsb.append("  ").append("ADD").append(" ").append("PARTITION");
                fsb.append(" ").append(parRS.getName());
                if (ModelUtil.hasLength((String)tableSpaceName)) {
                    fsb.append(" ").append("TABLESPACE").append(" ").append(tableSpaceName);
                }
                fsb.append(" \n");
            }
        }
        ddl.put("IND", fsb.toString());
        return ddl;
    }
}

