/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.ddlgen.OracleAlterDDLStorageProperties;
import oracle.javatools.db.ora.ddlgen.OracleBaseGenerator;
import oracle.javatools.db.ora.ddlgen.OracleRelationDDLGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleAlterDDLIndex
extends OracleBaseGenerator {
    public static final String PROPERTYNAME_NAME = "name";
    public static final String PROPERTYNAME_PARALLEL = "parallelDegree";

    public OracleAlterDDLIndex(DBObjectProvider prov, ResultSet rs) {
        super(prov, rs);
    }

    @Override
    public int getUpdateAction(ResultSet rs) {
        HashMap<String, Object> indexAttributes = OracleAlterDDLIndex.getAttributes(rs, false);
        for (String attr : indexAttributes.keySet()) {
            ResultSet ospRS;
            HashMap<String, Object> storageAttributes;
            if (!(PROPERTYNAME_PARALLEL.equals(attr) || PROPERTYNAME_NAME.equals(attr) || "OracleIndexPartitions".equals(attr) || "OracleStorageProperties".equals(attr))) {
                return 2;
            }
            if ("OracleIndexPartitions".equals(attr) && this.isAddHashPartition(rs)) {
                return 2;
            }
            if (!"OracleStorageProperties".equals(attr) || !(storageAttributes = OracleAlterDDLIndex.getAttributes(ospRS = (ResultSet)rs.getAllObjectsMap().get("OracleStorageProperties"), false)).containsKey("tablespace")) continue;
            return 2;
        }
        return 1;
    }

    @Override
    public Ddl getAlterStatement(SchemaObject schemaObject, ResultSet soDiff) {
        return this.getAlterIndex((Index)schemaObject, soDiff);
    }

    protected boolean isAddHashPartition(ResultSet rs) {
        ResultSet oipList;
        List newList;
        ResultSet oipMap;
        Map oipAttrs;
        boolean result = false;
        Map indexAttributes = rs.getModifiedObjectMap();
        if (indexAttributes.containsKey("OracleIndexPartitions") && (oipAttrs = (oipMap = (ResultSet)indexAttributes.get("OracleIndexPartitions")).getModifiedObjectMap()).containsKey("partitions") && (newList = (oipList = (ResultSet)oipAttrs.get("partitions")).getBonlyList()).size() > 0) {
            result = true;
        }
        return result;
    }

    private Ddl getAlterIndex(Index index, ResultSet indexDiff) {
        Ddl ddl = new Ddl();
        boolean attributeChange = false;
        ArrayList<String> alterIndexStmts = new ArrayList<String>();
        HashMap<String, Object> indexAttributes = OracleAlterDDLIndex.getAttributes(indexDiff, false);
        StringBuffer fsb = new StringBuffer();
        if (indexAttributes.containsKey(PROPERTYNAME_PARALLEL)) {
            Table table = index.getTable();
            if (table != null && (table.getProperty("TableType") == Table.TableType.NORMAL || table.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED)) {
                fsb.append(this.alterIndex(index));
                String parallelDegree = (String)indexAttributes.get(PROPERTYNAME_PARALLEL);
                if (parallelDegree.equals("1")) {
                    fsb.append("NOPARALLEL");
                } else {
                    fsb.append("PARALLEL");
                    if (!parallelDegree.equals("0")) {
                        fsb.append(" ").append(parallelDegree);
                    }
                }
                fsb.append(" ").append(" \n");
            }
            alterIndexStmts.add(fsb.toString());
            fsb = new StringBuffer();
        }
        if (indexAttributes.containsKey(PROPERTYNAME_NAME)) {
            String newName = (String)indexAttributes.get(PROPERTYNAME_NAME);
            fsb.append(this.alterIndex(index));
            fsb.append("RENAME").append(" ").append("TO");
            fsb.append(" ").append(newName).append(" ").append(" \n");
            alterIndexStmts.add(fsb.toString());
            fsb = new StringBuffer();
        }
        if (indexAttributes.containsKey("OracleIndexPartitions")) {
            alterIndexStmts.addAll(this.alterIndexPartioning(index, indexDiff));
        }
        ResultSet ospRS = (ResultSet)indexDiff.getAllObjectsMap().get("OracleStorageProperties");
        StringBuffer alterContext = new StringBuffer(this.alterIndex(index));
        alterIndexStmts.addAll(OracleAlterDDLStorageProperties.getAlterStorageProperties(ospRS, this.m_prov, (SchemaObject)index, alterContext.toString()));
        if (alterIndexStmts.size() > 0) {
            ddl.put("IND", alterIndexStmts);
        }
        return ddl;
    }

    private ArrayList<String> alterIndexPartioning(Index index, ResultSet indexRS) {
        ResultSet oipRS = (ResultSet)indexRS.getAllObjectsMap().get("OracleIndexPartitions");
        Map oipAttrs = oipRS.getModifiedObjectMap();
        ArrayList<String> retval = new ArrayList<String>();
        if (oipAttrs.containsKey("partitions")) {
            ResultSet partitionsRS = (ResultSet)oipAttrs.get("partitions");
            for (ResultSet partitionRS : partitionsRS.getModifiedObjectList()) {
                if (this.addIndexPartition(partitionRS)) continue;
                StringBuffer fsb = new StringBuffer();
                this.modifyIndexDefaultAttrs(fsb, index, partitionRS);
                this.modifyIndexPartition(fsb, index, partitionRS);
                this.renameIndexPartition(fsb, index, partitionRS);
                retval.add(fsb.toString());
            }
            for (ResultSet partitionRS : partitionsRS.getAonlyList()) {
                StringBuffer fsb = new StringBuffer();
                fsb.append(this.alterIndex(index));
                fsb.append("DROP").append(" ").append("PARTITION").append(" ");
                fsb.append(partitionRS.getName());
                retval.add(fsb.toString());
            }
        }
        return retval;
    }

    private void renameIndexPartition(StringBuffer fsb, Index index, ResultSet partitionRS) {
        Map partAttrs = partitionRS.getModifiedObjectMap();
        ResultSet nameRS = (ResultSet)partAttrs.get(PROPERTYNAME_NAME);
        if (nameRS != null) {
            String oldName = DisplayProps.getAVal(nameRS);
            String newName = DisplayProps.getBVal(nameRS);
            fsb.append(this.alterIndex(index));
            fsb.append("RENAME").append(" ").append("PARTITION");
            fsb.append(" ").append(oldName).append(" ").append("TO");
            fsb.append(" ").append(newName).append(" ").append(" \n");
        }
    }

    private void modifyIndexDefaultAttrs(StringBuffer fsb, Index index, ResultSet partitionRS) {
    }

    private void modifyIndexPartition(StringBuffer fsb, Index index, ResultSet partitionRS) {
        StringBuffer modpar = new StringBuffer();
        Map parAttrMap = partitionRS.getModifiedObjectMap();
        if (parAttrMap.containsKey("segmentAttributes")) {
            ResultSet segmentAttrRS = (ResultSet)parAttrMap.get("segmentAttributes");
            Map attrMap = segmentAttrRS.getModifiedObjectMap();
            OracleStorageProperties osp = (OracleStorageProperties)segmentAttrRS.b();
            if (attrMap.containsKey("logging")) {
                modpar.append("    ");
                modpar.append(osp.getLogging() != false ? "LOGGING" : "NOLOGGING");
                modpar.append(" \n");
            }
            if (attrMap.containsKey("initrans")) {
                modpar.append("    ").append("INITRANS").append(" ");
                modpar.append(osp.getInitrans());
                modpar.append(" \n");
            }
            if (attrMap.containsKey("maxtrans")) {
                modpar.append("    ").append("MAXTRANS").append(" ");
                modpar.append(osp.getMaxtrans());
                modpar.append(" \n");
            }
            if (attrMap.containsKey("initialExtent") || attrMap.containsKey("nextExtent") || attrMap.containsKey("minExtent") || attrMap.containsKey("percentIncrease") || attrMap.containsKey("maxExtent") || attrMap.containsKey("freelists") || attrMap.containsKey("freelistGroups")) {
                modpar.append(OracleRelationDDLGenerator.getStorageClause(osp, "    "));
                modpar.append(" \n");
            }
        }
        if (parAttrMap.containsKey("keyCompression")) {
            IndexPartition ip = (IndexPartition)partitionRS.b();
            if (ip.getKeyCompression().booleanValue()) {
                modpar.append("    ").append("COMPRESS");
            } else {
                modpar.append("    ").append("NOCOMPRESS");
            }
            modpar.append(" \n");
        }
        if (modpar.length() > 0) {
            fsb.append(this.alterIndex(index));
            fsb.append("  ").append("MODIFY").append(" ").append("PARTITION");
            fsb.append(" ").append(partitionRS.getName()).append(" \n");
            fsb.append(modpar);
        }
    }

    private boolean addIndexPartition(ResultSet partitionRS) {
        return partitionRS.a() == null;
    }

    protected String alterIndex(Index index) {
        StringBuffer fsb = new StringBuffer();
        fsb.append("ALTER").append(" ").append("INDEX").append(" ");
        fsb.append(this.getSchemaDotName((DBObject)index));
        fsb.append(" \n");
        return fsb.toString();
    }
}

