/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.ddlgen.MaterializedViewDDLHelper;
import oracle.javatools.db.ora.ddlgen.OracleAlterDDLStorageProperties;
import oracle.javatools.db.ora.ddlgen.OracleMatViewDDLGenerator;

public class OracleAlterDDLMatView
extends OracleMatViewDDLGenerator {
    public static final String PROPERTYNAME_CACHE = "cache";
    public static final String PROPERTYNAME_PARALLEL = "parallel";
    public static final String PROPERTYNAME_ISUSENOINDEX = "useNoIndex";
    public static final String PROPERTYNAME_INDEXTABLESPACE = "tablespace";
    public static final String PROPERTYNAME_INDEXPCTFREE = "indexPercentFree";
    public static final String PROPERTYNAME_INDEXPCTUSED = "indexPercentUsed";
    public static final String PROPERTYNAME_INITTRANS = "indexInitTrans";
    public static final String PROPERTYNAME_MINEXTENT = "indexMinExtent";
    public static final String PROPERTYNAME_MAXEXTENT = "indexMaxExtent";
    public static final String PROPERTYNAME_REFRESHMODE = "refreshMode";
    public static final String PROPERTYNAME_NEXTREFRESH = "nextRefresh";
    public static final String PROPERTYNAME_INTERVAL = "interval";
    public static final String PROPERTYNAME_METHOD = "refreshMethod";
    public static final String PROPERTYNAME_KEYTYPE = "keyType";
    public static final String PROPERTYNAME_REWRITE = "rewrite";
    public static final String PROPERTYNAME_RSTYPE = "rollbackSegmentType";
    public static final String PROPERTYNAME_RSNAME = "rollbackSegmentName";
    public static final String PROPERTYNAME_CONSTRAINTS = "usingConstraints";
    public static List s_mvPropList = new ArrayList();
    public static List s_mvIgnoreIfNeverRefreshPropList;

    static {
        s_mvPropList.add(PROPERTYNAME_CACHE);
        s_mvPropList.add(PROPERTYNAME_PARALLEL);
        s_mvPropList.add(PROPERTYNAME_INDEXTABLESPACE);
        s_mvPropList.add(PROPERTYNAME_INDEXPCTFREE);
        s_mvPropList.add(PROPERTYNAME_INDEXPCTUSED);
        s_mvPropList.add(PROPERTYNAME_INITTRANS);
        s_mvPropList.add(PROPERTYNAME_MINEXTENT);
        s_mvPropList.add(PROPERTYNAME_MAXEXTENT);
        s_mvPropList.add(PROPERTYNAME_REFRESHMODE);
        s_mvPropList.add(PROPERTYNAME_NEXTREFRESH);
        s_mvPropList.add(PROPERTYNAME_INTERVAL);
        s_mvPropList.add(PROPERTYNAME_METHOD);
        s_mvPropList.add(PROPERTYNAME_KEYTYPE);
        s_mvPropList.add(PROPERTYNAME_RSTYPE);
        s_mvPropList.add(PROPERTYNAME_RSNAME);
        s_mvPropList.add(PROPERTYNAME_CONSTRAINTS);
        s_mvPropList.add(PROPERTYNAME_REWRITE);
        s_mvIgnoreIfNeverRefreshPropList = new ArrayList();
        s_mvIgnoreIfNeverRefreshPropList.add(PROPERTYNAME_INTERVAL);
        s_mvIgnoreIfNeverRefreshPropList.add(PROPERTYNAME_KEYTYPE);
        s_mvIgnoreIfNeverRefreshPropList.add(PROPERTYNAME_METHOD);
        s_mvIgnoreIfNeverRefreshPropList.add(PROPERTYNAME_RSTYPE);
        s_mvIgnoreIfNeverRefreshPropList.add(PROPERTYNAME_RSNAME);
        s_mvIgnoreIfNeverRefreshPropList.add(PROPERTYNAME_CONSTRAINTS);
    }

    public OracleAlterDDLMatView(DBObjectProvider prov, ResultSet rs) {
        super(prov);
        this.m_diffs = rs;
    }

    public Ddl getAlterStatement(SchemaObject schemaObject, ResultSet soDiff) {
        return this.getAlterMView((MaterializedView)schemaObject, soDiff);
    }

    private Ddl getAlterMView(MaterializedView mv, ResultSet mvDiff) {
        Ddl ddl = new Ddl();
        MaterializedView updated = (MaterializedView)mvDiff.b();
        MaterializedViewDDLHelper helper = new MaterializedViewDDLHelper(updated, this.m_prov);
        StringBuffer fsb = new StringBuffer();
        ArrayList<String> mviewAlterStmts = new ArrayList<String>();
        boolean refresh = false;
        HashMap<String, Object> mvAttributes = OracleAlterDDLMatView.getAttributes(mvDiff, false);
        for (String attr : mvAttributes.keySet()) {
            if (PROPERTYNAME_CACHE.equals(attr)) {
                fsb.append(helper.getCacheDDL());
            }
            if (PROPERTYNAME_PARALLEL.equals(attr)) {
                fsb.append(helper.getParallelDDL());
            }
            if ("compression".equals(attr)) {
                fsb.append(helper.getCompressionDDL(true));
            }
            if (PROPERTYNAME_INITTRANS.equals(attr)) {
                fsb.append(helper.getUsingIndexDDL(true));
            }
            if ((PROPERTYNAME_REFRESHMODE.equals(attr) || PROPERTYNAME_NEXTREFRESH.equals(attr) || PROPERTYNAME_INTERVAL.equals(attr) || PROPERTYNAME_METHOD.equals(attr) || PROPERTYNAME_KEYTYPE.equals(attr) || PROPERTYNAME_RSTYPE.equals(attr) || PROPERTYNAME_RSNAME.equals(attr) || PROPERTYNAME_CONSTRAINTS.equals(attr)) && !refresh) {
                refresh = true;
                fsb.append(helper.getRefreshDDL());
            }
            if (PROPERTYNAME_REWRITE.equals(attr)) {
                if (updated.isRewrite()) {
                    fsb.append("ENABLE").append(" ");
                } else {
                    fsb.append("DISABLE").append(" ");
                }
                fsb.append("QUERY REWRITE").append(" ");
            }
            if (!"Comment".equals(attr)) continue;
            String type = this.m_prov instanceof Oracle10g ? "MATERIALIZED VIEW" : "TABLE";
            String comment = (String)updated.getProperty("Comment");
            comment = comment.replace('\n', ' ').replace('\r', ' ').replaceAll("'", "''");
            StringBuffer sb = new StringBuffer();
            sb.append("COMMENT").append(" ").append("ON").append(" ").append(type).append(" ").append(this.getSchemaDotName((DBObject)updated)).append(" ").append("IS").append(" ").append("'").append(comment).append("'").append("\n");
            ddl.put("CMT", sb.toString());
        }
        if (fsb.toString().trim().length() > 1) {
            StringBuffer all = new StringBuffer();
            all.append("ALTER").append(" ").append("MATERIALIZED VIEW").append(" ");
            all.append(this.getSchemaDotName((DBObject)updated));
            all.append(" \n");
            all.append(fsb);
            mviewAlterStmts.add(all.toString());
        }
        ResultSet ospRS = (ResultSet)mvDiff.getAllObjectsMap().get("OracleStorageProperties");
        StringBuffer alterContext = new StringBuffer("ALTER").append(" ").append("MATERIALIZED VIEW").append(" ").append(this.getSchemaDotName((DBObject)updated));
        mviewAlterStmts.addAll(OracleAlterDDLStorageProperties.getAlterStorageProperties(ospRS, this.m_prov, (SchemaObject)updated, alterContext.toString()));
        ResultSet osp2RS = (ResultSet)mvDiff.getAllObjectsMap().get("MatViewIndexStorageProperties");
        StringBuffer alterContext2 = new StringBuffer("ALTER").append(" ").append("MATERIALIZED VIEW").append(" ").append(this.getSchemaDotName((DBObject)updated)).append(" ").append("USING").append(" ").append("INDEX");
        if (mviewAlterStmts.size() > 0) {
            ddl.put("MVW", mviewAlterStmts);
        }
        List changedIndexes = this.getChanged(mvDiff, "indexes");
        List droppedIndexes = this.getDropped(mvDiff, "indexes");
        droppedIndexes.addAll(changedIndexes);
        List addedIndexes = this.getNew(mvDiff, "indexes");
        addedIndexes.addAll(changedIndexes);
        ArrayList<String> indexDrops = new ArrayList<String>();
        for (ResultSet indexDiff : droppedIndexes) {
            Index index = (Index)indexDiff.a();
            Ddl drop = this.m_indexGen.getDeleteDDL((SchemaObject)index, false);
            indexDrops.add(drop.get("DROP"));
        }
        ArrayList<String> indexCreates = new ArrayList<String>();
        for (ResultSet indexDiff : addedIndexes) {
            Index index = (Index)indexDiff.b();
            Ddl create = this.m_indexGen.getCreateDDL((SchemaObject)index, false, false);
            indexCreates.add(create.get("IND"));
        }
        ddl.put("DROP", indexDrops);
        ddl.put("IND", indexCreates);
        this.alterOracleTablePartitions(ddl, (Table)updated, mvDiff);
        return ddl;
    }

    private List getChanged(ResultSet tableDiff, String listType) {
        ResultSet list;
        List result = new ArrayList();
        if (tableDiff.a() instanceof Table && (list = (ResultSet)tableDiff.getAllObjectsMap().get(listType)) != null) {
            result = list.getModifiedObjectList();
        }
        return result;
    }

    private List getDropped(ResultSet tableDiff, String listType) {
        Map tableMap;
        ResultSet list;
        List result = new ArrayList();
        if (this.getNodeType(tableDiff).equals("MATERIALIZED VIEW") && (list = (ResultSet)(tableMap = tableDiff.getAllObjectsMap()).get(listType)) != null) {
            result = list.getAonlyList();
        }
        return result;
    }

    private List getNew(ResultSet tableDiff, String listType) {
        Map tableAttrs;
        ResultSet list;
        List result = new ArrayList();
        if (tableDiff.a() instanceof Table && (list = (ResultSet)(tableAttrs = tableDiff.getAllObjectsMap()).get(listType)) != null) {
            result = list.getBonlyList();
        }
        return result;
    }

    private String getNodeType(ResultSet node) {
        int dot;
        Object o = node.a();
        if (o == null) {
            o = node.b();
        }
        String nodeType = null;
        if (o instanceof DBObject) {
            nodeType = ((DBObject)o).getType();
        }
        if ((dot = nodeType.lastIndexOf(".")) > -1) {
            nodeType = nodeType.substring(dot + 1);
        }
        return nodeType;
    }
}

