/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.ddlgen.OracleAlterDDLStorageProperties;
import oracle.javatools.db.ora.ddlgen.OracleBaseGenerator;
import oracle.javatools.util.ModelUtil;

public class OracleAlterDDLMatViewLog
extends OracleBaseGenerator {
    public static final String PROPERTYNAME_CACHE = "cache";
    public static final String PROPERTYNAME_PARALLEL = "parallel";
    public static final String PROPERTYNAME_LOGGING = "logging";
    public static final String PROPERTYNAME_NEWVALUES = "newValues";
    public static final String PROPERTYNAME_OBJECTID = "objectIdLogged";
    public static final String PROPERTYNAME_ROWID = "rowidLogged";
    public static final String PROPERTYNAME_PRIMARY_KEY = "primaryKeyLogged";
    public static final String PROPERTYNAME_SEQUENCE = "sequenceLogged";
    public static List s_mvlPropsChangeWithAlter = new ArrayList();
    public static List s_mvlPropsMakeTrueWithAlter;

    static {
        s_mvlPropsChangeWithAlter.add(PROPERTYNAME_CACHE);
        s_mvlPropsChangeWithAlter.add(PROPERTYNAME_PARALLEL);
        s_mvlPropsChangeWithAlter.add(PROPERTYNAME_LOGGING);
        s_mvlPropsChangeWithAlter.add(PROPERTYNAME_NEWVALUES);
        s_mvlPropsMakeTrueWithAlter = new ArrayList();
        s_mvlPropsMakeTrueWithAlter.add(PROPERTYNAME_OBJECTID);
        s_mvlPropsMakeTrueWithAlter.add(PROPERTYNAME_ROWID);
        s_mvlPropsMakeTrueWithAlter.add(PROPERTYNAME_PRIMARY_KEY);
        s_mvlPropsMakeTrueWithAlter.add(PROPERTYNAME_SEQUENCE);
    }

    public OracleAlterDDLMatViewLog(DBObjectProvider prov, ResultSet rs) {
        super(prov, rs);
    }

    public Ddl getAlterStatement(SchemaObject schemaObject, ResultSet soDiff) {
        StringBuffer alterContext;
        ResultSet ospRS;
        ArrayList<String> alterStorage;
        Ddl ddl = new Ddl();
        MaterializedViewLog updated = (MaterializedViewLog)soDiff.b();
        StringBuffer fsb = new StringBuffer();
        ArrayList<String> mvlStmts = new ArrayList<String>();
        String name = this.qualifiedName((MaterializedViewLog)schemaObject);
        fsb.append("ALTER").append(" ").append("MATERIALIZED VIEW LOG").append(" ");
        fsb.append("ON").append(" ");
        fsb.append(name).append("\n");
        boolean refresh = false;
        HashMap<String, Object> mvAttributes = OracleAlterDDLMatViewLog.getAttributes(soDiff, false);
        for (String attr : mvAttributes.keySet()) {
            if (PROPERTYNAME_CACHE.equals(attr) && updated.getCache() != null) {
                fsb.append(updated.getCache() != false ? "CACHE" : "NOCACHE");
                fsb.append(" ");
                continue;
            }
            if (PROPERTYNAME_LOGGING.equals(attr)) {
                OracleStorageProperties osp = (OracleStorageProperties)updated.getProperty("OracleStorageProperties");
                Boolean logging = osp.getLogging();
                if (logging != null && logging.booleanValue()) {
                    fsb.append("LOGGING");
                } else {
                    fsb.append("NOLOGGING");
                }
                fsb.append(" ");
                continue;
            }
            if (PROPERTYNAME_PARALLEL.equals(attr) && updated.getParallel() == 1) {
                fsb.append("NOPARALLEL").append(" ");
                continue;
            }
            if (PROPERTYNAME_PARALLEL.equals(attr) && updated.getParallel() == 0) {
                fsb.append("PARALLEL").append(" ");
                continue;
            }
            if (!PROPERTYNAME_PARALLEL.equals(attr)) continue;
            fsb.append("PARALLEL").append(" ").append(updated.getParallel()).append(" ");
        }
        Iterator<String> i = mvAttributes.keySet().iterator();
        boolean addAdded = false;
        while (i.hasNext()) {
            String attr = i.next();
            if (PROPERTYNAME_OBJECTID.equals(attr) && updated.getObjectIdLogged() != null && updated.getObjectIdLogged().booleanValue()) {
                if (addAdded) {
                    fsb.append(",").append(" ");
                } else {
                    fsb.append("ADD").append(" ");
                    addAdded = true;
                }
                fsb.append("OBJECT").append(" ").append("ID").append(" ");
                continue;
            }
            if (PROPERTYNAME_ROWID.equals(attr) && updated.getRowidLogged() != null && updated.getRowidLogged().booleanValue()) {
                if (addAdded) {
                    fsb.append(",").append(" ");
                } else {
                    fsb.append("ADD").append(" ");
                    addAdded = true;
                }
                fsb.append("ROWID").append(" ");
                continue;
            }
            if (PROPERTYNAME_PRIMARY_KEY.equals(attr) && updated.getPrimaryKeyLogged() != null && updated.getPrimaryKeyLogged().booleanValue()) {
                if (addAdded) {
                    fsb.append(",").append(" ");
                } else {
                    fsb.append("ADD").append(" ");
                    addAdded = true;
                }
                fsb.append("PRIMARY").append(" ").append("KEY").append(" ");
                continue;
            }
            if (!PROPERTYNAME_SEQUENCE.equals(attr) || updated.getSequenceLogged() == null || !updated.getSequenceLogged().booleanValue()) continue;
            if (addAdded) {
                fsb.append(",").append(" ");
            } else {
                fsb.append("ADD").append(" ");
                addAdded = true;
            }
            fsb.append("SEQUENCE").append(" ");
        }
        for (String attr : mvAttributes.keySet()) {
            if (!attr.equals("columnIDs")) continue;
            if (!addAdded) {
                fsb.append("ADD").append(" ");
            }
            addAdded = true;
            DBObjectID[] colIDs = updated.getColumnIDs();
            if (colIDs.length <= 0) continue;
            int j = 0;
            while (j < colIDs.length) {
                Column col = null;
                try {
                    col = (Column)colIDs[j].resolveID();
                }
                catch (DBException e) {
                    // empty catch block
                }
                fsb.append(j == 0 ? "(" : ",");
                fsb.append(col.getName());
                ++j;
            }
            fsb.append(")").append(" ");
        }
        for (String attr : mvAttributes.keySet()) {
            if (!PROPERTYNAME_NEWVALUES.equals(attr) || updated.getNewValues() == null) continue;
            if (!addAdded) {
                fsb.append("ADD").append(" ");
            }
            addAdded = true;
            fsb.append(updated.getNewValues() != false ? "INCLUDING" : "EXCLUDING");
            fsb.append(" ").append("NEW").append(" ").append("VALUES").append(" ");
        }
        if (fsb.length() > 0) {
            mvlStmts.add(fsb.toString());
        }
        if ((alterStorage = OracleAlterDDLStorageProperties.getAlterStorageProperties(ospRS = (ResultSet)soDiff.getAllObjectsMap().get("OracleStorageProperties"), this.m_prov, (SchemaObject)updated, (alterContext = new StringBuffer("ALTER").append(" ").append("MATERIALIZED VIEW LOG").append(" ").append("ON").append(" ").append(name)).toString())) != null && alterStorage.size() > 0) {
            mvlStmts.addAll(alterStorage);
        }
        ddl.put("MVL", mvlStmts);
        return ddl;
    }

    private String qualifiedName(MaterializedViewLog mvl) {
        String name = this.m_prov.getExternalName(mvl.getName());
        try {
            Table master = (Table)mvl.getMasterTableID().resolveID();
            if (this.m_prov instanceof BaseOracleDatabase && ModelUtil.areDifferent((Object)master.getSchema(), (Object)((BaseOracleDatabase)this.m_prov).getUserName())) {
                name = this.m_prov.getExternalName(master.getSchema().getName()) + "." + name;
            }
        }
        catch (DBException e) {
            DBLog.getLogger().log(Level.WARNING, "failed to find master table");
        }
        return name;
    }
}

