/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import java.util.HashMap;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.ddlgen.OracleBaseGenerator;

public class OracleAlterDDLSequence
extends OracleBaseGenerator {
    public static final String PROPERTYNAME_INCREMENTBY = "incrementBy";
    public static final String PROPERTYNAME_MAXVALUE = "maxValue";
    public static final String PROPERTYNAME_MINVALUE = "minValue";
    public static final String PROPERTYNAME_CYCLEFLAG = "cycleFlag";
    public static final String PROPERTYNAME_CACHESIZE = "cacheSize";
    public static final String PROPERTYNAME_ORDERFLAG = "orderFlag";
    private static HashMap s_seqAttrMap = new HashMap();
    private static HashMap s_seqNoAttrMap = new HashMap();

    public OracleAlterDDLSequence(DBObjectProvider prov, ResultSet rs) {
        super(prov, rs);
        this.$init$();
    }

    public Ddl getAlterStatement(SchemaObject schemaObject, ResultSet soDiff) {
        return this.getAlterSequence((Sequence)schemaObject, soDiff);
    }

    private Ddl getAlterSequence(Sequence sequence, ResultSet seqDiff) {
        Ddl ddl = new Ddl();
        boolean attributeChange = false;
        HashMap<String, Object> seqAttributes = OracleAlterDDLSequence.getAttributes(seqDiff, false);
        StringBuffer fsb = new StringBuffer();
        fsb.append("ALTER").append(" ").append("SEQUENCE").append(" ");
        fsb.append(this.getSchemaDotName((DBObject)sequence));
        fsb.append(" \n");
        for (String attr : seqAttributes.keySet()) {
            if (!s_seqAttrMap.containsKey(attr)) continue;
            attributeChange = true;
            String value = (String)seqAttributes.get(attr);
            if (value == null || value.length() == 0) {
                String novalue = (String)s_seqNoAttrMap.get(attr);
                fsb.append(novalue);
            } else {
                String attrname = (String)s_seqAttrMap.get(attr);
                if ("true".equals(value)) {
                    fsb.append(attrname);
                } else if ("false".equals(value)) {
                    String noflag = (String)s_seqNoAttrMap.get(attr);
                    fsb.append(noflag);
                } else {
                    fsb.append(attrname).append(" ").append(value);
                }
            }
            fsb.append(" \n");
        }
        if (attributeChange) {
            ddl.put("SEQ", fsb.toString());
        }
        return ddl;
    }

    private void $init$() {
        s_seqAttrMap.put(PROPERTYNAME_INCREMENTBY, "INCREMENT BY");
        s_seqAttrMap.put(PROPERTYNAME_MAXVALUE, "MAXVALUE");
        s_seqAttrMap.put(PROPERTYNAME_MINVALUE, "MINVALUE");
        s_seqAttrMap.put(PROPERTYNAME_CYCLEFLAG, "CYCLE");
        s_seqAttrMap.put(PROPERTYNAME_CACHESIZE, "CACHE");
        s_seqAttrMap.put(PROPERTYNAME_ORDERFLAG, "ORDER");
        s_seqNoAttrMap.put(PROPERTYNAME_INCREMENTBY, "INCREMENT BY 1");
        s_seqNoAttrMap.put(PROPERTYNAME_MAXVALUE, "NOMAXVALUE");
        s_seqNoAttrMap.put(PROPERTYNAME_MINVALUE, "NOMINVALUE");
        s_seqNoAttrMap.put(PROPERTYNAME_CYCLEFLAG, "NOCYCLE");
        s_seqNoAttrMap.put(PROPERTYNAME_CACHESIZE, "NOCACHE");
        s_seqNoAttrMap.put(PROPERTYNAME_ORDERFLAG, "NOORDER");
    }
}

