/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.ddlgen.OracleTableDDLGenerator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleAlterDDLStorageProperties
extends OracleTableDDLGenerator {
    private static final Map<String, String> s_property2KeywordLookup = new HashMap<String, String>();
    private static final Map<String, String> s_property2NLSLookup = new HashMap<String, String>();

    private OracleAlterDDLStorageProperties() {
        super(null);
    }

    public static ArrayList<String> getAlterStorageProperties(ResultSet rs, DBObjectProvider prov, SchemaObject schemaObject, String alterContext) {
        return OracleAlterDDLStorageProperties.getAlterStorageProperties(rs, prov, schemaObject, alterContext, true);
    }

    public static ArrayList<String> getAlterStorageProperties(ResultSet rs, DBObjectProvider prov, SchemaObject schemaObject, String alterContext, boolean includeLogging) {
        ArrayList<String> alterDDL = new ArrayList<String>();
        if (rs != null) {
            StringBuffer alterClauses = new StringBuffer();
            StringBuffer moveClauses = new StringBuffer();
            OracleAlterDDLStorageProperties.getSegmentAttributeClauses(rs.getNotSameObjectMap(), alterClauses, moveClauses, schemaObject, false, prov);
            if (alterClauses.length() > 0) {
                StringBuffer alterTable = new StringBuffer(alterContext).append(alterClauses);
                alterDDL.add(alterTable.toString());
            }
            if (moveClauses.length() > 0) {
                StringBuffer alterTable = new StringBuffer(alterContext).append(" ").append("MOVE").append(moveClauses);
                alterDDL.add(alterTable.toString());
            }
        }
        return alterDDL;
    }

    public static void getSegmentAttributeClauses(Map properties, StringBuffer alterClauses, StringBuffer moveClauses, SchemaObject schemaObject, boolean isIOTOverflowSegment, DBObjectProvider prov) {
        OracleAlterDDLStorageProperties.getSegmentAttributeClauses(properties, alterClauses, moveClauses, schemaObject, isIOTOverflowSegment, prov, true);
    }

    private static void getSegmentAttributeClauses(Map properties, StringBuffer alterClauses, StringBuffer moveClauses, SchemaObject schemaObject, boolean isIOTOverflowSegment, DBObjectProvider prov, boolean includeLogging) {
        boolean isIOT = Table.TableType.INDEX_ORGANIZED == schemaObject.getProperty("TableType");
        boolean isPartitioned = Boolean.TRUE.equals(schemaObject.getProperty("PARTITIONED TABLE"));
        StringBuffer moveStorageClauses = new StringBuffer();
        for (ResultSet property : properties.values()) {
            if (property == null || !ModelUtil.hasLength((String)DisplayProps.getBVal(property))) continue;
            String propertyName = property.getName();
            String propertyValue = DisplayProps.getBVal(property);
            if ("tablespace".equals(propertyName)) {
                if (!isPartitioned) {
                    OracleAlterDDLStorageProperties.addStoragePropertyClause(propertyName, prov.getExternalName(propertyValue), moveClauses);
                    continue;
                }
                String warning = DBArb.format((int)350, (Object)DBArb.getString((int)217), (Object)prov.getExternalName(schemaObject.getName(), "TABLE"));
                DBLog.getLogger().warning(warning);
                continue;
            }
            if ("percentFree".equals(propertyName)) {
                if (!isIOT || isIOTOverflowSegment) {
                    OracleAlterDDLStorageProperties.addStoragePropertyClause(propertyName, propertyValue, alterClauses);
                    continue;
                }
                if (!isPartitioned) {
                    OracleAlterDDLStorageProperties.addStoragePropertyClause(propertyName, propertyValue, moveClauses);
                    continue;
                }
                String warning = DBArb.format((int)16, (Object)prov.getExternalName(schemaObject.getName(), "TABLE"));
                DBLog.getLogger().warning(warning);
                continue;
            }
            if ("percentUsed".equals(propertyName)) {
                if (!isIOT || isIOTOverflowSegment) {
                    OracleAlterDDLStorageProperties.addStoragePropertyClause(propertyName, propertyValue, alterClauses);
                    continue;
                }
                String warning = DBArb.format((int)67, (Object)prov.getExternalName(schemaObject.getName(), "TABLE"));
                DBLog.getLogger().warning(warning);
                continue;
            }
            if ("freelists".equals(propertyName) || "freelistGroups".equals(propertyName) || "initialExtent".equals(propertyName) || "nextExtent".equals(propertyName) || "minExtent".equals(propertyName) || "maxExtent".equals(propertyName) || "percentIncrease".equals(propertyName)) {
                if (!isPartitioned) {
                    OracleAlterDDLStorageProperties.addStoragePropertyClause(propertyName, propertyValue, moveStorageClauses);
                    continue;
                }
                String warning = DBArb.format((int)350, (Object)s_property2NLSLookup.get(propertyName), (Object)prov.getExternalName(schemaObject.getName(), "TABLE"));
                DBLog.getLogger().warning(warning);
                continue;
            }
            if ("logging".equals(propertyName) && !includeLogging) continue;
            OracleAlterDDLStorageProperties.addStoragePropertyClause(propertyName, propertyValue, alterClauses);
        }
        if (moveStorageClauses.length() > 0) {
            moveClauses.append(" ").append("STORAGE").append("(").append(moveStorageClauses).append(")");
        }
    }

    private static void addStoragePropertyClause(String name, String value, StringBuffer buf) {
        if (ModelUtil.hasLength((String)value)) {
            if ("logging".equals(name)) {
                if ("false".equals(value)) {
                    buf.append(" ").append("NO").append("LOGGING");
                } else {
                    buf.append(" ").append("LOGGING");
                }
            } else if ("bufferMode".equals(name)) {
                buf.append(OracleAlterDDLStorageProperties.getBufferPool(value));
            } else if ("maxExtent".equals(name)) {
                String unlimitedValue = new Integer(Integer.MAX_VALUE).toString();
                if (unlimitedValue.equals(value)) {
                    buf.append(" ").append(s_property2KeywordLookup.get(name)).append(" ").append("UNLIMITED");
                } else {
                    buf.append(" ").append(s_property2KeywordLookup.get(name)).append(" ").append(value);
                }
            } else {
                buf.append(" ").append(s_property2KeywordLookup.get(name)).append(" ").append(value);
            }
        }
    }

    static {
        s_property2KeywordLookup.put("freelists", "FREELISTS");
        s_property2KeywordLookup.put("freelistGroups", "FREELIST GROUPS");
        s_property2KeywordLookup.put("initialExtent", "INITIAL");
        s_property2KeywordLookup.put("initrans", "INITRANS");
        s_property2KeywordLookup.put("maxExtent", "MAXEXTENTS");
        s_property2KeywordLookup.put("maxtrans", "MAXTRANS");
        s_property2KeywordLookup.put("minExtent", "MINEXTENTS");
        s_property2KeywordLookup.put("nextExtent", "NEXT");
        s_property2KeywordLookup.put("percentFree", "PCTFREE");
        s_property2KeywordLookup.put("percentIncrease", "PCTINCREASE");
        s_property2KeywordLookup.put("percentUsed", "PCTUSED");
        s_property2KeywordLookup.put("tablespace", "TABLESPACE");
        s_property2NLSLookup.put("freelists", DBArb.getString((int)76));
        s_property2NLSLookup.put("freelistGroups", DBArb.getString((int)379));
        s_property2NLSLookup.put("initialExtent", DBArb.getString((int)184));
        s_property2NLSLookup.put("initrans", DBArb.getString((int)113));
        s_property2NLSLookup.put("maxExtent", DBArb.getString((int)65));
        s_property2NLSLookup.put("maxtrans", DBArb.getString((int)341));
        s_property2NLSLookup.put("minExtent", DBArb.getString((int)317));
        s_property2NLSLookup.put("nextExtent", DBArb.getString((int)370));
        s_property2NLSLookup.put("percentFree", DBArb.getString((int)348));
        s_property2NLSLookup.put("percentIncrease", DBArb.getString((int)17));
        s_property2NLSLookup.put("percentUsed", DBArb.getString((int)23));
        s_property2NLSLookup.put("tablespace", DBArb.getString((int)217));
    }
}

