/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import java.util.Iterator;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.ddlgen.OracleTriggerDDLGenerator;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;

public class OracleAlterDDLTrigger
extends OracleTriggerDDLGenerator {
    public OracleAlterDDLTrigger(DBObjectProvider prov, ResultSet rs) {
        super(prov);
        this.m_diffs = rs;
    }

    public Ddl getAlterStatement(SchemaObject schemaObject, ResultSet soDiff) {
        Ddl ddl = new Ddl();
        Map diffs = soDiff.getModifiedObjectMap();
        Trigger trigger = (Trigger)soDiff.b();
        if (diffs.containsKey("source") && trigger.getSource() == null) {
            diffs.remove("source");
        }
        if (diffs.size() == 1 && diffs.containsKey("enabled")) {
            String name = this.getSchemaDotName((DBObject)trigger);
            StringBuilder alter = new StringBuilder();
            alter.append("ALTER").append(" ").append("TRIGGER").append(" ").append(name).append(" ");
            if (trigger.isEnabled()) {
                alter.append("ENABLE");
            } else {
                alter.append("DISABLE");
            }
            ddl.put("TRG_DIS", alter.toString());
        } else {
            Iterator pi = PropertyIterator.getPropertyIterator((Object)trigger);
            while (pi.hasNext()) {
                String propertyName = ((PropertyInfo)pi.next()).getPropertyName();
                if (!diffs.containsKey(propertyName)) continue;
                ResultSet nameRS = (ResultSet)diffs.get(propertyName);
                if (!nameRS.isSame() && nameRS.a() instanceof Trigger) {
                    Trigger original = (Trigger)nameRS.a();
                    ddl = this.getDeleteDDL((SchemaObject)original, false);
                    ddl.append(this.getCreateDDL((SchemaObject)trigger, true, false));
                    break;
                }
                ddl = this.getCreateDDL((SchemaObject)trigger, true, false);
                break;
            }
        }
        return ddl;
    }
}

