/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.AbstractDDLGenerator;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.Table;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleSchemaProperties;
import oracle.javatools.db.ora.RecycledObject;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OracleBaseGenerator
extends AbstractDDLGenerator {
    protected boolean m_diagnosticPrint;
    protected DBObjectProvider m_prov;
    protected ResultSet m_diffs;
    protected boolean m_createPrompts;
    protected boolean m_prefixSchemaName;
    protected String m_createSpoolingCommands;
    protected boolean m_replace;
    protected boolean m_cascade;
    public static final int UPDATE_UNKNOWN = 0;
    public static final int UPDATE_ALTER = 1;
    public static final int UPDATE_REPLACE = 2;
    static final /* synthetic */ boolean $assertionsDisabled;
    protected static final String LPAREN = "(";
    protected static final String RPAREN = ")";
    protected static final String SP = " ";
    protected static final String SP2 = "  ";
    protected static final String SP4 = "    ";
    protected static final String SP6 = "      ";
    protected static final String SP8 = "        ";
    protected static final String DOT = ".";
    protected static final String COLON = ":";
    protected static final String COMMA = ",";
    protected static final String SEMICOLON = ";";
    protected static final String SLASH = "/";
    protected static final String SINGLEQUOTE = "'";
    protected static final String DQ = "\"";
    protected static final String SQ = "'";
    protected static final String NEWLINE = "\n";
    protected static final String NL = " \n";
    protected static final String ACCESS_PARAMETERS = "ACCESS PARAMETERS";
    protected static final String ADD = "ADD";
    protected static final String AS = "AS";
    protected static final String AFTER = "AFTER";
    protected static final String ALTER = "ALTER";
    protected static final String AUTHENTICATED = "AUTHENTICATED";
    protected static final String BEFORE = "BEFORE";
    protected static final String BEGIN = "BEGIN";
    protected static final String BITMAP = "BITMAP";
    protected static final String BODY = "BODY";
    protected static final String BY = "BY";
    protected static final String BUFFER_POOL = "BUFFER_POOL";
    protected static final String BUILD = "BUILD";
    protected static final String CACHE = "CACHE";
    protected static final String CASCADE = "CASCADE";
    protected static final String CHECK = "CHECK";
    protected static final String CHUNK = "CHUNK";
    protected static final String CLOB = "CLOB";
    protected static final String COLUMN = "COLUMN";
    protected static final String COMMENT = "COMMENT";
    protected static final String COMMIT = "COMMIT";
    protected static final String COMPLETE = "COMPLETE";
    protected static final String COMPRESS = "COMPRESS";
    protected static final String CONNECT = "CONNECT";
    protected static final String CONSTRAINT = "CONSTRAINT";
    protected static final String CONSTRAINTS = "CONSTRAINTS";
    protected static final String CONTEXT = "CONTEXT";
    protected static final String CREATE = "CREATE";
    protected static final String CREATE_OR_REPLACE = "CREATE OR REPLACE";
    protected static final String CTXSYS = "CTXSYS";
    protected static final String CYCLE = "CYCLE";
    protected static final String CURRENT_USER = "CURRENT_USER";
    protected static final String DATABASE = "DATABASE";
    protected static final String DEFAULT = "DEFAULT";
    protected static final String DEFERRED = "DEFERRED";
    protected static final String DELETE = "DELETE";
    protected static final String DEMAND = "DEMAND";
    protected static final String DIRECTORY = "DIRECTORY";
    protected static final String DISABLE = "DISABLE";
    protected static final String DROP = "DROP";
    protected static final String EACH = "EACH";
    protected static final String ENABLE = "ENABLE";
    protected static final String END = "END";
    protected static final String ENFORCED = "ENFORCED";
    protected static final String ENABLE_STORAGE_IN_ROW = "ENABLE STORAGE IN ROW";
    protected static final String EXCLUDING = "EXCLUDING";
    protected static final String EXTERNAL = "EXTERNAL";
    protected static final String FAST = "FAST";
    protected static final String FOR = "FOR";
    protected static final String FOR_UPDATE = "FOR_UPDATE";
    protected static final String FORCE = "FORCE";
    protected static final String FOREIGN = "FOREIGN";
    protected static final String FLASHBACK = "FLASHBACK";
    protected static final String FREELIST = "FREELIST";
    protected static final String FREELISTS = "FREELISTS";
    protected static final String FREEPOOLS = "FREEPOOLS";
    protected static final String GLOBAL = "GLOBAL";
    protected static final String GRANT = "GRANT";
    protected static final String GREATEST = "GREATEST";
    protected static final String GROUPS = "GROUPS";
    protected static final String ID = "ID";
    protected static final String IDENTIFIED = "IDENTIFIED";
    protected static final String INCREMENT = "INCREMENT";
    protected static final String IMMEDIATE = "IMMEDIATE";
    protected static final String IN = "IN";
    protected static final String INCLUDING = "INCLUDING";
    protected static final String INDEX = "INDEX";
    protected static final String INDEXES = "INDEXES";
    protected static final String INDEXTYPE = "INDEXTYPE";
    protected static final String INITIAL = "INITIAL";
    protected static final String INITRANS = "INITRANS";
    protected static final String INSERT = "INSERT";
    protected static final String INSTEAD = "INSTEAD";
    protected static final String IS = "IS";
    protected static final String KEEP = "KEEP";
    protected static final String KEY = "KEY";
    protected static final String LINK = "LINK";
    protected static final String LOB = "LOB";
    protected static final String LOCAL = "LOCAL";
    protected static final String LOCATION = "LOCATION";
    protected static final String LOGGING = "LOGGING";
    protected static final String MAPPING = "MAPPING";
    protected static final String MASTER = "MASTER";
    protected static final String MAXEXTENTS = "MAXEXTENTS";
    protected static final String MAXTRANS = "MAXTRANS";
    protected static final String MAXVALUE = "MAXVALUE";
    protected static final String MINEXTENTS = "MINEXTENTS";
    protected static final String MINVALUE = "MINVALUE";
    protected static final String MODIFY = "MODIFY";
    protected static final String MOVE = "MOVE";
    protected static final String MVIEW = "MATERIALIZED VIEW";
    protected static final String MVIEWLOG = "MATERIALIZED VIEW LOG";
    protected static final String NEXT = "NEXT";
    protected static final String NEVER_REFRESH = "NEVER REFRESH";
    protected static final String NESTED_TABLE = "NESTED TABLE";
    protected static final String NEW = "NEW";
    protected static final String NO = "NO";
    protected static final String NOCACHE = "NOCACHE";
    protected static final String NOCOMPRESS = "NOCOMPRESS";
    protected static final String NOCYCLE = "NOCYCLE";
    protected static final String NOLOGGING = "NOLOGGING";
    protected static final String NOORDER = "NOORDER";
    protected static final String NOPARALLEL = "NOPARALLEL";
    protected static final String NOT = "NOT";
    protected static final String NULL = "NULL";
    protected static final String OBJECT = "OBJECT";
    protected static final String OF = "OF";
    protected static final String OFF = "OFF";
    protected static final String OLD = "OLD";
    protected static final String ON = "ON";
    protected static final String OR = "OR";
    protected static final String ORDER = "ORDER";
    protected static final String ORGANIZATION = "ORGANIZATION";
    protected static final String OVERFLOW = "OVERFLOW";
    protected static final String PARALLEL = "PARALLEL";
    protected static final String PARAMETERS = "PARAMETERS";
    protected static final String PARTITION = "PARTITION";
    protected static final String PARTITIONS = "PARTITIONS";
    protected static final String PCTFREE = "PCTFREE";
    protected static final String PCTINCREASE = "PCTINCREASE";
    protected static final String PCTTHRESHOLD = "PCTTHRESHOLD";
    protected static final String PCTUSED = "PCTUSED";
    protected static final String PCTVERSION = "PCTVERSION";
    protected static final String PREBUILT = "PREBUILT";
    protected static final String PRESERVE = "PRESERVE";
    protected static final String PRIMARY = "PRIMARY";
    protected static final String PROJECT = "PROJECT";
    protected static final String PROMPT = "PROMPT";
    protected static final String PUBLIC = "PUBLIC";
    protected static final String PURGE = "PURGE";
    protected static final String QUERY_REWRITE = "QUERY REWRITE";
    protected static final String REBUILD = "REBUILD";
    protected static final String RECYCLE = "RECYCLE";
    protected static final String REDUCED_PRECISION = "REDUCED PRECISION";
    protected static final String RENAME = "RENAME";
    protected static final String REFERENCES = "REFERENCES";
    protected static final String REFERENCING = "REFERENCING";
    protected static final String REFRESH = "REFRESH";
    protected static final String REJECT_LIMIT = "REJECT LIMIT";
    protected static final String RETENTION = "RETENTION";
    protected static final String RETURN = "RETURN";
    protected static final String ROLLBACK_SEGMENT = "ROLLBACK SEGMENT";
    protected static final String ROW = "ROW";
    protected static final String ROWID = "ROWID";
    protected static final String ROWS = "ROWS";
    protected static final String SCHEMA = "SCHEMA";
    protected static final String SEQUENCE = "SEQUENCE";
    protected static final String SET = "SET";
    protected static final String SHARED = "SHARED";
    protected static final String SPEC = "SPEC";
    protected static final String SPOOL = "SPOOL";
    protected static final String SQLBLANKLINES = "SQLBLANKLINES";
    protected static final String START = "START";
    protected static final String STORAGE = "STORAGE";
    protected static final String STORE = "STORE";
    protected static final String SUBPARTITION = "SUBPARTITION";
    protected static final String SUBPARTITIONS = "SUBPARTITIONS";
    protected static final String SUBSTITUTABLE_AT_ALL_LEVELS = "SUBSTITUTABLE_AT_ALL_LEVELS";
    protected static final String SYNONYM = "SYNONYM";
    protected static final String SYSDATE = "SYSDATE";
    protected static final String TABLE = "TABLE";
    protected static final String TABLESPACE = "TABLESPACE";
    protected static final String TEMPLATE = "TEMPLATE";
    protected static final String TEMPORARY = "TEMPORARY";
    protected static final String TO = "TO";
    protected static final String TO_BEFORE_DROP = "TO BEFORE DROP";
    protected static final String TO_DATE = "TO_DATE";
    protected static final String TRIGGER = "TRIGGER";
    protected static final String TRUSTED = "TRUSTED";
    protected static final String TYPE = "TYPE";
    protected static final String UPDATE = "UPDATE";
    protected static final String UNIQUE = "UNIQUE";
    protected static final String UNLIMITED = "UNLIMITED";
    protected static final String UNUSABLE = "UNUSABLE";
    protected static final String USER = "USER";
    protected static final String USING = "USING";
    protected static final String VALUES = "VALUES";
    protected static final String VALUES_LESS_THAN = "VALUES LESS THAN";
    protected static final String VARRAY = "VARRAY";
    protected static final String VIEW = "VIEW";
    protected static final String WHEN = "WHEN";
    protected static final String WITH = "WITH";
    protected static final String WITHOUT = "WITHOUT";
    protected static final String YES = "YES";

    private void $init$() {
        this.m_diagnosticPrint = false;
        this.m_createPrompts = false;
    }

    public OracleBaseGenerator(DBObjectProvider prov) {
        this.$init$();
        this.m_prov = prov;
    }

    public OracleBaseGenerator(DBObjectProvider prov, ResultSet rs) {
        this.$init$();
        this.m_prov = prov;
        this.m_diffs = rs;
    }

    public void setNewOptions(DDLOptions options) {
        this.setReplace(options.isReplace());
        this.setCascade(options.isCascade());
        this.setPrefixSchemaName(options.isPrefixSchemaName());
        this.setCreatePrompts(options.isIncludePrompts());
        this.setSpooling(options.getSpoolFile());
    }

    public Ddl getCreateDDL(SchemaObject so, boolean replace, boolean cascade) {
        return null;
    }

    public Ddl getCreateDDL(SchemaObject[] so, boolean replace, boolean cascade) {
        return null;
    }

    public Ddl getDeleteDDL(SchemaObject so, boolean cascade) {
        return null;
    }

    public Ddl getDeleteDDL(SchemaObject[] so, boolean cascade) {
        return null;
    }

    public Ddl[] getUpdateDDL(SchemaObject soold, SchemaObject sonew) {
        return null;
    }

    public Ddl[] getUpdateDDL(SchemaObject[] soold, SchemaObject[] sonew) {
        return null;
    }

    public Ddl getAlterStatement(SchemaObject so, ResultSet rs) {
        return null;
    }

    protected Schema getDefaultSchema() {
        Schema defaultSchema = null;
        if (this.m_prov instanceof OracleDatabaseImpl) {
            try {
                defaultSchema = this.m_prov.getDefaultSchema();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return defaultSchema;
    }

    protected String getSchemaDotName(DBObject obj) {
        return this.getSchemaDotName(DBUtil.getSchema((DBObject)obj), obj.getName());
    }

    protected String getSchemaDotName(DBObjectID objID) {
        DBObject obj = null;
        try {
            obj = objID.resolveID();
        }
        catch (DBException e) {
            obj = null;
        }
        return obj == null ? null : this.getSchemaDotName(obj);
    }

    protected String getSchemaDotName(Schema schema, String objectName) {
        return this.getSchemaDotName(AbstractDBObjectProvider.convertObject((DBObject)schema), objectName);
    }

    private String getSchemaDotName(String schemaName, String objectName) {
        return this.getSchemaDotName(schemaName, objectName, this.getDefaultSchema());
    }

    private String getSchemaDotName(String schemaName, String objectName, Schema defaultSchema) {
        StringBuffer schemaDotName = new StringBuffer();
        if (this.m_prefixSchemaName || defaultSchema != null && ModelUtil.hasLength((String)schemaName) && ModelUtil.areDifferent((Object)defaultSchema.getName(), (Object)schemaName)) {
            schemaDotName.append(this.m_prov.getExternalName(schemaName)).append(DOT);
        }
        schemaDotName.append(this.m_prov.getExternalName(objectName));
        return schemaDotName.toString();
    }

    protected void addPrompt(StringBuffer b, String action, String type, String name, String preposition, String target) {
        if (this.m_createPrompts) {
            b.append(PROMPT).append(SP);
            b.append(action.toLowerCase()).append(SP);
            if (type != null) {
                b.append(type.toLowerCase());
            }
            if (name != null) {
                b.append(SP).append("'").append(name).append("'");
            }
            if (preposition != null) {
                b.append(SP).append(preposition.toLowerCase()).append(SP);
            }
            if (target != null) {
                b.append("'").append(target).append("'");
            }
            b.append(NEWLINE);
        }
    }

    protected void addPrompt(StringBuffer b, String action, String type, String name) {
        this.addPrompt(b, action, type, name, null, null);
    }

    protected Ddl dropBasicObject(SchemaObject object) {
        String name = this.getSchemaDotName((DBObject)object);
        String type = object.getType();
        StringBuffer drop = new StringBuffer();
        this.addPrompt(drop, DROP, type, name);
        drop.append(DROP).append(SP).append(type).append(SP);
        drop.append(name);
        Ddl ddl = new Ddl();
        ddl.put(DROP, drop.toString());
        return ddl;
    }

    private Ddl purgeRecycledObject(RecycledObject recycled) {
        String sysName = recycled.getName();
        String origName = recycled.getOriginalName();
        StringBuffer purge = new StringBuffer();
        this.addPrompt(purge, PURGE, RECYCLE, origName);
        purge.append(PURGE).append(SP);
        if (TABLE.equals(recycled.getOriginalType())) {
            purge.append(TABLE).append(SP);
        } else if (INDEX.equals(recycled.getOriginalType())) {
            purge.append(INDEX).append(SP);
        }
        purge.append(DQ).append(sysName).append(DQ);
        Ddl ddl = new Ddl();
        ddl.put(DROP, purge.toString());
        return ddl;
    }

    protected String createCommentOn(String ObjType, String name, Map properties) {
        String comment = properties == null ? null : (String)properties.get("Comment");
        return this.createCommentOn(ObjType, name, comment, false);
    }

    protected String createCommentOn(String objType, String name, String comment) {
        return this.createCommentOn(objType, name, comment, true);
    }

    protected String createCommentOn(String objType, String name, String comment, boolean createNull) {
        StringBuffer buf = new StringBuffer();
        if (comment != null || createNull) {
            buf.append(COMMENT).append(SP).append(ON).append(SP).append(objType);
            buf.append(SP).append(name).append(SP).append(IS).append(SP);
            buf.append("'");
            if (comment != null) {
                comment = comment.replace('\n', ' ').replace('\r', ' ').replaceAll("'", "''");
                buf.append(comment);
            }
            buf.append("'");
            buf.append(NEWLINE);
        }
        return buf.toString();
    }

    protected String createCommentOnRelation(Relation relation) {
        String name = this.getSchemaDotName((DBObject)relation);
        Map properties = relation.getProperties();
        return this.createCommentOn(TABLE, name, properties);
    }

    private boolean isOnlyCommentDifferent(ResultSet diff) {
        boolean result = false;
        Map attrs = diff.getNotSameObjectMap();
        if (attrs.size() == 1 && attrs.containsKey("Comment")) {
            result = true;
        }
        return result;
    }

    private String getCommentIfDifferent(ResultSet diff) {
        ResultSet rs;
        String comment = null;
        Map attrs = diff.getNotSameObjectMap();
        if (attrs.containsKey("Comment") && (comment = DisplayProps.getBVal(rs = (ResultSet)attrs.get("Comment"))) == null) {
            comment = "";
        }
        return comment;
    }

    protected static HashMap<String, Object> getAttributes(ResultSet rs, boolean getAll) {
        HashMap<String, Object> attrmap = new HashMap<String, Object>();
        Map attrs = rs.getAllObjectsMap();
        if (attrs != null && attrs.keySet() != null) {
            Iterator i = attrs.keySet().iterator();
            while (i.hasNext()) {
                ResultSet attr = (ResultSet)attrs.get(i.next());
                if (!getAll && attr.isSame()) continue;
                attrmap.put(attr.getName(), DisplayProps.getBVal(attr));
            }
        }
        return attrmap;
    }

    public Ddl[] getUpdateDDL(ResultSet rs, boolean replace, boolean cascade) {
        this.setReplace(replace);
        this.setCascade(cascade);
        return this.getUpdateDDL(rs);
    }

    static {
        $assertionsDisabled = OracleBaseGenerator.class.desiredAssertionStatus() ^ true;
    }

    public Ddl[] getUpdateDDL(ResultSet rs) {
        ArrayList<Ddl> ddlArray = new ArrayList<Ddl>();
        if (!rs.isSame()) {
            ArrayList<ResultSet> dbObjects = null;
            if ("LIST".equals(rs.getType())) {
                dbObjects = rs.getAllObjectsList();
            } else {
                if (!$assertionsDisabled && !"MAP".equals(rs.getType())) {
                    throw new AssertionError();
                }
                dbObjects = new ArrayList<ResultSet>();
                dbObjects.add(rs);
            }
            for (ResultSet objectDiff : dbObjects) {
                if (objectDiff.isSame()) continue;
                String type = ((DBObject)objectDiff.getResultSetObject()).getType();
                OracleBaseGenerator alterGen = (OracleBaseGenerator)this.getAlterDDLGenerator(type);
                int action = 2;
                if (alterGen != null) {
                    alterGen.copyRegisteredGenerators(this);
                    action = alterGen.getUpdateAction(objectDiff);
                }
                if (objectDiff.a() == null || 2 == action) {
                    SchemaObject schemaObject = (SchemaObject)objectDiff.b();
                    String comment = this.getCommentIfDifferent(objectDiff);
                    Ddl commentDdl = null;
                    if (comment != null) {
                        commentDdl = new Ddl();
                        commentDdl.put("CMT", this.createCommentOn(TABLE, schemaObject.getName(), comment, true));
                    }
                    if (schemaObject.getType().equals(VIEW) && this.isOnlyCommentDifferent(objectDiff)) {
                        ddlArray.add(commentDdl);
                        continue;
                    }
                    ddlArray.add(this.getCreateDDL(schemaObject, this.m_replace || 2 == action, this.m_cascade));
                    if (!schemaObject.getType().equals(VIEW) || commentDdl == null || comment.length() != 0) continue;
                    ddlArray.add(commentDdl);
                    continue;
                }
                if (objectDiff.b() == null) {
                    ddlArray.add(this.getDeleteDDL((SchemaObject)objectDiff.a(), false));
                    continue;
                }
                if (1 != action) continue;
                ddlArray.add(alterGen.getAlterStatement((SchemaObject)objectDiff.a(), objectDiff));
            }
            ddlArray.add(this.generateSpoolCommands());
        }
        Ddl[] ddla = new Ddl[]{};
        return ddlArray.toArray(ddla);
    }

    public Ddl getCreateDDL(Schema schema) {
        Iterator iter;
        String name = new StringBuffer().append(this.m_prov.getExternalName(schema.getName())).toString();
        StringBuffer buf = new StringBuffer();
        this.addPrompt(buf, CREATE, USER, name);
        buf.append(CREATE).append(SP).append(USER).append(SP);
        buf.append(name);
        buf.append(SP).append(IDENTIFIED).append(SP).append(BY).append(SP);
        buf.append(schema.getProperty("PASSWORD"));
        OracleSchemaProperties osp = (OracleSchemaProperties)schema.getProperty("OracleSchemaProperties");
        if (osp != null) {
            String s = osp.getDefaultTablespace();
            if (ModelUtil.hasLength((String)s)) {
                buf.append(SP).append(DEFAULT).append(SP).append(TABLESPACE).append(SP);
                buf.append(s);
            }
            if (ModelUtil.hasLength((String)(s = osp.getTemporaryTablespace()))) {
                buf.append(SP).append(TEMPORARY).append(SP).append(TABLESPACE).append(SP);
                buf.append(s);
            }
        }
        Ddl ddl = new Ddl();
        ddl.put(SCHEMA, buf.toString());
        Set privs = (Set)schema.getProperty("USER PRIVS");
        if (privs != null && (iter = privs.iterator()).hasNext()) {
            buf.setLength(0);
            buf.append(GRANT).append(SP);
            buf.append(iter.next());
            while (iter.hasNext()) {
                buf.append(COMMA).append(SP).append(iter.next());
            }
            buf.append(SP).append(TO).append(SP).append(name);
            ddl.put(GRANT, buf.toString());
        }
        ddl.append(this.generateSpoolCommands());
        return ddl;
    }

    public Ddl getDeleteDDL(Schema schema, boolean cascade) {
        String name = new StringBuffer().append(this.m_prov.getExternalName(schema.getName())).toString();
        StringBuffer buf = new StringBuffer();
        this.addPrompt(buf, DROP, USER, name);
        buf.append(DROP).append(SP).append(USER).append(SP);
        buf.append(name);
        if (cascade) {
            buf.append(SP).append(CASCADE);
        }
        Ddl ddl = new Ddl();
        ddl.put(DROP, buf.toString());
        ddl.append(this.generateSpoolCommands());
        return ddl;
    }

    public void setCreatePrompts(boolean value) {
        this.m_createPrompts = value;
    }

    public void setSpooling(String filename) {
        this.m_createSpoolingCommands = filename;
    }

    public void setReplace(boolean value) {
        this.m_replace = value;
    }

    public void setCascade(boolean value) {
        this.m_cascade = value;
    }

    public void setPrefixSchemaName(boolean value) {
        this.m_prefixSchemaName = value;
    }

    public boolean hasCreatePrompts() {
        return this.m_createPrompts;
    }

    protected Ddl generateSpoolCommands() {
        Ddl ddl = new Ddl();
        if (this.m_createPrompts && this.m_createSpoolingCommands != null) {
            String spoolCommand = "SPOOL " + this.m_createSpoolingCommands;
            String spoolOff = "SPOOL OFF";
            ddl.putOne("SPOOLON", spoolCommand);
            ddl.putOne("SPOOLOFF", spoolOff);
        }
        return ddl;
    }

    public int getUpdateAction(ResultSet rs) {
        int result = 0;
        if (rs != null) {
            result = 2;
            Class cla = rs.getResultSetClass();
            if (Index.class.equals((Object)cla) || Sequence.class.equals((Object)cla) || Table.class.equals((Object)cla) || Trigger.class.equals((Object)cla) || MaterializedView.class.equals((Object)cla) || MaterializedViewLog.class.equals((Object)cla)) {
                result = 1;
            }
        }
        return result;
    }

    protected static String kw(String str) {
        boolean lowercasePlSql;
        GlobalSettings settings = GlobalSettings.getInstance();
        boolean bl = lowercasePlSql = settings != null && settings.isNewPlSqlLowerCase();
        if (str != null && lowercasePlSql && !str.startsWith(DQ) && !str.startsWith("'")) {
            return str.toLowerCase();
        }
        return str;
    }
}

