/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.ora.ddlgen.OracleBaseGenerator;
import oracle.javatools.util.ModelUtil;

public class OracleDBLinkDDLGenerator
extends OracleBaseGenerator {
    public OracleDBLinkDDLGenerator(DBObjectProvider prov) {
        super(prov);
    }

    public Ddl getCreateDDL(SchemaObject dbobject, boolean replace, boolean cascade) {
        return this.createDatabaseLink((DatabaseLink)dbobject);
    }

    public Ddl getDeleteDDL(SchemaObject dbObject, boolean cascade) {
        return this.dropDatabaseLink((DatabaseLink)dbObject);
    }

    public Ddl[] getUpdateDDL(SchemaObject dbMaster, SchemaObject dbUpdatable) {
        return null;
    }

    public Ddl[] getUpdateDDL(ResultSet rs) {
        return null;
    }

    private Ddl createDatabaseLink(DatabaseLink dblink) {
        StringBuffer create = new StringBuffer("CREATE ");
        if (dblink.isShared()) {
            create.append("SHARED").append(" ");
        }
        if (dblink.isPublic()) {
            create.append("PUBLIC").append(" ");
        }
        create.append("DATABASE").append(" ").append("LINK").append(" ").append("\"").append(dblink.getName()).append("\"");
        if (dblink.getUsername() != null || dblink.isCurrentUser()) {
            create.append(" ").append("CONNECT").append(" ").append("TO").append(" ");
            if (dblink.isCurrentUser()) {
                create.append("CURRENT_USER");
            } else {
                create.append(dblink.getUsername()).append(" ").append("IDENTIFIED").append(" ").append("BY").append(" ").append(dblink.getPassword());
            }
        }
        create.append(this.getAuthentification(dblink));
        if (ModelUtil.hasLength((String)dblink.getHost())) {
            create.append(" ").append("USING").append(" ").append("'" + dblink.getHost() + "'");
        }
        Ddl ddl = new Ddl();
        ddl.put("DATABASELINK", create.toString());
        return ddl;
    }

    protected Ddl dropDatabaseLink(DatabaseLink dblink) {
        StringBuffer drop = new StringBuffer();
        drop.append("DROP").append(" ");
        if (dblink.isPublic()) {
            drop.append("PUBLIC").append(" ");
        }
        drop.append("DATABASE").append(" ").append("LINK").append(" ").append(dblink.getName());
        Ddl ddl = new Ddl();
        ddl.put("DROP", drop.toString());
        return ddl;
    }

    private String getAuthentification(DatabaseLink dblink) {
        StringBuffer result = new StringBuffer();
        if (dblink.isShared()) {
            result.append(" ").append("AUTHENTICATED").append(" ").append("BY").append(" ").append(dblink.getAuthentificationUser()).append(" ").append("IDENTIFIED").append(" ").append("BY").append(" ").append(dblink.getAuthentificationPassword());
        }
        return result.toString();
    }
}

