/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.Index;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.Indextype;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.ora.ddlgen.OracleBaseGenerator;
import oracle.javatools.db.ora.ddlgen.OracleRelationDDLGenerator;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class OracleIndexDDLGenerator
extends OracleBaseGenerator {
    public OracleIndexDDLGenerator(DBObjectProvider prov) {
        super(prov);
    }

    public Ddl getCreateDDL(SchemaObject dbobject, boolean replace, boolean cascade) {
        return this.getCreateIndexDDL((Index)dbobject);
    }

    public Ddl getDeleteDDL(SchemaObject dbObject, boolean cascade) {
        Index index;
        Ddl ddl = this.dropBasicObject(dbObject);
        if (dbObject instanceof Index && (index = (Index)dbObject).getIndexType() == Index.IndexType.DOMAIN) {
            StringBuffer stmt = new StringBuffer(ddl.get("DROP"));
            stmt.append(" ").append("FORCE");
            ddl.put("DROP", stmt.toString());
        }
        return ddl;
    }

    public Ddl[] getUpdateDDL(SchemaObject dbMaster, SchemaObject dbUpdatable) {
        return null;
    }

    public Ddl[] getUpdateDDL(ResultSet rs) {
        return null;
    }

    private Ddl getCreateIndexDDL(Index index) {
        Integer compress;
        int degree;
        Table table = index.getTable();
        String name = this.getSchemaDotName((DBObject)index);
        StringBuffer create = new StringBuffer();
        this.addPrompt(create, "CREATE", "INDEX", name);
        create.append("CREATE").append(" ");
        if (Index.IndexType.BITMAP == index.getIndexType()) {
            create.append("BITMAP").append(" ");
        } else if (Index.IndexType.UNIQUE == index.getIndexType()) {
            create.append("UNIQUE").append(" ");
        }
        create.append("INDEX").append(" ");
        create.append(name);
        create.append(" ").append("ON").append(" ");
        String indexedTableName = table == null ? null : this.getSchemaDotName((DBObject)table);
        create.append(indexedTableName);
        create.append(" ").append("(");
        IndexObject[] ios = index.getColumnExpressions();
        int i = 0;
        while (i < ios.length) {
            SQLFragment expression;
            if (i > 0) {
                create.append(",").append(" ");
            }
            if ((expression = ios[i].getExpression()) instanceof ColumnUsage) {
                ((ColumnUsage)expression).setProvider(this.m_prov);
            }
            create.append(expression.getSQLText());
            String order = ios[i].getOrder();
            if (ModelUtil.hasLength((String)order)) {
                create.append(" ").append(order);
            }
            ++i;
        }
        create.append(")");
        if (index.getIndexType() == Index.IndexType.DOMAIN) {
            String schemaName = null;
            String indextypeName = null;
            DBObjectID indextypeID = index.getDomainIndextype();
            if (indextypeID != null) {
                if (indextypeID instanceof ReferenceID) {
                    schemaName = ((ReferenceID)indextypeID).getSchemaName();
                    indextypeName = ((ReferenceID)indextypeID).getName();
                } else {
                    try {
                        Indextype indextype;
                        DBObject object = indextypeID.resolveID();
                        if (object != null && object instanceof Indextype && (indextype = (Indextype)object).getSchema() != null && indextype.getName() != null) {
                            schemaName = indextype.getSchema().getName();
                            indextypeName = indextype.getName();
                        }
                    }
                    catch (DBException e) {
                        // empty catch block
                    }
                }
            }
            if (ModelUtil.hasLength(schemaName) && ModelUtil.hasLength(indextypeName)) {
                String parameters;
                create.append(" ").append("INDEXTYPE").append(" ").append("IS").append(" ").append(schemaName).append(".").append(indextypeName);
                this.addDomainIndexPartitions(index, create);
                String string = parameters = index.getDomainIndextypeParameters() != null ? index.getDomainIndextypeParameters().trim() : null;
                if (ModelUtil.hasLength((String)parameters)) {
                    create.append(" \n").append("PARAMETERS").append("(").append("'").append(parameters).append("'").append(")");
                }
            }
        } else {
            OracleStorageProperties osp;
            OracleIndexPartitions oip = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
            if (oip != null) {
                OracleIndexPartitions.PartitionType partitionType = oip.getPartitionType();
                if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH || partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
                    this.addGlobalPartitions(index, create);
                } else if (partitionType == OracleIndexPartitions.PartitionType.LOCAL_HASH) {
                    this.addLocalHashPartitions(index.getTable(), oip, create);
                } else if (partitionType == OracleIndexPartitions.PartitionType.LOCAL_COMP) {
                    this.addLocalCompPartitions(index.getTable(), oip, create);
                } else if (partitionType == OracleIndexPartitions.PartitionType.LOCAL_OTHER) {
                    this.addLocalOtherPartitions(index.getTable(), oip, create);
                }
            }
            if ((osp = (OracleStorageProperties)index.getProperty("OracleStorageProperties")) != null) {
                create.append(OracleRelationDDLGenerator.getSegmentAttributeClause(osp, "  "));
            }
        }
        if ((degree = index.getParallelDegree()) != 1 && table != null && (table.getProperty("TableType") == Table.TableType.NORMAL || table.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED)) {
            create.append(" ").append("PARALLEL");
            if (degree > 1) {
                create.append(" ").append(degree);
            }
        }
        if ((compress = index.getKeyCompression()) != null) {
            create.append(" ").append("COMPRESS");
            if (compress != 0) {
                create.append(" ").append(compress);
            }
        }
        Ddl ddl = new Ddl();
        ddl.put("IND", create.toString());
        return ddl;
    }

    private void addDomainIndexPartitions(Index index, StringBuffer create) {
        OracleIndexPartitions oip = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
        if (oip != null) {
            StringBuffer ddl = new StringBuffer();
            IndexPartition[] indexPartitionArray = oip.getPartitions();
            int n = 0;
            while (n < indexPartitionArray.length) {
                IndexPartition partition = indexPartitionArray[n];
                if (ddl.length() > 0) {
                    ddl.append(",");
                }
                ddl.append(" \n").append("    ").append("PARTITION");
                if (ModelUtil.hasLength((String)partition.getName())) {
                    ddl.append(" ").append(partition.getName());
                }
                if (ModelUtil.hasLength((String)partition.getDomainParameters())) {
                    ddl.append(" ").append("PARAMETERS").append("(").append("'").append(partition.getDomainParameters()).append("'").append(")");
                }
                ++n;
            }
            if (ddl.length() > 0) {
                create.append(" \n").append("LOCAL").append(" \n").append("(").append(ddl).append(" \n").append(")");
            }
        }
    }

    private void addGlobalPartitions(Index index, StringBuffer create) {
        int hashQuantity;
        OracleIndexPartitions oip = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
        StringBuffer columns = new StringBuffer();
        DBObjectID[] dBObjectIDArray = oip.getGlobalPartitionColumns();
        int n = 0;
        while (n < dBObjectIDArray.length) {
            DBObjectID id = dBObjectIDArray[n];
            Column partitionColumn = (Column)index.getTable().findOwnedObject(id);
            if (partitionColumn == null) {
                try {
                    partitionColumn = (Column)id.resolveID();
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
            if (partitionColumn != null) {
                if (columns.length() > 0) {
                    columns.append(",").append(" ");
                }
            } else {
                return;
            }
            columns.append(partitionColumn.getName());
            ++n;
        }
        IndexPartition[] partitions = oip.getPartitions();
        int n2 = hashQuantity = oip.getGlobalHashQuantity() == null ? 0 : oip.getGlobalHashQuantity();
        if (columns.length() > 0 && (partitions.length > 0 || oip.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_HASH && hashQuantity > 0)) {
            String partitionBy = oip.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_HASH ? "HASH" : "RANGE";
            create.append(" \n").append("GLOBAL").append(" ").append("PARTITION").append(" ").append("BY").append(" ").append(partitionBy).append("(").append(columns).append(")");
            if (oip.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_HASH) {
                if (hashQuantity > 0) {
                    create.append(" ").append("PARTITIONS").append(" ").append(hashQuantity).append(this.getStoreInTablespaces(oip.getTablespaces()));
                } else if (partitions.length > 0) {
                    create.append(this.getHashPartitions(index.getTable(), partitions));
                }
            } else {
                create.append(this.getGlobalRangePartitions(partitions));
            }
        }
    }

    private void addLocalHashPartitions(Table table, OracleIndexPartitions oip, StringBuffer create) {
        create.append(" \n").append("LOCAL");
        if (oip.getPartitions().length > 0) {
            create.append(this.getHashPartitions(table, oip.getPartitions()));
        } else if (oip.getTablespaces().length > 0) {
            create.append(this.getStoreInTablespaces(oip.getTablespaces()));
        }
    }

    private void addLocalOtherPartitions(Table table, OracleIndexPartitions oip, StringBuffer create) {
        create.append(" \n").append("LOCAL");
        if (oip.getPartitions().length > 0) {
            create.append(this.getOtherPartitions(table, oip.getPartitions()));
        }
    }

    private void addLocalCompPartitions(Table table, OracleIndexPartitions oip, StringBuffer create) {
        create.append(" \n").append("LOCAL");
        if (oip.getTablespaces().length > 0) {
            create.append(this.getStoreInTablespaces(oip.getTablespaces()));
        }
        if (oip.getPartitions().length > 0) {
            create.append(this.getOtherPartitions(table, oip.getPartitions()));
        }
    }

    private StringBuffer getOtherPartitions(Table table, IndexPartition[] partitions) {
        OracleTablePartitions otp = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
        TablePartition[] tablePartitions = otp.getPartitions();
        StringBuffer ddl = new StringBuffer(" \n").append("(");
        int i = 0;
        while (i < partitions.length) {
            IndexPartition partition = partitions[i];
            if (i > 0) {
                ddl.append(",").append(" \n").append(" ");
            }
            ddl.append("PARTITION");
            if (ModelUtil.hasLength((String)partition.getName())) {
                ddl.append(" ").append(partition.getName());
            }
            if (partition.getSegmentAttributes() != null) {
                if (!(this.m_prov instanceof Oracle10g) && !ModelUtil.hasLength((String)partition.getName())) {
                    ddl.append(" ").append(tablePartitions[i].getName());
                }
                ddl.append(" \n").append(OracleRelationDDLGenerator.getSegmentAttributeClause(partition.getSegmentAttributes(), "    "));
            }
            if (partition.getKeyCompression() != null) {
                if (partition.getKeyCompression().booleanValue()) {
                    ddl.append(" ").append("COMPRESS");
                } else {
                    ddl.append(" ").append("NOCOMPRESS");
                }
            }
            if (partition.getSubpartitions() != null) {
                ddl.append(this.getSubpartitions(tablePartitions[i].getPartitionLevelSubpartitions(), partition.getSubpartitions()));
            }
            ++i;
        }
        return ddl.append(" \n").append(")");
    }

    private StringBuffer getSubpartitions(OracleTablePartitions tableSubpartitions, OracleIndexPartitions subpartitions) {
        StringBuffer ddl = new StringBuffer();
        if (subpartitions.getPartitions().length > 0) {
            ddl.append(" \n").append("  ").append(" ").append("(");
            int i = 0;
            while (i < subpartitions.getPartitions().length) {
                IndexPartition subpartition = subpartitions.getPartitions()[i];
                if (i > 0) {
                    ddl.append(",").append(" \n").append("    ");
                }
                ddl.append("SUBPARTITION");
                if (ModelUtil.hasLength((String)subpartition.getName())) {
                    ddl.append(" ").append(subpartition.getName());
                }
                if (subpartition.getSegmentAttributes() != null && ModelUtil.hasLength((String)subpartition.getSegmentAttributes().getTablespace())) {
                    if (!(this.m_prov instanceof Oracle10g) && !ModelUtil.hasLength((String)subpartition.getName())) {
                        ddl.append(" ").append(tableSubpartitions.getPartitions()[i].getName());
                    }
                    ddl.append(" ").append("TABLESPACE").append(" ").append(subpartition.getSegmentAttributes().getTablespace());
                }
                ++i;
            }
            ddl.append(" \n").append("  ").append(" ").append(")");
        } else if (subpartitions.getTablespaces().length > 0) {
            ddl.append(" \n").append("  ").append(this.getStoreInTablespaces(subpartitions.getTablespaces()));
        }
        return ddl;
    }

    private StringBuffer getHashPartitions(Table table, IndexPartition[] partitions) {
        StringBuffer ddl = new StringBuffer(" \n").append("(");
        int i = 0;
        while (i < partitions.length) {
            IndexPartition partition = partitions[i];
            if (i > 0) {
                ddl.append(",").append(" \n").append(" ");
            }
            ddl.append("PARTITION");
            if (ModelUtil.hasLength((String)partition.getName())) {
                ddl.append(" ").append(partition.getName());
            }
            if (partition.getSegmentAttributes() != null && ModelUtil.hasLength((String)partition.getSegmentAttributes().getTablespace())) {
                if (!(this.m_prov instanceof Oracle10g) && !ModelUtil.hasLength((String)partition.getName())) {
                    OracleTablePartitions otp = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
                    TablePartition[] tablePartitions = otp.getPartitions();
                    ddl.append(" ").append(tablePartitions[i].getName());
                }
                ddl.append(" ").append("TABLESPACE").append(" ").append(partition.getSegmentAttributes().getTablespace());
            }
            ++i;
        }
        return ddl.append(" \n").append(")");
    }

    private StringBuffer getGlobalRangePartitions(IndexPartition[] partitions) {
        StringBuffer ddl = new StringBuffer(" \n").append("(");
        int count = 0;
        IndexPartition[] indexPartitionArray = partitions;
        int n = 0;
        while (n < indexPartitionArray.length) {
            IndexPartition partition = indexPartitionArray[n];
            if (count++ > 0) {
                ddl.append(",").append(" \n").append(" ");
            }
            ddl.append("PARTITION");
            if (ModelUtil.hasLength((String)partition.getName())) {
                ddl.append(" ").append(partition.getName());
            }
            ddl.append(" ").append("VALUES LESS THAN").append("(").append(this.getValuesLessThan(partition)).append(")");
            if (partition.getSegmentAttributes() != null) {
                ddl.append(" \n").append(OracleRelationDDLGenerator.getSegmentAttributeClause(partition.getSegmentAttributes(), "    "));
            }
            ++n;
        }
        return ddl.append(" \n").append(")");
    }

    private StringBuffer getValuesLessThan(IndexPartition partition) {
        StringBuffer ddl = new StringBuffer();
        int i = 0;
        Object[] objectArray = partition.getValuesLessThan();
        int n = 0;
        while (n < objectArray.length) {
            Object value = objectArray[n];
            if (value != null) {
                if (i++ > 0) {
                    ddl.append(",").append(" ");
                }
                ddl.append(value.toString());
            }
            ++n;
        }
        return ddl;
    }

    private StringBuffer getStoreInTablespaces(String[] tablespaces) {
        StringBuffer list = new StringBuffer();
        String[] stringArray = tablespaces;
        int n = 0;
        while (n < stringArray.length) {
            String tablespaceName = stringArray[n];
            if (list.length() > 0) {
                list.append(",").append(" ");
            }
            list.append(tablespaceName);
            ++n;
        }
        return list.length() == 0 ? list : new StringBuffer(" ").append("STORE").append(" ").append("IN").append("(").append(list).append(")");
    }
}

