/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import java.util.ArrayList;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.ddlgen.MaterializedViewDDLHelper;
import oracle.javatools.db.ora.ddlgen.OracleIndexDDLGenerator;
import oracle.javatools.db.ora.ddlgen.OracleRelationDDLGenerator;

public class OracleMatViewDDLGenerator
extends OracleRelationDDLGenerator {
    protected OracleIndexDDLGenerator m_indexGen;

    public OracleMatViewDDLGenerator(DBObjectProvider prov) {
        super(prov);
        this.m_indexGen = new OracleIndexDDLGenerator(prov);
    }

    public Ddl getCreateDDL(SchemaObject dbobject, boolean replace, boolean cascade) {
        return this.createMaterializedView((MaterializedView)dbobject);
    }

    public Ddl getDeleteDDL(SchemaObject dbObject, boolean cascade) {
        return this.dropBasicObject(dbObject);
    }

    public Ddl[] getUpdateDDL(SchemaObject dbMaster, SchemaObject dbUpdatable) {
        return null;
    }

    public Ddl[] getUpdateDDL(ResultSet rs) {
        return null;
    }

    private Ddl createMaterializedView(MaterializedView mview) {
        String name = this.getSchemaDotName((DBObject)mview);
        StringBuffer create = new StringBuffer();
        MaterializedViewDDLHelper helper = new MaterializedViewDDLHelper(mview, this.m_prov);
        this.addPrompt(create, "CREATE", "MATERIALIZED VIEW", name);
        create.append("CREATE").append(" ");
        create.append("MATERIALIZED VIEW").append(" ");
        create.append(name).append("\n");
        MaterializedView.PrebuiltType prebuilt = mview.getOnPrebuilt();
        if (prebuilt != null && prebuilt != MaterializedView.PrebuiltType.NONE) {
            create.append("ON").append(" ").append("PREBUILT").append(" ");
            create.append("TABLE").append(" ");
            if (prebuilt != MaterializedView.PrebuiltType.UNSPECIFIED_PRECISION) {
                if (prebuilt == MaterializedView.PrebuiltType.WITH_REDUCED_PRECISION) {
                    create.append("WITH").append(" ");
                } else {
                    create.append("WITHOUT").append(" ");
                }
                create.append("REDUCED PRECISION").append(" ");
            }
        } else {
            OracleStorageProperties osp = (OracleStorageProperties)mview.getProperty("OracleStorageProperties");
            if (osp != null) {
                create.append(OracleRelationDDLGenerator.getSegmentAttributeClause(osp, "  "));
            }
            create.append(helper.getCompressionDDL(false));
            OracleTablePartitions tablePartitions = (OracleTablePartitions)mview.getProperty("OracleTablePartitions");
            if (tablePartitions != null) {
                create.append(this.createOracleTablePartitions(tablePartitions));
            }
            create.append(helper.getCacheDDL());
            create.append(helper.getParallelDDL());
            if (mview.getBuildType() == MaterializedView.BuildType.DEFERRED) {
                create.append("BUILD").append(" ").append("DEFERRED").append("\n");
            } else if (mview.getBuildType() == MaterializedView.BuildType.IMMEDIATE) {
                create.append("BUILD").append(" ").append("IMMEDIATE").append("\n");
            }
        }
        create.append(helper.getUsingIndexDDL(false));
        create.append(helper.getRefreshDDL());
        if (mview.isUpdatable()) {
            create.append("FOR_UPDATE").append(" ");
        }
        if (mview.isRewrite()) {
            create.append("ENABLE").append(" ");
        } else {
            create.append("DISABLE").append(" ");
        }
        create.append("QUERY REWRITE").append(" ");
        create.append(" ").append("AS").append("\n");
        create.append(mview.getViewText());
        Ddl ddl = new Ddl();
        ddl.put("MVW", create.toString());
        String comment = this.createCommentOnRelation((Relation)mview);
        if (comment != null && comment.length() > 0) {
            ddl.put("CMT", comment);
        }
        ArrayList<String> indexSql = new ArrayList<String>();
        Index[] indexes = mview.getIndexes();
        int i = 0;
        while (i < indexes.length) {
            Ddl indexDDL = this.m_indexGen.getCreateDDL((SchemaObject)indexes[i], false, false);
            indexSql.add(indexDDL.get("IND"));
            ++i;
        }
        if (indexSql.size() > 0) {
            ddl.put("IND", indexSql);
        }
        return ddl;
    }
}

