/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import java.util.logging.Level;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.ddlgen.OracleBaseGenerator;
import oracle.javatools.db.ora.ddlgen.OracleRelationDDLGenerator;
import oracle.javatools.util.ModelUtil;

public class OracleMatViewLogDDLGenerator
extends OracleBaseGenerator {
    public OracleMatViewLogDDLGenerator(DBObjectProvider prov) {
        super(prov);
    }

    public Ddl getCreateDDL(SchemaObject dbobject, boolean replace, boolean cascade) {
        return this.createMaterializedViewLog((MaterializedViewLog)dbobject, replace);
    }

    public Ddl getDeleteDDL(SchemaObject dbObject, boolean cascade) {
        return this.dropMViewLog((MaterializedViewLog)dbObject);
    }

    public Ddl[] getUpdateDDL(SchemaObject dbMaster, SchemaObject dbUpdatable) {
        return null;
    }

    public Ddl[] getUpdateDDL(ResultSet rs) {
        return null;
    }

    protected Ddl createMaterializedViewLog(MaterializedViewLog mvlog, boolean replace) {
        StringBuffer create = new StringBuffer();
        String name = this.qualifiedName(mvlog);
        this.addPrompt(create, "CREATE", "MATERIALIZED VIEW LOG", name);
        create.append("CREATE").append(" ");
        create.append("MATERIALIZED VIEW LOG").append(" ").append("ON").append(" ");
        create.append(name).append("\n");
        OracleStorageProperties osp = (OracleStorageProperties)mvlog.getProperty("OracleStorageProperties");
        if (osp != null) {
            create.append(OracleRelationDDLGenerator.getSegmentAttributeClause(osp, "  "));
        }
        if (mvlog.getCache() != null) {
            create.append(mvlog.getCache() != false ? "CACHE" : "NOCACHE").append(" ");
        }
        if (mvlog.getParallel() == 0) {
            create.append("PARALLEL").append(" ");
        } else if (mvlog.getParallel() > 1) {
            create.append("PARALLEL").append(" ");
            create.append(mvlog.getParallel()).append(" ");
        }
        boolean needComma = false;
        if (mvlog.getPrimaryKeyLogged() != null && mvlog.getPrimaryKeyLogged() != false || mvlog.getRowidLogged() != null && mvlog.getRowidLogged() != false || mvlog.getObjectIdLogged() != null && mvlog.getObjectIdLogged() != false || mvlog.getSequenceLogged() != null && mvlog.getSequenceLogged() != false || mvlog.getColumnIDs().length > 0) {
            DBObjectID[] colIDs;
            create.append("\n").append("WITH").append(" ");
            if (mvlog.getPrimaryKeyLogged() != null && mvlog.getPrimaryKeyLogged().booleanValue()) {
                create.append("PRIMARY").append(" ").append("KEY").append(" ");
                needComma = true;
            }
            if (mvlog.getRowidLogged() != null && mvlog.getRowidLogged().booleanValue()) {
                if (needComma) {
                    create.append(",").append(" ");
                }
                create.append("ROWID").append(" ");
                needComma = true;
            }
            if (mvlog.getObjectIdLogged() != null && mvlog.getObjectIdLogged().booleanValue()) {
                if (needComma) {
                    create.append(",").append(" ");
                }
                create.append("OBJECT").append(" ").append("ID").append(" ");
                needComma = true;
            }
            if (mvlog.getSequenceLogged() != null && mvlog.getSequenceLogged().booleanValue()) {
                if (needComma) {
                    create.append(",").append(" ");
                }
                create.append("SEQUENCE").append(" ");
            }
            if ((colIDs = mvlog.getColumnIDs()).length > 0) {
                int i = 0;
                while (i < colIDs.length) {
                    create.append(i == 0 ? "(" : ",");
                    create.append(DBUtil.getDBObjectName((DBObjectID)colIDs[i]));
                    ++i;
                }
                create.append(")").append(" ");
            }
        }
        if (mvlog.getNewValues() != null) {
            create.append("\n");
            create.append(mvlog.getNewValues() != false ? "INCLUDING" : "EXCLUDING").append(" ");
            create.append("NEW").append(" ").append("VALUES").append(" ");
        }
        Ddl ddl = new Ddl();
        ddl.put("MVL", create.toString());
        return ddl;
    }

    private Ddl dropMViewLog(MaterializedViewLog log) {
        String name = this.qualifiedName(log);
        String type = "MATERIALIZED VIEW LOG";
        StringBuffer drop = new StringBuffer();
        this.addPrompt(drop, "DROP", type, name);
        drop.append("DROP").append(" ").append(type).append(" ");
        drop.append("ON").append(" ");
        drop.append(name);
        Ddl ddl = new Ddl();
        ddl.put("DROPMVL", drop.toString());
        return ddl;
    }

    private String qualifiedName(MaterializedViewLog mvl) {
        String name = this.m_prov.getExternalName(mvl.getName());
        try {
            Table master = (Table)mvl.getMasterTableID().resolveID();
            if (this.m_prov instanceof BaseOracleDatabase && ModelUtil.areDifferent((Object)master.getSchema(), (Object)((BaseOracleDatabase)this.m_prov).getUserName())) {
                name = this.m_prov.getExternalName(master.getSchema().getName()) + "." + name;
            }
        }
        catch (DBException e) {
            DBLog.getLogger().log(Level.WARNING, "failed to find master table");
        }
        return name;
    }
}

