/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.Oracle10gDDLAlterTable;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleNestedTableProperties;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.ora.ddlgen.OracleBaseGenerator;
import oracle.javatools.util.ModelUtil;

public abstract class OracleRelationDDLGenerator
extends OracleBaseGenerator {
    static final /* synthetic */ boolean $assertionsDisabled;
    public static final String PRECISION = "precision";
    public static final String SCALE = "scale";
    public static final String DATATYPEUSAGE = "dataTypeUsage";
    public static final String ISNOTNULL = "notNull";
    public static final String DEFAULT_DIFF = "default";
    public static final String ISENABLED = "enabled";
    public static final String COLUMNS = "columns";
    public static final String CONSTRAINTS = "constraints";
    public static final String PROPERTYNAME_INDEXES = "indexes";
    public static final String PROPERTYNAME_CHECKCONDITION = "checkCondition";
    public static final String PROPERTYNAME_ORACLEEXTERNALTABLEPROPERTIES = "OracleExternalTableProperties";
    public static final String PROPERTYNAME_PROJECTCOLUMN = "projectColumn";
    public static final String PROPERTYNAME_REJECTLIMIT = "rejectLimit";
    public static final String PROPERTYNAME_ACCESSPARAMETERS = "accessParameters";
    public static final String PROPERTYNAME_ACCESSUSINGCLOB = "accessUsingClob";
    public static final String PROPERTYNAME_LOCATIONSPECIFIERS = "locationSpecifiers";
    public static final String PROPERTYNAME_DEFAULT_DIRECTORY = "defaultDirectory";
    public static final String PROPERTYNAME_DIRECTORY = "directory";
    public static final String PROPERTYNAME_SPECIFIER = "specifier";
    public static final String PROPERTYNAME_ORACLEIOTPROPERTIES = "OracleIndexOrganizedTableProperties";
    public static final String PROPERTYNAME_PCT_THRESHOLD = "pctThreshold";
    public static final String PROPERTYNAME_KEY_COMPRESSION = "keyCompression";
    public static final String PROPERTYNAME_MAPPED = "mapped";
    public static final String PROPERTYNAME_INCLUDE_COLUMN = "includeColumn";
    public static final String PROPERTYNAME_OVERFLOWABLE = "overflowable";
    public static final String PROPERTYNAME_OVERFLOW_PROPERTIES = "overflowProperties";
    public static final String PROPERTYNAME_ORACLESTORAGEPROPERTIES = "OracleStorageProperties";
    public static final String PROPERTYNAME_BUFFER_MODE = "bufferMode";
    public static final String PROPERTYNAME_FREELISTS = "freelists";
    public static final String PROPERTYNAME_FREELIST_GROUPS = "freelistGroups";
    public static final String PROPERTYNAME_INI_EXTENT = "initialExtent";
    public static final String PROPERTYNAME_INITRANS = "initrans";
    public static final String PROPERTYNAME_LOGGING = "logging";
    public static final String PROPERTYNAME_MAXEXTENTS = "maxExtent";
    public static final String PROPERTYNAME_MAXTRANS = "maxtrans";
    public static final String PROPERTYNAME_MINEXTENTS = "minExtent";
    public static final String PROPERTYNAME_NEXT_EXTENT = "nextExtent";
    public static final String PROPERTYNAME_PCTFREE = "percentFree";
    public static final String PROPERTYNAME_PCTINCREASE = "percentIncrease";
    public static final String PROPERTYNAME_PCTUSED = "percentUsed";
    public static final String PROPERTYNAME_TABLESPACE = "tablespace";
    public static final String ALTER_TABLE;
    public static final String PROPERTYNAME_ORACLETABLEPARTITIONS = "OracleTablePartitions";
    public static final String PROPERTYNAME_PARTITION_COLUMNS = "partitionColumns";
    public static final String PROPERTYNAME_PARTITIONS = "partitions";
    public static final String PROPERTYNAME_PARTITION_HASH_QUANTITY = "hashQuantity";
    public static final String PROPERTYNAME_PARTITION_HASH_QUANTITY_TABLESPACES = "hashQuantityTablespaces";
    public static final String PROPERTYNAME_PARTITION_SUBPARTITION_MODEL = "subpartitionModel";
    public static final String PROPERTYNAME_TABLEPARTITION = "TablePartition";
    public static final String PROPERTYNAME_NAME = "name";
    public static final String PROPERTYNAME_COMPRESSION = "compression";
    public static final String PROPERTYNAME_VALUES = "values";
    public static final String PROPERTYNAME_SEGMENT_ATTRIBUTES = "segmentAttributes";
    public static final String PROPERTYNAME_PARTITION_LEVEL_SUBPARTITIONS = "partitionLevelSubpartitions";
    public static final String PROPERTYNAME_LOB_DESCRIPTORS = "LOBDescriptors";
    public static final String PROPERTYNAME_LOB_DESCRIPTOR_CACHE = "cache";
    public static final String PROPERTYNAME_LOB_DESCRIPTOR_CHUNK = "chunk";
    public static final String PROPERTYNAME_LOB_DESCRIPTOR_FREEPOOLS = "freepools";
    public static final String PROPERTYNAME_LOB_DESCRIPTOR_LOB_SEGNAME = "LOBSegName";
    public static final String PROPERTYNAME_LOB_DESCRIPTOR_PCTVERSION = "pctVersion";
    public static final String PROPERTYNAME_LOB_DESCRIPTOR_RETENTION = "retention";
    public static final String PROPERTYNAME_LOB_DESCRIPTOR_STORAGE = "storage";
    public static final String PROPERTYNAME_LOB_DESCRIPTOR_STORAGE_ENABLED_IN_ROW = "storageEnabledInRow";
    private static final Map<String, String> s_storageProperty2KeywordMap;

    public OracleRelationDDLGenerator(DBObjectProvider prov) {
        super(prov);
    }

    public Ddl getDeleteDDL(SchemaObject dbObject, boolean cascade) {
        return this.dropRelation((Relation)dbObject, cascade);
    }

    protected Ddl dropRelation(Relation table, boolean cascade) {
        String name = this.getSchemaDotName((DBObject)table);
        String type = table.getType();
        ArrayList<String> dropal = new ArrayList<String>();
        Constraint[] cons = table.getConstraints();
        int i = 0;
        while (i < cons.length) {
            if (cons[i] instanceof FKConstraint) {
                StringBuffer dropcon = new StringBuffer();
                FKConstraint constraint = (FKConstraint)cons[i];
                dropcon.append("ALTER " + type + " " + name + " ");
                dropcon.append("DROP CONSTRAINT ");
                dropcon.append("\"" + constraint.getName() + "\"");
                dropcon.append("\n");
                dropal.add(dropcon.toString());
            }
            ++i;
        }
        StringBuffer drop = new StringBuffer();
        this.addPrompt(drop, "DROP", type, name);
        drop.append("DROP").append(" ").append(type).append(" ");
        drop.append(name);
        if (cascade) {
            drop.append(" ").append("CASCADE").append(" ").append(CONSTRAINTS);
        }
        Ddl ddl = new Ddl();
        ddl.put("DROPCON", dropal);
        ddl.put("DROP", drop.toString());
        return ddl;
    }

    protected static String integerAsKorM(Integer val) {
        int i = val;
        String s = new String("");
        if (i >= 1024 && i % 1024 == 0) {
            s = "K";
            if ((i /= 1024) % 1024 == 0) {
                i /= 1024;
                s = "M";
            }
        }
        return Integer.toString(i) + s;
    }

    public static StringBuffer getStorageClause(OracleStorageProperties osp, String indent) {
        StringBuffer ddl = new StringBuffer();
        if (osp != null) {
            OracleStorageProperties.BufferModes bufferpool;
            Integer freelistgroups;
            Integer freelists;
            Integer pctincrease;
            Integer maxextents;
            Integer minextents;
            Integer next;
            StringBuffer buf = new StringBuffer();
            String clauseIndent = indent + "  ";
            Integer initial = osp.getInitialExtent();
            if (initial != null) {
                buf.append(clauseIndent).append("INITIAL").append(" ").append(OracleRelationDDLGenerator.integerAsKorM(initial)).append("\n");
            }
            if ((next = osp.getNextExtent()) != null) {
                buf.append(clauseIndent).append("NEXT").append(" ").append(OracleRelationDDLGenerator.integerAsKorM(next)).append("\n");
            }
            if ((minextents = osp.getMinExtent()) != null) {
                buf.append(clauseIndent).append("MINEXTENTS").append(" ").append(minextents.toString()).append("\n");
            }
            if ((maxextents = osp.getMaxExtent()) != null) {
                buf.append(clauseIndent).append("MAXEXTENTS").append(" " + (maxextents == Integer.MAX_VALUE ? "UNLIMITED" : maxextents.toString())).append("\n");
            }
            if ((pctincrease = osp.getPercentIncrease()) != null) {
                buf.append(clauseIndent).append("PCTINCREASE").append(" ").append(pctincrease.toString()).append("\n");
            }
            if ((freelists = osp.getFreelists()) != null) {
                buf.append(clauseIndent).append("FREELISTS").append(" ").append(freelists.toString()).append("\n");
            }
            if ((freelistgroups = osp.getFreelistGroups()) != null) {
                buf.append(clauseIndent).append("FREELIST").append(" ").append("GROUPS").append(" ").append(freelistgroups.toString()).append("\n");
            }
            if ((bufferpool = osp.getBufferMode()) != null) {
                buf.append(clauseIndent).append("BUFFER_POOL").append(" ").append(bufferpool).append("\n");
            }
            if (buf.length() > 0) {
                ddl.append(indent).append("STORAGE").append("\n").append(indent).append("(").append("\n").append(buf).append(indent).append(")").append("\n");
            }
        }
        return ddl;
    }

    static {
        $assertionsDisabled = OracleRelationDDLGenerator.class.desiredAssertionStatus() ^ true;
        ALTER_TABLE = "ALTER" + " " + "TABLE" + " ";
        s_storageProperty2KeywordMap = new HashMap<String, String>();
        s_storageProperty2KeywordMap.put(PROPERTYNAME_INI_EXTENT, "INITIAL");
        s_storageProperty2KeywordMap.put(PROPERTYNAME_NEXT_EXTENT, "NEXT");
        s_storageProperty2KeywordMap.put(PROPERTYNAME_MINEXTENTS, "MINEXTENTS");
        s_storageProperty2KeywordMap.put(PROPERTYNAME_MAXEXTENTS, "MAXEXTENTS");
        s_storageProperty2KeywordMap.put(PROPERTYNAME_PCTINCREASE, "PCTINCREASE");
        s_storageProperty2KeywordMap.put(PROPERTYNAME_FREELISTS, "FREELISTS");
        s_storageProperty2KeywordMap.put(PROPERTYNAME_FREELIST_GROUPS, "FREELIST GROUPS");
    }

    protected StringBuffer createOracleTablePartitions(OracleTablePartitions tablePartitions) {
        StringBuffer ddl = new StringBuffer();
        if (tablePartitions != null) {
            DBObjectID[] columns = tablePartitions.getPartitionColumns();
            TablePartition[] partitions = tablePartitions.getPartitions();
            OracleTablePartitions.PartitionType partitionType = tablePartitions.getPartitionType();
            if (tablePartitions.getObjectType() == OracleTablePartitions.ObjectType.PARTITION && columns.length > 0 && partitionType != null) {
                ddl.append("PARTITION").append(" ").append("BY").append(" ").append(partitionType).append(this.createColumnNameList(columns)).append("\n");
                OracleTablePartitions subpartitions = tablePartitions.getSubpartitionModel();
                if (subpartitions != null) {
                    ddl.append(this.createOracleTableSubpartitions(subpartitions));
                }
                if (partitionType == OracleTablePartitions.PartitionType.HASH && tablePartitions.getHashQuantity() != null) {
                    ddl.append(this.createTableHashPartitionsByQuantity(tablePartitions));
                } else {
                    boolean first = true;
                    TablePartition[] tablePartitionArray = partitions;
                    int n = 0;
                    while (n < tablePartitionArray.length) {
                        TablePartition partition = tablePartitionArray[n];
                        if (!$assertionsDisabled && partition == null) {
                            throw new AssertionError();
                        }
                        if (partition != null) {
                            if (first) {
                                ddl.append("(").append("\n").append("  ");
                                first = false;
                            } else {
                                ddl.append(",").append(" ");
                            }
                            ddl.append("PARTITION").append(" ");
                            if (ModelUtil.hasLength((String)partition.getName())) {
                                ddl.append(this.m_prov.getExternalName(partition.getName())).append(" ");
                            }
                            if (partitionType == OracleTablePartitions.PartitionType.HASH) {
                                ddl.append("\n").append(this.createPartitioningStorageClause(partition, "    "));
                            } else if (partitionType == OracleTablePartitions.PartitionType.LIST) {
                                ddl.append(this.createTableListPartition(partition));
                            } else if (partitionType == OracleTablePartitions.PartitionType.RANGE) {
                                ddl.append(this.createTableRangePartition(partition));
                            }
                        }
                        ++n;
                    }
                    if (!first) {
                        ddl.append(")").append("\n");
                    }
                }
            } else {
                ddl.append("PARTITION").append(" ").append("BY").append(" ").append(partitionType).append(this.createColumnNameList(columns)).append("\n");
            }
        }
        return ddl;
    }

    protected StringBuffer createPartitioningStorageClause(TablePartition partition, String indent) {
        StringBuffer ddl = new StringBuffer();
        if (partition != null) {
            OracleStorageProperties segmentAttributes = partition.getSegmentAttributes();
            if (segmentAttributes != null && ModelUtil.hasLength((String)segmentAttributes.getTablespace())) {
                ddl.append(indent).append("TABLESPACE").append(" ").append(this.m_prov.getExternalName(segmentAttributes.getTablespace())).append("\n");
            }
            LOBDescriptor[] lobDescriptors = partition.getLOBDescriptors();
            int i = 0;
            while (i < lobDescriptors.length) {
                String tablespaceName;
                DBObjectID[] columns = lobDescriptors[i].getColumns();
                String lobSegName = lobDescriptors[i].getLOBSegName();
                OracleStorageProperties storage = lobDescriptors[i].getStorage();
                String string = tablespaceName = storage != null ? storage.getTablespace() : null;
                if (columns.length > 0 && columns[0] != null) {
                    if (LOBDescriptor.isLOBColumn((DBObjectID)columns[0])) {
                        if (ModelUtil.hasLength((String)lobSegName) || ModelUtil.hasLength((String)tablespaceName)) {
                            ddl.append(indent).append("LOB").append(this.createColumnNameList(columns)).append(" ").append("STORE").append(" ").append("AS").append(" ");
                            if (ModelUtil.hasLength((String)lobSegName)) {
                                ddl.append(lobSegName);
                            }
                            if (ModelUtil.hasLength((String)tablespaceName)) {
                                ddl.append("(").append("TABLESPACE").append(" ").append(this.m_prov.getExternalName(tablespaceName)).append(")");
                            }
                            ddl.append("\n");
                        }
                    } else {
                        String varrayName = DBUtil.getDBObjectName((DBObjectID)columns[0]);
                        if (ModelUtil.hasLength((String)lobSegName) && ModelUtil.hasLength((String)varrayName)) {
                            ddl.append(indent).append("VARRAY").append(" ").append(this.m_prov.getExternalName(varrayName)).append(" ").append("STORE").append(" ").append("AS").append(" ").append("LOB").append(" ").append(lobSegName).append("\n");
                        }
                    }
                }
                ++i;
            }
        }
        return ddl;
    }

    protected StringBuffer createTableRangePartition(TablePartition partition) {
        StringBuffer ddl = new StringBuffer();
        Object[] rangeValues = partition.getValues();
        if (!$assertionsDisabled && rangeValues.length <= 0) {
            throw new AssertionError();
        }
        if (rangeValues.length > 0) {
            ddl.append(this.createTablePartitionValues("VALUES LESS THAN", partition.getValues())).append("\n").append(this.createTablePartitionDescription(partition));
            if (partition.getPartitionLevelSubpartitions() != null) {
                ddl.append(this.createOracleTableSubpartitions(partition.getPartitionLevelSubpartitions()));
            }
        }
        return ddl;
    }

    protected StringBuffer createTableListPartition(TablePartition partition) {
        StringBuffer ddl = new StringBuffer();
        Object[] listValues = partition.getValues();
        if (!$assertionsDisabled && listValues.length <= 0) {
            throw new AssertionError();
        }
        if (listValues.length > 0) {
            ddl.append(this.createTablePartitionValues("VALUES", listValues)).append("\n").append(this.createTablePartitionDescription(partition));
        }
        return ddl;
    }

    protected StringBuffer createTablePartitionValues(String type, Object[] values) {
        StringBuffer ddl = new StringBuffer();
        if (values.length > 0) {
            ddl.append(type).append("(");
            int i = 0;
            while (i < values.length) {
                if (values[i] != null) {
                    if (i > 0) {
                        ddl.append(",").append(" ");
                    }
                    ddl.append(values[i].toString());
                }
                ++i;
            }
            ddl.append(")");
        }
        return ddl;
    }

    private StringBuffer createTableHashPartitionsByQuantity(OracleTablePartitions partitions) {
        StringBuffer ddl = new StringBuffer();
        if (partitions.getHashQuantity() != null && partitions.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
            ddl.append("  ").append("PARTITIONS").append(" ").append(partitions.getHashQuantity());
            String[] tablespaces = partitions.getHashQuantityTablespaces();
            if (tablespaces.length > 0) {
                ddl.append(" ").append("STORE").append(" ").append("IN").append(this.createTablespaceNameList(tablespaces));
            }
        }
        return ddl;
    }

    protected StringBuffer createLOBDescriptor(LOBDescriptor descriptor, Column owningColumn) {
        StringBuffer ddl = new StringBuffer();
        Column col = owningColumn;
        if (col == null) {
            DBObjectID[] columns = descriptor.getColumns();
            try {
                col = (Column)columns[0].resolveID();
            }
            catch (DBException e) {
                col = null;
            }
        }
        if (col != null) {
            ddl.append(LOBDescriptor.isLOBColumn((DBObjectID)col.getID()) ? this.createLOB(descriptor, owningColumn) : this.createVARRAY(descriptor, owningColumn));
        }
        return ddl;
    }

    private StringBuffer createLOB(LOBDescriptor descriptor, Column owningColumn) {
        StringBuffer ddl = new StringBuffer();
        if (owningColumn != null) {
            ddl.append("    ").append("LOB").append(" ").append("(").append(this.m_prov.getExternalName(owningColumn.getName())).append(")").append(" ").append("STORE").append(" ").append("AS").append(" ");
        } else {
            ddl.append("    ").append("LOB").append(this.createColumnNameList(descriptor.getColumns())).append(" ").append("STORE").append(" ").append("AS").append(" ");
        }
        if (descriptor.getLOBSegName() != null) {
            ddl.append(this.m_prov.getExternalName(descriptor.getLOBSegName()));
        }
        ddl.append(this.createLOBParameters(descriptor, true)).append("\n");
        return ddl;
    }

    private StringBuffer createVARRAY(LOBDescriptor descriptor, Column owningColumn) {
        StringBuffer ddl = new StringBuffer();
        String colName = null;
        colName = owningColumn != null ? owningColumn.getName() : DBUtil.getDBObjectName((DBObjectID)descriptor.getColumns()[0]);
        if (ModelUtil.hasLength((String)colName)) {
            ddl.append("    ").append("VARRAY").append(" ").append(this.m_prov.getExternalName(colName));
        }
        String lobSegName = this.m_prov.getExternalName(descriptor.getLOBSegName());
        StringBuffer lobParameters = this.createLOBParameters(descriptor, false);
        if (lobSegName != null || lobParameters.length() > 0) {
            ddl.append(" ").append("STORE").append(" ").append("AS").append(" ").append("LOB");
            if (lobSegName != null) {
                ddl.append(" ").append(lobSegName);
            }
            ddl.append(lobParameters).append("\n");
        }
        return ddl;
    }

    private StringBuffer createLOBParameters(LOBDescriptor descriptor, boolean includeTablespace) {
        StringBuffer ddl = new StringBuffer();
        ddl.append("      ").append(descriptor.isStorageEnabledInRow() ? "ENABLE" : "DISABLE").append(" ").append("STORAGE").append(" ").append("IN").append(" ").append("ROW").append("\n");
        if (descriptor.getChunk() != null) {
            ddl.append("      ").append("CHUNK").append(" ").append(descriptor.getChunk()).append("\n");
        }
        if (this.m_prov.getDescriptor().supportsFeature("FREEPOOLS") && descriptor.getFreepools() != null) {
            ddl.append("      ").append("FREEPOOLS").append(" ").append(descriptor.getFreepools()).append("\n");
        }
        if (descriptor.getPctVersion() != null) {
            ddl.append("      ").append("PCTVERSION").append(" ").append(descriptor.getPctVersion()).append("\n");
        }
        if (this.m_prov.getDescriptor().supportsFeature("RETENTION") && descriptor.isRetention()) {
            ddl.append("      ").append("RETENTION").append("\n");
        }
        OracleStorageProperties storage = descriptor.getStorage();
        String cache = descriptor.getCache();
        if (cache != null) {
            ddl.append("      ").append(cache);
            if (storage != null && storage.getLogging() != null && (cache.equalsIgnoreCase("NOCACHE") || cache.equalsIgnoreCase("CACHE READS"))) {
                ddl.append(" ").append(storage.getLogging().equals(Boolean.TRUE) ? "LOGGING" : "NOLOGGING");
            }
            ddl.append("\n");
        }
        if (storage != null) {
            if (includeTablespace && storage.getTablespace() != null) {
                ddl.append("      ").append("TABLESPACE").append(" ").append(this.m_prov.getExternalName(storage.getTablespace())).append("\n");
            }
            ddl.append(OracleRelationDDLGenerator.getStorageClause(storage, "      "));
        }
        StringBuffer lobParameters = new StringBuffer();
        if (ddl.length() > 0) {
            lobParameters.append("\n").append("    ").append("(").append("\n").append(ddl).append("    ").append(")");
        }
        return lobParameters;
    }

    private StringBuffer createTablePartitionDescription(TablePartition partition) {
        StringBuffer ddl = new StringBuffer();
        if (partition.getSegmentAttributes() != null) {
            ddl.append(this.createOracleStorageProperties(partition.getSegmentAttributes(), "    "));
        }
        if ("COMPRESS".equals(partition.getCompression())) {
            ddl.append("    ").append(partition.getCompression()).append("\n");
        }
        LOBDescriptor[] lobDescriptors = partition.getLOBDescriptors();
        int i = 0;
        while (i < lobDescriptors.length) {
            ddl.append(this.createLOBDescriptor(lobDescriptors[i], null));
            ++i;
        }
        return ddl;
    }

    private StringBuffer createOracleTableSubpartitions(OracleTablePartitions subpartitions) {
        StringBuffer ddl = new StringBuffer();
        OracleTablePartitions.PartitionType subpartitionType = subpartitions.getPartitionType();
        OracleTablePartitions.ObjectType objectType = subpartitions.getObjectType();
        if (subpartitionType != null && (subpartitionType == OracleTablePartitions.PartitionType.HASH || subpartitionType == OracleTablePartitions.PartitionType.LIST) && objectType != null && objectType != OracleTablePartitions.ObjectType.PARTITION) {
            if (objectType == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) {
                ddl.append(this.createPartitionLevelSubpartitions(subpartitions));
            } else {
                ddl.append("SUBPARTITION").append(" ").append("BY").append(" ").append(subpartitionType).append(this.createColumnNameList(subpartitions.getPartitionColumns()));
                if (objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
                    ddl.append(" ").append("SUBPARTITION").append(" ").append("TEMPLATE");
                    if (subpartitionType == OracleTablePartitions.PartitionType.HASH && subpartitions.getHashQuantity() != null) {
                        ddl.append(" ").append(subpartitions.getHashQuantity());
                    } else {
                        ddl.append("\n").append(this.createTableSubpartitions(subpartitions.getPartitions(), "  "));
                    }
                } else {
                    StringBuffer clause = this.createTableHashSubpartitionsByQuantity(subpartitions);
                    if (clause.length() > 0) {
                        ddl.append(" ").append(clause);
                    }
                }
            }
            if (ddl.length() > 0) {
                ddl.append("\n");
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return ddl;
    }

    private StringBuffer createTableHashSubpartitionsByQuantity(OracleTablePartitions subpartitions) {
        StringBuffer ddl = new StringBuffer();
        if (subpartitions.getHashQuantity() != null && subpartitions.getPartitionType() != null && subpartitions.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
            ddl.append("SUBPARTITIONS").append(" ").append(subpartitions.getHashQuantity());
            String[] tablespaces = subpartitions.getHashQuantityTablespaces();
            if (tablespaces.length > 0) {
                ddl.append(" ").append("STORE").append(" ").append("IN").append(this.createTablespaceNameList(tablespaces));
            }
        }
        return ddl;
    }

    private StringBuffer createPartitionLevelSubpartitions(OracleTablePartitions subpartitions) {
        StringBuffer clause = this.createTableHashSubpartitionsByQuantity(subpartitions);
        if (clause.length() > 0) {
            StringBuffer ddl = new StringBuffer("    ");
            return ddl.append(clause);
        }
        return this.createTableSubpartitions(subpartitions.getPartitions(), "    ");
    }

    protected StringBuffer createTableSubpartitions(TablePartition[] subpartitions, String indent) {
        StringBuffer ddl = new StringBuffer();
        if (subpartitions.length > 0) {
            String subpartitionIndent = indent + "  ";
            ddl.append(indent).append("(").append("\n");
            int i = 0;
            while (i < subpartitions.length) {
                if (i == 0) {
                    ddl.append(subpartitionIndent).append("SUBPARTITION");
                } else {
                    ddl.append(indent).append(",").append(" ").append("SUBPARTITION");
                }
                if (ModelUtil.hasLength((String)subpartitions[i].getName())) {
                    ddl.append(" ").append(this.m_prov.getExternalName(subpartitions[i].getName()));
                }
                if (subpartitions[i].getValues() != null) {
                    ddl.append(" ").append(this.createTablePartitionValues("VALUES", subpartitions[i].getValues()));
                }
                ddl.append("\n").append(this.createPartitioningStorageClause(subpartitions[i], subpartitionIndent + "  "));
                ++i;
            }
            ddl.append(indent).append(")");
        }
        return ddl;
    }

    protected StringBuffer createColumnNameList(DBObjectID[] columns) {
        StringBuffer list = new StringBuffer("(");
        boolean first = true;
        DBObjectID[] dBObjectIDArray = columns;
        int n = 0;
        while (n < dBObjectIDArray.length) {
            DBObjectID colID = dBObjectIDArray[n];
            Column col = null;
            try {
                col = (Column)colID.resolveID();
            }
            catch (DBException e) {
                // empty catch block
            }
            String colName = DBUtil.getDBObjectName((DBObjectID)colID);
            if (col instanceof ViewColumn && colName.contains(".")) {
                colName = colName.substring(colName.indexOf(".") + 1);
            }
            if (ModelUtil.hasLength((String)colName)) {
                if (!first) {
                    list.append(",").append(" ");
                }
                list.append(this.m_prov.getExternalName(colName));
                first = false;
            }
            ++n;
        }
        list.append(")");
        return list;
    }

    private StringBuffer createTablespaceNameList(String[] tablespaces) {
        StringBuffer list = new StringBuffer("(");
        boolean first = true;
        String[] stringArray = tablespaces;
        int n = 0;
        while (n < stringArray.length) {
            String tblspc = stringArray[n];
            if (ModelUtil.hasLength((String)tblspc)) {
                if (!first) {
                    list.append(",").append(" ");
                }
                list.append(this.m_prov.getExternalName(tblspc));
                first = false;
            }
            ++n;
        }
        list.append(")");
        return list;
    }

    protected String createOracleStorageProperties(OracleStorageProperties osp, String indent) {
        return OracleRelationDDLGenerator.getSegmentAttributeClause(osp, indent).toString();
    }

    public static StringBuffer getSegmentAttributeClause(OracleStorageProperties osp, String indent) {
        StringBuffer buf = new StringBuffer();
        if (osp != null) {
            Integer maxtrans;
            Integer initrans;
            Integer pctused;
            Integer pctfree;
            Boolean logging;
            String tablespace = osp.getTablespace();
            if (ModelUtil.hasLength((String)tablespace)) {
                buf.append(indent).append("TABLESPACE").append(" ").append("\"").append(tablespace).append("\"").append("\n");
            }
            if ((logging = osp.getLogging()) != null) {
                buf.append(indent).append(logging != false ? "LOGGING" : "NOLOGGING").append(" ").append("\n");
            }
            if ((pctfree = osp.getPercentFree()) != null) {
                buf.append(indent).append("PCTFREE").append(" ").append(pctfree.toString()).append("\n");
            }
            if ((pctused = osp.getPercentUsed()) != null) {
                buf.append(indent).append("PCTUSED").append(" ").append(pctused.toString()).append("\n");
            }
            if ((initrans = osp.getInitrans()) != null && initrans > 0 && initrans <= 255) {
                buf.append(indent).append("INITRANS").append(" ").append(initrans.toString()).append("\n");
            }
            if ((maxtrans = osp.getMaxtrans()) != null && maxtrans > 0 && maxtrans <= 255) {
                buf.append(indent).append("MAXTRANS").append(" ").append(maxtrans.toString()).append("\n");
            }
            buf.append(OracleRelationDDLGenerator.getStorageClause(osp, indent));
        }
        return buf;
    }

    protected String createOracleColumnProperties(Table table) {
        StringBuffer buf = new StringBuffer();
        Column[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            OracleColumnProperties ocp = (OracleColumnProperties)columns[i].getProperty("OracleColumnProperties");
            if (ocp != null) {
                LOBDescriptor ld = null;
                if (LOBDescriptor.isLOBColumn((DBObjectID)columns[i].getID())) {
                    ld = ocp.getLOBProperties();
                } else if (LOBDescriptor.isVARRAYColumn((DBObjectID)columns[i].getID())) {
                    ld = ocp.getVAProperties();
                }
                OracleNestedTableProperties ntp = ocp.getNestedTableProperties();
                if (ld != null) {
                    buf.append(this.createLOBDescriptor(ld, columns[i]));
                } else if (ntp != null) {
                    buf.append("    ").append("NESTED TABLE").append(" ").append(columns[i].getName());
                    buf.append(" ").append("STORE").append(" ").append("AS");
                    buf.append(" ").append(this.m_prov.getExternalName(ntp.getTableName()));
                    buf.append(" ").append("RETURN").append(" ").append("AS");
                    buf.append(" ").append(ntp.getReturnAs());
                    buf.append("\n");
                }
            }
            ++i;
        }
        return buf.toString();
    }

    protected String getColumnList(Column[] columns, boolean indent) {
        StringBuffer cols = new StringBuffer();
        if (indent) {
            cols.append("  ");
        }
        cols.append("(").append("\n");
        int i = 0;
        while (i < columns.length) {
            if (i > 0) {
                cols.append(",").append("\n");
            }
            if (indent) {
                cols.append("  ");
            }
            cols.append("  " + this.m_prov.getExternalName(columns[i].getName()));
            ++i;
        }
        cols.append("\n");
        if (indent) {
            cols.append("  ");
        }
        cols.append(")").append("\n");
        return cols.toString();
    }

    protected void alterOracleTablePartitions(Ddl ddl, Table table, ResultSet tableDiff) {
        ResultSet partitionsRS = (ResultSet)tableDiff.getAllObjectsMap().get(PROPERTYNAME_ORACLETABLEPARTITIONS);
        if (partitionsRS != null) {
            StringBuffer alterTable = null;
            alterTable = table instanceof MaterializedView ? new StringBuffer("ALTER").append(" ").append("MATERIALIZED VIEW").append(" ").append(this.getSchemaDotName((DBObject)table)).append(" ") : new StringBuffer(ALTER_TABLE).append(this.getSchemaDotName((DBObject)table)).append(" ");
            ArrayList alterStatements = new ArrayList();
            this.alterOracleTablePartitions(alterTable, alterStatements, partitionsRS, null, table);
            if (alterStatements.size() > 0) {
                ddl.put("TP", alterStatements);
            }
        }
    }

    private void alterOracleTablePartitions(StringBuffer alterTable, ArrayList alterStatements, ResultSet partitionsRS, String owningPartitionName, Table table) {
        Map changedProperties = partitionsRS.getModifiedObjectMap();
        ResultSet rs = (ResultSet)changedProperties.get(PROPERTYNAME_PARTITION_SUBPARTITION_MODEL);
        if (rs != null) {
            this.setSubpartitionModel(alterTable, alterStatements, rs);
        }
        if ((rs = (ResultSet)changedProperties.get(PROPERTYNAME_PARTITIONS)) != null) {
            OracleTablePartitions otp = (OracleTablePartitions)partitionsRS.a();
            this.modifyTablePartitions(alterTable, alterStatements, rs, otp.getSubpartitionModel() != null, table);
            if (otp.getPartitions().length > 1) {
                this.dropTablePartitions(alterTable, alterStatements, rs, table);
                this.addTablePartitions(alterTable, alterStatements, rs, owningPartitionName);
            } else {
                this.addTablePartitions(alterTable, alterStatements, rs, owningPartitionName);
                this.dropTablePartitions(alterTable, alterStatements, rs, table);
            }
        }
    }

    private void setSubpartitionModel(StringBuffer alterTable, ArrayList alterStatements, ResultSet subpartitionModelRS) {
        Map changedProperties = subpartitionModelRS.getModifiedObjectMap();
        if (changedProperties.containsKey(PROPERTYNAME_PARTITION_HASH_QUANTITY)) {
            ResultSet rs = (ResultSet)changedProperties.get(PROPERTYNAME_PARTITION_HASH_QUANTITY);
            StringBuffer buf = new StringBuffer(alterTable);
            buf.append("SET").append(" ").append("SUBPARTITION").append(" ").append("TEMPLATE").append(" ").append(DisplayProps.getBVal(rs));
            alterStatements.add(buf.toString());
        } else if (changedProperties.containsKey(PROPERTYNAME_PARTITIONS)) {
            ResultSet rs = (ResultSet)changedProperties.get(PROPERTYNAME_PARTITIONS);
            StringBuffer buf = new StringBuffer(alterTable);
            buf.append("SET").append(" ").append("SUBPARTITION").append(" ").append("TEMPLATE");
            List bTemplates = (List)rs.b();
            if (bTemplates.size() > 0) {
                TablePartition[] templates = bTemplates.toArray(new TablePartition[0]);
                buf.append(this.createTableSubpartitions(templates, "  "));
            } else {
                buf.append("(").append(")");
            }
            alterStatements.add(buf.toString());
        }
    }

    private void modifyTablePartitions(StringBuffer alterTable, ArrayList alterStatements, ResultSet partitionsRS, boolean isComposite, Table table) {
        boolean isIOT = table.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED;
        for (ResultSet listRS : partitionsRS.getModifiedObjectList()) {
            TablePartition partition = (TablePartition)listRS.a();
            if (partition != null) {
                boolean rebuildLocalIndexes = false;
                String partitionName = this.m_prov.getExternalName(partition.getName());
                String objectType = partition.getObjectType() == OracleTablePartitions.ObjectType.PARTITION ? "PARTITION" : "SUBPARTITION";
                Map changedProperties = listRS.getModifiedObjectMap();
                ResultSet rs = (ResultSet)changedProperties.get(PROPERTYNAME_PARTITION_LEVEL_SUBPARTITIONS);
                if (rs != null) {
                    this.alterOracleTablePartitions(alterTable, alterStatements, rs, partitionName, table);
                }
                if ((rs = (ResultSet)changedProperties.get(PROPERTYNAME_VALUES)) != null) {
                    if (partition.getPartitionType() == OracleTablePartitions.PartitionType.LIST) {
                        this.addListValues(alterTable, alterStatements, rs, partitionName, objectType);
                        this.dropListValues(alterTable, alterStatements, rs, partitionName, objectType);
                        rebuildLocalIndexes = true;
                    } else if (partition.getPartitionType() == OracleTablePartitions.PartitionType.RANGE) {
                        String warning = DBArb.format((int)232, (Object)partitionName, (Object)this.m_prov.getExternalName(table.getName(), "TABLE"));
                        DBLog.getLogger().warning(warning);
                    }
                }
                if ((rs = (ResultSet)changedProperties.get(PROPERTYNAME_LOB_DESCRIPTORS)) != null && this.modifyTablePartitionLOBs(alterTable, alterStatements, rs, partition)) {
                    rebuildLocalIndexes = true;
                }
                if ((rs = (ResultSet)changedProperties.get(PROPERTYNAME_COMPRESSION)) != null) {
                    if (!isIOT && partition.getObjectType() == OracleTablePartitions.ObjectType.PARTITION) {
                        String compression;
                        String string = "COMPRESS".equalsIgnoreCase(DisplayProps.getBVal(rs)) ? "COMPRESS" : (compression = "NOCOMPRESS".equalsIgnoreCase(DisplayProps.getBVal(rs)) ? "NOCOMPRESS" : null);
                        if (compression != null) {
                            StringBuffer buf = new StringBuffer(alterTable);
                            buf.append("MODIFY").append(" ").append("PARTITION").append(" ").append(partitionName).append(" ").append(compression);
                            alterStatements.add(buf.toString());
                            rebuildLocalIndexes = true;
                        }
                    } else {
                        String warning = DBArb.format((int)(partition.getObjectType() != OracleTablePartitions.ObjectType.PARTITION ? 289 : 69), (Object)partitionName, (Object)this.m_prov.getExternalName(table.getName(), "TABLE"));
                        DBLog.getLogger().warning(warning);
                    }
                }
                if ((rs = (ResultSet)changedProperties.get(PROPERTYNAME_SEGMENT_ATTRIBUTES)) != null) {
                    if (partition.getObjectType() != OracleTablePartitions.ObjectType.PARTITION || partition.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
                        Map changedSegAttrsMap = rs.getModifiedObjectMap();
                        if (!$assertionsDisabled && changedSegAttrsMap == null) {
                            throw new AssertionError();
                        }
                        ResultSet tablespaceRS = (ResultSet)changedSegAttrsMap.get(PROPERTYNAME_TABLESPACE);
                        if (tablespaceRS != null) {
                            StringBuffer buf = new StringBuffer(alterTable);
                            buf.append("MOVE").append(" ").append(objectType).append(" ").append(partitionName).append(" ").append("TABLESPACE").append(" ").append(DisplayProps.getBVal(tablespaceRS));
                            if (!isIOT) {
                                buf.append(" ").append(this.getUpdateIndexesClause());
                            }
                            alterStatements.add(buf.toString());
                        }
                    } else if (this.modifyTablePartitionSegmentAttributes(alterTable, alterStatements, rs, partitionName, table)) {
                        rebuildLocalIndexes = true;
                    }
                }
                if (rebuildLocalIndexes && !isComposite) {
                    StringBuffer buf = new StringBuffer(alterTable);
                    buf.append("MODIFY").append(" ").append(objectType).append(" ").append(partitionName).append(" ").append("REBUILD").append(" ").append("UNUSABLE").append(" ").append(" ").append("LOCAL").append(" ").append("INDEXES");
                    alterStatements.add(buf.toString());
                }
                if ((rs = (ResultSet)changedProperties.get(PROPERTYNAME_NAME)) == null) continue;
                partitionName = DisplayProps.getBVal(rs);
                StringBuffer buf = new StringBuffer(alterTable);
                buf.append("RENAME").append(" ").append(objectType).append(" ").append(this.m_prov.getExternalName(DisplayProps.getAVal(rs))).append(" ").append("TO").append(" ").append(this.m_prov.getExternalName(DisplayProps.getBVal(rs)));
                alterStatements.add(buf.toString());
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }

    private boolean modifyTablePartitionLOBs(StringBuffer alterTable, ArrayList alterStatements, ResultSet LOBDescriptorsRS, TablePartition partition) {
        boolean rebuildLocalIndexes = false;
        boolean isHashPartition = partition.getObjectType() == OracleTablePartitions.ObjectType.PARTITION && partition.getPartitionType() == OracleTablePartitions.PartitionType.HASH;
        String partitionName = this.m_prov.getExternalName(partition.getName());
        String objectType = partition.getObjectType() == OracleTablePartitions.ObjectType.PARTITION ? "PARTITION" : "SUBPARTITION";
        List lobDescriptors = LOBDescriptorsRS.getModifiedObjectList();
        lobDescriptors.addAll(LOBDescriptorsRS.getBonlyList());
        for (ResultSet listRS : lobDescriptors) {
            LOBDescriptor lobDescriptor = (LOBDescriptor)listRS.b();
            if (lobDescriptor == null) continue;
            Map changedProperties = listRS.getModifiedObjectMap();
            changedProperties.putAll(listRS.getBonlyMap());
            String lobSegName = this.getBVal(changedProperties, PROPERTYNAME_LOB_DESCRIPTOR_LOB_SEGNAME);
            String pctVersion = this.getBVal(changedProperties, PROPERTYNAME_LOB_DESCRIPTOR_PCTVERSION);
            String freepools = this.getBVal(changedProperties, PROPERTYNAME_LOB_DESCRIPTOR_FREEPOOLS);
            String enableInRow = this.getBVal(changedProperties, PROPERTYNAME_LOB_DESCRIPTOR_STORAGE_ENABLED_IN_ROW);
            String retention = this.getBVal(changedProperties, PROPERTYNAME_LOB_DESCRIPTOR_RETENTION);
            String cache = this.getBVal(changedProperties, PROPERTYNAME_LOB_DESCRIPTOR_CACHE);
            String chunk = this.getBVal(changedProperties, PROPERTYNAME_LOB_DESCRIPTOR_CHUNK);
            String tablespace = this.getLOBStorageVal(changedProperties, PROPERTYNAME_TABLESPACE);
            String bufferpool = this.getLOBStorageVal(changedProperties, PROPERTYNAME_BUFFER_MODE);
            String iniExtent = this.getLOBStorageVal(changedProperties, PROPERTYNAME_INI_EXTENT);
            String logging = this.getLOBStorageVal(changedProperties, PROPERTYNAME_LOGGING);
            DBObjectID[] columnIDs = lobDescriptor.getColumns();
            if (!isHashPartition && (ModelUtil.hasLength((String)retention) || ModelUtil.hasLength((String)pctVersion) || ModelUtil.hasLength((String)bufferpool) || ModelUtil.hasLength((String)logging) || ModelUtil.hasLength((String)cache))) {
                DBObjectID[] dBObjectIDArray = columnIDs;
                int n = 0;
                while (n < dBObjectIDArray.length) {
                    String columnName;
                    DBObjectID columnID = dBObjectIDArray[n];
                    if ((listRS.a() != null || !LOBDescriptor.isVARRAYColumn((DBObjectID)columnID)) && ModelUtil.hasLength((String)(columnName = DBUtil.getDBObjectName((DBObjectID)columnID)))) {
                        StringBuffer props = new StringBuffer();
                        if (ModelUtil.hasLength((String)pctVersion)) {
                            props.append(" ").append("PCTVERSION").append(" ").append(pctVersion);
                        } else if (ModelUtil.hasLength((String)retention) && retention.equals("true")) {
                            props.append(" ").append("RETENTION");
                        }
                        if (ModelUtil.hasLength((String)bufferpool)) {
                            props.append(OracleRelationDDLGenerator.getBufferPool(bufferpool));
                        }
                        if (ModelUtil.hasLength((String)cache) || ModelUtil.hasLength((String)logging)) {
                            if (!ModelUtil.hasLength((String)cache) && (cache = lobDescriptor.getCache()) != null && cache.equals("CACHE")) {
                                cache = null;
                            }
                            if (cache != null) {
                                props.append(" ").append(cache);
                                if (ModelUtil.hasLength((String)logging) && !cache.equals("CACHE")) {
                                    props.append(" ").append(logging.equals("true") ? "LOGGING" : "NOLOGGING");
                                }
                            }
                        }
                        if (props.length() > 0) {
                            StringBuffer stmt = new StringBuffer(alterTable);
                            stmt.append("MODIFY").append(" ").append(objectType).append(" ").append(partitionName).append(" ").append("LOB").append("(").append(columnName).append(")").append("(").append(props).append(" ").append(")");
                            alterStatements.add(stmt.toString());
                        }
                    }
                    ++n;
                }
            }
            if (!ModelUtil.hasLength((String)lobSegName) && (partition.getPartitionType() != OracleTablePartitions.PartitionType.HASH || !ModelUtil.hasLength((String)tablespace) || this instanceof Oracle10gDDLAlterTable) && (partition.getPartitionType() == OracleTablePartitions.PartitionType.HASH || !ModelUtil.hasLength((String)enableInRow) && !ModelUtil.hasLength((String)tablespace) && !ModelUtil.hasLength((String)freepools) && !ModelUtil.hasLength((String)chunk) && !ModelUtil.hasLength((String)iniExtent))) continue;
            DBObjectID[] dBObjectIDArray = columnIDs;
            int n = 0;
            while (n < dBObjectIDArray.length) {
                block25: {
                    StringBuffer stmt;
                    StringBuffer props;
                    block27: {
                        String columnName;
                        block26: {
                            DBObjectID columnID = dBObjectIDArray[n];
                            if (listRS.a() == null && LOBDescriptor.isVARRAYColumn((DBObjectID)columnID) || !ModelUtil.hasLength((String)(columnName = DBUtil.getDBObjectName((DBObjectID)columnID)))) break block25;
                            props = new StringBuffer();
                            if (ModelUtil.hasLength((String)tablespace) && (partition.getPartitionType() != OracleTablePartitions.PartitionType.HASH || !(this instanceof Oracle10gDDLAlterTable) && !LOBDescriptor.isVARRAYColumn((DBObjectID)columnID))) {
                                props.append(" ").append("TABLESPACE").append(" ").append(tablespace);
                            }
                            if (partition.getPartitionType() != OracleTablePartitions.PartitionType.HASH) {
                                if (ModelUtil.hasLength((String)chunk)) {
                                    props.append(" ").append("CHUNK").append(" ").append(chunk);
                                }
                                if (ModelUtil.hasLength((String)freepools)) {
                                    props.append(" ").append("FREEPOOLS").append(" ").append(freepools);
                                }
                                if (ModelUtil.hasLength((String)iniExtent)) {
                                    props.append(" ").append("STORAGE").append("(").append("INITIAL").append(" ").append(iniExtent).append(")");
                                }
                                if (ModelUtil.hasLength((String)enableInRow)) {
                                    props.append(" ").append(enableInRow.equals("true") ? "ENABLE" : "DISABLE").append(" ").append("STORAGE").append(" ").append("IN").append(" ").append("ROW");
                                }
                            }
                            if (props.length() <= 0 && !ModelUtil.hasLength((String)lobSegName)) break block25;
                            stmt = new StringBuffer(alterTable);
                            stmt.append("MOVE").append(" ").append(objectType).append(" ").append(partitionName).append(" ");
                            if (!LOBDescriptor.isLOBColumn((DBObjectID)columnID)) break block26;
                            stmt.append("LOB").append("(").append(columnName).append(")").append(" ").append("STORE").append(" ").append("AS");
                            break block27;
                        }
                        if (partition.getPartitionType() == OracleTablePartitions.PartitionType.HASH && !ModelUtil.hasLength((String)lobSegName)) break block25;
                        stmt.append("VARRAY").append(" ").append(columnName).append(" ").append("STORE").append(" ").append("AS").append(" ").append("LOB");
                    }
                    if (ModelUtil.hasLength((String)lobSegName)) {
                        stmt.append(" ").append(lobSegName);
                    }
                    if (props.length() > 0) {
                        stmt.append("(").append(props).append(" ").append(")");
                    }
                    alterStatements.add(stmt.toString());
                }
                ++n;
            }
        }
        return rebuildLocalIndexes;
    }

    private String getBVal(Map changedProperties, String property) {
        ResultSet rs = (ResultSet)changedProperties.get(property);
        if (rs != null) {
            return DisplayProps.getBVal(rs);
        }
        return null;
    }

    private String getLOBStorageVal(Map changedProperties, String property) {
        ResultSet rs = (ResultSet)changedProperties.get(PROPERTYNAME_LOB_DESCRIPTOR_STORAGE);
        if (rs != null) {
            Map changedStorageMap = rs.getModifiedObjectMap();
            if (!$assertionsDisabled && changedStorageMap == null) {
                throw new AssertionError();
            }
            ResultSet propertyRS = (ResultSet)changedStorageMap.get(property);
            if (propertyRS != null) {
                return DisplayProps.getBVal(propertyRS);
            }
        }
        return null;
    }

    private void addListValues(StringBuffer alterTable, ArrayList alterStatements, ResultSet rs, String partitionName, String objectType) {
        List addValues = rs.getBonlyList();
        if (addValues.size() > 0) {
            StringBuffer buf = new StringBuffer(alterTable);
            buf.append("MODIFY").append(" ").append(objectType).append(" ").append(partitionName).append(" ").append("ADD").append(" ").append("VALUES").append("(");
            boolean first = true;
            for (Object value : addValues) {
                if (!first) {
                    buf.append(",").append(" ");
                }
                first = false;
                buf.append(((ResultSet)value).b().toString());
            }
            buf.append(")");
            alterStatements.add(buf.toString());
        }
    }

    private void dropListValues(StringBuffer alterTable, ArrayList alterStatements, ResultSet rs, String partitionName, String objectType) {
        List dropValues = rs.getAonlyList();
        if (dropValues.size() > 0) {
            StringBuffer buf = new StringBuffer(alterTable);
            buf.append("MODIFY").append(" ").append(objectType).append(" ").append(partitionName).append(" ").append("DROP").append(" ").append("VALUES").append("(");
            boolean first = true;
            for (Object value : dropValues) {
                if (!first) {
                    buf.append(",").append(" ");
                }
                first = false;
                buf.append(((ResultSet)value).a().toString());
            }
            buf.append(")");
            alterStatements.add(buf.toString());
        }
    }

    private void addTablePartitions(StringBuffer alterTable, ArrayList alterStatements, ResultSet partitionsRS, String owningPartitionName) {
        for (ResultSet listRS : partitionsRS.getBonlyList()) {
            TablePartition partition = (TablePartition)listRS.b();
            if (!$assertionsDisabled && partition == null) {
                throw new AssertionError();
            }
            if (partition == null) continue;
            OracleTablePartitions.ObjectType objectType = partition.getObjectType();
            if (!$assertionsDisabled && objectType == null) {
                throw new AssertionError();
            }
            if (objectType == null) continue;
            StringBuffer buf = new StringBuffer(alterTable);
            if (objectType == OracleTablePartitions.ObjectType.PARTITION) {
                buf.append(this.getAddPartition(partition));
            } else if (objectType == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) {
                buf.append(this.getAddPartitionLevelSubpartition(partition, owningPartitionName));
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            if (buf.length() <= alterTable.length()) continue;
            alterStatements.add(buf.toString());
        }
    }

    private void dropTablePartitions(StringBuffer alterTable, ArrayList alterStatements, ResultSet partitionsRS, Table table) {
        for (ResultSet listRS : partitionsRS.getAonlyList()) {
            TablePartition partition = (TablePartition)listRS.a();
            if (!$assertionsDisabled && partition == null) {
                throw new AssertionError();
            }
            if (partition == null || partition.getPartitionType() == OracleTablePartitions.PartitionType.HASH) continue;
            OracleTablePartitions.ObjectType objectType = partition.getObjectType();
            if (objectType != null && (objectType == OracleTablePartitions.ObjectType.PARTITION || objectType == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION)) {
                String type = objectType == OracleTablePartitions.ObjectType.PARTITION ? "PARTITION" : "SUBPARTITION";
                StringBuffer buf = new StringBuffer(alterTable);
                buf.append("DROP").append(" ").append(type).append(" ").append(this.m_prov.getExternalName(partition.getName()));
                if (table.getProperty("TableType") != Table.TableType.INDEX_ORGANIZED) {
                    buf.append(" ").append(this.getUpdateIndexesClause());
                }
                alterStatements.add(buf.toString());
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }

    private boolean modifyTablePartitionSegmentAttributes(StringBuffer alterTable, ArrayList alterStatements, ResultSet segAttrsRS, String partitionName, Table table) {
        boolean rebuildLocalIndexes = false;
        Map changedPropertiesMap = segAttrsRS.getModifiedObjectMap();
        if (changedPropertiesMap != null && changedPropertiesMap.size() > 0) {
            StringBuffer buf = new StringBuffer(alterTable);
            buf.append("MODIFY").append(" ").append("PARTITION").append(" ").append(partitionName);
            int initLength = buf.length();
            boolean isIOT = table.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED;
            for (ResultSet property : changedPropertiesMap.values()) {
                String propertyName = property.getName();
                String propertyVal = DisplayProps.getBVal(property);
                if (!isIOT && PROPERTYNAME_PCTFREE.equals(propertyName) && ModelUtil.hasLength((String)propertyVal)) {
                    buf.append(" ").append("PCTFREE").append(" ").append(propertyVal);
                }
                if (!isIOT && PROPERTYNAME_PCTUSED.equals(propertyName) && ModelUtil.hasLength((String)propertyVal)) {
                    buf.append(" ").append("PCTUSED").append(" ").append(propertyVal);
                    continue;
                }
                if (PROPERTYNAME_INITRANS.equals(propertyName) && ModelUtil.hasLength((String)propertyVal)) {
                    buf.append(" ").append("INITRANS").append(" ").append(propertyVal);
                    continue;
                }
                if (PROPERTYNAME_MAXTRANS.equals(propertyName) && ModelUtil.hasLength((String)propertyVal)) {
                    buf.append(" ").append("MAXTRANS").append(" ").append(propertyVal);
                    continue;
                }
                if (PROPERTYNAME_LOGGING.equals(propertyName)) {
                    if ("false".equals(propertyVal)) {
                        buf.append(" ").append("NOLOGGING");
                        continue;
                    }
                    buf.append(" ").append("LOGGING");
                    continue;
                }
                if (!PROPERTYNAME_BUFFER_MODE.equals(propertyName)) continue;
                buf.append(OracleRelationDDLGenerator.getBufferPool(propertyVal));
            }
            if (buf.length() > initLength) {
                alterStatements.add(buf.toString());
                rebuildLocalIndexes = true;
            }
            buf = new StringBuffer(alterTable);
            buf.append("MOVE").append(" ").append("PARTITION").append(" ").append(partitionName);
            initLength = buf.length();
            StringBuffer storage = new StringBuffer();
            for (ResultSet property : changedPropertiesMap.values()) {
                String propertyName = property.getName();
                String propertyVal = DisplayProps.getBVal(property);
                if (PROPERTYNAME_TABLESPACE.equals(propertyName) && ModelUtil.hasLength((String)propertyVal)) {
                    buf.append(" ").append("TABLESPACE").append(" ").append(propertyVal);
                    continue;
                }
                if (isIOT && PROPERTYNAME_PCTFREE.equals(propertyName) && ModelUtil.hasLength((String)propertyVal)) {
                    buf.append(" ").append("PCTFREE").append(" ").append(propertyVal);
                    continue;
                }
                if (!s_storageProperty2KeywordMap.containsKey(propertyName) || !ModelUtil.hasLength((String)propertyVal)) continue;
                storage.append(" ").append(s_storageProperty2KeywordMap.get(propertyName)).append(" ").append(propertyVal);
            }
            if (storage.length() > 0) {
                buf.append(" ").append("STORAGE").append("(").append(storage).append(" ").append(")");
            }
            if (buf.length() > initLength) {
                if (!isIOT) {
                    buf.append(" ").append(this.getUpdateIndexesClause());
                }
                alterStatements.add(buf.toString());
            }
        }
        return rebuildLocalIndexes;
    }

    private StringBuffer getAddPartition(TablePartition partition) {
        StringBuffer buf = new StringBuffer();
        buf.append("ADD").append(" ").append("PARTITION").append(" ");
        if (ModelUtil.hasLength((String)partition.getName())) {
            buf.append(this.m_prov.getExternalName(partition.getName()));
        }
        if (partition.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
            buf.append(" \n").append(this.createPartitioningStorageClause(partition, "  "));
        } else if (partition.getPartitionType() == OracleTablePartitions.PartitionType.LIST) {
            buf.append(" ").append(this.createTableListPartition(partition));
        } else if (partition.getPartitionType() == OracleTablePartitions.PartitionType.RANGE) {
            buf.append(" ").append(this.createTableRangePartition(partition));
        }
        return buf.append(this.getUpdateIndexesClause());
    }

    private StringBuffer getAddPartitionLevelSubpartition(TablePartition subpartition, String owningPartitionName) {
        StringBuffer buf = new StringBuffer();
        buf.append("MODIFY").append(" ").append("PARTITION").append(" ").append(this.m_prov.getExternalName(owningPartitionName)).append(" ").append("ADD").append(" ").append("SUBPARTITION").append(" ");
        if (ModelUtil.hasLength((String)subpartition.getName())) {
            buf.append(this.m_prov.getExternalName(subpartition.getName()));
        }
        if (subpartition.getValues() != null) {
            buf.append(" ").append(this.createTablePartitionValues("VALUES", subpartition.getValues()));
        }
        buf.append(" \n").append(this.createPartitioningStorageClause(subpartition, "  "));
        return buf.append(this.getUpdateIndexesClause());
    }

    protected StringBuffer getUpdateIndexesClause() {
        return new StringBuffer("UPDATE").append(" ").append("GLOBAL").append(" ").append("INDEXES");
    }

    protected static StringBuffer getBufferPool(String buffer) {
        StringBuffer buf = new StringBuffer();
        if (buffer != null) {
            buf.append(" ").append("STORAGE").append("(").append("BUFFER_POOL").append(" ").append(buffer).append(")");
        }
        return buf;
    }
}

