/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.ddlgen.OracleBaseGenerator;

public class OracleSequenceDDLGenerator
extends OracleBaseGenerator {
    public OracleSequenceDDLGenerator(DBObjectProvider prov) {
        super(prov);
    }

    public Ddl getCreateDDL(SchemaObject dbobject, boolean replace, boolean cascade) {
        return this.getCreateSequenceDDL((Sequence)dbobject);
    }

    public Ddl getDeleteDDL(SchemaObject dbObject, boolean cascade) {
        return this.dropBasicObject(dbObject);
    }

    public Ddl[] getUpdateDDL(SchemaObject dbMaster, SchemaObject dbUpdatable) {
        return null;
    }

    public Ddl[] getUpdateDDL(ResultSet rs) {
        return null;
    }

    private Ddl getCreateSequenceDDL(Sequence sequence) {
        String name = this.getSchemaDotName((DBObject)sequence);
        StringBuffer create = new StringBuffer();
        this.addPrompt(create, "CREATE", "SEQUENCE", name);
        create.append("CREATE").append(" ");
        create.append("SEQUENCE").append(" ");
        create.append(name).append(" ");
        if (sequence.getIncrementBy() != null) {
            create.append("INCREMENT").append(" ").append("BY").append(" ");
            create.append(sequence.getIncrementBy().toString()).append(" ");
        }
        if (sequence.getStartWith() != null) {
            create.append("START").append(" ").append("WITH").append(" ");
            create.append(sequence.getStartWith().toString()).append(" ");
        }
        if (sequence.getMaxValue() != null) {
            create.append("MAXVALUE").append(" ");
            create.append(sequence.getMaxValue().toString()).append(" ");
        }
        if (sequence.getMinValue() != null) {
            create.append("MINVALUE").append(" ");
            create.append(sequence.getMinValue().toString()).append(" ");
        }
        if (sequence.getCycleFlag() != null && sequence.getCycleFlag().equals(Boolean.TRUE)) {
            create.append("CYCLE").append(" ");
        }
        if (sequence.getCacheFlag() != null) {
            if (sequence.getCacheFlag().booleanValue()) {
                if (sequence.getCacheSize() != null && sequence.getCacheSize().intValue() > 1) {
                    create.append("CACHE").append(" ").append(sequence.getCacheSize().toString()).append(" ");
                }
            } else {
                create.append("NOCACHE").append(" ");
            }
        }
        if (sequence.getOrderFlag() != null && sequence.getOrderFlag().equals(Boolean.TRUE)) {
            create.append("ORDER").append(" ");
        }
        Ddl ddl = new Ddl();
        ddl.put("SEQ", create.toString());
        return ddl;
    }
}

