/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.DeclarativePlSql;
import oracle.javatools.db.Package;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.ddlgen.OracleBaseGenerator;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.util.ModelUtil;

public class OracleSourceDDLGenerator
extends OracleBaseGenerator {
    public OracleSourceDDLGenerator(DBObjectProvider prov) {
        super(prov);
    }

    public Ddl getCreateDDL(SchemaObject dbObject, boolean replace, boolean cascade) {
        if (dbObject instanceof PlSql) {
            PlSql plsqlObject = (PlSql)dbObject;
            if (dbObject instanceof SpecPlSql && ModelUtil.hasLength((String)plsqlObject.getSource()) && (!(dbObject instanceof ComplexType) || !"COLLECTION".equals(((ComplexType)dbObject).getTypeCode()))) {
                return this.createSpecAndBody((SpecPlSql)dbObject, replace);
            }
            return this.createSourceObject((SourceObject)dbObject, replace);
        }
        return null;
    }

    public Ddl getDeleteDDL(SchemaObject dbObject, boolean cascade) {
        return this.dropBasicObject(dbObject);
    }

    public Ddl[] getUpdateDDL(SchemaObject dbMaster, SchemaObject dbUpdatable) {
        if (dbUpdatable instanceof SpecPlSql) {
            return new Ddl[]{this.createSpecAndBody((SpecPlSql)dbUpdatable, true)};
        }
        return new Ddl[]{this.createSourceObject((SourceObject)dbUpdatable, true)};
    }

    public Ddl[] getUpdateDDL(ResultSet rs) {
        return null;
    }

    private Ddl createSourceObject(SourceObject object, boolean replace) {
        String name = this.getSchemaDotName((DBObject)object);
        Ddl ddl = new Ddl();
        String specCode = object.getSource();
        if (ModelUtil.hasLength((String)specCode)) {
            PlSqlInterrogator pi = ((PlSql)object).getSourceInterrogator();
            StringBuffer spec = new StringBuffer();
            if (replace) {
                this.addPrompt(spec, "CREATE OR REPLACE", "TYPE SPEC", name);
                spec.append("CREATE OR REPLACE").append(" ");
            } else {
                this.addPrompt(spec, "CREATE", "TYPE SPEC", name);
                spec.append("CREATE").append(" ");
            }
            PlSqlFragment pf = pi.getRoot();
            if (pi.isEvolvedType()) {
                pf = (PlSqlFragment)pf.getSubFragments().get(0);
            }
            spec.append(pf.getSource());
            spec.append("\n").append("/").append("\n");
            ddl.put("SPEC", spec.toString());
            if (pi.isEvolvedType()) {
                String[] alterStatements = new String[pi.getRoot().getSubFragments().size() - 1];
                int i = 0;
                while (i < alterStatements.length) {
                    PlSqlFragment alterFrag = (PlSqlFragment)pi.getRoot().getSubFragments().get(i + 1);
                    alterStatements[i] = alterFrag.getSource();
                    ++i;
                }
                ddl.put("EVOLVED_TYPE_ALTER", alterStatements);
            }
        } else if (object instanceof DeclarativePlSql) {
            DBObjectID retTypeID;
            DeclarativePlSql pls = (DeclarativePlSql)object;
            String body = pls.getBody();
            if (!ModelUtil.hasLength((String)body)) {
                body = OracleSourceDDLGenerator.kw("BEGIN\n  ");
                if (pls.getReturnTypeID() != null) {
                    body = body + OracleSourceDDLGenerator.kw("RETURN") + " ";
                }
                body = body + OracleSourceDDLGenerator.kw("NULL;\nEND ") + OracleSourceDDLGenerator.kw(name) + ";";
            }
            StringBuffer spec = new StringBuffer();
            String cmd = replace ? "CREATE OR REPLACE" : "CREATE";
            this.addPrompt(spec, cmd, "TYPE SPEC", name);
            spec.append(OracleSourceDDLGenerator.kw(cmd)).append("\n").append(OracleSourceDDLGenerator.kw(object.getType())).append(" ").append(OracleSourceDDLGenerator.kw(name));
            PlSqlParameter[] params = pls.getParameters();
            if (params != null && params.length > 0) {
                spec.append("\n").append("(").append(" ");
                OracleSourceDDLGenerator.convertParam(spec, params[0]);
                int i = 1;
                while (i < params.length) {
                    spec.append("\n").append(",").append(" ");
                    OracleSourceDDLGenerator.convertParam(spec, params[i]);
                    ++i;
                }
                spec.append("\n").append(")");
            }
            if ((retTypeID = pls.getReturnTypeID()) != null) {
                spec.append(" ").append(OracleSourceDDLGenerator.kw("RETURN")).append(" ");
                spec.append(OracleSourceDDLGenerator.kw(DBUtil.getDBObjectName((DBObjectID)retTypeID)));
            }
            spec.append(" ").append(OracleSourceDDLGenerator.kw("AS")).append("\n");
            spec.append(body);
            ddl.put("SPEC", spec.toString());
        } else if (object instanceof ComplexType) {
            ComplexType objType = (ComplexType)object;
            StringBuffer spec = new StringBuffer();
            String cmd = replace ? "CREATE OR REPLACE" : "CREATE";
            this.addPrompt(spec, cmd, "TYPE SPEC", name);
            spec.append(OracleSourceDDLGenerator.kw(cmd)).append("\n");
            spec.append(OracleSourceDDLGenerator.kw(object.getType())).append(" ").append(OracleSourceDDLGenerator.kw(name)).append(" ").append(OracleSourceDDLGenerator.kw("AS")).append(" ");
            if ("OBJECT".equals(objType.getTypeCode())) {
                spec.append(OracleSourceDDLGenerator.kw("OBJECT")).append("\n").append("(").append(" ");
                spec.append(DBArb.getString((int)9));
                spec.append("\n").append(")").append(";");
            } else if ("TABLE".equals(objType.getCollectionType())) {
                spec.append(OracleSourceDDLGenerator.kw("TABLE")).append(" ").append(OracleSourceDDLGenerator.kw("OF")).append(" ");
                spec.append(DBArb.getString((int)6));
                spec.append(";");
            } else if ("VARYING ARRAY".equals(objType.getCollectionType())) {
                spec.append(OracleSourceDDLGenerator.kw("VARRAY")).append("(");
                spec.append(DBArb.getString((int)335));
                spec.append(")").append(" ").append(OracleSourceDDLGenerator.kw("OF")).append(" ");
                spec.append(DBArb.getString((int)6));
                spec.append(";");
            }
            ddl.put("SPEC", spec.toString());
        } else if (object instanceof Package) {
            StringBuffer spec = new StringBuffer();
            String cmd = replace ? "CREATE OR REPLACE" : "CREATE";
            this.addPrompt(spec, cmd, "TYPE SPEC", name);
            spec.append(OracleSourceDDLGenerator.kw(cmd)).append("\n");
            spec.append(OracleSourceDDLGenerator.kw(object.getType())).append(" ").append(OracleSourceDDLGenerator.kw(name)).append(" ").append(OracleSourceDDLGenerator.kw("AS"));
            spec.append("\n").append("\n").append("  ");
            spec.append(DBArb.getString((int)198));
            spec.append("\n").append("\n").append(OracleSourceDDLGenerator.kw("END")).append(" ").append(OracleSourceDDLGenerator.kw(name)).append(";");
            ddl.put("SPEC", spec.toString());
        }
        return ddl;
    }

    private static void convertParam(StringBuffer buf, PlSqlParameter param) {
        buf.append(OracleSourceDDLGenerator.kw(param.getName()));
        PlSqlParameter.Mode mode = param.getMode();
        if (mode != null) {
            buf.append(" ").append(OracleSourceDDLGenerator.kw(mode.toString()));
        }
        DataType type = param.getDataType();
        buf.append(" ").append(OracleSourceDDLGenerator.kw(type.getName()));
        String def = param.getDefaultValue();
        if (ModelUtil.hasLength((String)def)) {
            buf.append(" ").append(OracleSourceDDLGenerator.kw("DEFAULT")).append(" ").append(def);
        }
    }

    private Ddl createSpecAndBody(SpecPlSql object, boolean replace) {
        String name = this.getSchemaDotName((DBObject)object);
        Ddl ddl = new Ddl();
        if (object instanceof ComplexType) {
            this.createIncompleteType(replace, name, ddl);
        }
        ddl.append(this.createSourceObject((SourceObject)object, replace));
        StringBuffer body = new StringBuffer();
        String bodyCode = object.getBodySource();
        if (ModelUtil.hasLength((String)bodyCode)) {
            PlSqlInterrogator pi = object.getBodySourceInterrogator();
            PlSqlFragment pf = pi.getRoot();
            if (replace) {
                this.addPrompt(body, "CREATE OR REPLACE", "TYPE BODY", name);
                body.append("CREATE OR REPLACE").append(" ");
            } else {
                this.addPrompt(body, "CREATE", "TYPE BODY", name);
                body.append("CREATE").append(" ");
            }
            body.append(pf.getSource());
            body.append("\n").append("/").append("\n");
            ddl.put("BODY", body.toString());
        }
        return ddl;
    }

    private void createIncompleteType(boolean replace, String name, Ddl ddl) {
        StringBuffer incompleteType = new StringBuffer();
        if (replace) {
            incompleteType.append("CREATE OR REPLACE").append(" ");
        } else {
            incompleteType.append("CREATE").append(" ");
        }
        incompleteType.append("TYPE").append(" ");
        incompleteType.append(name).append(";");
        incompleteType.append("\n").append("/").append("\n");
        ddl.put("INCOMPLETE_TYPE", incompleteType.toString());
    }

    public static String defaultBodyForSpec(SpecPlSql obj, String externalName) {
        StringBuffer body = new StringBuffer();
        body.append(OracleSourceDDLGenerator.kw("CREATE OR REPLACE")).append("\n");
        body.append(OracleSourceDDLGenerator.kw(obj.getType())).append(" ").append(OracleSourceDDLGenerator.kw("BODY")).append(" ").append(OracleSourceDDLGenerator.kw(externalName)).append(" ").append(OracleSourceDDLGenerator.kw("AS"));
        obj.getSource();
        PlSqlInterrogator pi = obj.getSourceInterrogator();
        PlSqlFragment frag = pi.getRoot();
        if (frag != null && frag.getSubFragments() != null) {
            frag = (PlSqlFragment)frag.getSubFragments().get(0);
        }
        int i = 0;
        while (i < frag.getSubFragments().size()) {
            PlSqlFragment subFrag = (PlSqlFragment)frag.getSubFragments().get(i);
            if (subFrag.getFramentType() == PlSqlFragment.Type.PROCEDURE_FD || subFrag.getFramentType() == PlSqlFragment.Type.FUNCTION_FD) {
                String fd = subFrag.getSource();
                PlSqlToken tok = subFrag.getFirstToken();
                while (!tok.matches("FUNCTION") && !tok.matches("PROCEDURE")) {
                    tok = tok.getNextCodeToken();
                }
                tok = tok.getNextCodeToken();
                String methodName = tok.getSource();
                int pos = fd.length();
                if (obj.getType().equals("PACKAGE")) {
                    pos = fd.lastIndexOf(";");
                }
                body.append("\n").append("\n").append("  ");
                body.append(fd.substring(0, pos)).append(" ").append(OracleSourceDDLGenerator.kw("AS"));
                body.append("\n").append("  ").append(OracleSourceDDLGenerator.kw("BEGIN"));
                body.append("\n").append("    ").append(DBArb.getString((int)170));
                body.append("\n").append("    ");
                if (subFrag.getFramentType() == PlSqlFragment.Type.FUNCTION_FD) {
                    body.append(OracleSourceDDLGenerator.kw("RETURN")).append(" ");
                }
                body.append(OracleSourceDDLGenerator.kw("NULL")).append(";");
                body.append("\n").append("  ").append(OracleSourceDDLGenerator.kw("END")).append(" ").append(methodName).append(";");
            }
            ++i;
        }
        body.append("\n").append("\n").append(OracleSourceDDLGenerator.kw("END"));
        if (!(obj instanceof ComplexType)) {
            body.append(" ").append(OracleSourceDDLGenerator.kw(externalName));
        }
        body.append(";");
        return body.toString();
    }
}

