/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import java.util.logging.Level;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.ddlgen.OracleBaseGenerator;
import oracle.javatools.util.ModelUtil;

public class OracleSynonymDDLGenerator
extends OracleBaseGenerator {
    public OracleSynonymDDLGenerator(DBObjectProvider prov) {
        super(prov);
    }

    public Ddl getCreateDDL(SchemaObject dbobject, boolean replace, boolean cascade) {
        return this.createSynonym((Synonym)dbobject, replace);
    }

    public Ddl getDeleteDDL(SchemaObject dbObject, boolean cascade) {
        return this.dropSynonym((Synonym)dbObject);
    }

    public Ddl[] getUpdateDDL(SchemaObject dbMaster, SchemaObject dbUpdatable) {
        return new Ddl[]{this.createSynonym((Synonym)dbUpdatable, true)};
    }

    public Ddl[] getUpdateDDL(ResultSet rs) {
        return null;
    }

    private Ddl createSynonym(Synonym synonym, boolean replace) {
        String userName;
        String currentSchema = synonym.getSchema().getName();
        String name = this.getSchemaDotName((DBObject)synonym);
        StringBuffer create = new StringBuffer();
        this.addPrompt(create, "CREATE", "SYNONYM", name);
        if (this.m_prov instanceof BaseOracleDatabase && (userName = ((BaseOracleDatabase)this.m_prov).getUserName()) != null) {
            currentSchema = userName;
        }
        if (replace) {
            create.append("CREATE OR REPLACE").append(" ");
        } else {
            create.append("CREATE").append(" ");
        }
        if (synonym.isPublic()) {
            create.append("PUBLIC").append(" ");
            name = synonym.getName();
        }
        create.append("SYNONYM").append(" ");
        create.append(name);
        create.append(" ").append("FOR").append(" ");
        DBObjectID refID = synonym.getReference();
        String refSchemaName = "";
        String refObjName = "";
        try {
            SchemaObject so = (SchemaObject)refID.resolveID();
            if (refID instanceof ReferenceID) {
                refSchemaName = ((ReferenceID)refID).getSchemaName();
                refObjName = ((ReferenceID)refID).getName();
            } else if (so != null) {
                Schema refSchema = so.getSchema();
                if (refSchema != null) {
                    refSchemaName = refSchema.getName();
                }
                refObjName = so.getName();
            } else {
                DBLog.getLogger().log(Level.SEVERE, "Object based SYNONYM has null Referenced object");
            }
        }
        catch (DBException ex) {
            DBLog.getLogger().log(Level.SEVERE, "SYNONYM can resolve Referenced object", ex);
        }
        if (ModelUtil.hasLength((String)refSchemaName) && (this.m_prefixSchemaName || synonym.isPublic() || !refSchemaName.equals(currentSchema))) {
            create.append(refSchemaName).append(".");
        }
        create.append(refObjName);
        Ddl ddl = new Ddl();
        ddl.put("SYN", create.toString());
        return ddl;
    }

    private Ddl dropSynonym(Synonym synonym) {
        String name = null;
        name = synonym.isPublic() ? synonym.getName() : this.getSchemaDotName((DBObject)synonym);
        StringBuffer drop = new StringBuffer();
        this.addPrompt(drop, "DROP", "SYNONYM", name);
        drop.append("DROP").append(" ");
        if (synonym.isPublic()) {
            drop.append("PUBLIC").append(" ");
        }
        drop.append("SYNONYM").append(" ");
        drop.append(name);
        Ddl ddl = new Ddl();
        ddl.put("DROP", drop.toString());
        return ddl;
    }
}

