/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import java.util.ArrayList;
import java.util.Map;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.OpaqueFormatSpec;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.ddlgen.OracleAlterDDLIndex;
import oracle.javatools.db.ora.ddlgen.OracleIndexDDLGenerator;
import oracle.javatools.db.ora.ddlgen.OracleRelationDDLGenerator;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.util.ModelUtil;

public class OracleTableDDLGenerator
extends OracleRelationDDLGenerator {
    protected OracleIndexDDLGenerator m_indexGen;
    protected OracleAlterDDLIndex m_alterIndexGen;

    public OracleTableDDLGenerator(DBObjectProvider prov) {
        super(prov);
        this.m_indexGen = new OracleIndexDDLGenerator(prov);
        this.m_alterIndexGen = (OracleAlterDDLIndex)this.getAlterDDLGenerator("INDEX");
    }

    public Ddl getCreateDDL(SchemaObject dbobject, boolean replace, boolean cascade) {
        return this.createTable((Table)dbobject);
    }

    public Ddl[] getUpdateDDL(SchemaObject dbMaster, SchemaObject dbUpdatable) {
        return null;
    }

    public Ddl[] getUpdateDDL(ResultSet rs) {
        return null;
    }

    protected String schemaDot(FKConstraint fkConstraint) {
        Relation refRel = this.getFKReference(fkConstraint);
        Schema refSchema = refRel != null ? refRel.getSchema() : null;
        String refSchemaName = refSchema != null ? refSchema.getName() : null;
        return this.schemaDot(fkConstraint, refSchemaName);
    }

    private String schemaDot(FKConstraint fkConstraint, String refSchemaName) {
        StringBuffer cons = new StringBuffer("");
        if (ModelUtil.hasLength((String)refSchemaName)) {
            String defSchemaName;
            Schema defaultSchema = this.getDefaultSchema();
            Schema fkSchema = fkConstraint.getRelation().getSchema();
            String fkSchemaName = fkSchema != null ? fkSchema.getName() : null;
            String string = defSchemaName = defaultSchema != null ? defaultSchema.getName() : null;
            if (this.m_prefixSchemaName || !refSchemaName.equals(fkSchemaName) || ModelUtil.hasLength((String)defSchemaName) && ModelUtil.areDifferent((Object)defSchemaName, (Object)refSchemaName)) {
                cons.append(this.m_prov.getExternalName(refSchemaName)).append(".");
            }
        }
        return cons.toString();
    }

    private String createOracleTableProperties(Table table) {
        StringBuffer buf = new StringBuffer();
        Object type = table.getProperty("TableType");
        if (Table.TableType.TRANSACTION_TEMP == type) {
            buf.append("ON").append(" ").append("COMMIT").append(" ").append("DELETE").append(" ").append("ROWS").append("\n");
        } else if (Table.TableType.SESSION_TEMP == type) {
            buf.append("ON").append(" ").append("COMMIT").append(" ").append("PRESERVE").append(" ").append("ROWS").append("\n");
        } else if (Table.TableType.INDEX_ORGANIZED == type) {
            buf.append(this.createIotProperties(table));
            buf.append(this.createCompress(table));
            buf.append(this.createParallel(table));
            buf.append(this.createOracleColumnProperties(table));
        } else if (Table.TableType.EXTERNAL == type) {
            buf.append(this.createExternalTableProperties(table));
        } else {
            OracleStorageProperties osp = (OracleStorageProperties)table.getProperty("OracleStorageProperties");
            if (osp != null) {
                buf.append(this.createOracleStorageProperties(osp, "  "));
            }
            buf.append(this.createCompress(table));
            buf.append(this.createParallel(table));
            buf.append(this.createOracleColumnProperties(table));
        }
        return buf.toString();
    }

    private String createExternalTableProperties(Table table) {
        StringBuffer buf = new StringBuffer();
        OracleExternalTableProperties properties = (OracleExternalTableProperties)table.getProperty("OracleExternalTableProperties");
        if (properties != null) {
            String defaultDirName = DBUtil.getDBObjectName((DBObjectID)properties.getDefaultDirectory());
            OracleExternalTableProperties.LocationSpecifier[] locationSpecifiers = properties.getLocationSpecifiers();
            if (ModelUtil.hasLength((String)defaultDirName) && locationSpecifiers.length > 0) {
                buf.append("ORGANIZATION").append(" ").append("EXTERNAL").append("\n").append("(").append("\n");
                String accessDriverType = properties.getAccessDriverType();
                if (accessDriverType != null) {
                    buf.append("  ").append("TYPE").append(" ").append(accessDriverType).append("\n");
                }
                buf.append("  ").append("DEFAULT").append(" ").append("DIRECTORY").append(" ").append(this.m_prov.getExternalName(defaultDirName)).append("\n");
                Object accessParameters = properties.getAccessParameters();
                if (accessParameters != null) {
                    buf.append("  ").append("ACCESS PARAMETERS");
                    if (properties.isAccessUsingClob()) {
                        buf.append(" ").append("USING").append(" ").append("CLOB").append("\n").append("  ").append("(").append("\n").append("    ");
                        if (accessParameters instanceof SQLQuery) {
                            SQLQuery subquery = (SQLQuery)accessParameters;
                            buf.append(subquery.getSQLText());
                        } else {
                            buf.append(accessParameters.toString());
                        }
                    } else {
                        buf.append("\n").append("  ").append("(").append("\n").append("    ");
                        if (accessParameters instanceof OpaqueFormatSpec) {
                            OpaqueFormatSpec spec = (OpaqueFormatSpec)accessParameters;
                            buf.append(spec.getSpec());
                        } else {
                            buf.append(accessParameters.toString());
                        }
                    }
                    buf.append("\n").append("  ").append(")").append("\n");
                }
                buf.append("  ").append("LOCATION").append("\n").append("  ").append("(");
                int i = 0;
                while (i < locationSpecifiers.length) {
                    if (i > 0) {
                        buf.append(",");
                    }
                    buf.append("\n").append("    ");
                    String locSpecDirName = DBUtil.getDBObjectName((DBObjectID)locationSpecifiers[i].getDirectory());
                    if (ModelUtil.hasLength((String)locSpecDirName)) {
                        buf.append(this.m_prov.getExternalName(locSpecDirName)).append(":").append(" ");
                    }
                    String specifier = locationSpecifiers[i].getSpecifier();
                    buf.append("'").append(specifier == null ? "" : specifier).append("'");
                    ++i;
                }
                buf.append("\n").append("  ").append(")").append("\n").append(")").append("\n");
                String rejectLimit = properties.getRejectLimit();
                if (rejectLimit != null) {
                    buf.append("REJECT LIMIT").append(" ").append(rejectLimit).append("\n");
                }
            }
        } else {
            buf.append("ORGANIZATION").append(" ").append("EXTERNAL").append("(").append(")").append("\n");
        }
        return buf.toString();
    }

    private String createIotProperties(Table table) {
        OracleIndexOrganizedTableProperties iotProperties;
        StringBuffer buf = new StringBuffer();
        buf.append("ORGANIZATION").append(" ").append("INDEX").append("\n");
        OracleStorageProperties osp = (OracleStorageProperties)table.getProperty("OracleStorageProperties");
        if (osp != null) {
            buf.append(this.createOracleStorageProperties(osp, "  "));
        }
        if ((iotProperties = (OracleIndexOrganizedTableProperties)table.getProperty("OracleIndexOrganizedTableProperties")) != null) {
            Integer pctThreshold;
            Integer compress = iotProperties.getKeyCompression();
            if (compress != null) {
                buf.append("COMPRESS");
                if (compress > 0) {
                    buf.append(" ").append(compress);
                }
                buf.append("\n");
            }
            if ((pctThreshold = iotProperties.getPctThreshold()) != null) {
                buf.append("PCTTHRESHOLD").append(" ").append(pctThreshold).append("\n");
            }
            if (iotProperties.isMapped()) {
                buf.append("MAPPING").append(" ").append("TABLE").append("\n");
            }
            if (iotProperties.isOverflowable()) {
                String incColName = DBUtil.getDBObjectName((DBObjectID)iotProperties.getIncludeColumn());
                if (ModelUtil.hasLength((String)incColName)) {
                    buf.append("INCLUDING").append(" ").append(this.m_prov.getExternalName(incColName)).append("\n");
                }
                buf.append("OVERFLOW").append("\n");
                OracleStorageProperties overflow = iotProperties.getOverflowProperties();
                if (overflow != null) {
                    buf.append(" ").append(this.createOracleStorageProperties(overflow, "  "));
                }
            }
        }
        return buf.toString();
    }

    private String createCompress(Table table) {
        Boolean compress = (Boolean)table.getProperty("compression");
        if (compress != null && compress.booleanValue()) {
            return " COMPRESS\n";
        }
        return "";
    }

    private String createParallel(Table table) {
        Integer parallel = (Integer)table.getProperty("parallel");
        if (parallel != null && parallel == 0) {
            return " PARALLEL\n";
        }
        if (parallel != null && parallel != 1) {
            return " PARALLEL " + parallel.toString() + "\n";
        }
        return "";
    }

    private Ddl createTable(Table table) {
        OracleTablePartitions tablePartitions;
        Ddl relationalDDL = this.createRelationalObject((Relation)table);
        String name = this.getSchemaDotName((DBObject)table);
        StringBuffer create = new StringBuffer();
        this.addPrompt(create, "CREATE", "TABLE", name);
        create.append("CREATE");
        Object tableType = table.getProperty("TableType");
        if (Table.TableType.SESSION_TEMP == tableType || Table.TableType.TRANSACTION_TEMP == tableType) {
            create.append(" ").append("GLOBAL").append(" ").append("TEMPORARY");
        }
        create.append(" ").append("TABLE").append(" ").append(name).append("\n").append("(").append("\n").append(relationalDDL.get("TAB")).append(this.createPrimaryKey(table)).append(")").append("\n");
        String props = this.createOracleTableProperties(table);
        if (props != null) {
            create.append(props);
        }
        if (Table.TableType.EXTERNAL != tableType && Table.TableType.SESSION_TEMP != tableType && Table.TableType.TRANSACTION_TEMP != tableType && (tablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions")) != null && Boolean.TRUE.equals(table.getProperty("PARTITIONED TABLE"))) {
            create.append(this.createOracleTablePartitions(tablePartitions));
        }
        Ddl ddl = new Ddl();
        ddl.put("TAB", create.toString());
        if (Table.TableType.EXTERNAL == tableType) {
            OracleExternalTableProperties properties = (OracleExternalTableProperties)table.getProperty("OracleExternalTableProperties");
            if (properties != null && properties.getProjectColumn() == OracleExternalTableProperties.ProjectColumn.REFERENCED) {
                StringBuffer alter = new StringBuffer("ALTER").append(" ").append("TABLE").append(" ").append(table.getName()).append(" ").append("PROJECT").append(" ").append("COLUMN").append(" ").append(OracleExternalTableProperties.ProjectColumn.REFERENCED);
                ddl.put("OET", alter.toString());
            }
        } else {
            if (relationalDDL.containsKey("CONUK")) {
                ddl.put("CONUK", relationalDDL.getArray("CONUK"));
            }
            if (relationalDDL.containsKey("CONFK")) {
                ddl.put("CONFK", relationalDDL.getArray("CONFK"));
            }
            if (relationalDDL.containsKey("CONCC")) {
                ddl.put("CONCC", relationalDDL.getArray("CONCC"));
            }
            if (relationalDDL.containsKey("CMT")) {
                ddl.put("CMT", relationalDDL.get("CMT"));
            }
            if (relationalDDL.containsKey("CMC")) {
                ddl.put("CMC", relationalDDL.getArray("CMC"));
            }
            ArrayList<String> indexSql = new ArrayList<String>();
            Index[] indexes = table.getIndexes();
            int i = 0;
            while (i < indexes.length) {
                Ddl indexDDL = this.m_indexGen.getCreateDDL((SchemaObject)indexes[i], false, false);
                indexSql.add(indexDDL.get("IND"));
                ++i;
            }
            if (indexSql.size() > 0) {
                ddl.put("IND", indexSql);
            }
        }
        return ddl;
    }

    private String createPrimaryKey(Table table) {
        Constraint[] constraints = table.getConstraints();
        StringBuffer clause = new StringBuffer();
        int i = 0;
        while (i < constraints.length) {
            if (constraints[i] instanceof PKConstraint) {
                PKConstraint pk = (PKConstraint)constraints[i];
                clause.append(", ");
                this.appendConstraintName(clause, pk.getName());
                clause.append("PRIMARY KEY\n").append(this.getColumnList(pk.getColumns(), true));
                this.enableConstraint((Constraint)pk, clause, true);
            }
            ++i;
        }
        return clause.toString();
    }

    private Ddl createRelationalObject(Relation relation) {
        StringBuffer cols = new StringBuffer();
        ArrayList<String> colComments = new ArrayList<String>();
        Column[] columns = relation.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (i > 0) {
                cols.append(",").append("\n");
            }
            Ddl colDDL = this.createColumnDDL(columns[i]);
            cols.append(colDDL.get("ACO"));
            if (colDDL.containsKey("CMC")) {
                colComments.add(colDDL.get("CMC"));
            }
            ++i;
        }
        cols.append("\n");
        ArrayList<String> conukarray = new ArrayList<String>();
        Constraint[] constraints = relation.getConstraints();
        int i2 = 0;
        while (i2 < constraints.length) {
            if ("UniqueConstraint".equals(constraints[i2].getConstraintType())) {
                conukarray.add(this.createConstraint(constraints[i2]));
            }
            ++i2;
        }
        ArrayList<String> confkarray = new ArrayList<String>();
        int i3 = 0;
        while (i3 < constraints.length) {
            if (constraints[i3] instanceof FKConstraint) {
                confkarray.add(this.createConstraint(constraints[i3]));
            }
            ++i3;
        }
        ArrayList<String> conccarray = new ArrayList<String>();
        int i4 = 0;
        while (i4 < constraints.length) {
            if (constraints[i4] instanceof CheckConstraint) {
                conccarray.add(this.createConstraint(constraints[i4]));
            }
            ++i4;
        }
        Ddl ddl = new Ddl();
        ddl.put("TAB", cols.toString());
        ddl.put("CONUK", conukarray);
        ddl.put("CONFK", confkarray);
        ddl.put("CONCC", conccarray);
        Table.TableType tableType = (Table.TableType)relation.getProperty("TableType");
        if (!Table.TableType.EXTERNAL.equals((Object)tableType)) {
            String comment = this.createCommentOnRelation(relation);
            if (ModelUtil.hasLength((String)comment)) {
                ddl.put("CMT", comment);
            }
            ddl.put("CMC", colComments);
        }
        return ddl;
    }

    private String createConstraint(Constraint constraint) {
        String relationName = this.getSchemaDotName((DBObject)constraint.getRelation());
        StringBuffer cons = new StringBuffer();
        StringBuffer prolog = new StringBuffer();
        prolog.append("ALTER").append(" ").append("TABLE").append(" ");
        prolog.append(relationName);
        prolog.append("\n");
        if (constraint instanceof CheckConstraint) {
            this.addPrompt(cons, "CREATE", "CHECK CONSTRAINT", null, "ON", relationName);
            cons.append(prolog);
            cons.append(this.addCheckConstraint((CheckConstraint)constraint));
        } else if (constraint instanceof PKConstraint) {
            this.addPrompt(cons, "CREATE", "PRIMARY KEY CONSTRAINT", null, "ON", relationName);
            cons.append(prolog);
            cons.append(this.addUniqueConstraint((UniqueConstraint)constraint));
        } else if (constraint instanceof UniqueConstraint) {
            this.addPrompt(cons, "CREATE", "UNIQUE KEY CONSTRAINT", null, "ON", relationName);
            cons.append(prolog);
            cons.append(this.addUniqueConstraint((UniqueConstraint)constraint));
        } else if (constraint instanceof FKConstraint) {
            this.addPrompt(cons, "CREATE", "FOREIGN KEY CONSTRAINT", null, "ON", relationName);
            cons.append(prolog);
            cons.append(this.addFKConstraint((FKConstraint)constraint));
        }
        this.enableConstraint(constraint, cons, false);
        return cons.toString();
    }

    private void enableConstraint(Constraint constraint, StringBuffer cons, boolean indent) {
        if (indent) {
            cons.append("  ");
        } else {
            cons.append(" ");
        }
        if (constraint.isEnabled()) {
            cons.append("ENABLE");
        } else {
            cons.append("DISABLE");
        }
        cons.append("\n");
    }

    private Ddl createColumnDDL(Column column) {
        StringBuffer col = new StringBuffer("  ");
        col.append(this.m_prov.getExternalName(column.getName()));
        col.append(" ");
        DataType dt = null;
        try {
            dt = DataTypeHelper.getDataType((DataTypeUsage)column.getDataTypeUsage());
        }
        catch (DBException e) {
            // empty catch block
        }
        if (dt != null) {
            col.append(dt.getDDL(column.getDataTypeUsage()));
            if (column.getDefault() != null) {
                col.append(" ");
                col.append("DEFAULT");
                col.append(" ");
                String def = column.getDefault().toString();
                col.append(def);
            }
        }
        if (column.isNotNull()) {
            col.append(" ").append("NOT").append(" ").append("NULL");
        }
        Ddl ddl = new Ddl();
        ddl.put("ACO", col.toString());
        String colComment = this.createCommentOnColumn(column);
        if (ModelUtil.hasLength((String)colComment)) {
            ddl.put("CMC", colComment);
        }
        return ddl;
    }

    private String addCheckConstraint(CheckConstraint checkConstraint) {
        StringBuffer cons = new StringBuffer();
        cons.append("ADD").append(" ");
        this.appendConstraintName(cons, checkConstraint.getName());
        cons.append("CHECK").append("\n").append("(");
        String cond = checkConstraint.getCheckCondition();
        if (cond != null) {
            cond = cond.trim().replace('\n', ' ');
        }
        cons.append(cond);
        cons.append(")").append("\n");
        return cons.toString();
    }

    private String addUniqueConstraint(UniqueConstraint uniqueConstraint) {
        StringBuffer cons = new StringBuffer();
        cons.append("ADD").append(" ");
        this.appendConstraintName(cons, uniqueConstraint.getName());
        if (uniqueConstraint instanceof PKConstraint) {
            cons.append("PRIMARY").append(" ").append("KEY");
        } else {
            cons.append("UNIQUE");
        }
        cons.append("\n");
        cons.append(this.getColumnList(uniqueConstraint.getColumns(), false));
        return cons.toString();
    }

    protected void appendConstraintName(StringBuffer buf, String name) {
        if (ModelUtil.hasLength((String)name)) {
            boolean sysNameLen;
            boolean bl = sysNameLen = name.length() == 12 || name.length() == 11;
            if (!sysNameLen || !"SYS_C".equals(name.substring(0, 5))) {
                buf.append("CONSTRAINT").append(" ");
                buf.append(this.m_prov.getExternalName(name)).append(" ");
            }
        }
    }

    private Relation getFKReference(FKConstraint fk) {
        Relation result = null;
        try {
            DBObject obj = fk.getReferenceID().resolveID();
            if (obj instanceof UniqueConstraint) {
                result = ((UniqueConstraint)obj).getRelation();
            }
        }
        catch (DBException ex) {
            // empty catch block
        }
        return result;
    }

    private String addFKConstraint(FKConstraint fkConstraint) {
        String retval = "";
        UniqueConstraint refCon = null;
        StringBuffer cons = new StringBuffer();
        boolean okToBuild = false;
        boolean nameBased = false;
        DBObjectID refObjectID = fkConstraint.getReferenceID();
        ReferenceID parID = null;
        if (refObjectID instanceof ReferenceID) {
            nameBased = true;
            parID = (ReferenceID)refObjectID.getParent();
            okToBuild = true;
        } else {
            DBObject refObj = null;
            try {
                refObj = refObjectID.resolveID();
            }
            catch (DBException ex) {
                // empty catch block
            }
            if (refObj instanceof UniqueConstraint) {
                refCon = (UniqueConstraint)refObj;
                okToBuild = true;
            }
        }
        if (okToBuild) {
            cons.append("ADD").append(" ");
            this.appendConstraintName(cons, fkConstraint.getName());
            cons.append("FOREIGN").append(" ").append("KEY").append("\n");
            cons.append(this.getColumnList(fkConstraint.getColumns(), false));
            cons.append("REFERENCES");
            cons.append(" ");
            if (nameBased) {
                cons.append(this.schemaDot(fkConstraint, parID.getSchemaName()));
                cons.append(this.m_prov.getExternalName(parID.getName()));
            } else {
                cons.append(this.schemaDot(fkConstraint));
                cons.append(this.m_prov.getExternalName(AbstractDBObjectProvider.convertObject((DBObject)this.getFKReference(fkConstraint))));
            }
            cons.append("\n");
            cons.append("(").append("\n");
            if (nameBased) {
                String[] referencedColumns = ((ReferenceID)refObjectID).getChildObjectNames();
                int i = 0;
                while (i < referencedColumns.length) {
                    if (i != 0) {
                        cons.append(",").append("\n");
                    }
                    cons.append(this.m_prov.getExternalName(referencedColumns[i]));
                    ++i;
                }
                cons.append("\n").append(")");
            } else {
                Column[] referencedColumns = refCon.getColumns();
                int i = 0;
                while (i < referencedColumns.length) {
                    if (i != 0) {
                        cons.append(",").append("\n");
                    }
                    cons.append(this.m_prov.getExternalName(referencedColumns[i].getName()));
                    ++i;
                }
                cons.append("\n").append(")");
            }
            if (fkConstraint.getDeleteMode() == 1) {
                cons.append("\n").append("ON").append(" ").append("DELETE").append(" ").append("CASCADE");
            }
            if (fkConstraint.getDeleteMode() == 2) {
                cons.append("\n").append("ON").append(" ").append("DELETE").append(" ").append("SET").append(" ").append("NULL");
            }
        }
        return cons.toString();
    }

    private String createCommentOnColumn(Column column) {
        Relation relation = column.getRelation();
        Table.TableType tableType = (Table.TableType)relation.getProperty("TableType");
        if (!Table.TableType.EXTERNAL.equals((Object)tableType)) {
            String name = this.getSchemaDotName((DBObject)column.getRelation()) + "." + this.m_prov.getExternalName(column.getName());
            Map properties = column.getProperties();
            return this.createCommentOn("COLUMN", name, properties);
        }
        return null;
    }
}

