/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import oracle.ide.util.Assert;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.ddlgen.OracleBaseGenerator;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.util.ModelUtil;

public class OracleTriggerDDLGenerator
extends OracleBaseGenerator {
    public OracleTriggerDDLGenerator(DBObjectProvider prov) {
        super(prov);
    }

    public Ddl getCreateDDL(SchemaObject dbobject, boolean replace, boolean cascade) {
        return this.createTrigger((Trigger)dbobject, replace);
    }

    public Ddl getDeleteDDL(SchemaObject dbObject, boolean cascade) {
        return this.dropBasicObject(dbObject);
    }

    public Ddl[] getUpdateDDL(SchemaObject dbMaster, SchemaObject dbUpdatable) {
        return null;
    }

    public Ddl[] getUpdateDDL(ResultSet rs) {
        return null;
    }

    private Ddl createTrigger(Trigger trigger, boolean replace) {
        String name = this.getSchemaDotName((DBObject)trigger);
        StringBuffer create = new StringBuffer();
        Ddl ddl = new Ddl();
        if (replace) {
            this.addPrompt(create, "CREATE OR REPLACE", "TRIGGER", name);
            create.append(OracleTriggerDDLGenerator.kw("CREATE OR REPLACE")).append("\n");
        } else {
            this.addPrompt(create, "CREATE", "TRIGGER", name);
            create.append(OracleTriggerDDLGenerator.kw("CREATE")).append("\n");
        }
        String source = trigger.getSource();
        if (source == null || source.equals("")) {
            create.append(this.buildFromAttributes(trigger));
        } else {
            PlSqlInterrogator pi = trigger.getSourceInterrogator();
            PlSqlFragment pf = pi.getRoot();
            create.append(pf.getSource());
        }
        create.append("\n").append("/").append("\n");
        ddl.put("TRG", create.toString());
        if (!trigger.isEnabled()) {
            StringBuffer disable = new StringBuffer();
            disable.append("ALTER").append(" ").append("TRIGGER").append(" ").append(name).append(" ").append("DISABLE");
            ddl.put("TRG_DIS", disable.toString());
        }
        return ddl;
    }

    public StringBuffer buildFromAttributes(Trigger trigger) {
        String code;
        String name = this.getSchemaDotName((DBObject)trigger);
        StringBuffer create = new StringBuffer();
        create.append(OracleTriggerDDLGenerator.kw("TRIGGER")).append(" ").append(OracleTriggerDDLGenerator.kw(name)).append("\n");
        Trigger.Timing timing = trigger.getTiming();
        if (timing != null) {
            create.append(OracleTriggerDDLGenerator.kw(timing.toString())).append(" ");
        }
        if (Trigger.BaseType.TABLE == trigger.getBaseType() || Trigger.BaseType.VIEW == trigger.getBaseType()) {
            String[] events;
            Relation baseObject = null;
            try {
                DBObjectID id = trigger.getTableID();
                if (id != null) {
                    baseObject = (Relation)id.resolveID();
                }
            }
            catch (DBException e) {
                e.printStackTrace();
            }
            if ((events = trigger.getEvents()) != null) {
                int i = 0;
                while (i < events.length) {
                    String event;
                    if (i > 0) {
                        create.append(OracleTriggerDDLGenerator.kw("OR")).append(" ");
                    }
                    if ("INSERT".equals(event = events[i]) || "DELETE".equals(event) || "UPDATE".equals(event)) {
                        if ("INSERT".equals(event)) {
                            create.append(OracleTriggerDDLGenerator.kw("INSERT")).append(" ");
                        } else if ("DELETE".equals(event)) {
                            create.append(OracleTriggerDDLGenerator.kw("DELETE")).append(" ");
                        } else {
                            create.append(OracleTriggerDDLGenerator.kw("UPDATE")).append(" ");
                            DBObjectID[] columnIDs = trigger.getColumnIDs();
                            if ("UPDATE".equals(event) && Trigger.BaseType.TABLE == trigger.getBaseType() && columnIDs.length > 0) {
                                create.append(OracleTriggerDDLGenerator.kw("OF")).append(" ");
                                int j = 0;
                                while (j < columnIDs.length) {
                                    if (j != 0) {
                                        create.append(",");
                                    }
                                    Column col = null;
                                    try {
                                        col = (Column)columnIDs[j].resolveID();
                                    }
                                    catch (DBException e) {
                                        Assert.printStackTrace();
                                    }
                                    create.append(OracleTriggerDDLGenerator.kw(this.m_prov.getExternalName(col.getName())));
                                    ++j;
                                }
                                create.append(" ");
                            }
                        }
                    }
                    ++i;
                }
            }
            create.append(OracleTriggerDDLGenerator.kw("ON")).append(" ");
            String triggerSchemaName = this.m_prov.getExternalName(trigger.getSchema().getName());
            String baseObjectSchemaName = this.m_prov.getExternalName(baseObject.getSchema().getName());
            if (ModelUtil.areDifferent((Object)triggerSchemaName, (Object)baseObjectSchemaName)) {
                create.append(OracleTriggerDDLGenerator.kw(baseObjectSchemaName));
                create.append(".");
            }
            create.append(OracleTriggerDDLGenerator.kw(this.m_prov.getExternalName(baseObject.getName())));
            create.append("\n");
            String[] referenceNames = trigger.getReferenceNames();
            boolean needsRef = false;
            int j = 0;
            while (j < referenceNames.length) {
                if (ModelUtil.hasLength((String)referenceNames[j])) {
                    needsRef = true;
                    break;
                }
                ++j;
            }
            if (needsRef) {
                create.append(OracleTriggerDDLGenerator.kw("REFERENCING")).append(" ");
                int j2 = 0;
                while (j2 < referenceNames.length) {
                    if (ModelUtil.hasLength((String)referenceNames[j2])) {
                        create.append(OracleTriggerDDLGenerator.kw(j2 == 0 ? "OLD" : "NEW"));
                        create.append(" ").append(OracleTriggerDDLGenerator.kw("AS")).append(" ");
                        create.append(referenceNames[j2]).append(" ");
                    }
                    ++j2;
                }
                create.append("\n");
            }
            if (!trigger.isStatementLevel()) {
                create.append(OracleTriggerDDLGenerator.kw("FOR")).append(" ").append(OracleTriggerDDLGenerator.kw("EACH")).append(" ").append(OracleTriggerDDLGenerator.kw("ROW")).append(" ").append("\n");
            }
            if (Trigger.BaseType.TABLE == trigger.getBaseType() && ModelUtil.hasLength((String)trigger.getWhenClause())) {
                create.append(OracleTriggerDDLGenerator.kw("WHEN")).append(" ").append("(");
                create.append(trigger.getWhenClause());
                create.append(")").append(" ").append("\n");
            }
        } else {
            String[] events = trigger.getEvents();
            int i = 0;
            while (i < events.length) {
                if (i > 0) {
                    create.append(OracleTriggerDDLGenerator.kw("OR")).append(" ");
                }
                create.append(OracleTriggerDDLGenerator.kw(events[i])).append(" ");
                ++i;
            }
            create.append(OracleTriggerDDLGenerator.kw("ON")).append(" ");
            if (trigger.getBaseType() == Trigger.BaseType.DATABASE) {
                create.append(OracleTriggerDDLGenerator.kw("DATABASE")).append(" ");
            } else if (trigger.getTableOwner() != null && ModelUtil.hasLength((String)trigger.getTableOwner().getName())) {
                create.append(this.m_prov.getExternalName(trigger.getTableOwner().getName()));
                create.append(".").append("SCHEMA").append(" ");
            }
            create.append("\n");
        }
        if ((code = trigger.getCode()) == null || code.equals("")) {
            code = OracleTriggerDDLGenerator.kw("BEGIN\n  NULL;\nEND;\n");
            trigger.setCode(code);
        }
        create.append(code);
        return create;
    }
}

