/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.View;
import oracle.javatools.db.ora.ddlgen.OracleRelationDDLGenerator;

public class OracleViewDDLGenerator
extends OracleRelationDDLGenerator {
    public OracleViewDDLGenerator(DBObjectProvider prov) {
        super(prov);
    }

    public Ddl getCreateDDL(SchemaObject dbobject, boolean replace, boolean cascade) {
        return this.createView((View)dbobject, replace);
    }

    protected Ddl createView(View view, boolean replace) {
        String name = this.getSchemaDotName((DBObject)view);
        StringBuffer create = new StringBuffer();
        if (replace) {
            this.addPrompt(create, "CREATE OR REPLACE", "VIEW", name);
            create.append("CREATE OR REPLACE").append(" ");
        } else {
            this.addPrompt(create, "CREATE", "VIEW", name);
            create.append("CREATE").append(" ");
        }
        if (view.isForceOnCreate()) {
            create.append("FORCE").append(" ");
        }
        create.append("VIEW").append(" ");
        create.append(name);
        create.append(" ").append("AS").append(" ");
        create.append(view.getViewText());
        Ddl ddl = new Ddl();
        ddl.put("VW", create.toString());
        String comment = this.createCommentOnRelation((Relation)view);
        if (comment != null && comment.length() > 0) {
            ddl.put("CMT", comment);
        }
        return ddl;
    }
}

