/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import java.text.MessageFormat;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.XMLSchema;
import oracle.javatools.db.ora.ddlgen.OracleBaseGenerator;

public class OracleXMLSchemaDDLGenerator
extends OracleBaseGenerator {
    private static final String CREATE_XML_SCHEMA = " BEGIN \n  DBMS_XMLSCHEMA.registerSchema( \n    SCHEMAURL => ''{0}'', \n    SCHEMADOC => ''{1}'' ); \n END; ";
    private static final String DROP_XML_SCHEMA_BEGIN = "BEGIN \n  DBMS_XMLSCHEMA.deleteSchema( \n    SCHEMAURL => ''{0}'' ";
    private static final String DROP_XML_SCHEMA_CASCADE = "\n    DELETE_OPTION => dbms_xmlschema.DELETE_CASCADE ";

    public OracleXMLSchemaDDLGenerator(DBObjectProvider prov) {
        super(prov);
    }

    public Ddl getCreateDDL(SchemaObject dbobject, boolean replace, boolean cascade) {
        return this.createXMLSchema((XMLSchema)dbobject, replace);
    }

    public Ddl getDeleteDDL(SchemaObject dbObject, boolean cascade) {
        StringBuilder buff = new StringBuilder();
        buff.append(MessageFormat.format(DROP_XML_SCHEMA_BEGIN, dbObject.getName()));
        if (cascade) {
            buff.append(",").append(" ").append("\n").append(DROP_XML_SCHEMA_CASCADE);
        }
        buff.append(")").append(";").append("\n");
        buff.append("END").append(";");
        Ddl d = new Ddl();
        d.put("DROP", buff.toString());
        return d;
    }

    public Ddl[] getUpdateDDL(SchemaObject dbMaster, SchemaObject dbUpdatable) {
        return null;
    }

    public Ddl[] getUpdateDDL(ResultSet rs) {
        return null;
    }

    private Ddl createXMLSchema(XMLSchema xs, boolean replace) {
        String url = xs.getName();
        String schemaText = xs.getSchemaText().replaceAll("'", "''");
        Ddl ddl = new Ddl();
        ddl.put("XML SCHEMA", MessageFormat.format(CREATE_XML_SCHEMA, url, schemaText));
        return ddl;
    }
}

