/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.ora.sxml.DataTypeSXMLGenerator;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class ColumnSXMLGenerator
extends SXMLFragmentGenerator {
    protected void populateNode(Node parent, Document doc, Object obj) {
        block16: {
            block15: {
                if (!(obj instanceof Table)) break block15;
                Table tab = (Table)obj;
                Column[] columnArray = tab.getColumns();
                int n = 0;
                while (n < columnArray.length) {
                    Column col = columnArray[n];
                    OracleColumnProperties ocp = (OracleColumnProperties)col.getProperty("OracleColumnProperties");
                    if (ocp != null) {
                        Node colPropColPropsNode = this.findOrCreateNodeBefore(doc, parent, "RELATIONAL_TABLE/TABLE_PROPERTIES/COLUMN_PROPERTIES", "PARALLEL");
                        Node colPropColListNode = this.findOrCreateNode(doc, colPropColPropsNode, "COL_LIST");
                        Node colItem = this.createNode(doc, colPropColListNode, "COL_LIST_ITEM");
                        Node nameNode = this.findOrCreateNode(doc, colItem, "NAME");
                        nameNode.appendChild(doc.createTextNode(col.getName()));
                        try {
                            DataTypeUsage dtu = col.getDataTypeUsage();
                            DataType type = DataTypeHelper.getDataType((DataTypeUsage)dtu);
                            if (type != null) {
                                Node typeNode = this.findOrCreateNode(doc, colItem, "DATATYPE");
                                typeNode.appendChild(doc.createTextNode(DataTypeSXMLGenerator.getDataTypeElementText(type, dtu)));
                            }
                        }
                        catch (DBException dbe) {
                            dbe.printStackTrace();
                        }
                        this.getParentGenerator().populateNode(colItem, doc, ocp);
                    }
                    ++n;
                }
                break block16;
            }
            if (!(obj instanceof TablePartition)) break block16;
            TablePartition tabPart = (TablePartition)obj;
            LOBDescriptor[] lOBDescriptorArray = tabPart.getLOBDescriptors();
            int n = 0;
            while (n < lOBDescriptorArray.length) {
                LOBDescriptor ld = lOBDescriptorArray[n];
                DBObjectID[] dBObjectIDArray = ld.getColumns();
                int n2 = 0;
                while (n2 < dBObjectIDArray.length) {
                    DBObjectID colID = dBObjectIDArray[n2];
                    Column col = null;
                    try {
                        col = (Column)colID.resolveID();
                    }
                    catch (DBException e) {
                        // empty catch block
                    }
                    if (col != null) {
                        Node colPropColListNode = this.findOrCreateNodeBefore(doc, parent, "COLUMN_PROPERTIES/COL_LIST", "SUBPARTITION_LIST");
                        Node colItem = this.createNode(doc, colPropColListNode, "COL_LIST_ITEM");
                        Node nameNode = this.findOrCreateNode(doc, colItem, "NAME");
                        nameNode.appendChild(doc.createTextNode(col.getName()));
                        Node typeNode = this.findOrCreateNode(doc, colItem, "DATATYPE");
                        DataType type = null;
                        try {
                            DataTypeUsage dtu = col.getDataTypeUsage();
                            type = DataTypeHelper.getDataType((DataTypeUsage)dtu);
                            if (type != null) {
                                typeNode.appendChild(doc.createTextNode(DataTypeSXMLGenerator.getDataTypeElementText(type, dtu)));
                            }
                        }
                        catch (DBException dbe) {
                            dbe.printStackTrace();
                        }
                        Node lobNode = null;
                        if (LOBDescriptor.isVARRAYColumn((Column)col)) {
                            Node varrayNode = this.findOrCreateNodeAfter(doc, colItem, "VARRAY_PROPERTIES", "DATATYPE");
                            Node storeAsNode = this.createNode(doc, varrayNode, "STORE_AS");
                            storeAsNode.appendChild(doc.createTextNode("LOB"));
                            lobNode = this.createNode(doc, varrayNode, "LOB_PROPERTIES/STORAGE_TABLE");
                        } else {
                            lobNode = this.findOrCreateNodeAfter(doc, colItem, "LOB_PROPERTIES/STORAGE_TABLE", "DATATYPE");
                        }
                        this.getParentGenerator().populateNode(lobNode, doc, ld);
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    protected void readNode(Node parent, Object obj) {
        SXMLReader reader = (SXMLReader)this.getParentGenerator();
        if (obj instanceof Table) {
            Table tab = (Table)obj;
            Node colListNode = this.findNode(parent, "RELATIONAL_TABLE/TABLE_PROPERTIES/COLUMN_PROPERTIES/COL_LIST");
            if (colListNode != null) {
                SXMLFragmentGenerator.childXMLElementIterator it = new SXMLFragmentGenerator.childXMLElementIterator(colListNode);
                while (it.hasNext()) {
                    Node colNode = (Node)it.next();
                    String colName = this.nodeText(colNode, "NAME");
                    Column col = tab.getColumn(colName);
                    OracleColumnProperties ocp = new OracleColumnProperties();
                    col.setProperty("OracleColumnProperties", (Object)ocp);
                    reader.fillInObject(ocp, colNode, null);
                }
            }
        } else if (obj instanceof TablePartition) {
            boolean i = false;
        }
    }
}

