/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.ArrayList;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstraintSXMLGenerator
extends SXMLFragmentGenerator {
    private static final String CKS = "CHECK_CONSTRAINT_LIST";
    private static final String PKS = "PRIMARY_KEY_CONSTRAINT_LIST";
    private static final String UKS = "UNIQUE_KEY_CONSTRAINT_LIST";
    private static final String FKS = "FOREIGN_KEY_CONSTRAINT_LIST";

    @Override
    protected void populateNode(Node parent, Document doc, Object obj) {
        Node relTabNode = this.findOrCreateNode(doc, parent, "RELATIONAL_TABLE");
        Node cks = this.findOrCreateNodeAfter(doc, relTabNode, CKS, "COL_LIST");
        Node pks = this.findOrCreateNodeAfter(doc, relTabNode, PKS, CKS);
        Node uks = this.findOrCreateNodeAfter(doc, relTabNode, UKS, PKS);
        Node fks = this.findOrCreateNodeAfter(doc, relTabNode, FKS, UKS);
        Table tab = (Table)obj;
        Constraint[] cons = tab.getConstraints();
        int i = 0;
        while (i < cons.length) {
            if (cons[i] instanceof PKConstraint) {
                this.processConstraint(doc, parent, cons[i], PKS, pks);
            } else if (cons[i] instanceof FKConstraint) {
                Node conNode = this.processConstraint(doc, parent, cons[i], FKS, fks);
                FKConstraint fk = (FKConstraint)cons[i];
                int mode = fk.getDeleteMode();
                if (mode > 0) {
                    Node delNode = this.findOrCreateNode(doc, conNode, "REFERENCES/ON_DELETE");
                    String txt = mode == 1 ? "CASCADE" : (mode == 2 ? "SET_NULL" : null);
                    if (txt != null) {
                        delNode.appendChild(doc.createTextNode(txt));
                    }
                }
            } else if (cons[i] instanceof CheckConstraint) {
                this.processConstraint(doc, parent, cons[i], CKS, cks);
            } else if (cons[i] instanceof UniqueConstraint) {
                this.processConstraint(doc, parent, cons[i], UKS, uks);
            }
            ++i;
        }
        if (pks.getChildNodes().getLength() == 0) {
            relTabNode.removeChild(pks);
        }
        if (uks.getChildNodes().getLength() == 0) {
            relTabNode.removeChild(uks);
        }
        if (cks.getChildNodes().getLength() == 0) {
            relTabNode.removeChild(cks);
        }
        if (fks.getChildNodes().getLength() == 0) {
            relTabNode.removeChild(fks);
        }
    }

    private Node processConstraint(Document doc, Node parentNode, Constraint con, String listName, Node listNode) {
        Node conNode = this.createNode(doc, listNode, listName + "_ITEM");
        this.getParentGenerator().populateNode(conNode, doc, con);
        return conNode;
    }

    @Override
    protected void readNode(Node parent, Object obj) {
        SXMLReader reader = (SXMLReader)this.getParentGenerator();
        Table tab = (Table)obj;
        Object constraintsNode = null;
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        this.addConstraints(reader, this.findNode(parent, "RELATIONAL_TABLE/CHECK_CONSTRAINT_LIST"), constraints, CheckConstraint.class);
        this.addConstraints(reader, this.findNode(parent, "RELATIONAL_TABLE/PRIMARY_KEY_CONSTRAINT_LIST"), constraints, PKConstraint.class);
        this.addConstraints(reader, this.findNode(parent, "RELATIONAL_TABLE/UNIQUE_KEY_CONSTRAINT_LIST"), constraints, UniqueConstraint.class);
        this.addConstraints(reader, this.findNode(parent, "RELATIONAL_TABLE/FOREIGN_KEY_CONSTRAINT_LIST"), constraints, FKConstraint.class);
        tab.setConstraints(constraints.toArray(new Constraint[constraints.size()]));
    }

    private void addConstraints(SXMLReader reader, Node constraintsNode, ArrayList<Constraint> constraints, Class<? extends Constraint> clz) {
        if (constraintsNode != null) {
            SXMLFragmentGenerator.childXMLElementIterator nodeIter = new SXMLFragmentGenerator.childXMLElementIterator(constraintsNode);
            while (nodeIter.hasNext()) {
                Node n = (Node)nodeIter.next();
                Constraint c = null;
                try {
                    c = clz.newInstance();
                    reader.fillInObject(c, n, null);
                    constraints.add(c);
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
                if (!(c instanceof FKConstraint)) continue;
                String schemaName = this.nodeText(n, "REFERENCES/SCHEMA");
                Schema schema = new Schema(schemaName);
                String tableName = this.nodeText(n, "REFERENCES/NAME");
                ArrayList<String> colNames = new ArrayList<String>();
                Node colListNode = this.findNode(n, "REFERENCES/COL_LIST");
                if (colListNode != null) {
                    SXMLFragmentGenerator.childXMLElementIterator colListIter = new SXMLFragmentGenerator.childXMLElementIterator(colListNode);
                    while (colListIter.hasNext()) {
                        Node colNode = (Node)colListIter.next();
                        colNames.add(this.nodeText(colNode, "NAME"));
                    }
                }
                ReferenceID tabID = new ReferenceID("TABLE", schema, tableName);
                ReferenceID refID = new ReferenceID("CONSTRAINT", (DBObjectID)tabID, null, "FKConstraint", colNames.toArray(new String[colNames.size()]));
                ReferenceID oldRefID = (ReferenceID)((FKConstraint)c).getReferenceID();
                if (oldRefID != null) {
                    refID.setName(oldRefID.getName());
                }
                ((FKConstraint)c).setReferenceID((DBObjectID)refID);
                if ("SET_NULL".equals(this.nodeText(n, "REFERENCES/ON_DELETE"))) {
                    ((FKConstraint)c).setDeleteMode(2);
                    continue;
                }
                if ("CASCADE".equals(this.nodeText(n, "REFERENCES/ON_DELETE"))) {
                    ((FKConstraint)c).setDeleteMode(1);
                    continue;
                }
                ((FKConstraint)c).setDeleteMode(0);
            }
        }
    }

    ConstraintSXMLGenerator() {
    }
}

