/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.View;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.ObjectTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.datatypes.PredefinedDataTypeUsage;
import oracle.javatools.db.ora.Oracle11g;
import oracle.javatools.db.ora.OracleTypesArb;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataTypeSXMLGenerator
extends SXMLFragmentGenerator {
    private static Map<String, TypesFromXSD> s_dtMap;

    @Override
    protected void populateNode(Node parent, Document doc, Object obj) {
        if (!(((Column)obj).getRelation() instanceof View)) {
            DataTypeUsage dtu = ((Column)obj).getDataTypeUsage();
            try {
                DataType type = DataTypeHelper.getDataType((DataTypeUsage)dtu);
                if (type != null) {
                    Node typeNode = this.findOrCreateNodeAfter(doc, parent, "DATATYPE", "NAME");
                    String dataTypeElementText = DataTypeSXMLGenerator.getDataTypeElementText(type, dtu);
                    typeNode.appendChild(doc.createTextNode(dataTypeElementText));
                    if (type instanceof ComplexType) {
                        Schema s = ((ComplexType)type).getSchema();
                        String name = dataTypeElementText.equals("XMLTYPE") ? dataTypeElementText : ((ComplexType)type).getName();
                        if (s != null) {
                            Node sNode = this.findOrCreateNode(doc, parent, "TYPE_PROPERTIES/SCHEMA");
                            sNode.appendChild(doc.createTextNode(s.getName()));
                        }
                        if (ModelUtil.hasLength((String)name)) {
                            Node nameNode = this.findOrCreateNode(doc, parent, "TYPE_PROPERTIES/NAME");
                            nameNode.appendChild(doc.createTextNode(name));
                        }
                    } else {
                        Object length;
                        Object precision;
                        Object scale = dtu.getAttributeValue("scale");
                        if (scale != null) {
                            Node node = this.findOrCreateNodeAfter(doc, parent, "scale".toUpperCase(), "DATATYPE");
                            node.appendChild(doc.createTextNode(scale.toString()));
                        }
                        if ((precision = dtu.getAttributeValue("precision")) != null) {
                            Node node = this.findOrCreateNodeAfter(doc, parent, "precision".toUpperCase(), "DATATYPE");
                            node.appendChild(doc.createTextNode(precision.toString()));
                        }
                        if ((length = dtu.getAttributeValue("size")) != null) {
                            Node node = this.findOrCreateNodeAfter(doc, parent, "LENGTH", "DATATYPE");
                            node.appendChild(doc.createTextNode(length.toString()));
                        }
                    }
                }
            }
            catch (DBException dbe) {
                DBLog.logStackTrace((Throwable)dbe);
            }
        }
    }

    static final String getDataTypeElementText(DataType type, DataTypeUsage dtu) {
        String dataTypeElementText;
        if (type instanceof ComplexType) {
            String collectionType = ((ComplexType)type).getCollectionType();
            dataTypeElementText = "TABLE".equals(collectionType) ? "NESTED_TABLE" : ("VARYING ARRAY".equals(collectionType) ? "VARRAY" : ("SYS".equals(((ComplexType)type).getSchema().getName()) && "XMLTYPE".equalsIgnoreCase(((ComplexType)type).getName()) ? "XMLTYPE" : "UDT"));
        } else {
            Map<String, TypesFromXSD> typeMap = DataTypeSXMLGenerator.getDatatypeMap();
            if (typeMap.containsKey(dataTypeElementText = type.getName())) {
                dataTypeElementText = typeMap.get(dataTypeElementText).toString();
            }
            if ("TIMESTAMP".equals(dataTypeElementText)) {
                Object tz = dtu.getAttributeValue("time_zone");
                if ("TIME ZONE".equals(tz)) {
                    dataTypeElementText = TypesFromXSD.TIMESTAMP_WITH_TIMEZONE.toString();
                } else if ("LOCAL TIME ZONE".equals(tz)) {
                    dataTypeElementText = TypesFromXSD.TIMESTAMP_WITH_LOCAL_TIMEZONE.toString();
                }
            }
        }
        return dataTypeElementText;
    }

    @Override
    protected void readNode(Node parent, Object obj) {
        SXMLReader reader = (SXMLReader)this.getParentGenerator();
        Column col = (Column)obj;
        String dataTypeName = this.nodeText(parent, "DATATYPE");
        PredefinedDataTypeUsage dtu = null;
        if ("NESTED_TABLE".equals(dataTypeName) || "VARRAY".equals(dataTypeName) || "XMLTYPE".equals(dataTypeName) || "UDT".equals(dataTypeName)) {
            String schemaName = this.nodeText(parent, "TYPE_PROPERTIES/SCHEMA");
            String typeName = this.nodeText(parent, "TYPE_PROPERTIES/NAME");
            String XMLType = OracleTypesArb.getString(39);
            if (typeName.toUpperCase().equals(XMLType.toUpperCase())) {
                typeName = XMLType;
            }
            if ("XMLTYPE".equals(dataTypeName) && schemaName == null) {
                schemaName = "SYS";
            }
            Schema schema = new Schema(schemaName);
            ComplexType ot = new ComplexType(typeName, schema);
            NameBasedID id = new NameBasedID();
            id.setName(typeName);
            id.setSchema(schema);
            id.setType("TYPE");
            ot.setID((DBObjectID)id);
            if ("NESTED_TABLE".equals(dataTypeName)) {
                ot.setTypeCode("COLLECTION");
                ot.setCollectionType("TABLE");
            } else if ("VARRAY".equals(dataTypeName)) {
                ot.setTypeCode("COLLECTION");
                ot.setCollectionType("VARYING ARRAY");
            } else {
                ot.setTypeCode("OBJECT");
                ot.setCollectionType(null);
            }
            dtu = new ObjectTypeUsage(ot);
        } else if (dataTypeName != null) {
            DataTypeRegistry dtr = DataTypeRegistry.getInstance();
            DataType dataType = dtr.findDataType(dataTypeName, Oracle11g.class);
            if (dataType == null) {
                TypesFromXSD t = TypesFromXSD.valueOf(dataTypeName);
                for (String dt : s_dtMap.keySet()) {
                    if (!s_dtMap.get(dt).equals((Object)t)) continue;
                    dataTypeName = dt;
                    dataType = dtr.findDataType(dataTypeName, Oracle11g.class);
                    break;
                }
            }
            if (dataType != null) {
                String scale;
                String precision;
                dtu = new PredefinedDataTypeUsage((PredefinedDataType)dataType);
                HashMap<String, Integer> dtAttrs = new HashMap<String, Integer>();
                String length = this.nodeText(parent, "LENGTH");
                if (length != null) {
                    dtAttrs.put("size", Integer.valueOf(length));
                }
                if ((precision = this.nodeText(parent, "PRECISION")) != null) {
                    dtAttrs.put("precision", Integer.valueOf(precision));
                }
                if ((scale = this.nodeText(parent, "SCALE")) != null) {
                    dtAttrs.put("scale", Integer.valueOf(scale));
                }
                dtu.setAttributeValues(dtAttrs);
            }
        }
        col.setDataTypeUsage(dtu);
    }

    private static final synchronized Map<String, TypesFromXSD> getDatatypeMap() {
        if (s_dtMap == null) {
            s_dtMap = new HashMap<String, TypesFromXSD>();
            s_dtMap.put("CHAR VARYING", TypesFromXSD.VARCHAR2);
            s_dtMap.put("CHARACTER", TypesFromXSD.CHAR);
            s_dtMap.put("CHARACTER VARYING", TypesFromXSD.VARCHAR2);
            s_dtMap.put("DEC", TypesFromXSD.NUMBER);
            s_dtMap.put("DECIMAL", TypesFromXSD.NUMBER);
            s_dtMap.put("DOUBLE PRECISION", TypesFromXSD.NUMBER);
            s_dtMap.put("INT", TypesFromXSD.NUMBER);
            s_dtMap.put("INTEGER", TypesFromXSD.NUMBER);
            s_dtMap.put("INTERVAL YEAR", TypesFromXSD.INTERVAL_YEAR_TO_MONTH);
            s_dtMap.put("INTERVAL DAY", TypesFromXSD.INTERVAL_DAY_TO_SECOND);
            s_dtMap.put("LONG RAW", TypesFromXSD.LONG_RAW);
            s_dtMap.put("LONG VARCHAR", TypesFromXSD.CLOB);
            s_dtMap.put("NATIONAL CHAR", TypesFromXSD.NCHAR);
            s_dtMap.put("NATIONAL CHARACTER", TypesFromXSD.NCHAR);
            s_dtMap.put("NATIONAL CHAR VARYING", TypesFromXSD.NCHAR);
            s_dtMap.put("NATIONAL CHARACTER VARYING", TypesFromXSD.NCHAR);
            s_dtMap.put("NCHAR VARYING", TypesFromXSD.NCHAR);
            s_dtMap.put("NUMERIC", TypesFromXSD.NUMBER);
            s_dtMap.put("REAL", TypesFromXSD.NUMBER);
            s_dtMap.put("SMALLINT", TypesFromXSD.NUMBER);
            s_dtMap.put("VARCHAR", TypesFromXSD.VARCHAR2);
        }
        return s_dtMap;
    }

    DataTypeSXMLGenerator() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TypesFromXSD
    extends Enum<TypesFromXSD> {
        private static final /* synthetic */ TypesFromXSD[] $v;
        public static final /* enum */ TypesFromXSD CHAR;
        public static final /* enum */ TypesFromXSD VARCHAR2;
        public static final /* enum */ TypesFromXSD NCHAR;
        public static final /* enum */ TypesFromXSD NVARCHAR2;
        public static final /* enum */ TypesFromXSD NUMBER;
        public static final /* enum */ TypesFromXSD FLOAT;
        public static final /* enum */ TypesFromXSD BINARY_FLOAT;
        public static final /* enum */ TypesFromXSD BINARY_DOUBLE;
        public static final /* enum */ TypesFromXSD LONG;
        public static final /* enum */ TypesFromXSD LONG_RAW;
        public static final /* enum */ TypesFromXSD RAW;
        public static final /* enum */ TypesFromXSD DATE;
        public static final /* enum */ TypesFromXSD TIMESTAMP;
        public static final /* enum */ TypesFromXSD TIMESTAMP_WITH_TIMEZONE;
        public static final /* enum */ TypesFromXSD TIMESTAMP_WITH_LOCAL_TIMEZONE;
        public static final /* enum */ TypesFromXSD INTERVAL_YEAR_TO_MONTH;
        public static final /* enum */ TypesFromXSD INTERVAL_DAY_TO_SECOND;
        public static final /* enum */ TypesFromXSD TIME;
        public static final /* enum */ TypesFromXSD TIME_WITH_TIMEZONE;
        public static final /* enum */ TypesFromXSD BLOB;
        public static final /* enum */ TypesFromXSD CLOB;
        public static final /* enum */ TypesFromXSD NCLOB;
        public static final /* enum */ TypesFromXSD BFILE;
        public static final /* enum */ TypesFromXSD ROWID;
        public static final /* enum */ TypesFromXSD UROWID;
        public static final /* enum */ TypesFromXSD MLSLABEL;
        public static final /* enum */ TypesFromXSD UDT;
        public static final /* enum */ TypesFromXSD NESTED_TABLE;
        public static final /* enum */ TypesFromXSD VARRAY;
        public static final /* enum */ TypesFromXSD OPAQUE;
        public static final /* enum */ TypesFromXSD REF;
        public static final /* enum */ TypesFromXSD XMLTYPE;

        public static TypesFromXSD valueOf(String string) {
            return Enum.valueOf(TypesFromXSD.class, string);
        }

        public static final TypesFromXSD[] values() {
            return (TypesFromXSD[])$v.clone();
        }

        static {
            TypesFromXSD[] typesFromXSDArray = new TypesFromXSD[32];
            typesFromXSDArray[31] = XMLTYPE = new TypesFromXSD("XMLTYPE", 31);
            typesFromXSDArray[30] = REF = new TypesFromXSD("REF", 30);
            typesFromXSDArray[29] = OPAQUE = new TypesFromXSD("OPAQUE", 29);
            typesFromXSDArray[28] = VARRAY = new TypesFromXSD("VARRAY", 28);
            typesFromXSDArray[27] = NESTED_TABLE = new TypesFromXSD("NESTED_TABLE", 27);
            typesFromXSDArray[26] = UDT = new TypesFromXSD("UDT", 26);
            typesFromXSDArray[25] = MLSLABEL = new TypesFromXSD("MLSLABEL", 25);
            typesFromXSDArray[24] = UROWID = new TypesFromXSD("UROWID", 24);
            typesFromXSDArray[23] = ROWID = new TypesFromXSD("ROWID", 23);
            typesFromXSDArray[22] = BFILE = new TypesFromXSD("BFILE", 22);
            typesFromXSDArray[21] = NCLOB = new TypesFromXSD("NCLOB", 21);
            typesFromXSDArray[20] = CLOB = new TypesFromXSD("CLOB", 20);
            typesFromXSDArray[19] = BLOB = new TypesFromXSD("BLOB", 19);
            typesFromXSDArray[18] = TIME_WITH_TIMEZONE = new TypesFromXSD("TIME_WITH_TIMEZONE", 18);
            typesFromXSDArray[17] = TIME = new TypesFromXSD("TIME", 17);
            typesFromXSDArray[16] = INTERVAL_DAY_TO_SECOND = new TypesFromXSD("INTERVAL_DAY_TO_SECOND", 16);
            typesFromXSDArray[15] = INTERVAL_YEAR_TO_MONTH = new TypesFromXSD("INTERVAL_YEAR_TO_MONTH", 15);
            typesFromXSDArray[14] = TIMESTAMP_WITH_LOCAL_TIMEZONE = new TypesFromXSD("TIMESTAMP_WITH_LOCAL_TIMEZONE", 14);
            typesFromXSDArray[13] = TIMESTAMP_WITH_TIMEZONE = new TypesFromXSD("TIMESTAMP_WITH_TIMEZONE", 13);
            typesFromXSDArray[12] = TIMESTAMP = new TypesFromXSD("TIMESTAMP", 12);
            typesFromXSDArray[11] = DATE = new TypesFromXSD("DATE", 11);
            typesFromXSDArray[10] = RAW = new TypesFromXSD("RAW", 10);
            typesFromXSDArray[9] = LONG_RAW = new TypesFromXSD("LONG_RAW", 9);
            typesFromXSDArray[8] = LONG = new TypesFromXSD("LONG", 8);
            typesFromXSDArray[7] = BINARY_DOUBLE = new TypesFromXSD("BINARY_DOUBLE", 7);
            typesFromXSDArray[6] = BINARY_FLOAT = new TypesFromXSD("BINARY_FLOAT", 6);
            typesFromXSDArray[5] = FLOAT = new TypesFromXSD("FLOAT", 5);
            typesFromXSDArray[4] = NUMBER = new TypesFromXSD("NUMBER", 4);
            typesFromXSDArray[3] = NVARCHAR2 = new TypesFromXSD("NVARCHAR2", 3);
            typesFromXSDArray[2] = NCHAR = new TypesFromXSD("NCHAR", 2);
            typesFromXSDArray[1] = VARCHAR2 = new TypesFromXSD("VARCHAR2", 1);
            typesFromXSDArray[0] = CHAR = new TypesFromXSD("CHAR", 0);
            $v = typesFromXSDArray;
        }

        private TypesFromXSD(String string2, int n2) {
        }
    }
}

