/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class IndexObjectSXMLGenerator
extends SXMLFragmentGenerator {
    protected void populateNode(Node parent, Document doc, Object obj) {
        if (obj instanceof IndexObject) {
            IndexObject io = (IndexObject)obj;
            SQLFragment expr = io.getExpression();
            if (!(expr instanceof ColumnUsage)) {
                expr = (SQLFragment)expr.copyTo(null);
                this.markColumnUsages(expr);
            }
            Node nameNode = this.findOrCreateNode(doc, parent, "NAME");
            nameNode.appendChild(doc.createTextNode(expr.getSQLText()));
            if ("DESC".equals(io.getOrder())) {
                this.findOrCreateNodeAfter(doc, parent, "DESC", "NAME");
            }
        }
    }

    private void markColumnUsages(SQLFragment expr) {
        if (expr instanceof ColumnUsage) {
            ((ColumnUsage)expr).setAlwaysQuote(true);
        }
        DBObject[] dBObjectArray = expr.getOwnedObjects();
        int n = 0;
        while (n < dBObjectArray.length) {
            DBObject kid = dBObjectArray[n];
            if (kid instanceof SQLFragment) {
                this.markColumnUsages((SQLFragment)kid);
            }
            ++n;
        }
    }

    protected void readNode(Node parent, Object obj) {
        SXMLReader reader = (SXMLReader)this.getParentGenerator();
        if (obj instanceof IndexObject) {
            IndexObject io = (IndexObject)obj;
            String expression = this.nodeText(parent, "NAME");
            SQLFragment frag = reader.createExpression(expression);
            io.setExpression(frag);
            if (this.nodeExists(parent, "DESC")) {
                io.setOrder("DESC");
            }
        }
    }
}

