/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.ArrayList;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class IndexPartitionSXMLGenerator
extends SXMLFragmentGenerator {
    NameBasedID m_tableID;

    private void $init$() {
        this.m_tableID = null;
    }

    protected void populateNode(Node parent, Document doc, Object obj) {
        OracleIndexPartitions oip;
        DBObject dbobj = (DBObject)obj;
        if (dbobj instanceof IndexPartition) {
            OracleIndexPartitions oip2 = ((IndexPartition)dbobj).getSubpartitions();
            if (oip2 != null) {
                this.createHashOrSubpartitionList(oip2, doc, parent, "SUBPARTITION_LIST", "TABLESPACE");
            }
        } else if (dbobj instanceof Index && (oip = (OracleIndexPartitions)dbobj.getProperty("OracleIndexPartitions")) != null) {
            OracleIndexPartitions.PartitionType partitionType = oip.getPartitionType();
            String nodeLoc = partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH ? "TABLE_INDEX/GLOBAL_PARTITIONING/HASH_PARTITIONING" : (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE ? "TABLE_INDEX/GLOBAL_PARTITIONING/RANGE_PARTITIONING" : "TABLE_INDEX/LOCAL_PARTITIONING");
            Node partitioningNode = this.findOrCreateNode(doc, parent, nodeLoc);
            if (nodeLoc.equals("TABLE_INDEX/LOCAL_PARTITIONING")) {
                if (partitionType == OracleIndexPartitions.PartitionType.LOCAL_HASH) {
                    this.createHashOrSubpartitionList(oip, doc, partitioningNode, "PARTITION_LIST", "TABLESPACE");
                } else {
                    this.getParentGenerator().populateNode(partitioningNode, doc, oip);
                }
            } else {
                this.processPropertyMapping(partitioningNode, doc, oip, "COL_LIST//COL_LIST_ITEM/NAME", "globalPartitionColumns");
                if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH) {
                    Integer quantity = oip.getGlobalHashQuantity();
                    if (quantity != null && quantity > 0) {
                        Node qNode = this.findOrCreateNode(doc, partitioningNode, "PARTITIONS_BY_QUANTITY/QUANTITY");
                        qNode.appendChild(doc.createTextNode(quantity.toString()));
                        String[] tbls = oip.getTablespaces();
                        if (tbls != null && tbls.length > 0) {
                            Node tNode = this.findOrCreateNode(doc, partitioningNode, "PARTITIONS_BY_QUANTITY/TABLESPACE_LIST");
                            int i = 0;
                            while (i < tbls.length) {
                                Node tblsNode = this.createNode(doc, tNode, "TABLESPACE");
                                tblsNode.appendChild(doc.createTextNode(tbls[i]));
                                ++i;
                            }
                        }
                    } else {
                        this.createHashOrSubpartitionList(oip, doc, partitioningNode, "PARTITION_LIST", "TABLESPACE");
                    }
                } else {
                    this.getParentGenerator().populateNode(partitioningNode, doc, oip);
                }
            }
        }
    }

    private void createHashOrSubpartitionList(OracleIndexPartitions oip, Document doc, Node parent, String nodePath, String elemPath) {
        Node list = this.findOrCreateNode(doc, parent, nodePath);
        IndexPartition[] subparts = oip.getPartitions();
        int i = 0;
        while (i < subparts.length) {
            Node node = this.createNode(doc, list, nodePath + "_ITEM");
            this.processPropertyMapping(node, doc, subparts[i], "NAME", "name");
            this.processPropertyMapping(node, doc, subparts[i], elemPath, "segmentAttributes/tablespace");
            ++i;
        }
    }

    protected void readNode(Node parent, Object obj) {
        SXMLReader reader = (SXMLReader)this.getParentGenerator();
        if (obj instanceof IndexPartition) {
            if (this.nodeExists(parent, "SUBPARTITION_LIST")) {
                OracleIndexPartitions oip = new OracleIndexPartitions();
                oip.setPartitionType(OracleIndexPartitions.PartitionType.SUBPARTITION);
                this.readHashOrSubpartitionList(oip, this.findNode(parent, "SUBPARTITION_LIST"), "TABLESPACE");
                ((IndexPartition)obj).setSubpartitions(oip);
            }
        } else if (obj instanceof Index) {
            Index index = (Index)obj;
            OracleIndexPartitions.PartitionType partType = null;
            Node colListNode = null;
            Node partListNode = null;
            if (this.nodeExists(parent, "TABLE_INDEX/GLOBAL_PARTITIONING/HASH_PARTITIONING")) {
                partType = OracleIndexPartitions.PartitionType.GLOBAL_HASH;
                colListNode = this.findNode(parent, "TABLE_INDEX/GLOBAL_PARTITIONING/HASH_PARTITIONING/COL_LIST");
                partListNode = this.findNode(parent, "TABLE_INDEX/GLOBAL_PARTITIONING/HASH_PARTITIONING/PARTITION_LIST");
            } else if (this.nodeExists(parent, "TABLE_INDEX/GLOBAL_PARTITIONING/RANGE_PARTITIONING")) {
                partType = OracleIndexPartitions.PartitionType.GLOBAL_RANGE;
                colListNode = this.findNode(parent, "TABLE_INDEX/GLOBAL_PARTITIONING/RANGE_PARTITIONING/COL_LIST");
                partListNode = this.findNode(parent, "TABLE_INDEX/GLOBAL_PARTITIONING/RANGE_PARTITIONING/PARTITION_LIST");
            } else if (this.nodeExists(parent, "TABLE_INDEX/LOCAL_PARTITIONING")) {
                OracleTablePartitions otp = reader.getTablePartitionModel();
                if (otp != null) {
                    if (otp.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
                        partType = OracleIndexPartitions.PartitionType.LOCAL_HASH;
                    } else if (otp.getSubpartitionModel() != null) {
                        partType = OracleIndexPartitions.PartitionType.LOCAL_COMP;
                    }
                }
                if (partType == null) {
                    partType = OracleIndexPartitions.PartitionType.LOCAL_OTHER;
                }
                partListNode = this.findNode(parent, "TABLE_INDEX/LOCAL_PARTITIONING/PARTITION_LIST");
            }
            if (partType != null) {
                OracleIndexPartitions oip = new OracleIndexPartitions();
                index.setProperty("OracleIndexPartitions", (Object)oip);
                oip.setPartitionType(partType);
                if (partType == OracleIndexPartitions.PartitionType.LOCAL_COMP || partType == OracleIndexPartitions.PartitionType.LOCAL_OTHER) {
                    reader.fillInObject(oip, this.findNode(parent, "TABLE_INDEX/LOCAL_PARTITIONING"), null);
                } else if (partType == OracleIndexPartitions.PartitionType.LOCAL_HASH) {
                    this.readHashOrSubpartitionList(oip, partListNode, "TABLESPACE");
                } else {
                    if (colListNode != null) {
                        SXMLFragmentGenerator.childXMLElementIterator colIter = new SXMLFragmentGenerator.childXMLElementIterator(colListNode);
                        ArrayList<NameBasedID> colIDArr = new ArrayList<NameBasedID>();
                        while (colIter.hasNext()) {
                            Node n = colIter.next();
                            colIDArr.add(this.getColID(parent, this.nodeText(n, "NAME")));
                        }
                        oip.setGlobalPartitionColumns(colIDArr.toArray(new DBObjectID[colIDArr.size()]));
                    }
                    if (partType == OracleIndexPartitions.PartitionType.GLOBAL_HASH) {
                        String qntyStr = this.nodeText(parent, "TABLE_INDEX/GLOBAL_PARTITIONING/HASH_PARTITIONING/PARTITIONS_BY_QUANTITY/QUANTITY");
                        if (qntyStr != null) {
                            oip.setGlobalHashQuantity(Integer.valueOf(qntyStr));
                            Node tbspListNode = this.findNode(parent, "TABLE_INDEX/GLOBAL_PARTITIONING/HASH_PARTITIONING/PARTITIONS_BY_QUANTITY/TABLESPACE_LIST");
                            if (tbspListNode != null) {
                                ArrayList<String> tbpsList = new ArrayList<String>();
                                SXMLFragmentGenerator.childXMLElementIterator tbspIter = new SXMLFragmentGenerator.childXMLElementIterator(tbspListNode);
                                while (tbspIter.hasNext()) {
                                    Node n = tbspIter.next();
                                    if (!"TABLESPACE".equals(n.getLocalName())) continue;
                                    tbpsList.add(n.getTextContent());
                                }
                                oip.setTablespaces(tbpsList.toArray(new String[tbpsList.size()]));
                            }
                        } else {
                            this.readHashOrSubpartitionList(oip, partListNode, "TABLESPACE");
                        }
                    } else if (partType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
                        reader.fillInObject(oip, this.findNode(parent, "TABLE_INDEX/GLOBAL_PARTITIONING/RANGE_PARTITIONING"), null);
                    }
                }
            }
        }
    }

    private void readHashOrSubpartitionList(OracleIndexPartitions oip, Node partListNode, String elemPath) {
        SXMLFragmentGenerator.childXMLElementIterator partIter = new SXMLFragmentGenerator.childXMLElementIterator(partListNode);
        ArrayList<IndexPartition> partArr = new ArrayList<IndexPartition>();
        while (partIter.hasNext()) {
            Node n = partIter.next();
            IndexPartition ip = new IndexPartition(this.nodeText(n, "NAME"), oip);
            String tablespace = this.nodeText(n, elemPath);
            if (tablespace != null) {
                OracleStorageProperties osp = new OracleStorageProperties();
                osp.setTablespace(tablespace);
                ip.setSegmentAttributes(osp);
            }
            partArr.add(ip);
        }
        oip.setPartitions(partArr.toArray(new IndexPartition[partArr.size()]));
    }

    private NameBasedID getColID(Node node, String value) {
        if (this.m_tableID == null) {
            Node rootNode = node;
            while (!"INDEX".equals(node.getLocalName())) {
                rootNode = rootNode.getParentNode();
            }
            String schemaName = this.nodeText(rootNode, "TABLE_INDEX/ON_TABLE/SCHEMA");
            String tableName = this.nodeText(rootNode, "TABLE_INDEX/ON_TABLE/NAME");
            this.m_tableID = new NameBasedID("TABLE", schemaName, tableName);
        }
        return new NameBasedID("COLUMN", value, (DBObjectID)this.m_tableID);
    }

    IndexPartitionSXMLGenerator() {
        this.$init$();
    }
}

