/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class PhysicalPropsSXMLGenerator
extends SXMLFragmentGenerator {
    protected void populateNode(Node parent, Document doc, Object obj) {
        Table tab = (Table)obj;
        Table.TableType type = (Table.TableType)tab.getProperty("TableType");
        switch (1.$sm$oracle$javatools$db$Table$TableType[type.ordinal()]) {
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                OracleIndexOrganizedTableProperties iotProps;
                Node iotNode = this.findOrCreateNode(doc, parent, "RELATIONAL_TABLE/PHYSICAL_PROPERTIES/INDEX_ORGANIZED_TABLE");
                OracleStorageProperties sProps = (OracleStorageProperties)tab.getProperty("OracleStorageProperties");
                if (sProps != null) {
                    Node storageNode = this.findOrCreateNode(doc, iotNode, "SEGMENT_ATTRIBUTES");
                    this.getParentGenerator().populateNode(storageNode, doc, sProps);
                }
                if ((iotProps = (OracleIndexOrganizedTableProperties)tab.getProperty("OracleIndexOrganizedTableProperties")) == null) break;
                this.getParentGenerator().populateNode(iotNode, doc, iotProps);
                if (!iotProps.isOverflowable()) break;
                Node iotOverflowNode = this.findOrCreateNodeAfter(doc, iotNode, "OVERFLOW", "COMPRESS");
                break;
            }
            case 4: {
                Node extNode = this.findOrCreateNode(doc, parent, "RELATIONAL_TABLE/PHYSICAL_PROPERTIES/EXTERNAL_TABLE");
                OracleExternalTableProperties extProps = (OracleExternalTableProperties)tab.getProperty("OracleExternalTableProperties");
                if (extProps == null) break;
                this.getParentGenerator().populateNode(extNode, doc, extProps);
                break;
            }
            default: {
                Boolean compress;
                OracleStorageProperties props = (OracleStorageProperties)tab.getProperty("OracleStorageProperties");
                if (props != null) {
                    Node physicalPropsNode = this.findOrCreateNodeBefore(doc, parent, "RELATIONAL_TABLE/PHYSICAL_PROPERTIES", "TABLE_PROPERTIES");
                    Node storageNode = this.findOrCreateNode(doc, physicalPropsNode, "HEAP_TABLE/SEGMENT_ATTRIBUTES");
                    this.getParentGenerator().populateNode(storageNode, doc, props);
                }
                if ((compress = (Boolean)tab.getProperty("compression")) == null || !compress.booleanValue()) break;
                Node physicalPropsNode = this.findOrCreateNodeBefore(doc, parent, "RELATIONAL_TABLE/PHYSICAL_PROPERTIES", "TABLE_PROPERTIES");
                Node compressNode = this.findOrCreateNode(doc, physicalPropsNode, "HEAP_TABLE/COMPRESS");
                compressNode.appendChild(doc.createTextNode("Y"));
                break;
            }
        }
    }

    protected void readNode(Node parent, Object obj) {
        String compress;
        SXMLReader reader = (SXMLReader)this.getParentGenerator();
        Table tab = (Table)obj;
        Node tempNode = this.findNode(parent, "GLOBAL_TEMPORARY");
        if (tempNode != null) {
            String onCommit = this.nodeText(parent, "RELATIONAL_TABLE/ON_COMMIT");
            if ("PRESERVE".equals(onCommit)) {
                tab.setProperty("TableType", (Object)Table.TableType.SESSION_TEMP);
            } else {
                tab.setProperty("TableType", (Object)Table.TableType.TRANSACTION_TEMP);
            }
            return;
        }
        Node iotNode = this.findNode(parent, "RELATIONAL_TABLE/PHYSICAL_PROPERTIES/INDEX_ORGANIZED_TABLE");
        if (iotNode != null) {
            Node iotSegNode;
            tab.setProperty("TableType", (Object)Table.TableType.INDEX_ORGANIZED);
            OracleIndexOrganizedTableProperties iotProps = (OracleIndexOrganizedTableProperties)tab.getProperty("OracleIndexOrganizedTableProperties");
            if (iotProps == null) {
                iotProps = new OracleIndexOrganizedTableProperties();
                tab.setProperty("OracleIndexOrganizedTableProperties", (Object)iotProps);
            }
            reader.fillInObject(iotProps, iotNode, null);
            if (this.nodeExists(iotNode, "OVERFLOW")) {
                iotProps.setOverflowable(true);
            }
            if ((iotSegNode = this.findNode(iotNode, "SEGMENT_ATTRIBUTES")) != null) {
                OracleStorageProperties osp = (OracleStorageProperties)tab.getProperty("OracleStorageProperties");
                if (osp == null) {
                    osp = new OracleStorageProperties();
                    tab.setProperty("OracleStorageProperties", (Object)osp);
                }
                reader.fillInObject(osp, iotSegNode, null);
            }
            return;
        }
        Node externalNode = this.findNode(parent, "RELATIONAL_TABLE/PHYSICAL_PROPERTIES/EXTERNAL_TABLE");
        if (externalNode != null) {
            tab.setProperty("TableType", (Object)Table.TableType.EXTERNAL);
            OracleExternalTableProperties extProps = (OracleExternalTableProperties)tab.getProperty("OracleExternalTableProperties");
            if (extProps == null) {
                extProps = new OracleExternalTableProperties();
                tab.setProperty("OracleExternalTableProperties", (Object)extProps);
            }
            reader.fillInObject(extProps, externalNode, null);
            return;
        }
        Node segAttrNode = this.findNode(parent, "RELATIONAL_TABLE/PHYSICAL_PROPERTIES/HEAP_TABLE/SEGMENT_ATTRIBUTES");
        if (segAttrNode != null) {
            OracleStorageProperties osp = (OracleStorageProperties)tab.getProperty("OracleStorageProperties");
            if (osp == null) {
                osp = new OracleStorageProperties();
                tab.setProperty("OracleStorageProperties", (Object)osp);
            }
            reader.fillInObject(osp, segAttrNode, null);
        }
        if ("Y".equals(compress = this.nodeText(parent, "RELATIONAL_TABLE/PHYSICAL_PROPERTIES/HEAP_TABLE/COMPRESS"))) {
            tab.setProperty("compression", (Object)true);
        }
    }

    PhysicalPropsSXMLGenerator() {
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$javatools$db$Table$TableType;

        static {
            int[] nArray = new int[Table.TableType.values().length];
            $sm$oracle$javatools$db$Table$TableType = nArray;
            try {
                nArray[Table.TableType.TRANSACTION_TEMP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$Table$TableType[Table.TableType.SESSION_TEMP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$Table$TableType[Table.TableType.INDEX_ORGANIZED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$Table$TableType[Table.TableType.EXTERNAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$Table$TableType[Table.TableType.NORMAL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

