/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.Iterator;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLMappings;
import oracle.javatools.db.ora.sxml.SXMLValueConverter;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SXMLGenerator
extends SXMLFragmentGenerator {
    private static final String SXML_VERSION_1 = "1.0";
    protected static final String SXML_VERSION_CURRENT = "1.0";
    private DBObject m_obj;

    public SXMLGenerator() {
        this(new SXMLMappings());
    }

    SXMLGenerator(SXMLMappings mappings) {
        super.setMappings(mappings);
    }

    public boolean canGenerate(DBObject obj) {
        return this.getMappings().hasMappings(obj.getType()) || this.getMappings().getGenerators(obj.getType()) != null;
    }

    public void addMapping(String type, String elementPath, String propertyPath, SXMLValueConverter con) {
        this.getMappings().cache(type, elementPath, propertyPath, con);
    }

    public void removeMapping(String type, String elementPath, String propertyPath) {
        this.getMappings().uncache(type, elementPath, propertyPath);
    }

    public void addGenerator(String type, Class<? extends SXMLFragmentGenerator> gen) {
        this.getMappings().registerGen(type, gen);
    }

    public Document generateSXML(DBObject obj) {
        XMLDocument doc = new XMLDocument();
        this.m_obj = obj;
        String type = this.getType(obj);
        XMLSchema schema = this.getMappings().getXSD(type);
        if (schema != null) {
            doc.setSchema(schema);
        }
        doc.setEncoding("UTF-8");
        this.populateDoc(doc, obj, type);
        return doc;
    }

    protected void populateDoc(XMLDocument doc, DBObject obj, String type) {
        Element node = doc.createElementNS("http://xmlns.oracle.com/ku", this.getMappings().getNodeName(type));
        node.setAttribute("version", "1.0");
        this.populateNode(node, (Document)doc, obj);
        doc.appendChild((Node)node);
    }

    @Override
    protected void populateNode(Node objNode, Document doc, Object obj) {
        this.populateNodeImpl(objNode, doc, obj);
        Iterator<Class<? extends SXMLFragmentGenerator>> gens = this.getMappings().getGenerators(this.getType(obj));
        if (gens != null) {
            while (gens.hasNext()) {
                try {
                    SXMLFragmentGenerator gen = gens.next().newInstance();
                    gen.setParentGenerator(this);
                    gen.populateNode(objNode, doc, obj);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void populateNodeImpl(Node objNode, Document doc, Object obj) {
        String type = this.getType(obj);
        Iterator<SXMLMappings.Mapping> maps = this.getMappings().getMappings(type);
        while (maps.hasNext()) {
            SXMLMappings.Mapping map = maps.next();
            this.processPropertyMapping(objNode, doc, obj, map);
        }
    }

    String getTopLevelObjectSchemaName() {
        String retval = null;
        if (this.m_obj instanceof SchemaObject && ((SchemaObject)this.m_obj).getSchema() != null) {
            retval = ((SchemaObject)this.m_obj).getSchema().getName();
        }
        return retval;
    }

    @Override
    protected void readNode(Node parent, Object obj) {
    }
}

