/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.Table;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.View;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLMappings;
import oracle.javatools.db.ora.sxml.SXMLValueConverter;
import oracle.javatools.db.ora.sxml.UnsupportedTypeForSXMLException;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SXMLReader
extends SXMLFragmentGenerator {
    private Map<Class, Map<String, PropertyInfo>> m_infos;
    private SchemaObject m_schemaObj;

    private void $init$() {
        this.m_infos = new HashMap<Class, Map<String, PropertyInfo>>();
    }

    public SXMLReader() {
        this(new SXMLReaderMappings());
    }

    SXMLReader(SXMLMappings mappings) {
        this.$init$();
        super.setMappings(mappings);
    }

    public void addMapping(String type, String elementPath, String propertyPath, SXMLValueConverter con) {
        this.getMappings().cache(type, elementPath, propertyPath, con);
    }

    public void removeMapping(String type, String elementPath, String propertyPath) {
        this.getMappings().uncache(type, elementPath, propertyPath);
    }

    public void addGenerator(String type, Class<? extends SXMLFragmentGenerator> gen) {
        this.getMappings().registerGen(type, gen);
    }

    public SchemaObject getObject(XMLDocument doc) {
        Element rootNode = doc.getDocumentElement();
        return this.getObject(rootNode);
    }

    protected SchemaObject getObject(Node rootNode) {
        Index ind;
        this.m_schemaObj = null;
        String rootNodeName = rootNode.getLocalName();
        if (this.isRootNameForType(rootNodeName, "TABLE")) {
            this.m_schemaObj = new Table();
        } else if (this.isRootNameForType(rootNodeName, "VIEW")) {
            this.m_schemaObj = new View();
        } else if (this.isRootNameForType(rootNodeName, "MATERIALIZED VIEW")) {
            this.m_schemaObj = new MaterializedView();
            ((MaterializedView)this.m_schemaObj).setRefreshMethod(MaterializedView.RefreshMethod.FORCE);
        } else if (this.isRootNameForType(rootNodeName, "MATERIALIZED VIEW LOG")) {
            this.m_schemaObj = new MaterializedViewLog();
            ((MaterializedViewLog)this.m_schemaObj).setCache(Boolean.valueOf(false));
            ((MaterializedViewLog)this.m_schemaObj).setNewValues(Boolean.valueOf(false));
            ((MaterializedViewLog)this.m_schemaObj).setObjectIdLogged(Boolean.valueOf(false));
            ((MaterializedViewLog)this.m_schemaObj).setPrimaryKeyLogged(Boolean.valueOf(false));
            ((MaterializedViewLog)this.m_schemaObj).setRowidLogged(Boolean.valueOf(false));
            ((MaterializedViewLog)this.m_schemaObj).setSequenceLogged(Boolean.valueOf(false));
        } else if (this.isRootNameForType(rootNodeName, "SEQUENCE")) {
            this.m_schemaObj = new Sequence();
        } else if (this.isRootNameForType(rootNodeName, "SYNONYM")) {
            this.m_schemaObj = new Synonym();
        } else if (this.isRootNameForType(rootNodeName, "TRIGGER")) {
            this.m_schemaObj = new Trigger();
        } else if (this.isRootNameForType(rootNodeName, "INDEX")) {
            this.m_schemaObj = new Index();
        }
        if (this.m_schemaObj != null) {
            try {
                this.fillInObject(this.m_schemaObj, rootNode, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        } else {
            throw new UnsupportedTypeForSXMLException(rootNodeName);
        }
        if (this.m_schemaObj instanceof MaterializedViewLog) {
            MaterializedViewLog mvl = (MaterializedViewLog)this.m_schemaObj;
            NameBasedID masterID = (NameBasedID)mvl.getMasterTableID();
            masterID.setSchema(mvl.getSchema());
        }
        if (this.m_schemaObj instanceof Index && (ind = (Index)this.m_schemaObj).getIndexType() == null) {
            ind.setIndexType(Index.IndexType.NORMAL);
        }
        this.tidyPartitions();
        return this.m_schemaObj;
    }

    protected final void fillInObject(Object obj, Node parentNode, String objToParentNodePath) {
        HashSet<String> processedChildren = new HashSet<String>();
        String mappingType = this.getMappingType(obj);
        if (mappingType != null) {
            SXMLFragmentGenerator.childXMLElementIterator it = new SXMLFragmentGenerator.childXMLElementIterator(parentNode);
            while (it.hasNext()) {
                Node currentNode = (Node)it.next();
                Iterator<SXMLMappings.Mapping> maps = this.getMappings().getMappings(mappingType);
                String nodeName = currentNode.getLocalName();
                StringBuffer objToCurrentNodePath = new StringBuffer();
                if (objToParentNodePath != null) {
                    objToCurrentNodePath.append(objToParentNodePath).append("/");
                }
                objToCurrentNodePath.append(nodeName);
                StringBuffer objToCurrentNodePathSlash = new StringBuffer(objToCurrentNodePath).append("/");
                StringBuffer objToCurrentNodePathSlashSlash = new StringBuffer(objToCurrentNodePath).append("//");
                while (maps.hasNext()) {
                    SXMLMappings.Mapping map = maps.next();
                    String mappedElementPath = map.getElementPath();
                    String mappedPropertyPath = map.getPropertyPath();
                    if (mappedElementPath.startsWith(objToCurrentNodePathSlashSlash.toString())) {
                        Map<String, PropertyInfo> infos = this.getPropertyInfos(obj);
                        String propName = mappedPropertyPath;
                        if (propName.contains("/")) {
                            propName = propName.substring(propName.indexOf("/") + 1);
                        }
                        PropertyInfo info = infos.get(propName);
                        this.fillInArrayObject(obj, currentNode, objToCurrentNodePath.toString(), info);
                        continue;
                    }
                    if (mappedElementPath.startsWith(objToCurrentNodePathSlash.toString())) {
                        if (processedChildren.contains(nodeName)) continue;
                        processedChildren.add(nodeName);
                        this.fillInObject(obj, currentNode, objToCurrentNodePath.toString());
                        continue;
                    }
                    if (!mappedElementPath.equals(objToCurrentNodePath.toString()) || mappedPropertyPath == null) continue;
                    SXMLValueConverter con = map.getConverter();
                    this.processPropertyPath(obj, currentNode, mappedPropertyPath, this.getNodeText(currentNode), con);
                }
            }
        }
        if (!ModelUtil.hasLength((String)objToParentNodePath)) {
            this.fillInObjectWithReaders(parentNode, obj);
        }
        if (obj instanceof DBObject && objToParentNodePath == null) {
            NameBasedID objID = new NameBasedID();
            DBObject dbo = (DBObject)obj;
            objID.setType(dbo.getType());
            objID.setName(dbo.getName());
            if (obj instanceof SchemaObject) {
                objID.setSchema(((SchemaObject)dbo).getSchema());
            }
            dbo.setID((DBObjectID)objID);
        }
    }

    private void fillInArrayObject(Object obj, Node parentNode, String objToParentNodePath, PropertyInfo info) {
        Class<?> arrClz = info.getPropertyClass();
        if (arrClz.isArray()) {
            arrClz = arrClz.getComponentType();
        } else {
            this.wellIdidntExpectThat();
        }
        Class<Object> objClz = arrClz;
        ArrayList<Object> objectList = new ArrayList<Object>();
        Object existing = info.getPropertyValue(obj);
        if (existing instanceof Constraint[]) {
            Constraint[] existingArray;
            Constraint[] constraintArray = existingArray = (Constraint[])existing;
            int n = 0;
            while (n < constraintArray.length) {
                Constraint o = constraintArray[n];
                objectList.add(o);
                ++n;
            }
        }
        SXMLFragmentGenerator.childXMLElementIterator it = new SXMLFragmentGenerator.childXMLElementIterator(parentNode);
        while (it.hasNext()) {
            Node currentNode = (Node)it.next();
            Object childObj = null;
            if (objClz == DBObjectID.class) {
                childObj = this.createIDForProp(obj, info);
            } else {
                if (objClz == Constraint.class) {
                    if (parentNode.getLocalName().equals("PRIMARY_KEY_CONSTRAINT_LIST")) {
                        objClz = PKConstraint.class;
                    } else if (parentNode.getLocalName().equals("UNIQUE_KEY_CONSTRAINT_LIST")) {
                        objClz = UniqueConstraint.class;
                    } else if (parentNode.getLocalName().equals("FOREIGN_KEY_CONSTRAINT_LIST")) {
                        objClz = FKConstraint.class;
                    } else if (parentNode.getLocalName().equals("CHECK_CONSTRAINT_LIST")) {
                        objClz = CheckConstraint.class;
                    }
                }
                try {
                    childObj = objClz.newInstance();
                }
                catch (InstantiationException e) {
                    this.wellIdidntExpectThat();
                }
                catch (IllegalAccessException e) {
                    this.wellIdidntExpectThat();
                }
            }
            objectList.add(childObj);
            this.fillInObject(childObj, currentNode, null);
        }
        Object[] array = Array.newInstance(arrClz, objectList.size());
        array = objectList.toArray((Object[])array);
        try {
            info.setPropertyValue(obj, (Object)array);
        }
        catch (Exception e) {
            this.wellIdidntExpectThat();
        }
        for (Object e : objectList) {
            ChildDBObject child;
            if (!(e instanceof ChildDBObject) || !((child = (ChildDBObject)e).getID() instanceof NameBasedID)) continue;
            NameBasedID id = (NameBasedID)child.getID();
            id.setParent(((DBObject)obj).getID());
        }
    }

    private void processPropertyPath(Object obj, Node parentNode, String propertyPath, String sxmlValue, SXMLValueConverter con) {
        String[] propParts = propertyPath.split("/");
        Map<String, PropertyInfo> infos = this.getPropertyInfos(obj);
        PropertyInfo info = infos.get(propParts[0]);
        boolean done = false;
        if (info == null) {
            this.wellIdidntExpectThat();
        } else {
            Class clz = info.getPropertyClass();
            Object beanValue = null;
            if (clz == Map.class) {
                HashMap<String, Object> map = (HashMap<String, Object>)info.getPropertyValue(obj);
                if (map == null) {
                    map = new HashMap<String, Object>();
                    try {
                        info.setPropertyValue(obj, map);
                    }
                    catch (Exception e) {
                        this.wellIdidntExpectThat();
                    }
                }
                if (propParts.length > 1) {
                    Object objInMap = map.get(propParts[1]);
                    PropertyInfo propInfo = infos.get(propParts[1]);
                    clz = propInfo.getPropertyClass();
                    Object copy = null;
                    if (clz == String.class || clz == Integer.class || clz == Boolean.class) {
                        objInMap = clz != String.class ? ToStringManager.fromString((String)sxmlValue, (Class)clz) : sxmlValue;
                        map.put(propParts[1], objInMap);
                        done = true;
                    } else if (objInMap == null) {
                        try {
                            objInMap = clz.newInstance();
                            map.put(propParts[1], objInMap);
                            if (objInMap instanceof Copyable) {
                                copy = ((Copyable)objInMap).copyTo(null);
                            }
                        }
                        catch (InstantiationException e) {
                            this.wellIdidntExpectThat();
                        }
                        catch (IllegalAccessException e) {
                            this.wellIdidntExpectThat();
                        }
                    }
                    if (this.getMappingType(objInMap) != null) {
                        this.fillInObject(objInMap, parentNode, null);
                        if (copy != null && objInMap != null && objInMap.equals(copy)) {
                            map.remove(propParts[1]);
                        }
                    } else if (!done) {
                        StringBuffer objToCurrentNodePath = new StringBuffer(propertyPath.substring(propertyPath.indexOf("/") + 1));
                        this.processPropertyPath(objInMap, parentNode, objToCurrentNodePath.toString(), sxmlValue, con);
                    }
                }
            } else if (propParts.length == 1) {
                if (clz == DBObjectID.class) {
                    beanValue = this.createIDForProp(obj, info);
                    ((NameBasedID)beanValue).setName(sxmlValue);
                } else if (sxmlValue == null && con == null && parentNode.hasChildNodes()) {
                    try {
                        beanValue = clz.newInstance();
                    }
                    catch (InstantiationException e) {
                        this.wellIdidntExpectThat();
                    }
                    catch (IllegalAccessException e) {
                        this.wellIdidntExpectThat();
                    }
                } else {
                    if (con != null) {
                        try {
                            beanValue = con.getBeanValue(obj, sxmlValue);
                        }
                        catch (Exception e) {
                            this.wellIdidntExpectThat();
                        }
                    } else {
                        beanValue = (clz == Boolean.TYPE || clz == Boolean.class) && !ModelUtil.hasLength((String)sxmlValue) ? Boolean.valueOf(true) : sxmlValue;
                    }
                    if (beanValue instanceof String && clz != String.class && ToStringManager.converterAvailable(clz)) {
                        try {
                            beanValue = ToStringManager.fromString((String)((String)beanValue), (Class)clz);
                        }
                        catch (Exception e) {
                            this.wellIdidntExpectThat();
                        }
                    }
                }
                try {
                    info.setPropertyValue(obj, beanValue);
                }
                catch (Exception e) {
                    this.wellIdidntExpectThat();
                }
                String mappingType = this.getMappingType(beanValue);
                boolean fillIn = true;
                try {
                    this.getMappings().getMappings(mappingType);
                }
                catch (UnsupportedTypeForSXMLException e) {
                    fillIn = false;
                }
                if (this.getMappingType(beanValue) != null) {
                    this.fillInObject(beanValue, parentNode, null);
                }
            } else if (propParts.length > 1) {
                Object propertyPathObj = info.getPropertyValue(obj);
                if (propertyPathObj == null) {
                    if (clz == DBObjectID.class) {
                        propertyPathObj = this.createIDForProp(obj, info);
                    } else {
                        if (clz == SQLQuery.class) {
                            clz = NonDeclarativeSQLQuery.class;
                        } else if (clz == SQLFragment.class) {
                            clz = SimpleSQLFragment.class;
                        }
                        try {
                            propertyPathObj = clz.newInstance();
                        }
                        catch (InstantiationException e) {
                            this.wellIdidntExpectThat();
                        }
                        catch (IllegalAccessException e) {
                            this.wellIdidntExpectThat();
                        }
                    }
                    try {
                        info.setPropertyValue(obj, propertyPathObj);
                    }
                    catch (Exception e) {
                        this.wellIdidntExpectThat();
                    }
                }
                StringBuffer objToCurrentNodePath = new StringBuffer(propertyPath.substring(propertyPath.indexOf("/") + 1));
                this.processPropertyPath(propertyPathObj, parentNode, objToCurrentNodePath.toString(), sxmlValue, con);
            }
        }
    }

    private void fillInObjectWithReaders(Node node, Object obj) {
        Iterator<Class<? extends SXMLFragmentGenerator>> gens = this.getMappings().getGenerators(this.getMappingType(obj));
        if (gens != null) {
            while (gens.hasNext()) {
                try {
                    SXMLFragmentGenerator gen = gens.next().newInstance();
                    gen.setParentGenerator(this);
                    gen.readNode(node, obj);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getMappingType(Object obj) {
        if (obj == null) {
            boolean bl = true;
        }
        String mappingType = obj instanceof DBObject ? ((DBObject)obj).getType() : obj.getClass().getSimpleName();
        try {
            this.getMappings().getMappings(mappingType);
        }
        catch (UnsupportedTypeForSXMLException e) {
            mappingType = null;
        }
        return mappingType;
    }

    private Map<String, PropertyInfo> getPropertyInfos(Object bean) {
        return this.getPropertyInfos(bean.getClass());
    }

    private Map<String, PropertyInfo> getPropertyInfos(Class clz) {
        if (this.m_infos.containsKey(clz)) {
            return this.m_infos.get(clz);
        }
        PropertyIterator iter = new PropertyIterator(clz, OracleDatabase.class);
        Map infos = iter.getPropertyInfos(false, false, false);
        this.m_infos.put(clz, infos);
        return infos;
    }

    private boolean isRootNameForType(String rootNodeName, String type) {
        if (type != null) {
            String type2 = type;
            if (type.indexOf(" ") > -1) {
                type2 = type.replaceAll(" ", "_");
            }
            return type2.equals(rootNodeName);
        }
        return false;
    }

    private String getNodeText(Node node) {
        if (node.getChildNodes().getLength() <= 1) {
            return node.getTextContent();
        }
        return null;
    }

    private void tidyPartitions() {
        Table tab;
        OracleTablePartitions otp;
        if (this.m_schemaObj instanceof Table && (otp = (OracleTablePartitions)(tab = (Table)this.m_schemaObj).getProperty("OracleTablePartitions")) != null) {
            tab.setProperty("PARTITIONED TABLE", (Object)Boolean.TRUE);
            OracleTablePartitions subPartModel = otp.getSubpartitionModel();
            TablePartition[] tablePartitionArray = otp.getPartitions();
            int n = 0;
            while (n < tablePartitionArray.length) {
                TablePartition tp = tablePartitionArray[n];
                OracleTablePartitions plsp = tp.getPartitionLevelSubpartitions();
                if (plsp != null && subPartModel != null) {
                    if (plsp.getPartitionType() == null) {
                        plsp.setPartitionType(subPartModel.getPartitionType());
                    }
                    if (plsp.getPartitionColumns() == null || plsp.getPartitionColumns().length == 0) {
                        // empty if block
                    }
                }
                ++n;
            }
            this.propegateObjectAndPartitionType(otp);
        }
    }

    private void propegateObjectAndPartitionType(OracleTablePartitions otp) {
        TablePartition[] tablePartitionArray = otp.getPartitions();
        int n = 0;
        while (n < tablePartitionArray.length) {
            TablePartition tp = tablePartitionArray[n];
            if (tp.getObjectType() == null) {
                tp.setObjectType(otp.getObjectType());
            }
            if (tp.getPartitionType() == null) {
                tp.setPartitionType(otp.getPartitionType());
            }
            if (tp.getPartitionLevelSubpartitions() != null) {
                this.propegateObjectAndPartitionType(tp.getPartitionLevelSubpartitions());
            }
            ++n;
        }
        if (otp.getSubpartitionModel() != null) {
            this.propegateObjectAndPartitionType(otp.getSubpartitionModel());
        }
    }

    protected OracleTablePartitions getTablePartitionModel() {
        return (OracleTablePartitions)this.m_schemaObj.getProperty("OracleTablePartitions");
    }

    protected SQLFragment createExpression(String expression) {
        return new SimpleSQLFragment(expression);
    }

    protected void wellIdidntExpectThat() {
        throw new RuntimeException("Barf");
    }

    @Override
    protected void populateNode(Node parent, Document doc, Object obj) {
    }

    @Override
    protected void readNode(Node parent, Object obj) {
    }

    private DBObjectID createIDForProp(Object obj, PropertyInfo pi) {
        ReferenceID retval = null;
        if (obj instanceof OracleExternalTableProperties && pi.getPropertyName().equals("defaultDirectory")) {
            retval = new ReferenceID();
            retval.setSchemaName("SYS");
        } else if (obj instanceof OracleExternalTableProperties.LocationSpecifier && pi.getPropertyName().equals("directory")) {
            retval = new ReferenceID();
            retval.setSchemaName("SYS");
        } else if (obj instanceof Index && pi.getPropertyName().equals("domainIndextype")) {
            retval = new ReferenceID();
            retval.setSchemaName("SYS");
            retval.setType("INDEXTYPE");
        } else if (obj instanceof Synonym && pi.getPropertyName().equals("reference")) {
            retval = new ReferenceID();
        } else {
            NameBasedID id = new NameBasedID();
            if (obj instanceof MaterializedViewLog && pi.getPropertyName().equals("masterTableID")) {
                id.setType("TABLE");
            } else if (obj instanceof MaterializedViewLog && pi.getPropertyName().equals("columnIDs")) {
                id.setType("COLUMN");
                id.setParent(((MaterializedViewLog)obj).getMasterTableID());
            } else if (obj instanceof OracleIndexOrganizedTableProperties && pi.getPropertyName().equals("includeColumn")) {
                id.setType("COLUMN");
                id.setParent((DBObjectID)new NameBasedID(this.m_schemaObj.getType(), this.m_schemaObj.getSchema().getName(), this.m_schemaObj.getName()));
            } else if (obj instanceof FKConstraint && pi.getPropertyName().equals("referenceID")) {
                id.setType("CONSTRAINT");
            } else if (obj instanceof ColumnConstraint && pi.getPropertyName().equals("columnIDs")) {
                id.setType("COLUMN");
                id.setParent((DBObjectID)new NameBasedID(this.m_schemaObj.getType(), this.m_schemaObj.getSchema().getName(), this.m_schemaObj.getName()));
            } else if (obj instanceof OracleTablePartitions && pi.getPropertyName().equals("partitionColumns")) {
                id.setType("COLUMN");
                id.setParent((DBObjectID)new NameBasedID(this.m_schemaObj.getType(), this.m_schemaObj.getSchema().getName(), this.m_schemaObj.getName()));
            } else {
                this.wellIdidntExpectThat();
            }
            retval = id;
        }
        return retval;
    }

    private static class SXMLReaderMappings
    extends SXMLMappings {
        public SXMLReaderMappings() {
            this.uncache("MATERIALIZED VIEW", "REFRESH", "refreshMode");
            this.uncache("MATERIALIZED VIEW", "PHYSICAL_PROPERTIES/HEAP_TABLE", null);
            this.uncache("TABLE", "GLOBAL_TEMPORARY", "properties/TableType");
            this.uncache("TABLE", "RELATIONAL_TABLE/ON_COMMIT", "properties/TableType");
            this.uncache("CONSTRAINT", "REFERENCES/SCHEMA", "referenceID/relation/schema/name");
            this.uncache("CONSTRAINT", "REFERENCES/NAME", "referenceID/relation/name");
            this.uncache("CONSTRAINT", "REFERENCES/COL_LIST//COL_LIST_ITEM/NAME", "referenceID/columnIDs");
            this.uncache("CONSTRAINT", "REFERENCES/SCHEMA", "referenceID/parent/schemaName");
            this.uncache("CONSTRAINT", "REFERENCES/NAME", "referenceID/parent/name");
            this.uncache("CONSTRAINT", "REFERENCES/COL_LIST//COL_LIST_ITEM/NAME", "referenceID/columnNames");
            this.uncache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES/INDEXTYPE/SCHEMA", "domainIndextype/schema/name");
            this.uncache("SYNONYM", "OBJECT_SCHEMA", "reference/schema/name");
            this.uncache("OracleNestedTableProperties", "STORAGE_TABLE/SCHEMA", "!schema");
            this.uncache("LOB DESCRIPTOR", "SCHEMA", "!schema");
            this.uncache("OracleColumnProperties", "VARRAY_PROPERTIES/STORE_AS", "VAProperties");
            String NBID = NameBasedID.class.getSimpleName();
            this.cache(NBID, "SCHEMA", "schema/name", null);
            this.cache(NBID, "NAME", "name", null);
            this.cache("MATERIALIZED VIEW LOG", "ON_TABLE/NAME", "name");
            this.cache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES", "indexType", new SXMLMappings.ValueCheckingConverter(Index.IndexType.DOMAIN));
        }
    }
}

