/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.ArrayList;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLMappings;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class TriggerSXMLGenerator
extends SXMLFragmentGenerator {
    protected void populateNode(Node parent, Document doc, Object obj) {
        String root;
        Trigger trig = (Trigger)obj;
        Trigger.BaseType baseType = trig.getBaseType();
        if (baseType == null) {
            baseType = Trigger.BaseType.TABLE;
        }
        switch (1.$sm$oracle$javatools$db$Trigger$BaseType[baseType.ordinal()]) {
            case 1: {
                root = "DDL_EVENT";
                break;
            }
            case 2: {
                String[] events = trig.getEvents();
                if (events.length > 0 && Trigger.isDatabaseOnlyEvent((String)events[0])) {
                    root = "DATABASE_EVENT";
                    break;
                }
                root = "DDL_EVENT";
                break;
            }
            default: {
                root = "DML_EVENT";
            }
        }
        this.findOrCreateNodeAfter(doc, parent, root, "TRIGGER_TYPE");
        switch (1.$sm$oracle$javatools$db$Trigger$BaseType[baseType.ordinal()]) {
            case 1: {
                this.processPropertyMapping(parent, doc, trig, root + "/EVENT_LIST//EVENT_LIST_ITEM/EVENT", "events");
                this.processPropertyMapping(parent, doc, trig, root + "/SCHEMA", "tableOwner/name");
                break;
            }
            case 2: {
                String[] events = trig.getEvents();
                if (events.length <= 0) break;
                this.processPropertyMapping(parent, doc, trig, root + "/EVENT_LIST//EVENT_LIST_ITEM/EVENT", "events");
                if (Trigger.isDatabaseOnlyEvent((String)events[0])) break;
                this.findOrCreateNode(doc, parent, root + "/DATABASE");
                break;
            }
            default: {
                Node listNode = this.findOrCreateNode(doc, parent, root + "/EVENT_LIST");
                String[] events = trig.getEvents();
                int i = 0;
                while (i < events.length) {
                    Node eventItemNode = this.createNode(doc, listNode, "EVENT_LIST_ITEM");
                    Node eventNode = this.createNode(doc, eventItemNode, "EVENT");
                    eventNode.appendChild(doc.createTextNode(events[i]));
                    if (events[i].equals("UPDATE")) {
                        this.processPropertyMapping(eventItemNode, doc, trig, "COL_LIST//COL_LIST_ITEM/NAME", "columnIDs");
                    }
                    ++i;
                }
                this.processPropertyMapping(parent, doc, trig, root + "/SCHEMA", "tableOwner/name");
                this.processPropertyMapping(parent, doc, trig, root + "/NAME", "tableID");
                String[] refs = trig.getReferenceNames();
                if (refs == null) break;
                if (refs.length > 0 && ModelUtil.hasLength((String)refs[0])) {
                    Node oldNode = this.findOrCreateNode(doc, parent, root + "/REFERENCING/OLD_AS");
                    oldNode.appendChild(doc.createTextNode(refs[0]));
                }
                if (refs.length > 1 && ModelUtil.hasLength((String)refs[1])) {
                    Node oldNode = this.findOrCreateNode(doc, parent, root + "/REFERENCING/NEW_AS");
                    oldNode.appendChild(doc.createTextNode(refs[1]));
                }
                if (refs.length > 2 && ModelUtil.hasLength((String)refs[2])) {
                    Node oldNode = this.findOrCreateNode(doc, parent, root + "/REFERENCING/PARENT_AS");
                    oldNode.appendChild(doc.createTextNode(refs[2]));
                }
                this.processPropertyMapping(parent, doc, trig, root + "/REFERENCING/FOR_EACH_ROW", "statementLevel", new SXMLMappings.InverseBooleanConverter());
            }
        }
    }

    protected void readNode(Node parent, Object obj) {
        Trigger trigger = (Trigger)obj;
        Node eventListNode = null;
        Schema schema = null;
        String[] referencing = new String[2];
        if (this.nodeExists(parent, "DATABASE_EVENT")) {
            trigger.setBaseType(Trigger.BaseType.DATABASE);
            eventListNode = this.findNode(parent, "DATABASE_EVENT/EVENT_LIST");
        } else if (this.nodeExists(parent, "DDL_EVENT/DATABASE")) {
            trigger.setBaseType(Trigger.BaseType.DATABASE);
            eventListNode = this.findNode(parent, "DDL_EVENT/EVENT_LIST");
        } else if (this.nodeExists(parent, "DDL_EVENT")) {
            Schema s = new Schema(this.nodeText(parent, "DDL_EVENT/SCHEMA"));
            trigger.setTableOwner(s);
            trigger.setBaseType(Trigger.BaseType.SCHEMA);
            eventListNode = this.findNode(parent, "DDL_EVENT/EVENT_LIST");
        } else {
            schema = new Schema(this.nodeText(parent, "DML_EVENT/SCHEMA"));
            NameBasedID id = new NameBasedID();
            id.setSchema(schema);
            id.setName(this.nodeText(parent, "DML_EVENT/NAME"));
            trigger.setTableOwner(schema);
            trigger.setTableID((DBObjectID)id);
            if ("INSTEAD_OF".equals(this.nodeText(parent, "TRIGGER_TYPE"))) {
                trigger.setBaseType(Trigger.BaseType.VIEW);
                id.setType("VIEW");
            } else {
                trigger.setBaseType(Trigger.BaseType.TABLE);
                id.setType("TABLE");
            }
            eventListNode = this.findNode(parent, "DML_EVENT/EVENT_LIST");
            referencing[0] = this.nodeText(parent, "DML_EVENT/REFERENCING/OLD_AS");
            referencing[1] = this.nodeText(parent, "DML_EVENT/REFERENCING/NEW_AS");
            trigger.setReferenceNames(referencing);
            if (this.nodeExists(parent, "DML_EVENT/REFERENCING/FOR_EACH_ROW")) {
                trigger.setStatementLevel(false);
            }
        }
        ArrayList<String> eventList = new ArrayList<String>();
        if (eventListNode != null) {
            SXMLFragmentGenerator.childXMLElementIterator it = new SXMLFragmentGenerator.childXMLElementIterator(eventListNode);
            while (it.hasNext()) {
                String event;
                Node node = (Node)it.next();
                if (!"EVENT_LIST_ITEM".equals(node.getLocalName()) || (event = this.nodeText(node, "EVENT")) == null) continue;
                eventList.add(event);
                if (!this.nodeExists(node, "COL_LIST")) continue;
                ArrayList<NameBasedID> columnList = new ArrayList<NameBasedID>();
                Node colListNode = this.findNode(node, "COL_LIST");
                NodeList colNodes = colListNode.getChildNodes();
                int j = 0;
                while (j < colNodes.getLength()) {
                    Node colNode = colNodes.item(j);
                    if ("COL_LIST_ITEM".equals(colNode.getLocalName())) {
                        NameBasedID id = new NameBasedID();
                        id.setSchema(schema);
                        id.setName(this.nodeText(colNode, "NAME"));
                        id.setType("COLUMN");
                        id.setParent(trigger.getTableID());
                        columnList.add(id);
                    }
                    ++j;
                }
                trigger.setColumnIDs(columnList.toArray(new DBObjectID[columnList.size()]));
            }
            trigger.setEvents(eventList.toArray(new String[eventList.size()]));
        }
    }

    TriggerSXMLGenerator() {
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$javatools$db$Trigger$BaseType;

        static {
            int[] nArray = new int[Trigger.BaseType.values().length];
            $sm$oracle$javatools$db$Trigger$BaseType = nArray;
            try {
                nArray[Trigger.BaseType.SCHEMA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$Trigger$BaseType[Trigger.BaseType.DATABASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$Trigger$BaseType[Trigger.BaseType.TABLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$Trigger$BaseType[Trigger.BaseType.VIEW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

