/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOTPropertiesValidator
extends AbstractValidator<OracleIndexOrganizedTableProperties> {
    public IOTPropertiesValidator(DBObjectProvider pro) {
        super(pro);
    }

    @Override
    protected boolean canHaveEmptyName() {
        return true;
    }

    @Override
    public void validateObject(OracleIndexOrganizedTableProperties original, OracleIndexOrganizedTableProperties props) throws ValidationException {
        Table table = (Table)props.getParent();
        if (table == null) {
            throw new ValidationException((DBObject)props, "IOT properties must be set on a parent Table.");
        }
        super.validateObject(original, props);
    }

    @AbstractValidator.PropertyValidator(value={Property.pctThreshold})
    public void validatePctThreshold(OracleIndexOrganizedTableProperties original, OracleIndexOrganizedTableProperties props) throws ValidationException {
        Integer pct = props.getPctThreshold();
        if (pct != null && (pct < 1 || pct > 50)) {
            throw new ValidationException((DBObject)props, DBArb.getString((int)107));
        }
    }

    @AbstractValidator.PropertyValidator(value={Property.keyCompression})
    public void validateKeyCompression(OracleIndexOrganizedTableProperties original, OracleIndexOrganizedTableProperties props) throws ValidationException {
        Integer keyComp = props.getKeyCompression();
        if (keyComp != null) {
            Integer pkColumnCount;
            PKConstraint pk = PKConstraint.getPrimaryKey((Table)((Table)props.getParent()));
            Integer n = pkColumnCount = pk != null ? new Integer(pk.getColumns().length) : null;
            if (pkColumnCount != null && pkColumnCount == 1) {
                throw new ValidationException((DBObject)props, DBArb.getString((int)288));
            }
            if (keyComp < 0 || pkColumnCount == null || keyComp.compareTo(pkColumnCount) >= 0) {
                throw new ValidationException((DBObject)props, DBArb.getString((int)287));
            }
        }
    }

    @AbstractValidator.PropertyValidator(value={Property.includeColumn})
    public void validateIncludeColumn(OracleIndexOrganizedTableProperties original, OracleIndexOrganizedTableProperties props) throws ValidationException {
        DBObjectID incCol = props.getIncludeColumn();
        if (incCol != null) {
            Column includeColumn = null;
            try {
                includeColumn = incCol != null ? (Column)incCol.resolveID() : null;
            }
            catch (DBException e) {
                // empty catch block
            }
            if (includeColumn != null) {
                Constraint[] constraints;
                Table table;
                String includeColumnName = includeColumn.getName();
                includeColumn = null;
                if (ModelUtil.hasLength((String)includeColumnName) && (table = (Table)props.getParent()) != null) {
                    Column[] columnArray = table.getColumns();
                    int n = 0;
                    while (n < columnArray.length) {
                        Column col = columnArray[n];
                        if (includeColumnName.equals(col.getName())) {
                            includeColumn = col;
                            break;
                        }
                        ++n;
                    }
                }
                if (includeColumn == null) {
                    throw new ValidationException((DBObject)props, DBArb.getString((int)108));
                }
                Table table2 = (Table)props.getParent();
                Constraint[] constraintArray = constraints = table2 == null ? null : table2.getConstraints();
                if (constraints != null && constraints.length > 0) {
                    int con = 0;
                    while (con < constraints.length) {
                        if (constraints[con].getConstraintType().equals("PKConstraint")) {
                            PKConstraint pk = (PKConstraint)constraints[con];
                            Column[] pkColumns = pk.getColumns();
                            if (pkColumns.length <= 0 || includeColumn.getName().equals(pkColumns[pkColumns.length - 1].getName())) break;
                            int col = 0;
                            while (col < pkColumns.length - 1) {
                                if (includeColumn.getName().equals(pkColumns[col].getName())) {
                                    throw new ValidationException((DBObject)props, DBArb.getString((int)108));
                                }
                                ++col;
                            }
                            break;
                        }
                        ++con;
                    }
                }
            }
        }
    }

    @AbstractValidator.PropertyValidator(value={Property.overflowProperties})
    public void validateOverflowProperties(OracleIndexOrganizedTableProperties original, OracleIndexOrganizedTableProperties props) throws ValidationException {
        OracleStorageProperties sprops = props.getOverflowProperties();
        if (sprops != null) {
            sprops.validate((DBObject)props);
        }
    }
}

