/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexPartitionValidator
extends AbstractValidator<IndexPartition> {
    public IndexPartitionValidator(DBObjectProvider pro) {
        super(pro);
    }

    @Override
    protected boolean canHaveEmptyName() {
        return true;
    }

    @AbstractValidator.PropertyValidator(value={Property.globalPartitionColumns})
    public void validateGlobalRangePartition(IndexPartition original, IndexPartition indexP) throws ValidationException {
        OracleIndexPartitions parent = (OracleIndexPartitions)indexP.getParent();
        if (parent != null && parent.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
            Object[] valuesLessThan;
            DBObjectID[] partitionColumns = parent.getGlobalPartitionColumns();
            if (partitionColumns.length != (valuesLessThan = indexP.getValuesLessThan()).length) {
                String name = indexP.getName();
                throw new ValidationException((DBObject)indexP, DBArb.format((int)332, (Object)(ModelUtil.hasLength((String)name) ? name : DBArb.getString((int)12))));
            }
            Object[] objectArray = valuesLessThan;
            int n = 0;
            while (n < objectArray.length) {
                Object value = objectArray[n];
                if ("NULL".equalsIgnoreCase(value.toString())) {
                    String name = indexP.getName();
                    throw new ValidationException((DBObject)indexP, DBArb.format((int)332, (Object)(ModelUtil.hasLength((String)name) ? name : DBArb.getString((int)46))));
                }
                ++n;
            }
        }
    }

    @AbstractValidator.PropertyValidator(value={Property.segmentAttributes})
    public void validateSegmentAttributes(IndexPartition original, IndexPartition indexP) throws ValidationException {
        OracleStorageProperties storage = indexP.getSegmentAttributes();
        if (storage != null) {
            storage.validate((DBObject)indexP);
        }
    }
}

