/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.validators.AbstractValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOBDescriptorValidator
extends AbstractValidator {
    public LOBDescriptorValidator(DBObjectProvider pro) {
        super(pro);
    }

    @Override
    protected boolean canHaveEmptyName() {
        return true;
    }

    public void validateObject(DBObject original, DBObject updated) throws ValidationException {
        super.validateObject(original, updated);
        this.validate((LOBDescriptor)updated);
    }

    private void validate(LOBDescriptor lobd) throws ValidationException {
        this.validateColumns(lobd);
        this.validateChunk(lobd);
        this.validateCache(lobd);
        this.validateFreepools(lobd);
        this.validatePctVersion(lobd);
        this.validateStorage(lobd);
    }

    public void validateCache(LOBDescriptor lobd) throws ValidationException {
        String cache = lobd.getCache();
        if (!(cache == null || cache.equalsIgnoreCase("CACHE") || cache.equalsIgnoreCase("NOCACHE") || cache.equalsIgnoreCase("CACHE READS"))) {
            throw new ValidationException((DBObject)lobd, DBArb.format((int)302, (Object)cache));
        }
    }

    public void validateChunk(LOBDescriptor lobd) throws ValidationException {
        Integer chunk = lobd.getChunk();
        if (chunk != null) {
            if (chunk < 1 || chunk > 32768) {
                throw new ValidationException((DBObject)lobd, DBArb.getString((int)135));
            }
            OracleStorageProperties storage = lobd.getStorage();
            if (storage != null && storage.getNextExtent() != null && chunk > storage.getNextExtent()) {
                throw new ValidationException((DBObject)lobd, DBArb.format((int)132, (Object)storage.getNextExtent()));
            }
        }
    }

    public void validateFreepools(LOBDescriptor lobd) throws ValidationException {
        Integer freepools = lobd.getFreepools();
        if (freepools != null) {
            if (freepools < 0) {
                throw new ValidationException((DBObject)lobd, DBArb.getString((int)193));
            }
            OracleStorageProperties storage = lobd.getStorage();
            if (storage != null && storage.getFreelistGroups() != null) {
                throw new ValidationException((DBObject)lobd, DBArb.getString((int)118));
            }
        }
    }

    public void validatePctVersion(LOBDescriptor lobd) throws ValidationException {
        this.validateRetention(lobd);
        Integer pctVersion = lobd.getPctVersion();
        if (pctVersion != null && (pctVersion < 0 || pctVersion > 100)) {
            throw new ValidationException((DBObject)lobd, DBArb.getString((int)319));
        }
    }

    public void validateRetention(LOBDescriptor lobd) throws ValidationException {
        Integer pctVersion = lobd.getPctVersion();
        boolean retention = lobd.isRetention();
        if (retention && pctVersion != null) {
            throw new ValidationException((DBObject)lobd, DBArb.getString((int)44));
        }
    }

    public void validateStorage(LOBDescriptor lobd) throws ValidationException {
        OracleStorageProperties storage = lobd.getStorage();
        if (storage != null) {
            storage.validate((DBObject)lobd);
        }
    }

    public void validateColumns(LOBDescriptor lobd) throws ValidationException {
        DBObjectID[] lobColumns = lobd.getColumns();
        if (lobColumns.length < 1) {
            throw new ValidationException((DBObject)lobd, DBArb.getString((int)143));
        }
        String lobSegName = lobd.getLOBSegName();
        if (lobSegName != null && lobColumns.length > 1) {
            throw new ValidationException((DBObject)lobd, DBArb.getString((int)80));
        }
        int i = 0;
        while (i < lobColumns.length) {
            DBObjectID id = lobColumns[i];
            try {
                Column column = (Column)id.resolveID();
                boolean isVarrayColumn = LOBDescriptor.isVARRAYColumn((DBObjectID)id);
                if (!LOBDescriptor.isLOBColumn((DBObjectID)id) && !isVarrayColumn || isVarrayColumn && i > 0) {
                    throw new ValidationException((DBObject)lobd, DBArb.getString((int)143));
                }
                if (isVarrayColumn && lobSegName == null) {
                    throw new ValidationException((DBObject)lobd, DBArb.getString((int)196));
                }
            }
            catch (DBException e) {
                DBLog.logStackTrace((Throwable)e);
            }
            ++i;
        }
    }
}

