/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.text.MessageFormat;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.validators.AbstractSchemaObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterializedViewLogValidator
extends AbstractSchemaObjectValidator {
    public MaterializedViewLogValidator(DBObjectProvider prov) {
        super(prov);
    }

    @Override
    public void validateObject(DBObject original, DBObject updated) throws ValidationException {
        super.validateObject(original, updated);
        this.validateLog((MaterializedViewLog)original, (MaterializedViewLog)updated);
    }

    private void validateLog(MaterializedViewLog original, MaterializedViewLog updated) throws ValidationException {
        if (updated.getMasterTableID() instanceof ReferenceID) {
            throw new ValidationException((DBObject)updated, MessageFormat.format(DBArb.getString((int)155), updated.getName()));
        }
        if (!updated.getName().equals(DBUtil.getDBObjectName((DBObjectID)updated.getMasterTableID()))) {
            throw new ValidationException((DBObject)updated, MessageFormat.format(DBArb.getString((int)164), updated.getName(), DBUtil.getDBObjectName((DBObjectID)updated.getMasterTableID())));
        }
    }

    @Override
    protected void validateNameInUse(DBObject object) throws NameInUseException {
    }
}

