/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.sql.DeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.validators.AbstractSchemaObjectValidator;
import oracle.javatools.db.validators.AbstractValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterializedViewValidator
extends AbstractSchemaObjectValidator<MaterializedView> {
    public MaterializedViewValidator(DBObjectProvider prov) {
        super(prov);
    }

    @AbstractValidator.PropertyValidator(value={Property.SQLQuery})
    public void validateQuery(MaterializedView original, MaterializedView mview) throws ValidationException {
        SQLQuery query = mview.getSQLQuery();
        if (query == null) {
            throw new ValidationException((DBObject)mview, "View must have a query");
        }
        if (query instanceof DeclarativeSQLQuery) {
            try {
                SQLQueryBuilderFactory.createBuilder((DBObjectProvider)this.getProvider(), (Schema)mview.getSchema(), (SQLQuery)query);
            }
            catch (SQLQueryException sqe) {
                throw new ValidationException((DBObject)mview, sqe.getMessage());
            }
        }
        try {
            SQLQuery test = SQLQueryBuilderFactory.createQuery((DBObjectProvider)this.getProvider(), (Schema)mview.getSchema(), (String)query.getSQLText());
        }
        catch (SQLParseException spe) {
            throw new ValidationException((DBObject)mview, spe.getMessage());
        }
    }
}

