/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.lang.reflect.Field;
import java.sql.SQLException;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.View;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeSynonym;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.ora.Oracle9i;
import oracle.javatools.db.validators.ColumnValidator;
import oracle.sql.CharacterSet;

public class OracleColumnValidator
extends ColumnValidator {
    public OracleColumnValidator(DBObjectProvider prov) {
        super(prov);
    }

    protected void validateName(DBObject obj) throws InvalidNameException {
        super.validateName(obj);
        String name = obj.getName();
        if (name.equals("ROWID")) {
            throw new InvalidNameException(obj, DBArb.format((int)253, (Object)name, (Object)DBArb.format((int)305, (Object)name)));
        }
    }

    protected void validateColumnDefinition(Column column) throws ValidationException {
        if (column instanceof ViewColumn || column.getRelation() instanceof View) {
            return;
        }
        super.validateColumnDefinition(column);
        DataType dataType = null;
        try {
            dataType = DataTypeHelper.getDataType((DataTypeUsage)column.getDataTypeUsage());
        }
        catch (DBException dBException) {
            // empty catch block
        }
        String dataTypeName = dataType instanceof DataTypeSynonym ? ((DataTypeSynonym)dataType).getBaseType().getName() : dataType.getName();
        Table.TableType tableType = (Table.TableType)column.getRelation().getProperty("TableType");
        if (tableType == Table.TableType.EXTERNAL && (dataType instanceof ComplexType || dataTypeName.startsWith("LONG"))) {
            throw new ValidationException((DBObject)column, DBArb.getString((int)203), DBArb.format((int)371, (Object)column.getName()));
        }
        if (dataTypeName.startsWith("LONG")) {
            Column[] columns = column.getRelation().getColumns();
            int i = 0;
            while (i < columns.length) {
                DataType dt = null;
                try {
                    dt = DataTypeHelper.getDataType((DataTypeUsage)columns[i].getDataTypeUsage());
                }
                catch (DBException dbe) {
                    // empty catch block
                }
                if (dt.getName().startsWith("LONG") && !column.getName().equals(columns[i].getName())) {
                    throw new ValidationException((DBObject)column, DBArb.format((int)257, (Object)columns[i].getName()), DBArb.format((int)371, (Object)column.getName()));
                }
                ++i;
            }
        }
        if (this.getProvider() instanceof Oracle9i && column.getDefault() instanceof String) {
            Oracle9i db = (Oracle9i)this.getProvider();
            String defaultValue = (String)column.getDefault();
            if (defaultValue.charAt(0) == '\'') {
                defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
            }
            String charSetName = "NCHAR".equals(dataTypeName) || "NVARCHAR2".equals(dataTypeName) || "NCLOB".equals(dataTypeName) ? db.getNLSSessionValue("NLS_NCHAR_CHARACTERSET") : db.getNLSSessionValue("NLS_CHARACTERSET");
            try {
                Class<?> cs = Class.forName("oracle.sql.CharacterSet");
                Field field = cs.getDeclaredField(charSetName + "_CHARSET");
                CharacterSet charSet = CharacterSet.make((int)field.getShort(field));
                byte[] bytes = charSet.convert(defaultValue);
                DataTypeUsage usage = column.getDataTypeUsage();
                String unit = (String)usage.getAttributeValue("unit");
                if (("CHAR".equals(dataTypeName) || "VARCHAR2".equals(dataTypeName)) && ("BYTE".equals(unit) || unit == null && "BYTE".equals(db.getNLSSessionValue("NLS_LENGTH_SEMANTICS")))) {
                    Long dataTypeSize = DataTypeHelper.getLongAttributeValue((DataTypeUsage)usage, (String)"size");
                    if (dataTypeSize == null) {
                        DataTypeAttribute sizeAttr = dataType.getDataTypeAttribute("size");
                        Long l = dataTypeSize = sizeAttr != null ? (Long)sizeAttr.getDefaultValue() : null;
                    }
                    if (dataTypeSize != null && (long)bytes.length > dataTypeSize) {
                        throw new DefaultValueValidationException((DBObject)column, dataType.getName(), DBArb.format((int)34, (Object)new Long(bytes.length), (Object)dataTypeSize));
                    }
                }
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchFieldException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (SQLException e) {
                throw new DefaultValueValidationException((DBObject)column, dataType.getName(), DBArb.format((int)252, (Object)defaultValue, (Object)charSetName));
            }
        }
    }
}

