/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.diff.IndexObjectComparator;
import oracle.javatools.db.ora.OracleIndexBuilder;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;

class OracleIndexAndConstraintValidator {
    private OracleIndexAndConstraintValidator() {
    }

    static boolean contraintAndIndexColumnsMatch(DBObjectProvider pro, Table table, Column[] cols, IndexObject[] colExpressions) {
        IndexObjectComparator indexObjComparator = new IndexObjectComparator();
        int j = 0;
        while (j < cols.length) {
            String colExpr = pro.getExternalName(cols[j].getName(), "COLUMN");
            SQLFragment colUsage = OracleIndexBuilder.createExpression(colExpr, (Relation)table, pro);
            IndexObject io = new IndexObject(colUsage);
            if (indexObjComparator.compare(colExpressions[j], io) != 0) {
                return false;
            }
            ++j;
        }
        return true;
    }

    static void validateIndex(Index index) throws NameInUseException {
        Table tab = index.getTable();
        OracleIndexAndConstraintValidator.validateIndexesAndConstraints(tab, index, null);
    }

    static void validateConstraint(Constraint constraint) throws NameInUseException {
        Table tab = (Table)constraint.getParent();
        OracleIndexAndConstraintValidator.validateIndexesAndConstraints(tab, null, constraint);
    }

    private static void validateIndexesAndConstraints(Table table, Index theIndex, Constraint theConsraint) throws NameInUseException {
        Index[] indexArray = table.getIndexes();
        int n = 0;
        while (n < indexArray.length) {
            Index index = indexArray[n];
            if (theIndex == null || theIndex.equals((Object)index)) {
                Constraint[] constraintArray = table.getConstraints();
                int n2 = 0;
                while (n2 < constraintArray.length) {
                    Constraint constraint = constraintArray[n2];
                    if (!(theConsraint != null && !theConsraint.equals((Object)constraint) || !constraint.getName().equals(index.getName()) || constraint instanceof UniqueConstraint && !constraint.isEnabled() && index.getIndexType() == Index.IndexType.UNIQUE && OracleIndexAndConstraintValidator.columnsMatch(index, (UniqueConstraint)constraint))) {
                        throw new NameInUseException((DBObject)index);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private static boolean columnsMatch(Index index, UniqueConstraint uk) {
        boolean retval = true;
        if (index.getColumnExpressions().length != uk.getColumnIDs().length) {
            retval = false;
        } else {
            IndexObject[] indexObjs = index.getColumnExpressions();
            DBObjectID[] consColId = uk.getColumnIDs();
            int i = 0;
            while (i < indexObjs.length) {
                SQLFragment exp = indexObjs[i].getExpression();
                Column col = null;
                try {
                    col = (Column)consColId[i].resolveID();
                }
                catch (DBException e) {
                    col = null;
                }
                if (!(exp instanceof ColumnUsage) || col == null || !((ColumnUsage)exp).getColumnName().equals(col.getName())) {
                    retval = false;
                    break;
                }
                ++i;
            }
        }
        return retval;
    }
}

