/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Arrays;
import java.util.HashSet;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataTypeUsage;
import oracle.javatools.db.diff.IndexObjectComparator;
import oracle.javatools.db.ora.Indextype;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleSQLQueryBuilder;
import oracle.javatools.db.ora.OracleTypesArb;
import oracle.javatools.db.ora.validators.OracleIndexAndConstraintValidator;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.validators.IndexValidator;

public class OracleIndexValidator
extends IndexValidator {
    private static final HashSet INVALID_INDEX_DATATYPES = new HashSet<String>(Arrays.asList("LONG", "LONG RAW", "LOB", "BLOB", "CLOB", "NCLOB", "BFILE", "REF"));
    private static final HashSet VALID_TEXT_INDEX_DATATYPES = new HashSet<String>(Arrays.asList(OracleTypesArb.getString(39), OracleTypesArb.getString(33), "BLOB", "BFILE"));

    public OracleIndexValidator(DBObjectProvider prov) {
        super(prov);
    }

    protected void validateNameInUse(DBObject object) throws NameInUseException {
        super.validateNameInUse(object);
        if (object instanceof Index) {
            Table parent = (Table)object.getParent();
            try {
                this.getProvider().validateUniqueName("CONSTRAINT", (DBObject)parent.getSchema(), object.getName());
            }
            catch (NameInUseException e) {
                if (e.getUserName().equals(parent.getName()) && e.getUserType().equals(parent.getType())) {
                    if (!(this.getProvider() instanceof Database)) {
                        OracleIndexAndConstraintValidator.validateIndex((Index)object);
                    }
                }
                throw e;
            }
        }
    }

    protected void validateIndexDefinition(Index index) throws ValidationException {
        super.validateIndexDefinition(index);
        if (index.getIndexType() == Index.IndexType.DOMAIN) {
            this.validateDomainIndex(index);
        }
        boolean bitMapped = index.getIndexType() == Index.IndexType.BITMAP;
        IndexObject[] ios = index.getColumnExpressions();
        if (bitMapped && ios.length > 30) {
            throw new ValidationException((DBObject)index, DBArb.getString((int)4));
        }
        if (ios.length > 32) {
            throw new ValidationException((DBObject)index, DBArb.getString((int)273));
        }
        Integer keyComp = index.getKeyCompression();
        if (keyComp != null) {
            if (keyComp < 0) {
                throw new ValidationException((DBObject)index, DBArb.getString((int)161));
            }
            if (index.getIndexType() == Index.IndexType.DOMAIN) {
                throw new ValidationException((DBObject)index, DBArb.getString((int)167));
            }
            if (index.getIndexType() == Index.IndexType.UNIQUE && keyComp > ios.length - 1) {
                throw new ValidationException((DBObject)index, DBArb.getString((int)15));
            }
            if (index.getIndexType() == Index.IndexType.NORMAL && keyComp > ios.length) {
                throw new ValidationException((DBObject)index, DBArb.getString((int)303));
            }
        }
        if (!(this.getProvider() instanceof Database)) {
            OracleIndexAndConstraintValidator.validateIndex(index);
        }
    }

    protected void validateColumnType(Index index, Column col) throws ValidationException {
        if (index.getIndexType() != Index.IndexType.DOMAIN) {
            super.validateColumnType(index, col);
            boolean ok = true;
            String dtName = "";
            try {
                DataTypeUsage dtu = col.getDataTypeUsage();
                if (dtu != null) {
                    DataType dt = DataTypeHelper.getDataType((DataTypeUsage)dtu);
                    dtName = dt.getName();
                    if (dt instanceof PredefinedDataTypeUsage || INVALID_INDEX_DATATYPES.contains(dtName)) {
                        ok = false;
                    }
                }
            }
            catch (DBException dbe) {
                ok = false;
            }
            if (!ok) {
                throw new ValidationException((DBObject)col, DBArb.format((int)141, (Object)index.getName(), (Object)col.getName(), (Object)dtName));
            }
        }
    }

    protected void checkColumnExpressions(Index index) throws ValidationException {
        boolean bitMapped = false;
        IndexObject[] ios = index.getColumnExpressions();
        Table t = index.getTable();
        HashSet<String> columnNames = new HashSet<String>();
        int i = 0;
        while (i < ios.length) {
            String columnName;
            SQLFragment expression = ios[i].getExpression();
            if (expression instanceof ColumnUsage) {
                ((ColumnUsage)expression).setProvider(this.getProvider());
            }
            if (t.getColumn(columnName = this.getProvider().getInternalName(expression.getSQLText())) != null && (bitMapped || ios[i].getOrder() != "DESC")) {
                if (columnNames.contains(columnName)) {
                    throw new ValidationException((DBObject)index, DBArb.getString((int)268));
                }
                columnNames.add(columnName);
            }
            this.validateColumnExpression(index, expression);
            ++i;
        }
    }

    private void validateColumnExpression(Index index, SQLFragment columnExpression) throws ValidationException {
        boolean noColumns;
        Table t = index.getTable();
        boolean bl = noColumns = t instanceof MaterializedView && t.getColumns().length == 0;
        if (!noColumns) {
            try {
                for (String[] nameComponents : ParserUtils.getColumnNames((String)columnExpression.getSQLText(), (ParserUtils.ExpressionType)ParserUtils.ExpressionType.ARITHMETIC)) {
                    String columnName = this.getProvider().getInternalName(nameComponents[0]);
                    Column col = t.getColumn(columnName);
                    if (col == null) {
                        throw new ValidationException((DBObject)index, DBArb.format((int)308, (Object)columnName, (Object)t.getName()));
                    }
                    this.validateColumnType(index, col);
                }
            }
            catch (SQLQueryException e) {
                throw new ValidationException((DBObject)index, DBArb.format((int)117, (Object[])new Object[]{index.getName(), columnExpression}));
            }
        }
    }

    protected void checkDefinitionIsUnique(Index index) throws ValidationException {
        IndexObjectComparator indexObjComparator = new IndexObjectComparator();
        super.checkDefinitionIsUnique(index);
        IndexObject[] idxColExpressions = index.getColumnExpressions();
        Table owningTable = index.getTable();
        Constraint[] cons = owningTable.getConstraints();
        int i = 0;
        while (i < cons.length) {
            Column[] coniCols;
            if (!(!(cons[i] instanceof UniqueConstraint) || idxColExpressions.length != (coniCols = ((UniqueConstraint)cons[i]).getColumns()).length || !cons[i].isEnabled() && index.getIndexType() == Index.IndexType.UNIQUE || this.getProvider() instanceof Database && cons[i].getName().equals(index.getName()) || !OracleIndexAndConstraintValidator.contraintAndIndexColumnsMatch(this.getProvider(), owningTable, coniCols, idxColExpressions))) {
                throw new ValidationException((DBObject)index, DBArb.format((int)213, (Object)index.getName(), (Object)cons[i].getName()));
            }
            ++i;
        }
    }

    protected void validateDomainIndex(Index index) throws ValidationException {
        IndexObject[] ios = index.getColumnExpressions();
        Table t = index.getTable();
        if (ios.length != 1) {
            throw new ValidationException((DBObject)index, DBArb.getString((int)36));
        }
        SQLFragment expression = ios[0].getExpression();
        String columnName = this.getProvider().getInternalName(expression.getSQLText());
        Column col = t.getColumn(columnName);
        if (col == null) {
            throw new ValidationException((DBObject)index, DBArb.format((int)185, (Object)index, (Object)columnName));
        }
        DBObjectID indextypeID = index.getDomainIndextype();
        if (indextypeID == null) {
            throw new ValidationException((DBObject)index, DBArb.format((int)60, (Object)index.getName()));
        }
        String schemaName = null;
        if (indextypeID instanceof ReferenceID) {
            schemaName = ((ReferenceID)indextypeID).getSchemaName();
        } else {
            try {
                DBObject indextype;
                DBObject dBObject = indextype = indextypeID != null ? indextypeID.resolveID() : null;
                if (!(indextype instanceof Indextype)) {
                    throw new ValidationException((DBObject)index, DBArb.format((int)60, (Object)index));
                }
                Schema schema = ((Indextype)indextype).getSchema();
                schemaName = schema != null ? schema.getName() : null;
            }
            catch (DBException e) {
                // empty catch block
            }
        }
        if ("CTXSYS".equals(schemaName)) {
            String dtName = "";
            boolean ok = false;
            try {
                DataTypeUsage dtu = col.getDataTypeUsage();
                DataType dt = DataTypeHelper.getDataType((DataTypeUsage)dtu);
                dtName = dt.getName();
                if (dt instanceof CharacterDataType || VALID_TEXT_INDEX_DATATYPES.contains(dtName)) {
                    ok = true;
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
            if (!ok) {
                throw new ValidationException((DBObject)index, DBArb.format((int)35, (Object)index.getName(), (Object)columnName, (Object)dtName));
            }
        }
    }

    protected void checkInavildFunctions(Index index) throws ValidationException {
        super.checkInavildFunctions(index);
        IndexObject[] ios = index.getColumnExpressions();
        OracleSQLQueryBuilder builder = new OracleSQLQueryBuilder(this.getProvider(), index.getSchema());
        int i = 0;
        while (i < ios.length) {
            String exprText = ios[i].getExpression().getSQLText();
            StringBuilder sb = new StringBuilder("SELECT ");
            sb.append(exprText);
            sb.append(" AS X FROM (SELECT ");
            String comma = "";
            Column[] columnArray = ((Relation)index.getParent()).getColumns();
            int n = 0;
            while (n < columnArray.length) {
                Column col = columnArray[n];
                sb.append(comma);
                sb.append("1 AS ");
                sb.append(col.getName());
                comma = ",";
                ++n;
            }
            sb.append(" FROM DUAL)");
            try {
                builder.buildQuery(sb.toString());
                SelectObject so = builder.getSelectObject("X");
                this.checkInavildFunctionsInFragment(so.getExpression(), ios[i]);
            }
            catch (SQLQueryException e) {
                // empty catch block
            }
            ++i;
        }
    }

    private void checkInavildFunctionsInFragment(SQLFragment frag, IndexObject io) throws ValidationException {
        if (frag instanceof Function && ((Function)frag).isGrouping()) {
            throw new ValidationException((DBObject)io, DBArb.format((int)7, (Object)io.getSQLText()));
        }
        if (frag instanceof Operation) {
            SQLFragment[] args = ((Operation)frag).getArguments();
            int i = 0;
            while (i < args.length) {
                if (args[i] != null) {
                    this.checkInavildFunctionsInFragment(args[i], io);
                }
                ++i;
            }
        }
        String fnName = frag.getSQLText();
        if (frag instanceof Function) {
            fnName = ((Function)frag).getFunction();
        }
        if ("USER".equalsIgnoreCase(fnName) || "ROWNUM".equalsIgnoreCase(fnName) || "SYSDATE".equalsIgnoreCase(fnName) || "SYSTIMESTAMP".equalsIgnoreCase(fnName) || "CURRENT_DATE".equalsIgnoreCase(fnName) || "CURRENT_TIMESTAMP".equalsIgnoreCase(fnName)) {
            throw new ValidationException((DBObject)io, DBArb.format((int)7, (Object)io.getSQLText()));
        }
    }

    protected void checkBitmapIndexOnIOT(Index index) throws ValidationException {
        OracleIndexOrganizedTableProperties oiotProps;
        Table table;
        if (!(Index.IndexType.BITMAP != index.getIndexType() || Table.TableType.INDEX_ORGANIZED != (table = index.getTable()).getProperty("TableType") || (oiotProps = (OracleIndexOrganizedTableProperties)table.getProperty("OracleIndexOrganizedTableProperties")) != null && oiotProps.isMapped())) {
            throw new ValidationException((DBObject)index, DBArb.format((int)146, (Object)table, (Object)index));
        }
    }
}

