/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.MissingValidatorException;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.validators.ExternalTablePropsValidator;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.db.validators.TableValidator;

public class OracleTableValidator
extends TableValidator {
    public OracleTableValidator(DBObjectProvider prov) {
        super(prov);
    }

    protected boolean enforceChildNameUniqueInSchema(DBObject obj) {
        return (obj instanceof Constraint || obj instanceof Index) && !this.isChildOfPendingObject(obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @AbstractValidator.PropertyValidator(value={Property.properties})
    public void validateProperties(Table original, Table updated) throws ValidationException {
        OracleTablePartitions partitions;
        OracleStorageProperties storageProperties;
        boolean isPartitioned = updated.getProperty("PARTITIONED TABLE") == Boolean.TRUE;
        Table.TableType tableType = (Table.TableType)updated.getProperty("TableType");
        if (tableType == Table.TableType.INDEX_ORGANIZED) {
            if (this.getPK(updated) == null) {
                throw new ValidationException((DBObject)updated, DBArb.getString((int)28));
            }
            if (!this.getPK(updated).isEnabled()) {
                throw new ValidationException((DBObject)updated, DBArb.getString((int)352));
            }
            OracleIndexOrganizedTableProperties properties = (OracleIndexOrganizedTableProperties)updated.getProperty("OracleIndexOrganizedTableProperties");
            if (properties != null) {
                try {
                    this.getProvider().validateObject((DBObject)properties);
                }
                catch (MissingValidatorException mve) {
                    throw new ValidationException((DBObject)updated, DBArb.getString((int)314));
                }
            }
        } else if (tableType == Table.TableType.EXTERNAL) {
            OracleExternalTableProperties properties = (OracleExternalTableProperties)updated.getProperty("OracleExternalTableProperties");
            if (properties == null) throw new ValidationException((DBObject)updated, DBArb.getString((int)115));
            this.getProvider().validateObject((DBObject)properties);
        } else if (tableType == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP) {
            if (isPartitioned) {
                throw new ValidationException((DBObject)updated, DBArb.format((int)264, (Object)DBArb.getString((int)61), (Object)DBArb.getString((int)307)));
            }
            Constraint[] constraintArray = updated.getConstraints();
            int n = 0;
            while (n < constraintArray.length) {
                Constraint constraint = constraintArray[n];
                if (constraint instanceof FKConstraint) {
                    throw new ValidationException((DBObject)updated, DBArb.format((int)264, (Object)DBArb.getString((int)61), (Object)DBArb.getString((int)236)));
                }
                ++n;
            }
            Column[] columnArray = updated.getColumns();
            int n2 = 0;
            while (n2 < columnArray.length) {
                Column column = columnArray[n2];
                OracleColumnProperties ocp = (OracleColumnProperties)column.getProperty("OracleColumnProperties");
                if (ocp != null && ocp.getNestedTableProperties() != null) {
                    throw new ValidationException((DBObject)column, DBArb.format((int)264, (Object)DBArb.getString((int)61), (Object)DBArb.getString((int)347)), DBArb.format((int)371, (Object)column.getName()));
                }
                ++n2;
            }
        }
        if ((storageProperties = (OracleStorageProperties)updated.getProperty("OracleStorageProperties")) != null) {
            storageProperties.validate((DBObject)updated);
        }
        if (!isPartitioned || (partitions = (OracleTablePartitions)updated.getProperty("OracleTablePartitions")) == null) return;
        try {
            this.getProvider().validateObject((DBObject)partitions);
            return;
        }
        catch (MissingValidatorException mve) {
            throw new ValidationException((DBObject)updated, DBArb.getString((int)119));
        }
    }

    @AbstractValidator.PropertyValidator(value={Property.properties, Property.TableType}, path=true)
    public void validateTableType(Table original, Table updated) throws ValidationException {
        Table.TableType tableType = (Table.TableType)updated.getProperty("TableType");
        if (tableType == Table.TableType.EXTERNAL) {
            ExternalTablePropsValidator.validateTable(updated);
        } else if (tableType == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP) {
            this.validateProperties(original, updated);
        }
    }

    private PKConstraint getPK(Table table) {
        if (table != null) {
            Constraint[] constraintArray = table.getConstraints();
            int n = 0;
            while (n < constraintArray.length) {
                Constraint constraint = constraintArray[n];
                if (constraint instanceof PKConstraint) {
                    return (PKConstraint)constraint;
                }
                ++n;
            }
        }
        return null;
    }
}

