/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.validators.AbstractValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablePartitionsValidator
extends AbstractValidator<OracleTablePartitions> {
    public TablePartitionsValidator(DBObjectProvider pro) {
        super(pro);
    }

    @Override
    protected boolean canHaveEmptyName() {
        return true;
    }

    @Override
    public void validateObject(OracleTablePartitions original, OracleTablePartitions parts) throws ValidationException {
        DBObject par = parts.getParent();
        if (par instanceof Table) {
            this.validateAll(parts);
        }
        super.validateObject(original, parts);
    }

    private void validateAll(OracleTablePartitions parts) throws ValidationException {
        OracleTablePartitions subpartitionModel = parts.getSubpartitionModel();
        if (subpartitionModel != null) {
            TablePartition[] tablePartitionArray = parts.getPartitions();
            int n = 0;
            while (n < tablePartitionArray.length) {
                TablePartition partition = tablePartitionArray[n];
                OracleTablePartitions subpartitions = partition.getPartitionLevelSubpartitions();
                if (subpartitions != null && subpartitions.getHashQuantity() != null && subpartitionModel.getPartitionType() == OracleTablePartitions.PartitionType.HASH && subpartitionModel.getObjectType() == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
                    throw new ValidationException((DBObject)parts, DBArb.getString((int)293));
                }
                if (subpartitionModel.getPartitions().length > 0 && (subpartitions == null || subpartitions.getPartitions().length == 0)) {
                    int partitionNameLength = partition.getName() != null ? partition.getName().length() : 0;
                    TablePartition[] tablePartitionArray2 = subpartitionModel.getPartitions();
                    int n2 = 0;
                    while (n2 < tablePartitionArray2.length) {
                        TablePartition template = tablePartitionArray2[n2];
                        int length = partitionNameLength + template.getName().length() + 1;
                        if (length > 30) {
                            throw new ValidationException((DBObject)parts, DBArb.format((int)129, (Object)(partition.getName() + '_' + template.getName()), (Object)partition.getName(), (Object)template.getName()));
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    @AbstractValidator.PropertyValidator(value={Property.partitionColumns})
    public void validateColumns(OracleTablePartitions original, OracleTablePartitions parts) throws ValidationException {
        this.validateTypes(parts);
        OracleTablePartitions.PartitionType partitionType = parts.getPartitionType();
        OracleTablePartitions.ObjectType objectType = parts.getObjectType();
        DBObjectID[] partitionColumns = parts.getPartitionColumns();
        if (objectType == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) {
            if (partitionColumns.length > 0) {
                throw new ValidationException((DBObject)parts, DBArb.getString((int)43));
            }
        } else {
            if (partitionType == OracleTablePartitions.PartitionType.LIST) {
                if (partitionColumns.length != 1 || partitionColumns.length == 1 && LOBDescriptor.isLOBColumn((DBObjectID)partitionColumns[0])) {
                    throw new ValidationException((DBObject)parts, DBArb.getString((int)110));
                }
            } else {
                if (partitionColumns.length < 1) {
                    throw new ValidationException((DBObject)parts, DBArb.getString((int)269));
                }
                if (partitionType == OracleTablePartitions.PartitionType.HASH && partitionColumns.length > 16) {
                    throw new ValidationException((DBObject)parts, DBArb.getString((int)357));
                }
            }
            DBObjectID[] dBObjectIDArray = partitionColumns;
            int n = 0;
            while (n < dBObjectIDArray.length) {
                DBObjectID columnID = dBObjectIDArray[n];
                if (this.isInvalidColumn(columnID)) {
                    throw new ValidationException((DBObject)parts, DBArb.getString((int)160));
                }
                ++n;
            }
        }
    }

    @AbstractValidator.PropertyValidator(value={Property.hashQuantity})
    public void validateHashQuantity(OracleTablePartitions original, OracleTablePartitions parts) throws ValidationException {
        this.validateTypes(parts);
        OracleTablePartitions.PartitionType partitionType = parts.getPartitionType();
        OracleTablePartitions.ObjectType objectType = parts.getObjectType();
        TablePartition[] partitions = parts.getPartitions();
        Integer hashQuantity = parts.getHashQuantity();
        String[] hashQuantityTablespaces = parts.getHashQuantityTablespaces();
        if (partitionType == OracleTablePartitions.PartitionType.HASH) {
            if (partitions.length != 0 && hashQuantity != null) {
                throw new ValidationException((DBObject)parts, DBArb.getString((int)31));
            }
            if (objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE && partitions.length == 0 && hashQuantity == null) {
                throw new ValidationException((DBObject)parts, DBArb.getString((int)231));
            }
        } else if (hashQuantity != null || hashQuantityTablespaces.length != 0) {
            throw new ValidationException((DBObject)parts, DBArb.getString((int)177));
        }
        if (hashQuantity == null && hashQuantityTablespaces.length != 0) {
            throw new ValidationException((DBObject)parts, DBArb.getString((int)22));
        }
    }

    @AbstractValidator.PropertyValidator(value={Property.partitions})
    public void validatePartitions(OracleTablePartitions original, OracleTablePartitions parts) throws ValidationException {
        this.validateHashQuantity(original, parts);
        OracleTablePartitions.PartitionType partitionType = parts.getPartitionType();
        OracleTablePartitions.ObjectType objectType = parts.getObjectType();
        TablePartition[] partitions = parts.getPartitions();
        if (partitionType != OracleTablePartitions.PartitionType.HASH && objectType == OracleTablePartitions.ObjectType.PARTITION && partitions.length < 1) {
            throw new ValidationException((DBObject)parts, DBArb.format((int)71, (Object)partitionType));
        }
        if (partitionType == OracleTablePartitions.PartitionType.LIST && (objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE || objectType == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) && partitions.length < 1) {
            throw new ValidationException((DBObject)parts, DBArb.getString((int)163));
        }
        TablePartition[] tablePartitionArray = partitions;
        int n = 0;
        while (n < tablePartitionArray.length) {
            TablePartition partition = tablePartitionArray[n];
            if (partition.getPartitionType() != partitionType) {
                throw new ValidationException((DBObject)parts, DBArb.format((int)89, (Object)partitionType));
            }
            this.getProvider().validateObject((DBObject)partition);
            ++n;
        }
    }

    @AbstractValidator.PropertyValidator(value={Property.subpartitionModel})
    public void validateSubpartitionModel(OracleTablePartitions original, OracleTablePartitions parts) throws ValidationException {
        OracleTablePartitions subpartitionModel = parts.getSubpartitionModel();
        if (subpartitionModel != null) {
            this.validateTypes(parts);
            OracleTablePartitions.PartitionType partitionType = parts.getPartitionType();
            OracleTablePartitions.ObjectType objectType = parts.getObjectType();
            if (partitionType == OracleTablePartitions.PartitionType.RANGE && objectType == OracleTablePartitions.ObjectType.PARTITION) {
                this.getProvider().validateObject((DBObject)subpartitionModel);
            } else {
                throw new ValidationException((DBObject)parts, DBArb.format((int)70, (Object)partitionType));
            }
        }
    }

    private void validateTypes(OracleTablePartitions parts) throws ValidationException {
        OracleTablePartitions.PartitionType partitionType = parts.getPartitionType();
        if (partitionType == null) {
            throw new ValidationException((DBObject)parts, DBArb.getString((int)340));
        }
        OracleTablePartitions.ObjectType objectType = parts.getObjectType();
        if (objectType == null) {
            throw new ValidationException((DBObject)parts, DBArb.getString((int)339));
        }
    }

    private boolean isInvalidColumn(DBObjectID colID) {
        try {
            Column col = (Column)colID.resolveID();
            if (col != null) {
                DataType dataType = DataTypeHelper.getDataType((DataTypeUsage)col.getDataTypeUsage());
                if (dataType instanceof ComplexType) {
                    boolean bl = true;
                    return bl;
                }
                if (dataType != null) {
                    String dataTypeName = dataType.getName();
                    boolean bl = "LONG".equalsIgnoreCase(dataTypeName) || "LONG RAW".equalsIgnoreCase(dataTypeName) || "ROWID".equalsIgnoreCase(dataTypeName) || "UROWID".equalsIgnoreCase(dataTypeName) || "BLOB".equalsIgnoreCase(dataTypeName) || "CLOB".equalsIgnoreCase(dataTypeName) || "NCLOB".equalsIgnoreCase(dataTypeName) || "BFILE".equalsIgnoreCase(dataTypeName);
                    return bl;
                }
            }
        }
        catch (DBException e) {
            // empty catch block
        }
        return false;
    }
}

