/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sybase;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.javatools.db.BaseDatabaseDescriptor;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.InvalidNameException;

public class AdaptiveServerAnywhereDescriptor
extends BaseDatabaseDescriptor {
    public static final int MAX_NAME_LENGTH = 128;
    public static final char OPEN_QUOTE_IDENTIFIER = '[';
    public static final char CLOSE_QUOTE_IDENTIFIER = ']';
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "BACKUP", "BEGIN", "BETWEEN", "BIGINT", "BINARY", "BIT", "BOTTOM", "BREAK", "BY", "CALL", "CAPABILITY", "CASCADE", "CASE", "CAST", "CHAR", "CHAR_CONVERT", "CHARACTER", "CHECK", "CHECKPOINT", "CLOSE", "COMMENT", "COMMIT", "CONNECT", "CONSTRAINT", "CONTAINS", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CUBE", "CURRENT", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATE", "DBSPACE", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELETE", "DELETING", "DESC", "DISTINCT", "DO", "DOUBLE", "DROP", "DYNAMIC", "ELSE", "ELSEIF", "ENCRYPTED", "END", "ENDIF", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTING", "EXISTS", "EXTERNLOGIN", "FETCH", "FIRST", "FLOAT", "FOR", "FORCE", "FOREIGN", "FORWARD", "FROM", "FULL", "GOTO", "GRANT", "GROUP", "HAVING", "HOLDLOCK", "IDENTIFIED", "IF", "IN", "INDEX", "INDEX_LPAREN", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INSERTING", "INSTALL", "INSTEAD", "INT", "INTEGER", "INTEGRATED", "INTERSECT", "INTO", "IQ", "IS", "ISOLATION", "JOIN", "KEY", "LATERAL", "LEFT", "LIKE", "LOCK", "LOGIN", "LONG", "MATCH", "MEMBERSHIP", "MESSAGE", "MODE", "MODIFY", "NATURAL", "NEW", "NO", "NOHOLDLOCK", "NOT", "NOTIFY", "NULL", "NUMERIC", "OF", "OFF", "ON", "OPEN", "OPTION", "OPTIONS", "OR", "ORDER", "OTHERS", "OUT", "OUTER", "OVER", "PASSTHROUGH", "PRECISION", "PREPEARE", "PRIMARY", "PRINT", "PRIVILEGES", "PROC", "PROCEDURE", "PUBLICATION", "RAISERROR", "READTEXT", "REAL", "REFERENCE", "REFERENCES", "RELEASE", "REMOTE", "REMOVE", "RENAME", "REORGANIZE", "RESOURCE", "RESTORE", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "ROLLBACK", "ROLLUP", "SAVE", "SAVEPOINT", "SCROLL", "SELECT", "SENSITIVE", "SESSION", "SET", "SETUSER", "SHARE", "SMALLINT", "SOME", "SQLCODE", "SQLSTATE", "START", "STOP", "SUBTRANS", "SUBTRANSACTION", "SYNCHRONIZE", "SYNTAX_ERROR", "TABLE", "TEMPORARY", "TEXTSIZE", "THEN", "TIME", "TIMESTAMP", "TINYINT", "TO", "TOP", "TRAN", "TRIGGER", "TRUNCATE", "TSEQUAL", "UNBOUNDED", "UNION", "UNIQUE", "UNKNOWN", "UNSIGNED", "UPDATE", "UPDATING", "USER", "USING", "VALIDATE", "VALUES", "VARBINARY", "VARCHAR", "VARIABLE", "VARYING", "VIEW", "WAIT", "WAITFOR", "WHEN", "WHERE", "WHILE", "WINDOW", "WITH", "WITH_CUBE", "WITH_LPAREN", "WITH_ROLLUP", "WITHIN", "WORK", "WRITETEXT"));

    public int getCasePolicy() {
        return 3;
    }

    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    public int getMaxNameLength(String type) {
        return 128;
    }

    public void validateName(String type, String name) throws InvalidNameException {
        boolean isValid = true;
        String reason = "";
        try {
            AdaptiveServerAnywhereDescriptor.validateIdentifier((String)name, (char)'\"', (int)128, (String)"_$#@", (boolean)false, (Set)RESERVED_WORDS, (int)this.getCasePolicy());
        }
        catch (InvalidNameException ine) {
            isValid = false;
            reason = ine.getMessage();
        }
        char firstChar = name.charAt(0);
        if (isValid && firstChar != '\"' && !Character.isLetter(firstChar) && firstChar != '_' && firstChar != '$' && firstChar != '#' && firstChar != '@') {
            throw new InvalidNameException(null, DBArb.getString((int)353));
        }
        if (!isValid && firstChar == '[' && name.indexOf(91, 1) == -1 && name.indexOf(93, 1) == name.length() - 1 && name.length() > 2 && name.length() < 131) {
            isValid = true;
        }
        if (!isValid) {
            throw new InvalidNameException(null, reason);
        }
        String unquotedName = firstChar == '\"' ? name.substring(1, name.length() - 1) : name;
        int lastChar = 0;
        int idx = 0;
        while (idx < unquotedName.length()) {
            char thisChar = unquotedName.charAt(idx);
            if (Character.isISOControl(thisChar) || thisChar == '\"' || lastChar == 92 && thisChar == '\\') {
                throw new InvalidNameException(null, DBArb.getString((int)353));
            }
            lastChar = unquotedName.charAt(idx);
            ++idx;
        }
        int idx2 = 0;
        while (idx2 < unquotedName.length()) {
            if (name.charAt(idx2) == '\'' && (++idx2 == unquotedName.length() - 1 || name.charAt(idx2) != '\'')) {
                throw new InvalidNameException(null, DBArb.getString((int)353));
            }
            ++idx2;
        }
    }
}

