/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sybase;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.sybase.AdaptiveServerAnywhereDatabase;
import oracle.javatools.db.sybase.AdaptiveServerAnywhereDatabaseImpl;
import oracle.javatools.db.sybase.AdaptiveServerAnywhereDescriptor;
import oracle.javatools.db.sybase.AdaptiveServerDatabaseImpl;
import oracle.javatools.db.sybase.AdaptiveServerEnterpriseDatabase;
import oracle.javatools.db.sybase.AdaptiveServerEnterpriseDatabaseImpl;
import oracle.javatools.db.sybase.AdaptiveServerEnterpriseDescriptor;

public class AdaptiveServerDatabaseFactory
extends DatabaseFactory.DatabaseCreator {
    private DatabaseDescriptor m_anywhereDesc;
    private DatabaseDescriptor m_enterpriseDesc;

    public AdaptiveServerDatabaseFactory() {
        DataTypeRegistry dtr = DataTypeRegistry.getInstance();
        dtr.registerProvider((DataTypeRegistry.Registerer)new AdaptiveServerDatabaseImpl.Registerer(), AdaptiveServerDatabaseImpl.class);
        dtr.registerProvider((DataTypeRegistry.Registerer)new AdaptiveServerAnywhereDatabaseImpl.Registerer(), AdaptiveServerAnywhereDatabaseImpl.class);
        dtr.registerProvider((DataTypeRegistry.Registerer)new AdaptiveServerEnterpriseDatabaseImpl.Registerer(), AdaptiveServerEnterpriseDatabaseImpl.class);
    }

    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        if (this.isAnywhere(conn)) {
            return new AdaptiveServerAnywhereDatabaseImpl(connStore, connName, conn);
        }
        if (this.isEnterprise(conn)) {
            return new AdaptiveServerEnterpriseDatabaseImpl(connStore, connName, conn);
        }
        return null;
    }

    private boolean isAnywhere(Connection conn) {
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String driverName = dmd.getDriverName();
                String dbName = dmd.getDatabaseProductName();
                if (driverName.indexOf("Sybase") > -1 && dbName.indexOf("Anywhere") > -1) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (SQLException sqlx) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isEnterprise(Connection conn) {
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String driverName = dmd.getDriverName();
                String dbName = dmd.getDatabaseProductName();
                if (driverName.indexOf("Sybase") > -1 || dbName.indexOf("Adaptive Server Enterprise") > -1) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (SQLException sqlx) {
                // empty catch block
            }
        }
        return false;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        if (AdaptiveServerAnywhereDatabase.class.isAssignableFrom(providerClass)) {
            if (this.m_anywhereDesc == null) {
                this.m_anywhereDesc = new AdaptiveServerAnywhereDescriptor();
            }
            return this.m_anywhereDesc;
        }
        if (AdaptiveServerEnterpriseDatabase.class.isAssignableFrom(providerClass)) {
            if (this.m_enterpriseDesc == null) {
                this.m_enterpriseDesc = new AdaptiveServerEnterpriseDescriptor();
            }
            return this.m_enterpriseDesc;
        }
        return null;
    }
}

