/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sybase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.validators.ConstraintValidator;

class AdaptiveServerEnterpriseDatabaseConstraintValidator
extends ConstraintValidator {
    private static List _compatibleTypesLists;

    public AdaptiveServerEnterpriseDatabaseConstraintValidator(DBObjectProvider prov) {
        super(prov);
    }

    protected boolean incompatibleDataTypes(DataType fkColDataType, DataType refColDataType) {
        boolean incompatible;
        DataTypeRegistry dtr = DataTypeRegistry.getInstance();
        if (dtr.isSynonymType(fkColDataType)) {
            fkColDataType = dtr.getBaseType(fkColDataType);
        }
        if (dtr.isSynonymType(refColDataType)) {
            refColDataType = dtr.getBaseType(refColDataType);
        }
        if (incompatible = super.incompatibleDataTypes(fkColDataType, refColDataType)) {
            if (_compatibleTypesLists == null) {
                AdaptiveServerEnterpriseDatabaseConstraintValidator.initialiseCompatibleTypes();
            }
            for (List compatibleTypes : _compatibleTypesLists) {
                if (compatibleTypes == null || !compatibleTypes.contains(fkColDataType.getName()) || !compatibleTypes.contains(refColDataType.getName())) continue;
                incompatible = false;
            }
        }
        return incompatible;
    }

    private static void initialiseCompatibleTypes() {
        _compatibleTypesLists = new ArrayList();
        String[] chars = new String[]{"CHAR", "NCHAR", "VARCHAR", "NVARCHAR"};
        String[] unichars = new String[]{"UNICHAR", "UNIVARCHAR"};
        _compatibleTypesLists.add(new ArrayList<String>(Arrays.asList(chars)));
        _compatibleTypesLists.add(new ArrayList<String>(Arrays.asList(unichars)));
    }
}

