/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sybase;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.BaseDatabaseDescriptor;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.sybase.AdaptiveServerEnterpriseDatabaseConstraintValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptiveServerEnterpriseDescriptor
extends BaseDatabaseDescriptor {
    private static final String YEN = "00a5";
    public static final int MAX_NAME_LENGTH = 30;
    public static final int MAX_TEMP_NAME_LENGTH = 13;
    public static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ADD", "ALL", "ALTER", "AND", "ANY", "ARITH_OVERFLOW", "AS", "ASC", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BREAK", "BROWSE", "BULK", "BY", "CASCADE", "CASE", "CHAR_CONVERT", "CHECK", "CHECKPOINT", "CLOSE", "CLUSTERED", "COALESCE", "COMMIT", "COMPUTE", "CONFIRM", "CONNECT", "CONSTRAINT", "CONTINUE", "CONTROLROW", "CONVERT", "COUNT", "CREATE", "CURRENT", "CURSOR", "DATABASE", "DBCC", "DEALLOCATE", "DECLARE", "DEFAULT", "DELETE", "DESC", "DETERMINISTIC", "DISK", "DISTINCT", "DOUBLE", "DROP", "DUMMY", "DUMP", "ELSE", "END", "ENDTRAN", "ERRLVL", "ERRORDATA", "ERROREXIT", "ESCAPE", "EXCEPT", "EXCLUSIVE", "EXEC", "EXECUTE", "EXISTS", "EXIT", "EXP_ROW_SIZE", "EXTERNAL", "FETCH", "FILLFACTOR", "FOR", "FOREIGN", "FROM", "FUNC", "FUNCTION", "GOTO", "GRANT", "GROUP", "HAVING", "HOLDLOCK", "IDENTITY", "IDENTITY_GAP", "IDENTITY_INSERT", "IDENTITY_START", "IF", "IN", "INDEX", "INOUT", "INSERT", "INSTALL", "INTERSECT", "INTO", "IS", "ISOLATION", "JAR", "JOIN", "KEY", "KILL", "LEVEL", "LIKE", "LINENO", "LOAD", "LOCK", "MAX", "MAX_ROWS_PER_PAGE", "MIN", "MIRROR", "MIRROREXIT", "MODIFY", "NATIONAL", "NOHOLDLOCK", "NONCLUSTERED", "NOT", "NULL", "NULLIF", "NUMERIC_TRUNCATION", "OF", "OFF", "OFFSETS", "ON", "ONCE", "ONLINE", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUT", "OUTPUT", "OVER", "PARTITION", "PERCENT", "PERM", "PERMANENT", "PLAN", "PRECISION", "PREPARE", "PRIMARY", "PRINT", "PRIVILEGES", "PROC", "PROCEDURE", "PROCESSEXIT", "PROXY_TABLE", "PUBLIC", "QUIESCE", "RAISERROR", "READ", "READPAST", "READTEXT", "RECONFIGURE", "REFERENCES", "REMOVE", "REORG", "REPLACE", "REPLICATION", "RESERVEPAGEGAP", "RETURN", "RETURNS", "REVOKE", "ROLE", "ROLLBACK", "ROWCOUNT", "ROWS", "RULE", "SAVE", "SCHEMA", "SELECT", "SET", "SETUSER", "SHUTDOWN", "SOME", "STATISTICS", "STRINGSIZE", "STRIPE", "SUM", "SYB_IDENTITY", "SYB_RESTREE", "SYB_TERMINATE", "TABLE", "TEMP", "TEMPORARY", "TEXTSIZE", "TO", "TRAN", "TRANSACTION", "TRIGGER", "TRUNCATE", "TSEQUAL", "UNION", "UNIQUE", "UNPARTITION", "UPDATE", "USE", "USER", "USER_OPTION", "USING", "VALUES", "VARYING", "VIEW", "WAITFOR", "WHEN", "WHERE", "WHILE", "WITH", "WORK", "WRITETEXT"));

    public int getCasePolicy() {
        return 3;
    }

    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    public int getMaxNameLength(String type) {
        return 30;
    }

    public void validateName(String type, String name) throws InvalidNameException {
        boolean isValid = true;
        String reason = "";
        try {
            AdaptiveServerEnterpriseDescriptor.validateIdentifier((String)name, (char)'\"', (int)30, (String)"_#@?$00a5", (boolean)false, (Set)RESERVED_WORDS, (int)this.getCasePolicy());
        }
        catch (InvalidNameException ine) {
            isValid = false;
            reason = ine.getMessage();
        }
        if (isValid) {
            char firstChar = name.charAt(0);
            if (firstChar == '\"') {
                if (name.length() > 30) {
                    throw new InvalidNameException(null, DBArb.getString((int)10));
                }
                if (name.charAt(1) == '#') {
                    throw new InvalidNameException(null, DBArb.getString((int)353));
                }
            } else {
                if (!Character.isLetter(firstChar) && firstChar != '_' && firstChar != '#' && firstChar != '@' || name.startsWith("@@")) {
                    throw new InvalidNameException(null, DBArb.getString((int)353));
                }
                if (firstChar == '#') {
                    if (name.length() < 2) {
                        throw new InvalidNameException(null, DBArb.getString((int)201));
                    }
                    if (name.length() > 13) {
                        throw new InvalidNameException(null, DBArb.getString((int)10));
                    }
                }
            }
        }
        if (!isValid) {
            throw new InvalidNameException(null, reason);
        }
    }

    public Map getValidators(Class<? extends Database> dbImpl, DBObjectProvider pro) {
        Map<String, DBObjectValidator> v = super.getValidators(dbImpl, pro);
        v.put("CONSTRAINT", new AdaptiveServerEnterpriseDatabaseConstraintValidator(pro));
        return v;
    }
}

